//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.lang.Math.*;
import java.util.*;


/** ɕ`悳ƍl̗\sB */
public class Predictor {

    // trigger  reference ̑Ή֌W
    public static final int NONE 		= -1;
    public static final int NORMAL 		= 0;
    public static final int VERTICAL_AXIS 	= 1;
    public static final int HORIZONTAL_AXIS 	= 2;
    public static final int REVERSE 		= 3;

    //reference  context ̐ڑ֌W
    public static final int CONNECT_SS	= 1;
    public static final int CONNECT_SE	= 2;
    public static final int CONNECT_ES	= 3;
    public static final int CONNECT_EE	= 4;



    private static LinkedList contexts;
    private static Candidates candidates;
    private static Scene scene;
 
    public static Candidates generate_candidates(Segment trigger, Scene _scene){

	candidates = new Candidates();
	contexts = new LinkedList();
	scene = _scene;

	//candidates.append(new Candidate(trigger.x1+20, trigger.y1+20, trigger.x2+20, trigger.y2+20));	


	// ܂ trigger ƍ reference TāAcontxts B
	Segment reference;
	int trg_ref_relation;
        Enumeration e = scene.elements();
	while (e.hasMoreElements()){
	  reference = (Segment) e.nextElement();
	  trg_ref_relation = check_congruent(trigger, reference);
	  if (trg_ref_relation != NONE)
		add_contexts(trigger, reference, trg_ref_relation);
	}

	// ꂽ context Ƃ trigger ̎ predicted B
	Context context;
        e = contexts.elements();
	while (e.hasMoreElements()){
	  context = (Context) e.nextElement();
	  add_predicted(trigger, context);
	}

	return candidates;
    }


    /** ǂ̃`FbNBȂ֌WԂB*/
    private static int check_congruent(Segment trigger, Segment reference){
	Vector2 t = trigger.vector();
	Vector2 r = reference.vector();

	if       (Def.equal(t.x,  r.x) && Def.equal(t.y, r.y)) return  NORMAL;
	else if  (Def.equal(t.x, -r.x) && Def.equal(t.y, r.y)) return  VERTICAL_AXIS;
	else if  (Def.equal(t.x,  r.x) && Def.equal(t.y, -r.y)) return  HORIZONTAL_AXIS;
	else if  (Def.equal(t.x, -r.x) && Def.equal(t.y, -r.y)) return  REVERSE;
	else return NONE;
    }


    /** reference ɂȂĂ̂W߂ contexts ։B */
    private static void add_contexts(Segment trigger, Segment reference, int trg_ref_relation){
	int ref_cxt_relation;
	Segment connected;
        Enumeration e = scene.elements();
	while (e.hasMoreElements()){
	  connected = (Segment) e.nextElement();
	  ref_cxt_relation = check_connected(reference, connected);
	  if (ref_cxt_relation != NONE)
		add_context(connected, reference, ref_cxt_relation, trg_ref_relation);
	}
    }

    /** referece  context ̐ڑ֌WԂB */
    private static int check_connected(Segment reference, Segment connected){
	Node rs = reference.start_node();
	Node re = reference.end_node();
	Node cs = connected.start_node();
	Node ce = connected.end_node();

	if (rs.same(cs))
	    return CONNECT_SS;
	else if (rs.same(ce))
	    return CONNECT_SE;
	else if (re.same(cs))
	    return CONNECT_ES;
	else if (re.same(ce))
	    return CONNECT_EE;
	else 	
	    return NONE;
    }

    /** ̂Ȃ`FbNB */
    private static void add_context(Segment connected, Segment reference, 
					int ref_cxt_relation, int trg_ref_relation){
	Context new_context = new Context(connected, reference, ref_cxt_relation, trg_ref_relation);
	Context context;
        Enumeration e = contexts.elements();
	while (e.hasMoreElements()){
	  context = (Context) e.nextElement();
	  if (new_context.equal(context))
		return;
	}
	contexts.append(new_context);
    }

    private static void add_predicted(Segment trigger, Context context){
	add_predicted_sub(trigger.start_node(), context.x, context.y);
	add_predicted_sub(trigger.end_node(), -context.x, -context.y);

	if (Def.equal(trigger.x1, trigger.x2)){
	  add_predicted_sub(trigger.start_node(), -context.x, context.y);
	  add_predicted_sub(trigger.end_node(), context.x, -context.y);
	}
	else if (Def.equal(trigger.y1, trigger.y2)){
	  add_predicted_sub(trigger.start_node(), context.x, -context.y);
	  add_predicted_sub(trigger.end_node(), -context.x, context.y);
	}
    }

    private static void add_predicted_sub(Node node, double x, double y){
	Candidate candidate = new Candidate(
			node.x, node.y, node.x + x, node.y + y);
	if (!scene.contain_identical_segment((Segment) candidate))
		candidates.append(candidate);
    }


	
}








/** reference  context ̈ʒu֌WL^ */
class Context{
    public double x;
    public double y;

    Context(Segment connected, Segment reference, int ref_cxt_relation, int trg_ref_relation){
	Node cs = connected.start_node();
	Node ce = connected.end_node();
	Node rs = reference.start_node();
	Node re = reference.end_node();

	// reference  context ̐ڑ֌W
	switch (ref_cxt_relation){
	  case Predictor.CONNECT_EE:
	    x = -(cs.x - ce.x);
	    y = -(cs.y - ce.y);
	    break;
	  case Predictor.CONNECT_ES:
	    x = -(ce.x - cs.x);
	    y = -(ce.y - cs.y);
	    break;
	  case Predictor.CONNECT_SE:
	    x =  (cs.x - ce.x);
	    y =  (cs.y - ce.y);
	    break;
	  case Predictor.CONNECT_SS:
	    x =  (ce.x - cs.x);
	    y =  (ce.y - cs.y);
	    break;
        }

	// trigger  reference ̑Ή֌Wl
	switch (trg_ref_relation){
	  case Predictor.VERTICAL_AXIS:
	    x = -x;
	    break;
	  case Predictor.HORIZONTAL_AXIS:
	    y = -y;
	    break;
	  case Predictor.REVERSE:
	    x = -x;
	    y = -y;
	}
    }

    public boolean equal(Context c){
	return (Def.equal(x, c.x) && Def.equal(y, c.y));
    }

}
