//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.lang.Math.*;
import java.util.*;


/** }`𒲂ׂāAׂ􉽊wI𐄘_B*/
public class Inferencer {

    private static final int X1 = 0;
    private static final int Y1 = 1;
    private static final int X2 = 2;
    private static final int Y2 = 3;

    private static final int NONE = 0;
    private static final int CONNECT_SS = 1;
    private static final int CONNECT_SE = 2;
    private static final int CONNECT_ES = 3;
    private static final int CONNECT_EE = 4;
    private static final int TOUCH_START = 5;
    private static final int TOUCH_END   = 6;

    // Kp͈̂Bł߂̂ێ
    private static double minimum_congruence;
    private static double congruence_x;
    private static double congruence_y;
    private static LinkedList congruence_references;

    // align Kp̂͂ꂼBł߂̂ێ
    private static double[] minimum_align = new double[4];
    private static double[] align = new double[4];
    private static LinkedList[] align_references = new LinkedList[4];

    //Inferencer(){
    //}

    private static final double _MINIMUM_ALIGN = 10;
    private static final double _MINIMUM_CONGRUENCE = 30;
    private static final double _MINIMUM_CONNECT = 20;
    private static final double _MINIMUM_TOUCH = 10;
    private static final double _MINIMUM_PARALLEL = 30;	// 傫ڂɂƂB
    private static final double _MAX_PARALLEL = 200;	// Ԋu̍őlB ȏ͗Ă疳
    private static final double MINIMUM_SLOPE = 0.1;
    private static double MINIMUM_ALIGN;
    private static double MINIMUM_CONGRUENCE;
    private static double MINIMUM_CONNECT;
    private static double MINIMUM_TOUCH;
    private static double MINIMUM_PARALLEL;
    private static double MAX_PARALLEL;
    //private static double MINIMUM_SLOPE;

    private static void init(double size){
	MINIMUM_ALIGN = _MINIMUM_ALIGN / size;
	MINIMUM_CONGRUENCE = _MINIMUM_CONGRUENCE / size;
	MINIMUM_CONNECT = _MINIMUM_CONNECT / size;
	MINIMUM_TOUCH = _MINIMUM_TOUCH / size;
	MINIMUM_PARALLEL = _MINIMUM_PARALLEL / size;
	MAX_PARALLEL = _MAX_PARALLEL / size;
	//MINIMUM_SLOPE = _MINIMUM_SLOPE;
    }

    private static Constraints constraints;
    // connect  align ȂB
    private static boolean start_node_is_connected;
    private static boolean   end_node_is_connected;

    public static Constraints infer_constraints(Segment stroke, Scene scene, double scale){

	// adjust parameters to scale
	init(scale);

	constraints = new Constraints();

	// ̔pB 
	double xdiff = stroke.x2 - stroke.x1;
	double ydiff = stroke.y2 - stroke.y1;
	
	// connect  align ȂB
	start_node_is_connected = false;
	end_node_is_connected = false;

	// CT[` 
	Segment segment;
	Enumeration e = scene.elements();
      	while (e.hasMoreElements()){
	    segment = (Segment) e.nextElement();
	    check_connection(stroke, segment, scene);
	    check_align(stroke, segment);
	    check_slope(stroke, segment);
	    check_congruent(xdiff, ydiff, segment);
	}
	
	// connect  align ȂBڏȌ̂ɗL
	if (start_node_is_connected)
	  remove_align(Constraint.ALIGN_X1, Constraint.ALIGN_Y1);
	if (end_node_is_connected)
	  remove_align(Constraint.ALIGN_X2, Constraint.ALIGN_Y2);

	// ƉƓʊp`FbNBdeviation r̃`FbNȂB
	check_horizontal_vertical(stroke);


	return constraints;

    }

    private static void remove_align(int type1, int type2){
	  constraints.reset();
      	  while (constraints.hasMoreElements()){
	    Constraint constraint = (Constraint) constraints.currentElement();
	    if (constraint.type == type1 ||
	        constraint.type == type2 )
	      constraints.remove();
	    else
	      constraints.nextElement();
	  }
	
    }

	
    /** ƉƓʊp`FbNBdeviation r̃`FbNȂB*/
    private static  void check_horizontal_vertical(Segment stroke){
	Vector2 new_vector = stroke.vector();
	Vector2 base = new Vector2(100, 0 );
	Vector2 vector;
	double deviation;
	
	// 덷Ȃ
	//double[] angles = {0, 30, 45, 60, 90, 120, 135, 150};
	double r3 = Math.sqrt(3);
	double[] vectors = {1,0, r3,1, 1,1, 1,r3, 0,1, -1,r3, -1,1, -r3,1};
	// 
	for ( int i=0; i<8; i++){
	    //vector = base.rotate(angles[i]);
	    vector = new Vector2(vectors[i*2], vectors[i*2+1]);
	    deviation = Math.abs(new_vector.get_sin(vector));
	    if (deviation < MINIMUM_SLOPE){
	    	constraints.add_slope(vector.y, - vector.x, deviation, null);
	    	return;
	    }
	}
    }	




    /** congruent ԋ߂̂g */
    private static  void check_congruent(double xdiff, double ydiff, Segment segment){
	double old_xdiff = Math.abs(segment.x2 - segment.x1);
	double old_ydiff = Math.abs(segment.y2 - segment.y1);
	// duplicate or mirror
	check_congruent_sub(xdiff, ydiff, old_xdiff, old_ydiff, segment);
	// 90, 270 degree rotation
	check_congruent_sub(xdiff, ydiff, old_ydiff, old_xdiff, segment);
    }
    private static  void check_congruent_sub(
		double xdiff, double ydiff, double old_xdiff, double old_ydiff, Segment segment){
	double deviation = Vector2.distance(Math.abs(xdiff), Math.abs(ydiff), 
						old_xdiff, old_ydiff );
	if (deviation < MINIMUM_CONGRUENCE)
	  constraints.add_congruent(
		Tools.sign(xdiff) * old_xdiff, Tools.sign(ydiff) * old_ydiff, deviation, segment);
    }

    /** align ԋ߂̂g */
    private static void check_align(Segment stroke, Segment segment){
	check_align_sub(X1, segment.x1, stroke, segment);
	check_align_sub(X1, segment.x2, stroke, segment);
	check_align_sub(Y1, segment.y1, stroke, segment);
	check_align_sub(Y1, segment.y2, stroke, segment);
	check_align_sub(X2, segment.x1, stroke, segment);
	check_align_sub(X2, segment.x2, stroke, segment);
	check_align_sub(Y2, segment.y1, stroke, segment);
	check_align_sub(Y2, segment.y2, stroke, segment);

	// ̂Ƃɒ_`FbN
	if (Def.equal(segment.x1, segment.x2)){
	  double mid_y = (segment.y1 + segment.y2) /2;
	  check_align_sub(Y1, mid_y, stroke, segment);
	  check_align_sub(Y2, mid_y, stroke, segment);
	}
	else if (Def.equal(segment.y1, segment.y2)){
	  double mid_x = (segment.x1 + segment.x2) /2;
	  check_align_sub(X1, mid_x, stroke, segment);
	  check_align_sub(X2, mid_x, stroke, segment);
	}


    }
    private static void check_align_sub(int i, double constant, Segment stroke, Segment segment){
	double deviation = Math.abs(stroke.coords(i) - constant); 
	if (deviation < MINIMUM_ALIGN)
	  constraints.add_align(Constraint.ALIGN[i], constant, deviation, segment);
    }


    /** slope ԋ߂̂g */
    private static void check_slope(Segment stroke, Segment segment){
	double deviation;

	Vector2 new_vector = stroke.vector();
	Vector2 old_vector = segment.vector();


	//s
	double sin = old_vector.get_sin(new_vector);
	deviation = Math.abs(sin);
	if (deviation < MINIMUM_SLOPE){
	    constraints.add_slope(
		segment.y2 - segment.y1, segment.x1 - segment.x2, deviation, segment);
	    return;
	}	
	//
	double cos = old_vector.get_cos(new_vector);
	deviation = Math.abs(cos);
	if (deviation < MINIMUM_SLOPE)
	    constraints.add_slope(
		segment.x2 - segment.x1, segment.y2 - segment.y1, deviation, segment);
    }

    private static void check_connection(Segment stroke, Segment segment, Scene scene){
	double deviation;

	deviation = Node.distance(stroke.start_node(), segment.start_node());
 	if (deviation < MINIMUM_CONNECT){
	    start_node_is_connected = true;
	    constraints.add_start_node(segment.start_node(), deviation, segment);
	    return;}
	deviation = Node.distance(stroke.start_node(), segment.end_node());
 	if (deviation < MINIMUM_CONNECT){
	    start_node_is_connected = true;
	    constraints.add_start_node(segment.end_node(), deviation, segment);
	    return;}

	deviation = Node.distance(stroke.end_node(), segment.start_node());
 	if (deviation < MINIMUM_CONNECT){
	    end_node_is_connected = true;
	    constraints.add_end_node(segment.start_node(), deviation, segment);
	    return;}
	deviation = Node.distance(stroke.end_node(), segment.end_node());
 	if (deviation < MINIMUM_CONNECT){
	    end_node_is_connected = true;
	    constraints.add_end_node(segment.end_node(), deviation, segment);
	    return;}

	deviation = segment.distance(stroke.start_node()) ;
	if (deviation 	< MINIMUM_TOUCH){
	    constraints.add_start_online(segment, deviation);
	    return;}
	deviation = segment.distance(stroke.end_node()) ;
	if (deviation 	< MINIMUM_TOUCH){
	    constraints.add_end_online(segment, deviation);
	    return;}

	// sԊũ`FbNBWϊB(slope Ɠd`FbNȂ̂Ŗʂ)
	Vector2 new_vector = stroke.vector();
	Vector2 old_vector = segment.vector();

	double sin = old_vector.get_sin(new_vector);
	deviation = Math.abs(sin);
	if (deviation < MINIMUM_SLOPE){
	    // s!! Wϊ!!
	    Vector2 normal_vector_x = old_vector.normalize();
	    Segment stroke2 = stroke.coord_system(normal_vector_x);
	    Segment segment2 = segment.coord_system(normal_vector_x);

	    double interval = stroke2.y1 - segment2.y1;
	    if (Math.abs(interval) < MINIMUM_ALIGN){
	        // ꒼
	    	constraints.add_parallel(segment, 0, Math.abs(deviation));
		return;
	    }
	    // ꂷĂăpCvɌȂB
	    if (Math.abs(interval) > MAX_PARALLEL)
		return;
	    if ((((stroke2.x1 - segment2.x2)*(stroke2.x2 - segment2.x1))<0)||
		     (((stroke2.x1 - segment2.x2)*(stroke2.x2 - segment2.x2))<0)||
		     (((segment2.x1 - stroke2.x1)*(segment2.x2 - stroke2.x1))<0)) {
	        // sdȂ肠B`FbN
		double target = scene.get_closest_interval(Math.abs(interval));
		deviation = Math.abs(target - Math.abs(interval));
		if (deviation < MINIMUM_PARALLEL)
		    constraints.add_parallel(segment, 
			Tools.sign(interval) * target, Math.abs(deviation));
	    }
	}	
    }




}


