//  Copyright (C) 1999 Takeo Igarashi

import java.awt.event.*;
import java.awt.*;
import java.applet.*;
import java.lang.Math.*;
import java.util.*;


/** wv̕\ */
public class HelpPanel extends Panel {

    public DrawPanel drawPanel;
    
    public HelpPanel(DrawPanel dp) {
	this.drawPanel = dp;
	drawPanel.helpPanel = this;
    }

    public final int XMERGIN = 10;
    public final int YMERGIN = 10;
    public final int YSTEP   = 18;
    
    public int current_line = 2;
    public Graphics graphics;
    public void init_canvas(Graphics g){
    	graphics = g;
    	current_line = 1;
    }
    public void println(String s){
        graphics.drawString(s, XMERGIN, YMERGIN + YSTEP *current_line++);
    }    
    
   public void paint(Graphics g) {

	g.setFont(new Font("Helvetica", Font.PLAIN, 16));

	init_canvas(g);
    	switch (drawPanel.operation_status) {
    	case DrawPanel.ZOOMING:
	    println("Zooming");
	    break;
    	case DrawPanel.MOVING:
	    println("Scrolling the canvas");
	    break;
        case DrawPanel.ERASING:
	    println("Erasing");
	    break;
        default:
	    if (drawPanel.state == DrawPanel.SELECTING){
		println("Beautified lines:");
		println("   Red    - Selected candidate");
		println("   Purple - Other candidates");
		println("   Green  - Geometric constraints satisfied by the red line.");
		println("");
		println("       Click the desired purple candidate to select.");
		println("       Click blank region to finish selection.");
		println("       Draw a freefrom stroke to proceed.");
	    }
	    else if (drawPanel.state == DrawPanel.PREDICTING) {
		println("Predicted lines:");
		println("    Click a purple line if you like it.");
		println("    Click blank region to quit prediction.");
		println("    Draw a freefrom stroke to proceed.");
	    }
	    else {
	    	println("Left Button:");
		println("    Drawing a freeform stroke       -> Beautification");
		println("    Single click on a line segment  -> Prediction");
		println("    Scribbling                         -> Erasing");
		println("    Dragging after a click          -> Erasing");
		println("");
		println("Right Button");
		println("    Simple Dragging                 -> Scrolling");
		println("    Dragging after a click          -> Zooming");
	    }
	    
	    
	    break;
	}
 
   }
}
