//  Copyright (C) 1999 Takeo Igarashi


import java.awt.event.*;
import java.awt.*;
import java.applet.*;

import java.lang.*;

/** `߂̃NX */
public class Graphics2 {

    public static void drawWideLine(Graphics g, 
		double x1, double y1, double x2, double y2, double w){

	drawWideLine(g, (int)x1,(int)y1,(int)x2,(int)y2,w);
    }
    public static void drawWideLine(Graphics g, 
		int x1, int y1, int x2, int y2, double w){

	int x = x2 - x1;
	int y = y2 - y1;
	double length = Math.sqrt(x*x + y*y);
	double nx = x / length * w /2.0;
	double ny = y / length * w /2.0;

	// double tx = ny * w / 2.0;
	// double ty = - nx * w / 2.0;
	
	Point start = new Point(x1, y1);
	Point end   = new Point(x2, y2);
	Vector2 vector = new Vector2(nx, ny);

	Polygon s = new Polygon();

	addPoint(s, start, vector.rotate(90));
	addPoint(s, start, vector.rotate(135));
	addPoint(s, start, vector.rotate(180));
	addPoint(s, start, vector.rotate(225));
	addPoint(s, start, vector.rotate(270));
	addPoint(s, end, vector.rotate(270));
	addPoint(s, end, vector.rotate(315));
	addPoint(s, end, vector.rotate(0));
	addPoint(s, end, vector.rotate(45));
	addPoint(s, end, vector.rotate(90));
	addPoint(s, start, vector.rotate(90));

	g.fillPolygon(s);
	
    }

    static void addPoint(Polygon s, Point p, Vector2 v){
	s.addPoint((int)(p.x + v.x), (int)(p.y + v.y));
    }



    /** center.x, center.y, radius, width */
    public static void drawWideCircle(Graphics g, 
		int x, int y, int radius, int w){

	for(int i= radius - w/2; i < radius + w/2; i++)
	  g.drawOval(x-i, y-i, i*2-1, i*2-1);
    }


    /** [̕\p */
    private static final int MARK_SIZE = 10;

    public static void drawHorizontalMark(Graphics g, int x, int y){
	drawWideLine(g, x-MARK_SIZE, y, x+MARK_SIZE, y, 3);
    }
    public static void drawVerticalMark(Graphics g, int x, int y){
	drawWideLine(g, x, y-MARK_SIZE, x, y+MARK_SIZE, 3);
    }

    public static void drawCongruentMark(Graphics g, int x1, int y1, int x2, int y2){
	Vector2 n = new Vector2(x2-x1, y2-y1).normalize().scale(MARK_SIZE/2);
	Vector2 h = n.rotate(90).scale(2);

	int mx = (x1 + x2)/2;
	int my = (y1 + y2)/2;

	drawWideLine(g, mx+h.x, my+h.y, mx-h.x, my-h.y, 3);
	drawWideLine(g, mx+n.x+h.x, my+n.y+h.y, mx+n.x-h.x, my+n.y-h.y, 3);
	
    }
    // pp 0,30,45,,,,
    public static void drawAngleMark(Graphics g, int x1, int y1, int x2, int y2){
	// ͌Ε̂ŕ\ȂB
	if ((x1 == x2) || (y1 == y2)) 
	    return;
	Vector2 n  = new Vector2(x2-x1, y2-y1).normalize().scale(MARK_SIZE);
	if (n.y >0 ) n = n.rotate(180);
	Vector2 b  = new Vector2(MARK_SIZE , 0);
	Vector2 n2 = n.scale(2);
	Vector2 b2 = b.scale(2);
	int mx = (x1 + 2*x2)/3;
	int my = (y1 + 2*y2)/3;
	drawWideLine(g, mx-b2.x,my-b2.y,mx+b2.x, my+b2.y, 3);
	drawWideLine(g, mx,     my,     mx+n2.x, my+n2.y, 3);
	drawWideLine(g, mx+b.x, my+b.y, mx+n.x, my+n.y, 3);
    }
    public static void drawSlopeMark(Graphics g, int x1, int y1, int x2, int y2){
	Vector2 normal_vector = new Vector2(x2-x1, y2-y1).normalize();
	Vector2 h1 = normal_vector.rotate(150).scale(MARK_SIZE*2);
	Vector2 h2 = normal_vector.rotate(210).scale(MARK_SIZE*2);
	int mx = (x1 + 2*x2)/3;
	int my = (y1 + 2*y2)/3;
	drawWideLine(g, mx, my, mx+h1.x, my+h1.y, 3);
	drawWideLine(g, mx, my, mx+h2.x, my+h2.y, 3);
    }
    // perpendicular, right angle
    public static void drawSlopeMark2(Graphics g, int x1, int y1, int x2, int y2){
	Vector2 n = new Vector2(x2-x1, y2-y1).normalize().scale(MARK_SIZE);
	Vector2 h1 = n.rotate(90);
	Vector2 h2 = h1.scale(2);
	int mx = (x1 + 2*x2)/3;
	int my = (y1 + 2*y2)/3;
	drawWideLine(g, mx, my, mx+h1.x, my+h1.y, 3);
	drawWideLine(g, mx+h1.x, my+h1.y, mx+h1.x+n.x, my+h1.y+n.y, 3);
	drawWideLine(g, mx+n.x, my+n.y, mx+n.x+h2.x, my+n.y+h2.y, 3);
    }

    public static void drawParallelMark(Graphics g, int x1, int y1, int x2, int y2){

	Vector2 normal_vector = new Vector2(x2-x1, y2-y1).normalize();
	Vector2 h1 = normal_vector.rotate(150).scale(MARK_SIZE);
	Vector2 h2 = normal_vector.rotate(210).scale(MARK_SIZE);


	drawWideLine(g, x1, y1, x1-h1.x, y1-h1.y, 3);
	drawWideLine(g, x1, y1, x1-h2.x, y1-h2.y, 3);
	drawWideLine(g, x2, y2, x2+h1.x, y2+h1.y, 3);
	drawWideLine(g, x2, y2, x2+h2.x, y2+h2.y, 3);
	drawWideLine(g, x1, y1, x2, y2, 3);
    }

}

