//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.lang.Math.*;
import java.util.*;


/** solver  pool  vfBvZr̕ϐZbgێB
 *  \bhƂĐ󂯎ČvZs@\B
 */
public class Element {

	public double[]		variables;
	private final double NONE = -1;
	private final int X1 = 0;
	private final int Y1 = 1;
	private final int X2 = 2;
	private final int Y2 = 3;

	/** ׂĂ̕ϐm肵Ă邩ǂB 񂪓Kp邽тɃ`FbN*/
	public boolean complete;

	/** ̓Xg[N̈ʒuɏ\߂lꂽ */
	private CloseEnough close_enough;
	private Element root;

	public LinkedList 	history;	// vZ̉ߒŎgp 
	public LinkedList	suspended;	// Aҋ@̐ 
	public LinkedList	children;	// 琶܂ꂽ element 

	private final int SUCCEED = 0;
	private final int SUSPENDED = 1;
	private final int REDUNDANT = 2;
	private final int FAILED = 3;

    /** root  */
    Element(CloseEnough close_enough_){
	root = this;
	close_enough = close_enough_;
	complete = false;
	variables = new double[4];
	  for(int i=0; i < 4; i++) variables[i]=NONE;
	history = new LinkedList();
	suspended = new LinkedList();
	children = new LinkedList();
    }


    /** add_constraint_sub Ă΂BǉĒlύX邽߂ɐeƓȎqB*/
    Element(Element e){
	root = e.root;
	close_enough = e.close_enough;
	complete = false;
	variables = (double[]) e.variables.clone();
	history = e.history.copy();
	suspended = e.suspended.copy();
	children = new LinkedList();
    }

    public boolean fixed(int i){
	return (variables[i] != NONE);
    }

    /** gather_complete_elements Ă΂B */
    public void check_complete(){
	if ((variables[X1] != NONE) &&
	    (variables[Y1] != NONE) &&
	    (variables[X2] != NONE) &&
	    (variables[Y2] != NONE)){
	  complete = true;
	  }

    }


    public void display(){
	display_sub("");
    }
    public void display_sub(String s){
	System.out.println(s+ (int)variables[X1] +","+ (int)variables[Y1]+","+
		 (int)variables[X2]+","+ (int)variables[Y2]+
		 "   suspend "+suspended.size() + ", histroy "+ history.size());
        Enumeration e = children.elements();
	while (e.hasMoreElements())
		((Element) e.nextElement()).display_sub(s + " ");
	
    }

    /** KpBqA**** qւKpB */
    public void apply_constraint(Constraint constraint){
	//vZrŎqVӂ̂Ō̎qۑB
	LinkedList original_children = children.copy(); 
	
	if (apply_constraint_sub(constraint)){
	    Enumeration e = original_children.elements();
	    while (e.hasMoreElements())
		((Element) e.nextElement()).apply_constraint(constraint);
	}
    }
    /** qČvZB true ԂB */
    private boolean apply_constraint_sub(Constraint constraint){
	Element	child = new Element(this);
	int result = child.calcurate(constraint);
	switch (result){
	    case SUCCEED:	//vZɐBchild ƂĒǉB

		// ܂ suspend ƖȂ`FbNB
		if (child.suspend_check()) break;

		// l̕ωƂ̃Xg[N痣ꂷĂȂ`FbNB
		// ?? if (child.too_much_deformation()) break;
				
		// ܂蓯̂炱̎q͎̂Ă邪A̎qւ̓`d͂B
		// suspend Ƃ̓`FbNȂB
		child.history.append(constraint);
		if (child.suspended.size() == 0)
		  if (child.search_identical(root)) return true;

		// ׂẴ`FbNpXB
		child.check_complete();	
	  	close_enough.check(child);
		children.append(child);
		return true;
	    case SUSPENDED:
		child.suspended.append(constraint);
		children.append(child);
		return true;
	    case REDUNDANT:	// łɐ񂪖ĂB
		// ?? ɉĂB
		history.append(constraint);
		break;
	    case FAILED:
		break;
	}
	// break ł܂ł玸sBchild ͎̂ĂB
	return false;
    }	



    /** ۂɌvZĎ̒lXVBvZʂ|[gB */
    private int calcurate(Constraint constraint){
	// return SUCCEED, SUSPEND, IDENTICAL, FAILED
	double[] v = variables;
	int i, j;	//[ptO
	switch (constraint.type ){
	  case Constraint.START_NODE:	// [_w x1 = a, y1 = b
	    if (    (v[X1] == constraint.coefficients[0]) 
		 && (v[Y1] == constraint.coefficients[1]))
		return REDUNDANT;
	    if (   (( v[X1] == NONE ) || (v[X1] == constraint.coefficients[0])) 
		&& (( v[Y1] == NONE ) || (v[Y1] == constraint.coefficients[1])) ){
		v[X1] = constraint.coefficients[0];
		v[Y1] = constraint.coefficients[1];
		return SUCCEED;
	    }
	    return FAILED;
	  case Constraint.END_NODE:	// [_w x2 = a, y2 = b
	    if (    (v[X2] == constraint.coefficients[0]) 
		 && (v[Y2] == constraint.coefficients[1]))
		return REDUNDANT;
	    if (   (( v[X2] == NONE ) || (v[X2] == constraint.coefficients[0])) 
		&& (( v[Y2] == NONE ) || (v[Y2] == constraint.coefficients[1])) ){
		v[X2] = constraint.coefficients[0];
		v[Y2] = constraint.coefficients[1];
		return SUCCEED;
	    }
	    return FAILED;
	  case Constraint.CONGRUENT:	// v[ x2-x1= a, y2-y1= b
	    i = calcurate_diff(X2,X1, constraint.coefficients[0]);
	    j = calcurate_diff(Y2,Y1, constraint.coefficients[1]);
	    return report_pariwise_constraints(i,j);
	  case Constraint.ALIGN_X1:	// x0 = a;
	    return calcurate_align(X1, constraint.coefficients[0]);
	  case Constraint.ALIGN_Y1:
	    return calcurate_align(Y1, constraint.coefficients[0]);
	  case Constraint.ALIGN_X2:
	    return calcurate_align(X2, constraint.coefficients[0]);
	  case Constraint.ALIGN_Y2:
	    return calcurate_align(Y2, constraint.coefficients[0]);
	  case Constraint.START_ONLINE:	// a * x + b * y = c
	    return calcurate_online(X1, Y1, constraint.coefficients[0], 
		constraint.coefficients[1], constraint.coefficients[2], constraint.START_ONLINE);
	  case Constraint.END_ONLINE:	// a * x + b * y = c
	    return calcurate_online(X2, Y2, constraint.coefficients[0],
		constraint.coefficients[1], constraint.coefficients[2], constraint.END_ONLINE);
	  case Constraint.DIFF_X:	// a * x + b * y = c
	    return calcurate_diff(X2,X1, constraint.coefficients[0]);
	  case Constraint.DIFF_Y:	// a * x + b * y = c
	    return calcurate_diff(Y2,Y1, constraint.coefficients[0]);

	  case Constraint.SLOPE:	// a * (x2-x1) + b *(y2-y1) = 0
	    if ( !fixed(X1) && fixed(Y1) && fixed(X2) && fixed(Y2) ){
		v[X1] = v[X2] + (v[Y2] - v[Y1]) * constraint.coefficients[1] / constraint.coefficients[0];
		return SUCCEED;}
	    if ( fixed(X1) && !fixed(Y1) && fixed(X2) && fixed(Y2) ){
		v[Y1] = v[Y2] + (v[X2] - v[X1]) * constraint.coefficients[0] / constraint.coefficients[1];
		return SUCCEED;}
	    if ( fixed(X1) && fixed(Y1) && !fixed(X2) && fixed(Y2) ){
		v[X2] = v[X1] - (v[Y2] - v[Y1]) * constraint.coefficients[1] / constraint.coefficients[0];
		return SUCCEED;}
	    if ( fixed(X1) && fixed(Y1) && fixed(X2) && !fixed(Y2) ){
		v[Y2] = v[Y1] - (v[X2] - v[X1]) * constraint.coefficients[0] / constraint.coefficients[1];
		return SUCCEED;}
	    if ( fixed(X1) && fixed(Y1) && fixed(X2) && fixed(Y2) ){
		 System.out.println(""+((v[X2] - v[X1]) * constraint.coefficients[0] + 
		    (v[Y2] - v[Y1]) * constraint.coefficients[1] ));
		if (Def.negrigible(
		    (v[X2] - v[X1]) * constraint.coefficients[0] + 
		    (v[Y2] - v[Y1]) * constraint.coefficients[1] ))
		    return REDUNDANT;
		else
		    return FAILED;
	    }
	    // A...
	    // end .. fixed, start_connect
	    if ( !fixed(X1) && !fixed(Y1) && fixed(X2) && fixed(Y2) )
		return calcurate_slope_sub(constraint, Constraint.START_ONLINE, X1, Y1, X2, Y2);
	    if ( fixed(X1) && fixed(Y1) && !fixed(X2) && !fixed(Y2) )
		return calcurate_slope_sub(constraint, Constraint.END_ONLINE, X2, Y2, X1, Y1);
	    return SUSPENDED; 
   	
	
	  case Constraint.ALIGN_X:	// parallel ̓P[X
	    i = calcurate_align(X1, constraint.coefficients[0]);
	    j = calcurate_align(X2, constraint.coefficients[0]);
	    return report_pariwise_constraints(i,j);
	  case Constraint.ALIGN_Y:	// parallel ̓P[X
	    i = calcurate_align(Y1, constraint.coefficients[0]);
	    j = calcurate_align(Y2, constraint.coefficients[0]);
	    return report_pariwise_constraints(i,j);
	  case Constraint.PARALLEL:	// v[
	    i = calcurate_online(X1, Y1, constraint.coefficients[0], 
		constraint.coefficients[1], constraint.coefficients[2], constraint.START_ONLINE);
	    j = calcurate_online(X2, Y2, constraint.coefficients[0], 
		constraint.coefficients[1], constraint.coefficients[2], constraint.END_ONLINE);
	    return report_pariwise_constraints(i,j);
	}
	return FAILED;
    }


    // [KvƂ鐧ɊւvZʃ|[g̊Ǘ
    private int report_pariwise_constraints(int i, int j){
	    if (( i == FAILED ) || ( j == FAILED )) return FAILED;
	    if (( i == REDUNDANT ) && ( j == REDUNDANT )) return REDUNDANT;
	    if (( i == SUSPENDED ) || ( j == SUSPENDED )) return SUSPENDED;
	    return SUCCEED;
    }


    // ǍvZs
    // (end.fixed() && start_online  ) || ( start.fixed() && end_online)
    // type = START_ONLINE or END_ONLINE , PARALLEL (start + end)
    private int calcurate_slope_sub(Constraint constraint, int type, int x1,int y1, int x2, int y2){
	int result;
        suspended.reset();
	while (suspended.hasMoreElements()){
	    Constraint constraint2 = (Constraint) suspended.currentElement();
	    if (constraint2.type == type){
		result = slope_and_online(
		    constraint2.coefficients[0],
		    constraint2.coefficients[1],
		    constraint2.coefficients[2],
		    constraint.coefficients[0],
		    constraint.coefficients[1],
		    x1, y1, x2, y2);
		if (result == SUCCEED){
		    history.append(constraint2);
		    suspended.remove();
		}
		return result;	// SUCCEED or FAILED
	    }
	    suspended.nextElement();
	}
	return SUSPENDED;
    }




    private int calcurate_align(int i, double constant){
	if (variables[i] == constant) return REDUNDANT;
	if (variables[i] == NONE) {
		variables[i] = constant;
		return SUCCEED;
	}
	return FAILED;
    }


    // start  end pBtype ͘Ȃ蔻
    private int calcurate_online(int x, int y, double a,double b,double c, int type){
	if (variables[x] == NONE && variables[y] == NONE) {
		// A`FbN
		return calcurate_online_sub(x, y, a, b, c, type);
		//return SUSPENDED;
	}
	else if (variables[x] == NONE && variables[y] != NONE){
		variables[x] = ((c - variables[y] * b) / a);
		return SUCCEED;
	}
	else if (variables[y] == NONE && variables[x] != NONE){
		variables[y] = ((c - variables[x] * a) / b);
		return SUCCEED;
	}
	else if (Math.abs(variables[x] * a + variables[y] * b - c ) < Def.ERROR_RANGE){
		return REDUNDANT;
	}
	return FAILED;
    }
    // suspended ɂO A`FbN
    // online  slope Ƃ̘A͐ł̂ŃpXB <- !!
    // parallel  slope ͂肦ȂB
    // parallel  online ͂肦̂łŃ`FbNB
    // ܂̂܂܂ƎgƂ̊ԂłĂ܂̂łȂƂȂẮB
    private int calcurate_online_sub(int X1, int Y1, double a,double b,double c, int type ){
	int X2 = 3 - Y1;
	int Y2 = 3 - X1;
	int result;
        suspended.reset();
	while (suspended.hasMoreElements()){
	    Constraint constraint2 = (Constraint) suspended.currentElement();
	    if ((constraint2.type == type) || (constraint2.type == Constraint.PARALLEL)) {
		result = online_and_online(
		    a,b,c,
		    constraint2.coefficients[0],
		    constraint2.coefficients[1],
		    constraint2.coefficients[2],
		    X1, Y1);
		// ł肪PARALLELłȂꍇAB
		if ((result == SUCCEED) && (constraint2.type != Constraint.PARALLEL)) {
		    history.append(constraint2);
		    suspended.remove();
		}
		// FAILED ̏ꍇAĝłÂB
		if (result == SUCCEED)
			return result;	// SUCCEED or FAILED
	    }
	    else  // online + slope c肪m肵Ăꍇ̂ݘA
	    if ((constraint2.type == Constraint.SLOPE) && (fixed(X2) && fixed(Y2))){
		result = slope_and_online(
		    a, b, c, 
		    constraint2.coefficients[0],
		    constraint2.coefficients[1],
		    X1, Y1, X2, Y2);
		if (result == SUCCEED){
		    history.append(constraint2);
		    suspended.remove();
		}
		return result;	// SUCCEED or FAILED
	    }
	    suspended.nextElement();
	}
	return SUSPENDED;
    }






    // congruent p
    private int calcurate_diff(int i, int j, double constant){ // i - j = c
	if ((variables[i] == NONE) && (variables[j] == NONE)) return SUSPENDED;
	if ((variables[i] != NONE) && (variables[j] == NONE)){
		variables[j] = variables[i] - constant;
		return SUCCEED;	}
	if ((variables[i] == NONE) && (variables[j] != NONE)){
		variables[i] = variables[j] + constant;
		return SUCCEED;	}  
	// ?? abs 덷̍l
	if (Def.equal(variables[i] - variables[j], constant)) return REDUNDANT;
	return FAILED;
    }		
    /** A lύXB	 */
    //	x1,y1 are not fixed,  x2,y2 are fixed	
    //			a  * x1      + b  * y1      = c
    //			aa * (x2-x1) + bb * (y2-y1) = 0
    private int slope_and_online(
			double a, double b, double c, double aa, double bb,
			int x1, int y1, int x2, int y2){
	double diameter = a * bb - b * aa;
	if (Math.abs(diameter) < Def.ERROR_RANGE) return FAILED;
	double tmp = variables[x2] * aa + variables[y2] * bb;
	
	variables[x1] = (( -b * tmp + bb * c) / diameter); 	
	variables[y1] = ((  a * tmp - aa * c) / diameter); 	

	return SUCCEED;
    }
    /** A lύXB	 */
    //	x1,y1 are not fixed,  x2,y2 are fixed	
    //			a0 * x1      + b0 * y1      = c0
    //			a1 * x1      + b1 * y1      = c1
    private int online_and_online(
			double a0, double b0, double c0, 
			double a1, double b1, double c1,
			int x1, int y1){
	System.out.println("online"+", "+(int)a0+", "+(int)b0+", "+(int)c0+", "+(int)a1+", "+(int)b1+
				", "+(int)c1);
	if (Math.abs(a0 * b1 - a1 * b0) < Def.ERROR_RANGE)
		return FAILED;
	System.out.println("succeed");
	variables[x1] = ((-b0 * c1 + b1 * c0)/(a0 * b1 - a1 * b0)) ;
	variables[y1]=  ((-a0 * c1 + a1 * c0)/(a1 * b0 - a0 * b1));
	return SUCCEED;
    }












    /** KpA suspend ̒g`FbNB
        Kvȓ`dslXVB true ԂB */
    private boolean suspend_check(){
	int result;
	Constraint constraint;
        Enumeration e = suspended.elements();
	while (e.hasMoreElements()){
	  constraint =  (Constraint) e.nextElement();
	  result = calcurate(constraint);	// Aߒsuspendedω\蒍
	  switch (result){
	    case FAILED: 	// BfĖ߂B
	      return true;
	    case SUCCEED:	// vŽʁAlXVBsuspended Ăт͂߂݂B
	      history.append(constraint);
	      suspended.remove(constraint);
	      e = suspended.elements();
	      break;
	    case REDUNDANT:	//łɖĂBƂ̂ĎցB
	      history.append(constraint);
	      suspended.remove(constraint);
	      break;
	    case SUSPENDED:	//Ă suspend. fʂ肵ĎցB	      
	      //suspended.nextElement();
	  }
	}
	return false;	//suspended̍XVvZI
    }

    /** ܂蓯̂Ȃ`FbNB */
    private boolean search_identical(Element element){
	if (this == element)
		return false;
	switch (relation(element)){
	  case IDENTICAL:
	    // ̔!!  history փ}[W
	    element.history.merge(history);
	    return true;
	  case DIFFERENT:
	    return false;
	  case NOT_YET:
	    Enumeration e = element.children.elements();
	    while (e.hasMoreElements())
		if (search_identical((Element) e.nextElement()))
			return true;
	}
	return false;
    }
    /**    
	100  100  IDENTICAL
	100  110  DIFFERENT
	-1   100  DIFFERENT
	100  -1	  NOT_YET

	suspeded ɂ!!
    */
    private int relation(Element e){
	boolean not_yet = false;
	for (int i = 0; i<4; i++)
	    if (variables[i] != e.variables[i])
		if (e.fixed(i))
		  return DIFFERENT;
		else
		  not_yet = true;
	// ̊ml͑SvBm肠B suspended Ă悢Bq݂KvB
	if (not_yet)	
		return NOT_YET;
	// ml͊SvB suspended ƂƂ... ႤI q݂KvȂB
	if (e.suspended.size() > 0)
		return DIFFERENT;
	return IDENTICAL;
    }
    private final int IDENTICAL = 0;
    private final int DIFFERENT = 1;
    private final int NOT_YET   = 2;

}
