//  Copyright (C) 1999 Takeo Igarashi

import java.awt.event.*;
import java.awt.*;
import java.applet.*;
import java.lang.Math.*;
import java.util.*;


/** `ȂJoX */
class DrawPanel extends Panel {
    public static final int LINES = 0;
    public static final int POINTS = 1;
    Scene scene;
    Candidates candidates;

    int x1,y1;
    int x2,y2;
    int xl, yl;
    double stroke_length;

    public static double scale = 1;
    public static double original_scale = 1;
    // top-left corner of abstract frame on the real window
    public static int frameX = 0; 
    public static int frameY = 0;
    public static int original_frameX;
    public static int original_frameY;
    public static int operation_status;


    public static final int NONE = 0;
    public static final int ZOOMING = 1;
    public static final int MOVING = 2;
    public static final int DRAWING = 3;
    public static final int ERASING = 4;


    public static Eraser eraser;
    public static Feedback feedback;

    public int state;
    public static final int SETTLED = 0; 
    public static final int SELECTING = 1;
    public static final int PREDICTING = 2;


    private static final int MINIMUM_STROKE_LENGTH = 10;
    private static final int MINIMUM_SELECT_DISTANCE = 10;

    private static final int WIRE_VISIBLE = 2;	// scale

    public static HelpPanel helpPanel;

    public DrawPanel() {
	eraser =  new Eraser();
	feedback =  new Feedback();
	setBackground(Color.white);
	addMouseMotionListener(new MouseDispatcher());
	addMouseListener(new MouseDispatcher());

	scene = new Scene();
	candidates = new Candidates();

	state = SETTLED;
	
   }

  public void save(String filename){
	File.save(filename, scene);
    
  }

  public void load(String filename){
	scene = (Scene)File.load(filename);
	repaint_all();
  }

  public void clear(){
	scene = new Scene();
	candidates = new Candidates();

	state = SETTLED;
	repaint_all();
  }  	


  // event handlers ---------------------

  public void zooming_interim(MouseEvent e){
	//scale = original_scale + (e.getX() - x1)/100.0;
	scale = original_scale * Math.pow(Math.E, (e.getX() - x1)/100.0);
	frameX = x1 + (int)((original_frameX - x1)*scale/original_scale);
	frameY = y1 + (int)((original_frameY - y1)*scale/original_scale);
	repaint_all();
  }

  public void moving_interim(MouseEvent e){
	frameX = frameX + (e.getX() - x1);
	frameY = frameY + (e.getY() - y1);
	x1 = e.getX();
	y1 = e.getY();
    	repaint_all();
  }	


  public void drawing_interim(MouseEvent e){
	      	xl = x2;
	      	yl = y2;
	      	x2 = e.getX();
	      	y2 = e.getY();
		stroke_length += Math.sqrt((x2-xl)*(x2-xl)+(y2-yl)*(y2-yl));

	     	repaint_feedback();
	      	//repaint_all();

  }



  public void zooming_start(MouseEvent e){
		operation_status = ZOOMING;
		original_scale = scale;
		original_frameX = frameX;
		original_frameY = frameY;
		mouse_start(e);
  }
  public void moving_start(MouseEvent e){
		operation_status = MOVING;
		mouse_start(e);
  }

  public void drawing_start(MouseEvent e){
		operation_status = DRAWING;
		mouse_start(e);
		stroke_length=0;

		feedback.draw_init();
  }
  public void mouse_start(MouseEvent e){
    		x1 = e.getX();
     		y1 = e.getY();
		x2 = x1;
		y2 = y1;
  }


  public void drawing_finish(MouseEvent e){

	
	System.out.println("storke "+stroke_length+" "+ 
		(Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)) / stroke_length));

	if (stroke_length < 10) {
		return;
	}
	else if ((Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)) / stroke_length)<0.9) {
		finish_selection();
		eraser.erase_closest(x1, y1);
	}
	else {	
	    Segment stroke = new Segment(
		rcX(x1), rcY(y1), rcX(x2), rcY(y2));
            candidates = Beautifier.generate_candidates(stroke, scene, scale);
	    state = SELECTING;
	    repaint();
	}
  }


  /** set the primary candidate to the scene as a new settled segment */
  public void finish_selection(){
	if (candidates.size() > 0 && state != PREDICTING){
	    Segment primary = candidates.get_primary_segment();
	    if (primary != null)
		scene.append(primary);
	}
	candidates.clear();
	repaint_all();
	state = SETTLED;
  }

  /** `̑IB͂ -> mƗ\A I -> primary ςB */
  public void select_candidate(){
	Segment segment = (Segment) candidates.get_closest(
		rcX(x1), rcY(y1), MINIMUM_SELECT_DISTANCE);
	if (segment == null){
	  Segment trigger = candidates.get_primary_segment();
	  finish_selection();
	  if (trigger != null){
	    generate_predictions(trigger);
	  }
	}
	else{
	  candidates.set_primary((Candidate) segment);
	  repaint_all();
	}
  }
  
  /** \̑IB͂ -> \j, I -> mƎ\ */
  public void select_predicted_candidate(){
	Segment segment = candidates.get_closest(
		rcX(x1), rcY(y1), MINIMUM_SELECT_DISTANCE);
	if (segment == null)
	  interrupt_prediction();
	else{
	  scene.append(segment);
	  segment = scene.get_closest(
		rcX(x1), rcY(y1), MINIMUM_SELECT_DISTANCE);
	  generate_predictions(segment);
	}
  }

  /** \~B ̂ĂB erase 쒼Oɂ΂B*/
  public void interrupt_prediction(){
	  candidates.clear();
	  repaint_all();
	  state = SETTLED;
  }	


  /** make predictions trigger ̎ɗ\ */
  public void generate_predictions(Segment trigger){
        candidates = Predictor.generate_candidates(trigger, scene);
	repaint_all();
	if (candidates.size() >0)
	  state = PREDICTING;
	else 
	  state = SETTLED;
  }	

  /** m肵Ă segment  click ɂNė\B*/
  public void start_prediction(){
 	Segment trigger = scene.get_closest(rcX(x1), rcY(y1), MINIMUM_SELECT_DISTANCE);
	if (trigger != null){
	  generate_predictions(trigger);
	}
  }












   /** abstract coords -> screen coords */
   public int cX(double x){
	return (int)(x * scale)+  frameX;
    }
   /** abstract coords -> screen coords */
   public int cY(double y){
	return (int)(y * scale)+ frameY;
    }

   /** screen coords -> abstract coords */
   public double rcX(int x){
	return (double)((x - frameX) / scale);
    }
   /** screen coords -> abstract coords */
   public double rcY(int y){
	return (double)((y - frameY) / scale);
   }
   public double rc(double size){
 	return (size / scale);
   }
	










   // paint

   public void repaint_feedback(){
	//redraw_background = false;
	repaint();
   }
   public void repaint_all(){
	redraw_background = true;
	repaint();
   }

   boolean redraw_background = true;
   Image buffered_image;

   public void update(Graphics g) {
	paint(g);
   }
   public void paint(Graphics g) {
     if (redraw_background){

	//double buffering
	buffered_image = createImage(getSize().width, getSize().height);
	Graphics bg = buffered_image.getGraphics();
	//Graphics bg = g;

	// ʏ
	bg.clearRect(0,0, getSize().width, getSize().height);

	//bg.setPaintMode();
	Enumeration  e;
	Enumeration  ee;

	// clear wire
	draw_segment_init();

	// draw the scene 
	e = scene.elements();
      	while (e.hasMoreElements())
	    draw_segment(bg, (Segment) e.nextElement(), Color.black);

	// draw the candidates 
	e = candidates.elements();
	if (e.hasMoreElements()){
      	  while (e.hasMoreElements())
	    draw_segment(bg, (Segment) e.nextElement(), Color.magenta);
	}
	Candidate primary = candidates.get_primary_candidate();
	if (primary != null)
	  draw_segment(bg, (Segment) primary, Color.red);

	draw_segment_wire(bg);

	// draw explanations
	if (primary != null)
	  draw_explanations(bg, primary);

	//double buffering
	bg.dispose();
        g.drawImage(buffered_image,0,0,this);

	feedback.previous = feedback.NONE;

	redraw_background = false;
     }
     else
	feedback.clear(g);

     feedback.draw(g);
   }

   private void draw_segment(Graphics g, Segment p, Color color){
	g.setColor(color);
	Graphics2.drawWideLine(
			g, cX(p.x1), cY(p.y1), cX(p.x2), cY(p.y2),
			scale * 8);
	if (scale > WIRE_VISIBLE) wires.append(p);
   }

   /** ԏ(Ō)ɐc` */
   private LinkedList wires;
   private void draw_segment_init(){
	wires = new LinkedList();
   }
   private void draw_segment_wire(Graphics g){	
	Segment p;
	g.setColor(Color.white);
	Enumeration e = wires.elements();
      	while (e.hasMoreElements()){
	    p = (Segment) e.nextElement();
	    g.drawLine(cX(p.x1), cY(p.y1), cX(p.x2), cY(p.y2));
	}
    }


    // Ă鐧̕\	
    public void draw_explanations(Graphics g, Candidate candidate){
	  g.setColor(Color.green);
	  Enumeration e = candidate.related_constraints.elements();
      	  while (e.hasMoreElements())
	    draw_explanation(g, candidate, (Constraint) e.nextElement());
    }

    public void draw_explanation(Graphics g, Candidate c, Constraint constraint){
	  // if (constraint.references.size() == 0) return;
	  Enumeration e;
	  switch(constraint.type){
	    case Constraint.CONGRUENT:
        	e = constraint.references.elements();
		while (e.hasMoreElements()){
		  Segment s = (Segment) e.nextElement();
		  Graphics2.drawCongruentMark(g, cX(s.x1),cY(s.y1),cX(s.x2), cY(s.y2));
		}
		break;
	    case Constraint.START_ONLINE:
	    case Constraint.START_NODE:
		Graphics2.drawWideCircle(g, cX(c.x1), cY(c.y1), 10, 3);
		break;
	    case Constraint.END_ONLINE:
	    case Constraint.END_NODE:
		Graphics2.drawWideCircle(g, cX(c.x2), cY(c.y2), 10, 3);
		break;
	    case Constraint.ALIGN_X1:
	        if (constraint.references.size() == 0) return;
		Graphics2.drawVerticalMark(g, cX(c.x1), cY(c.y1));
		draw_explanation_align_x(g, c.x1, constraint.references);
		break;
	    case Constraint.ALIGN_Y1:
	        if (constraint.references.size() == 0) return;
		Graphics2.drawHorizontalMark(g, cX(c.x1), cY(c.y1));
    		draw_explanation_align_y(g, c.y1, constraint.references);
		break;
	    case Constraint.ALIGN_X2:
	        if (constraint.references.size() == 0) return;
		Graphics2.drawVerticalMark(g, cX(c.x2), cY(c.y2));
    		draw_explanation_align_x(g, c.x2, constraint.references);
		break;
	    case Constraint.ALIGN_Y2:
	        if (constraint.references.size() == 0) return;
		Graphics2.drawHorizontalMark(g, cX(c.x2), cY(c.y2));
    		draw_explanation_align_y(g, c.y2, constraint.references);
		break;
	    case Constraint.SLOPE:
        	e = constraint.references.elements();
		if (!e.hasMoreElements()){ // t@X == ܂p
		    Graphics2.drawAngleMark(g, cX(c.x1),cY(c.y1),cX(c.x2), cY(c.y2));
		    break;
		}
		while (e.hasMoreElements()){
		  Segment s = (Segment) e.nextElement();
		  if (s.parallel(c))
		    Graphics2.drawSlopeMark(g, cX(s.x1),cY(s.y1),cX(s.x2), cY(s.y2));
		  else
		    Graphics2.drawSlopeMark2(g, cX(s.x1),cY(s.y1),cX(s.x2), cY(s.y2));
		}
		break;
	    case Constraint.PARALLEL:
	    case Constraint.ALIGN_X:
	    case Constraint.ALIGN_Y:
        	e = constraint.references.elements();
		// ԋ߂̒T
		Segment s = (Segment) e.nextElement();
		double min = c.parallel_interval(s);
		while (e.hasMoreElements()){
		    Segment segment = (Segment) e.nextElement();
		    double interval = c.parallel_interval(segment);
		    if (min > interval){
			min = interval;
			s = segment;
		    }
		}
			
		// 񓙕
		Node mid_node = new Node( (c.x1 + c.x2)/2 , (c.y1 + c.y2)/2);
		Segment n = new Segment(mid_node.x, mid_node.y, 
			mid_node.x - (c.y2-c.y1), mid_node.y + (c.x2-c.x1));
		// _
		Node cross_node = n.cross_node(s);
		if (cross_node == null) {
			System.out.println("error in parallel explanation");
			break;}
		n = new Segment(mid_node, cross_node);
		Graphics2.drawParallelMark(g, cX(n.x1),cY(n.y1),cX(n.x2), cY(n.y2));
		break;
	  }
    }

    public void draw_explanation_align_x(Graphics g, double x, LinkedList references){
	Segment s;
        Enumeration e = references.elements();
	while (e.hasMoreElements()){
	  s = (Segment) e.nextElement();
	  if (s.coords(0) == x) 
		Graphics2.drawVerticalMark(g, cX(s.x1), cY(s.y1));
	  if (s.coords(2) == x) 
		Graphics2.drawVerticalMark(g, cX(s.x2), cY(s.y2));
	  else if ((s.coords(0) + s.coords(2))/2 == x)
		Graphics2.drawVerticalMark(g, cX((s.x2 + s.x1)/2), cY((s.y2+s.y1)/2));
	}
    }
    public void draw_explanation_align_y(Graphics g, double y, LinkedList references){
	Segment s;
        Enumeration e = references.elements();
	while (e.hasMoreElements()){
	  s = (Segment) e.nextElement();
	  if (s.coords(1) == y) 
		Graphics2.drawHorizontalMark(g, cX(s.x1), cY(s.y1));
	  if (s.coords(3) == y) 
		Graphics2.drawHorizontalMark(g, cX(s.x2), cY(s.y2));
	  else if ((s.coords(1) + s.coords(3))/2 == y)
		Graphics2.drawHorizontalMark(g, cX((s.x2 + s.x1)/2), cY((s.y2+s.y1)/2));
	}
    }
	










   // feedback object

   public class Feedback {
	public int previous;
	public int p1, p2, p3, p4;
	public double p5;
	public final int NONE = 0;
	public final int LINE = 1;
	public final int OVAL = 2;

	private int prev_x, prev_y;


	Feedback(){
		previous = NONE;
	}

	public void clear(Graphics g){
		//g.setXORMode(getBackground());
		g.setColor(Color.red);
		if (previous == LINE){
		   Graphics2.drawWideLine(g, p1, p2, p3, p4, p5);
		   if (scale > WIRE_VISIBLE) 
		     g.drawLine(p1, p2, p3, p4);
		}
		if (previous == OVAL)
		   g.drawOval(p1, p2, p3, p4); 
		previous = NONE;
	}
	

	public void draw_init(){
		prev_x = x1;
		prev_y = y1;
	}
	public void draw(Graphics g){
		//g.setXORMode(getBackground());
		g.setColor(Color.red);

	     	// draw feed back objects 
		if (operation_status == DRAWING)  {
		    //p1 = x1; p2 = y1; p3 = x2; p4 = y2; p5 = scale * 8;
		    p1 = prev_x; p2 = prev_y; p3 = x2; p4 = y2; p5 = scale * 8;
		    prev_x = x2; prev_y = y2;
		    Graphics2.drawWideLine(g, p1, p2, p3, p4, p5);
		    if (scale > WIRE_VISIBLE) 
		      g.drawLine(p1, p2, p3, p4);
		    previous = LINE;
		}
		else if (operation_status == ERASING) {
		    p1 = x1-eraser.size; p2 = y1-eraser.size; 
		    p3 = eraser.size*2;  p4 = eraser.size*2; 
		    g.drawOval(p1, p2, p3, p4); 
	    	    previous = OVAL;
		}
		
	}

    }












   // eraser

   public class Eraser {
  	public int size;
        public Timer timer;

	Eraser(){
		size = 5;
		timer = new Timer();
	}

	public void interim(MouseEvent e){
		timer.stop_ifAlive();
		x2 = e.getX();
		y2 = e.getY();
		do_erase();
		x1 = x2;
		y1 = y2;
	}

  	public void start(MouseEvent e){
	  size = 5;
	  timer.stop_ifAlive();
	  timer = new Timer();
	  timer.start();
	  do_erase();

	  operation_status = ERASING;
	  mouse_start(e);
	}

  	public void finish(MouseEvent e){
	  timer.stop_ifAlive();
  	}

	public void do_erase(){
		Segment segment;

		// Segment erase_segment = 
		//	new Segment(rcX(x1), rcY(y1), rcX(x2), rcY(y2));
		
		Node erase_point = new Node(rcX(x2), rcY(y2));
		double converted_size = rc(size);

		boolean removed = false;
		scene.reset();
		while (scene.hasMoreElements()){
		    segment = (Segment) scene.currentElement();
		    //if segment.cross(erase_segment) ||
		    if (segment.distance(erase_point) < converted_size) {
			scene.remove();
			scene.reset();
			removed = true;
		    }
		    else
			scene.nextElement();
		}
		if (removed)
		  repaint_all();
		else
	          repaint_feedback();

  	}

	public void erase_closest(int x, int y){
		Node erase_point = new Node(rcX(x), rcY(y));

		if (scene.size()==0)
			return;

		Enumeration e = scene.elements();
		Segment closest = (Segment) e.nextElement();
		double min = closest.distance(erase_point);
		
		while (e.hasMoreElements()){
		    Segment segment = (Segment) e.nextElement();
		    if (segment.distance(erase_point) < min) {
		    	closest = segment;
		    	min = segment.distance(erase_point);
		    }
		}

		scene.remove(closest);
	}



  	public class Timer extends Thread{
	  public void run(){
	    while(true){
              try { Thread.sleep(100);
              } catch (InterruptedException e){}
	      size = (int)(size * 1.4);
	      do_erase();
	    }
	  }
	  public void stop_ifAlive(){
	    if (isAlive()) stop();
	  }
	}


    }








    // central event dispatcher
    public class MouseDispatcher 
	extends MouseAdapter implements MouseMotionListener{

  	public void mouseMoved(MouseEvent e) {
  	}

  	public void mouseDragged(MouseEvent e) {
	    	e.consume();
	    	switch (operation_status) {
	    	case ZOOMING:
		    zooming_interim(e);
		    break;
	    	case MOVING:
		    moving_interim(e);
		    break;
	        case ERASING:
	            eraser.interim(e);
		    break;
	        case DRAWING:
		    drawing_interim(e);
		    break;
		}
   	}

  	public void mousePressed(MouseEvent e) {
 	    e.consume();

    	    if ((e.getModifiers() & e.BUTTON3_MASK)==e.BUTTON3_MASK ){
		if (e.getClickCount() == 2){
		  	zooming_start(e);}
		else{
			moving_start(e);}
    	    }
    	    else{	// Left Button
		if (e.getClickCount() == 2){
		  	if (state == SELECTING){
			    finish_selection();
			}
			else if (state == PREDICTING)
			    interrupt_prediction();
			eraser.start(e);}
		else{
			drawing_start(e);}
       	    }


	    helpPanel.repaint();

	}

	public void mouseReleased(MouseEvent e) {
	    e.consume();

	    switch (operation_status) {
	    case ZOOMING:
	    case MOVING:
		break;
	    case ERASING:
		eraser.finish(e);
		break;

	    // Drawing
	    case DRAWING:
		if (Vector2.distance(x1,y1,x2,y2) > MINIMUM_STROKE_LENGTH){
		  // stroke
		  // Iłrŕ`̂ŁA܂ÔmB
		  if (state == SELECTING)
			finish_selection();
		  drawing_finish(e);
		}
		else{  
		  // click
		  switch (state){
		    case 1:  // SELECTING:
			select_candidate();
			break;
		    case 2:  // PREDICTING:
			select_predicted_candidate();
			break;
		    case 0:  // SETTLED:
			start_prediction();
		  }
		}
		break;
		
	    }
            repaint_all();  
    	    operation_status = NONE;

	    helpPanel.repaint();

  	}
    }
}







