//  Copyright (C) 1999 Takeo Igarashi




import java.awt.event.*;
import java.awt.*;
import java.applet.*;
import java.net.*;

import java.lang.Math.*;

import java.util.Vector;


/** pl  */
class DrawControls extends Panel {
    DrawPanel target;
    Pegasus pegasus;
    TextField filename;

    public DrawControls(DrawPanel target, Pegasus pegasus) {
	this.target = target;
	this.pegasus = pegasus;
	setLayout(new FlowLayout());
	setBackground(Color.lightGray);

	add(new ClearButton());
	add(new HelpButton());
	
	add(new Label("Copyright(C) 1999 Takeo Igarashi"));

	// add(new QuitButton());

	// add(new LoadButton());
	// add(new SaveButton());
	// add(filename = new TextField("file name", 8));

    }

    public void paint(Graphics g) {
	Rectangle r = getBounds();

	g.setColor(Color.lightGray);
	g.draw3DRect(0, 0, r.width, r.height, false);
    }

  public Frame f;
  public void destroy(){
  	f.dispose();
  }
  
  /** Help Button */
  class HelpButton extends Button { 
    HelpButton(){
	setLabel("Help"); 
	addMouseListener(
	  new MouseAdapter() { 
      		public void mousePressed(MouseEvent e) { 
      		
      		
      			f = new Frame("Pegasus - Online Help [ Copyright(C) 1999 Takeo Igarashi ] ");
      			
			f.addWindowListener(
			  new WindowAdapter(){
			    public void windowClosing(WindowEvent e) {destroy();}}
		        );
      			
      			f.add("Center", new HelpPanel(target));
			f.setSize(450, 250);
			f.show();
      			/*
			AppletContext context = pegasus.getAppletContext();
			try{
			System.out.println(""+pegasus.getDocumentBase()+"\\help.html");
			URL url = new URL(""+pegasus.getDocumentBase()+"\\help.html");
			context.showDocument(url, "help");
			}
			catch(MalformedURLException err){}
			*/
			
    		} 
	  }
        );
    }
  } 


  /** Clear Button */
  class ClearButton extends Button { 
    ClearButton(){
	setLabel("Clear"); 
	addMouseListener(
	  new MouseAdapter() { 
      		public void mousePressed(MouseEvent e) { 
			target.clear();
    		} 
	  }
        );
    }
  } 


  
  /** Quit Button */
  class QuitButton extends Button { 
    QuitButton(){
	setLabel("quit"); 
	addMouseListener(
	  new MouseAdapter() { 
      		public void mousePressed(MouseEvent e) { 
			System.exit(0);
    		} 
	  }
        );
    }
  } 
 

  public class SaveButton extends Button { 
    SaveButton(){
	setLabel("save"); 
	addMouseListener(
	  new MouseAdapter() { 
      		public void mousePressed(MouseEvent e) { 
			target.save(filename.getText());}});
    }
  } 
  class LoadButton extends Button { 
    LoadButton(){
	setLabel("load"); 
	addMouseListener(
	  new MouseAdapter() { 
      		public void mousePressed(MouseEvent e) { 
			target.load(filename.getText());
    		} 
	  }
        );
    }
  } 

}

