//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.lang.Math.*;
import java.util.*;


/** ̏W */
public class Constraints {

	private LinkedList constraints;

	Constraints(){
		constraints = new LinkedList();
	}


	public Enumeration elements(){
		return constraints.elements();
	}
	public void reset(){
		constraints.reset();
	}
	public boolean hasMoreElements(){
		return constraints.hasMoreElements();
	}
	public Constraint currentElement(){
		return (Constraint) constraints.currentElement();
	}
	public void nextElement(){
		constraints.nextElement();
	}
	public int size(){
		return constraints.size();
	}
	public void remove(){
		constraints.remove();
	}








	public void display(){
	  Constraint constraint;
	  System.out.println("inferred constraints");
	  Enumeration e = constraints.elements();
      	  while (e.hasMoreElements()){
	    constraint = (Constraint) e.nextElement();
	    constraint.display();
	  }	
	}

	// łɓo^Ă鐧`FbNB
	// Ƌ߂̂łɂ΃pXB
	// ȂΒuB
	public void add_align(int type, double constant, double deviation, Segment segment){
	  Constraint constraint = new Constraint(type, constant, deviation);
	  check_and_append(constraint, segment);
        }		
	public void add_congruent(double x, double y, double deviation, Segment segment){
	  Constraint constraint = new Constraint(Constraint.CONGRUENT, x, y, deviation);
	  check_and_append(constraint, segment);
        }		
	public void add_start_node(Node node, double deviation, Segment segment){
	  Constraint constraint = new Constraint(Constraint.START_NODE, node, deviation);
	  check_and_append(constraint, segment);
        }		
	public void add_end_node(Node node, double deviation, Segment segment){
	  Constraint constraint = new Constraint(Constraint.END_NODE, node, deviation);
	  check_and_append(constraint, segment);
        }		
	// XSB̏ꍇ diff B a * (x2-x1) + b * (y2-y1);
	public void add_slope(double a, double b, double deviation, Segment segment){
	  Constraint constraint;
	  if (a == 0)
	    constraint = new Constraint(Constraint.DIFF_Y, 0, deviation);
	  else if (b == 0)
	    constraint = new Constraint(Constraint.DIFF_X, 0, deviation);
	  else
	    constraint = new Constraint(Constraint.SLOPE, a,b, deviation);
	  check_and_append(constraint, segment);
        }		
	
	// B`FbNȂ
	public void add_diff_y(double c){
	    constraints.append(new Constraint(Constraint.DIFF_Y, 0, 0));
	}
	// B`FbNȂ
	public void add_diff_x(double c){
	    constraints.append(new Constraint(Constraint.DIFF_X, 0, 0));
	}

	// ֍SB肪̏ꍇ align B
	public void add_start_online(Segment segment, double deviation){
	  Constraint constraint;
	  if (segment.x1 == segment.x2)
	      constraint = new Constraint(Constraint.ALIGN_X1, segment.x1, deviation);
	  else if (segment.y1 == segment.y2)
	      constraint = new Constraint(Constraint.ALIGN_Y1, segment.y1, deviation);
	  else {
		double a = segment.y2 - segment.y1;
		double b = segment.x1 - segment.x2;
		double c = segment.x1 * segment.y2 - segment.y1 * segment.x2;
		// c = c + parallel_width * Math.sqrt(a * a + b * b);
		constraint = new Constraint(Constraint.START_ONLINE, a,b,c, deviation);
	  }
	  check_and_append(constraint, segment);
        }		
	public void add_end_online(Segment segment, double deviation){
	  Constraint constraint;
	  if (segment.x1 == segment.x2)
	      constraint = new Constraint(Constraint.ALIGN_X2, segment.x1, deviation);
	  else if (segment.y1 == segment.y2)
	      constraint = new Constraint(Constraint.ALIGN_Y2, segment.y1, deviation);
	  else {
		double a = segment.y2 - segment.y1;
		double b = segment.x1 - segment.x2;
		double c = segment.x1 * segment.y2 - segment.y1 * segment.x2;
		// c = c + parallel_width * Math.sqrt(a * a + b * b);
		constraint = new Constraint(Constraint.END_ONLINE, a,b,c, deviation);
	  }
	  check_and_append(constraint, segment);
        }


	/** sԂ̊ԊuS */
	// n_ƏI_ segment  interval ړ̂̏֍SB
	public void add_parallel(Segment segment, double interval, double deviation){
	    Constraint constraint;
	    if (segment.x1 == segment.x2)
		constraint = new Constraint(Constraint.ALIGN_X, 
			segment.x1 - Tools.sign(segment.y2-segment.y1)*interval, deviation);
	    else if (segment.y1 == segment.y2)
		constraint = new Constraint(Constraint.ALIGN_Y, 
			segment.y1 + Tools.sign(segment.x2-segment.x1)*interval, deviation);
	    else {
		double a = segment.y2 - segment.y1;
		double b = segment.x1 - segment.x2;
		double c = segment.x1 * segment.y2 - segment.y1 * segment.x2;
		c = c - interval * Math.sqrt (a * a + b * b);
		
		constraint = new Constraint(Constraint.PARALLEL, a, b, c, deviation);
	    }
	    check_and_append(constraint, segment);
	}






	/** 𐧖W։Oɏd`FbNB̂ΐɉB */
	private void check_and_append(Constraint new_constraint, Segment segment){
	  Constraint constraint;
	  // d`FbNB̂ΐɉB
	  // ߂̂΃pXÂΒuB
	  constraints.reset();
	  while (constraints.hasMoreElements()){
	    constraint = (Constraint) constraints.currentElement();
	    if (constraint.type == new_constraint.type){	
	    	if (constraint.deviation + Def.ERROR_RANGE < new_constraint.deviation)
		    return;
		// ă`FbNBslopeւ̍l
	    	else if (constraint.deviation - Def.ERROR_RANGE < new_constraint.deviation){
	          // deviation łႤꍇB
	          if (constraint.equal(new_constraint)){
		    constraint.references_append(segment);
		    return;
	      	  }
	          else return;	// ȂÂ݂̂̂ƂĂB
	    	}
	        else{
		    //Â̎̂ĂĐV̓o^
		    //System.out.println("deviation "+ (constraint.deviation - new_constraint.deviation));
		    constraints.remove();
	  	    new_constraint.references_append(segment);
	  	    constraints.append(new_constraint);
		    return;
	    	}
	    }
	    constraints.nextElement();
	  }
	  // ̂Ȃ...
	  new_constraint.references_append(segment);
	  constraints.append(new_constraint);
	}
}

