//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.lang.Math.*;
import java.util.*;



/** `Ɏg􉽊wI */
public class Constraint {

	public int 	type;
	public int 	num_of_coefficients;
	public double[] coefficients;
	/** Ƃ̃Xg[N̂Bconstraints Q */
	public double	deviation;


	// p
	public LinkedList references;
	// null pXB
	public void references_append(Object element){
		if (element != null) references.append(element);
	}

	public static final int START_NODE 	= 1;
	public static final int END_NODE 	= 2;
	public static final int CONGRUENT 	= 3;
	public static final int ALIGN_X1 	= 4;
	public static final int ALIGN_Y1 	= 5;
	public static final int ALIGN_X2 	= 6;
	public static final int ALIGN_Y2 	= 7;
	public static final int START_ONLINE 	= 8;
	public static final int END_ONLINE 	= 9;
	public static final int SLOPE	 	= 10;
	public static final int DIFF_X	 	= 11;
	public static final int DIFF_Y	 	= 12;
	public static final int ALIGN_X	 	= 13;
	public static final int ALIGN_Y	 	= 14;
	public static final int PARALLEL 	= 15;

	public static final String[] names = {"", "START_NODE", "END_NODE", "CONGRUENT",
		"ALIGN_X1", "ALIGN_Y1", "ALIGN_X2", "ALIGN_Y2", 
		"START_ONLINE","END_ONLINE","SLOPE","DIFF_X","DIFF_Y",
		"ALIGN_X", "ALIGN_Y", "PARALLEL"} ;


	public static final int[] ALIGN = {4,5,6,7};

	Constraint(){		
	}
	/** align, diff */
	Constraint(int t, double c, double _deviation){
	    type = t;
	    num_of_coefficients = 1;
	    coefficients = new double[1];
	    coefficients[0] = c;
	    references = new LinkedList();
	    deviation = _deviation;
	}

	/** congruent, slope */
	Constraint(int t, double x, double y,  double _deviation){
	    type = t;
	    num_of_coefficients = 2;
	    coefficients = new double[2];
	    coefficients[0] = x;
	    coefficients[1] = y;
	    references = new LinkedList();
	    deviation = _deviation;
	}	
	/** start_node, end_node */
	Constraint(int t, Node node, double _deviation){
	    type = t;
	    num_of_coefficients = 2;
	    coefficients = new double[2];
	    coefficients[0] = node.x;
	    coefficients[1] = node.y;
	    references = new LinkedList();
	    deviation = _deviation;
	}
	/** start_online, end_online, parallel*/
	Constraint(int t, double a, double b, double c,  double _deviation){
	    type = t;
	    num_of_coefficients = 3;
	    coefficients = new double[3];
	    coefficients[0] = a;
	    coefficients[1] = b;
	    coefficients[2] = c;
	    references = new LinkedList();
	    deviation = _deviation;
	}

	/** d`FbNpB Constraints Ă΂B*/
	public boolean equal(Constraint c){
	    if (type != c.type) return false;
	    if (type == SLOPE) return true;	// 덷l̖ʓ|...
	    for (int i=0; i < num_of_coefficients; i++)
		if (coefficients[i] != c.coefficients[i])
		    return false;
	    return true;
	}
	

	public void display(){
	    String s = "";
	    for (int i=0; i < num_of_coefficients; i++)
		s = s + (coefficients[i]) + ", ";
	    System.out.println(names[type]+ " " + s);
	
	}

}

