/************************************************************************
 **             trace.c:  tracer for PRISM programs                    **
 **    Copyright (C) 1999                                              **
 **       Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara,            **
 **         Nobuhisa Ueda, Hiroshi Ishimaru,                           **
 **       Dept. of Computer Science, Tokyo Institute of Technology.    **
 ************************************************************************/

#include "prism.h"

int atom_id;

void init_atom_id(void){ atom_id = 1; }

int get_atom_id(void){ return ++atom_id; }

int get_com(void){
  int i;
  char c, com;

  /* We need only the first charactor: */
  for(i=0; (c=getc(stdin)) != '\n' && c != EOF; i++)
	if (i==0) com = c;
  
  if (i > 0 && (com < 'a' || 'z' < com)) return -1;
  else if (i == 0) return 0;
  else return com - 'a' + 1;
}

void help_msg(void){
  printf("\n [HELP]
    a: abort            s: skip
    l: leap             p: show spy points
    h: help

    x: show current switches  (explanation)
    y: show all switches      (explanation)
    z: show sampling switches (sample)\n\n");
}
