%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  start_stable.pl: parsing of PRISM command options.
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

start :-
	add_no_use_sentences,!,
	prolog_flag(argv,Flags),!,
	nofileerrors,!,
	start_prism(0,Flags,[],[],true),!.

start_prism(State,[Flag|Flags],Options,Files,Comm) :-
	( is_option(Flag,help),!,print_usage
    ; is_option(Flag,wd),!,       % [NOTE] '-wd' is an internal option
	  Flags=[PWD|Flags1],         % added by kame on Jul/15/1998
	  working_directory(_,PWD),
	  start_prism(State,Flags1,Options,Files,Comm)
    ; is_option(Flag,v),!,
	  ( State=0,!,
	    start_prism(2,Flags,[verbose],[],true)
	  ; print_usage )
    ; is_option(Flag,q),!,
	  ( State=0,!,
	    start_prism(2,Flags,[quiet],[],true)
	  ; print_usage )
    ; is_option(Flag,p),!,
	  ( State=0,!,
	    start_prism(4,Flags,[compile,verbose|Options],Files,Comm)
	  ; State=2,!,
	    start_prism(4,Flags,[compile|Options],Files,Comm)
	  ; print_usage )
    ; is_option(Flag,s),!,
	  ( State=0,!,
	    start_prism(4,Flags,[consult,verbose|Options],Files,Comm)
	  ; State=2,!,
	    start_prism(4,Flags,[consult|Options],Files,Comm)
	  ; print_usage )
    ; is_option(Flag,h),!,
	  ( State=3,!,
		start_prism(5,Flags,Options,Files,(nl,halt))
	  ; print_usage )
    ; is_option(Flag,_),!,
	  message("{Unknown option ~w}",[Flag]),!,
	  print_usage
	; atom(Flag),!,
	  ( (State=3;State=4),!,
	    '*append*'(Files,[Flag],Files1),!,
		start_prism(3,Flags,Options,Files1,Comm)
	  ; State=2,!,
	    '*append*'(Files,[Flag],Files1),!,
		start_prism(3,Flags,[compile|Options],Files1,Comm)
	  ; State=0,!,
	    '*append*'(Files,[Flag],Files1),!,
		start_prism(3,Flags,[compile,verbose|Options],Files1,Comm)
	  ; print_usage )).
	
print_usage :-
	format("Usage: prism [-help] [[-v|-q] [-p|-s] filename ... [-h]]~n",[]),!,
	format("(Options) -s  consult PRISM program files.~n",[]),!,
	format("          -p  compile PRISM program files.~n",[]),!,
	format("          -v  print program information while loading.~n",[]),!,
	format("          -q  be quiet while loading.~n",[]),!,
	format("          -h  terminate with halt/0 after loading.~n",[]),!,
	format("          -help  print this message.~n~n",[]),!,halt.
	
is_option(Atom,Opt) :-
	name(Atom,[45|OPT]),!,name(Opt,OPT).
	
