/************************************************************************
 **  prism.h: header file of C-routines of PRISM.
 **
 **  Copyright (C) 1998
 **    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
 **      Dept. of Computer Science, Tokyo Institute of Technology.
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>

/* 1: in debug mode  0: normal mode */
#define DEBUG 0

/* random.c */
#define M LONG_MAX
#define A 39894229L
#define C 5

/* em.c */
#define FIXED 1
#define NOTFIXED 0
#define Seq1(T,S,I,V) (*(G[(T)].table+(S)*ivNum12+(I)*valueNum1+(V)))
#define Gamma(T,S,I) (*(G[(T)].table+(S)*ivNum12+ivNum11+(I)))
#define Theta(I,V,TH) (*((TH)+(I)*valueNum1+(V)))
#define DISPLAYNUM 50    /*  added by                */
#define DISPLAYDOT 5     /*     kame on Jul/22/1998  */
/*
 * Seq1(T,S,I,V) and Gamma(T,S,I) are originally defined as:
 *
 * #define Seq1(T,S,I,V) *(G[T].table+S*((idNum+1)*(valueNum+1)+(idNum+1))+\
 *					+I*(valueNum+1)+V)
 * #define Gamma(T,S,I) *(G[T].table+S*((idNum+1)*(valueNum+1)+(idNum+1))+\
 *          	     (idNum+1)*(valueNum+1)+I)
 */
#define EPSILON 0.000001

/* trie.c */
#define GNULL (struct glink *)NULL
#define SNULL (struct sw *)NULL
#define LNULL (struct swlink *)NULL

/* prob.c */
#define PSeq1(S,I,V) *(PG.table+S*pivNum11+I*pvalueNum1+V)
#define PTheta(I,V) *(ptheta+I*pvalueNum1+V)

/* Struct Declarations */
/* em.c */
struct goal {
  int Snum;                 /* G(t) $B$N6K>.;Y;}=89g$N?t(B              */
  int *table;               /* $B4X?tI=$N(BG(t)$B$K4X$9$kItJ,$X$N%]%$%s%?(B */
  int observedNum;          /* $B4QB,$5$l$?%G!<%?$N?t(B                 */
  double Pdb;               /* P( G(t) = 1)                         */
};
                                   
struct switchInfo {             
  int idInProlog;           /* prolog$B$G$N(BId Number                  */
  int maxValue;             /* msw(i, d, x) : 0 <= x <= maxValue    */
  int Tnum;                 /* $BBh(B2$B0z?t(B T $B$N<oN`$N?t(B                 */
  int fixed;                /* fixed = {FIXED, NOTFIXED}            */
};

/* trie.c */
struct sw {
  short G_id;
  short T_id;
  short Val;
  struct swlink *Child;
  int *Table;  /* added by kame on Jul/23/1998 */
};

struct swlink {
  struct sw *Sw;
  struct swlink *NextSw;
};

struct glink {
  short Goal;    /* ID No. of the goal */
  int Count;     /* No. of explanations */
  int MaxDepth;  /* Max depth of the TRIE */
  int ObsNum;    /* No. of duplicating goals */
  double Pdb;    /* P_DB(Goal=1) modified by kame on Jul/11/1998 */
  struct swlink *Expl;
  struct glink *NextG;
};

/* Prototype Declarations */

/* random.c */
void      set_seed(long);
void      set_seed_time(void);
long    set_seed_time1(void);
void	show_seed(void);
double    random_float(double);
int       random_int(int);
long      random_generator(long *);

/* em.c */
void initVars(void);
void freeMemory(void);

int set_values(int, int);
int set_goals(int);
int set_idInfo(int, int, int);
void set_fixed(int, int, double);
void set_data(int, int);
void set_epsilon(double);
double get_epsilon();     /* added by kame on Feb/24/1998 */
void show_epsilon(void);
int prepare_rev_idInfo(void); /* added by kame on Jul/11/1998 */

void initTheta(void);
int ON_loop(double *);              /* added by kame on Jul/24/1998 */
void copyTheta(double *, double *);
int update_theta(void);
int c_EM_loop(void);
void display(int);

void show_rev_idInfo(void);
void show_sizes(void);
void show_sw(void);
void show_raw_sw(void);
void show_goals(void);
void show_ONtab(double *);

double get_theta(int, int);
double get_loglike(void);

/* trie.c */
int prepare_trie(void);
void cancel_trie(void);  /* added by kame on Dec/13/1997 */
int prepare_expl(int);
void return_to_root(void);
void return_to_expl_root(void);
void add_expl_count(int);
int get_trie(int,int,int,int);
int freeChild(struct swlink *);
void freeTrie(void);
int compare_sw(struct sw *, int, int, int);
void show_trie(void);
void show_trie_more(void); /* added by kame on Jul/23/1998 */
void show_trie_less(void); /* added by kame on Jul/23/1998 */
void show_expl(int, struct swlink *);
void show_expl_more(int, struct swlink *);
void show_expl_less(int, struct swlink *);
struct sw *salloc(void);
struct swlink *lalloc(void);
struct glink *galloc(void);
/* count_expls(), count_an_expl(): modified by kame on Jul/23/1998 */
int count_expls(void);
int count_an_expl(int, struct swlink *, int *);
void copy_to_table(int, int *);

/* prob.c */
void initProb(void);
int prepare_prob_trie(void);
void cancelProb(void);   /* added by kame on Nov/20/1997 */
void return_to_prob_root(void);
int get_Ptrie(int, int, int, int);
void free_Ptrie(void); 
void show_Ptrie(void);
int count_expls_P(void);
int count_an_expl_P(int,struct swlink *,int *);
void copy_to_table_P(int, int *);
int set_Pvalues(int, int);
int set_PidInfo(int, int);
int set_Ptheta(int, int, double);
double calc_Pdb(void);
void freePMemory(void);

/* trace.c */
void init_atom_id(void);
int get_atom_id(void);
int get_com(void);
void help_msg(void);
