%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  foreign_stable.pl: Foreign Language Interface
%%%                   provided by SICStus Prolog 3
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for random.c
foreign(set_seed,c,set_seed_by_manual(+integer)).
foreign(set_seed_time,c,set_seed_time). % using C-library time()
foreign(set_seed_time1,c,c_set_seed_time([-integer])).
foreign(show_seed,c,show_seed).
foreign(random_float,c,random_float(+float,[-float])).
	% random_float(r,R): return a random real <R> <= <r>
foreign(random_int,c,random_int(+integer,[-integer])).
	% random_int(r,I): return a random integer <I> <= <r>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for trie.c

%%% for exportation of explanations:
foreign(prepare_trie,c,prepare_c_trie([-integer])).
foreign(cancel_trie,c,cancel_trie).
foreign(prepare_expl,c,prepare_c_expl(+integer,[-integer])).
foreign(count_expls,c,count_c_ans([-integer])).
foreign(get_trie,c,
	    export_ans_sw(+integer,+integer,+integer,+integer,[-integer])).
foreign(show_trie,c,show_trie).
foreign(show_trie_more,c,show_trie_more).
foreign(show_trie_less,c,show_trie_less).
foreign(freeTrie,c,init_c_trie).
foreign(initRoot,c,really_init_trie).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for em.c

%%% for exportation of EM information:
foreign(set_values,c,export_sw(+integer,+integer,[-integer])).
foreign(set_idInfo,c,export_code(+integer,+integer,+integer,[-integer])).
foreign(set_fixed,c,export_fixed_code(+integer,+integer,+float)).
foreign(set_goals,c,export_goal_patterns(+integer,[-integer])).
foreign(set_data,c,export_goal_weight(+integer,+integer)).

%%% for importation of EM information:
foreign(get_theta,c,import_pb(+integer,+integer,[-float])).
foreign(get_loglike,c,import_loglike([-float])).

%%% for control of EM routine:
foreign(update_theta,c,update_pbs([-integer])).
foreign(initTheta,c,init_pbs).
foreign(c_EM_loop,c,c_EM_loop([-integer])).
foreign(set_epsilon,c,set_c_epsilon(+float)).
foreign(get_epsilon,c,get_c_epsilon([-float])).

%%% Miscellaneous interface predicates:
foreign(freeMemory,c,init_expl_table).
foreign(initVars,c,really_init_expl_table).
foreign(show_goals,c,c_goals).
foreign(show_sw,c,c_sw).
foreign(show_sizes,c,c_sizes).
foreign(show_epsilon,c,show_epsilon).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for prob.c

foreign(initProb,c,really_init_prob).
foreign(free_Ptrie,c,init_prob_trie).
foreign(freePMemory,c,init_prob_table).
foreign(prepare_prob_trie,c,prepare_prob_trie).
foreign(cancelProb,c,cancel_prob).
foreign(get_Ptrie,c,
	export_prob_ans_sw(+integer,+integer,+integer,+integer,[-integer])).
foreign(show_Ptrie,c,show_prob_trie).
foreign(set_Pvalues,c,export_prob_sw(+integer,+integer,[-integer])).
foreign(set_PidInfo,c,export_prob_code(+integer,+integer,[-integer])).
foreign(count_expls_P,c,count_prob_ans([-integer])).
foreign(set_Ptheta,c,export_pb(+integer,+integer,+float,[-integer])).
foreign(calc_Pdb,c,calc_Pdb([-float])).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for trace.c
foreign(init_atom_id,c,init_atom_id).
foreign(get_atom_id,c,get_atom_id([-integer])).
foreign(get_com,c,get_com([-integer])).
foreign(help_msg,c,help_msg).
