%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  emNoGUI.pl: EM main routines without GUI.
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% prepare_c_Pf deleted by kame on Jul/23/1998
em_loop(Codes) :-
	init_pbs,!,import_pbs(Codes),!,print_codes(Codes),!,
	clause('*Epsilon*'(Epsilon),true),!,
	em_loop(0,Epsilon,Codes),!.

% modified by kame on Jul/23/1998
em_loop(M,Epsilon,Codes) :-
	display_em_loop(M),!,
	update_pbs(R),!,
	( R=0,!,
          format("{PRISM INTERNAL ERROR: theta can not be updated.}~n",[]),!,
          fail
	; true ),!,
	import_loglike(New_Loglike),!,
	import_pbs(Codes),!,
	( M=0,!,
	  assertz('*Log_like*'(0,New_Loglike)),!,
	  em_loop(1,Epsilon,Codes)
	; Mm1 is M-1,!,
	  retract('*Log_like*'(Mm1,Old_Loglike)),!,
	  D is New_Loglike-Old_Loglike,!,
	  ( D < Epsilon,!,
	    nl,!,
		assert_loglike(New_Loglike),!,   % added by kame on Feb/27/1998
		converged_em_loop(M,Codes,New_Loglike)
	  ; Mp1 is M+1,!,
	    assertz('*Log_like*'(M,New_Loglike)),!,
		em_loop(Mp1,Epsilon,Codes) )),!.
