%%
%%  User Interface for GDA-LES System Version 2
%%  Copyright (C) 1999 Tokuyasu KAKUTA 
%%  1999.3.8 ver.053
%%

% 'oc' version (without 'exist') 

:-dynamic on_gda/0,comm_history/2,comm_history_count/1,comm_history_size/1,
          gda_result/1,select_pat/1,gen_rule/1,last_hypo_sort/1,pat_count/1,
          current_sim_num/2,default_sim_num/2,current_kb/1.
:-dynamic test_default/2, gui_flag/1.
:-op(700,fy,!).

gda_IO_version('053').
gui_flag(on).  %%% GUI

gui:-abolish(gui_flag,1),assert(gui_flag(on)).
cui:-abolish(gui_flag,1),assert(gui_flag(off)).

comm_history_size(20).
default_sim_num(1,5).

%test_default('demo',prohibit(event3,this_park)).  %%9/26
%test_default('ijdemo.kb',null(X:event)).
%test_default('civil.kb',null(X:payment)).
%test_default('park_old.kb',prohibit(event3,this_park)).
test_default('park.kb',prohibit(enter1)).
%test_default('t.pl',p(X)).

gdales:-newgda(not_test).
newgda:-newgda(test).
newgda(SW):-
    (gui_flag(off),!;init_gui),  %%% GUI
	(normal_inference,!;assert(normal_inference)),
	reset_comm_history,
	(on_gda,!,abolish(on_gda,0);true),
	(gda_version(GDA_Ver),!;
	 SW==test,!;
	 write('You have to compile or consult "newgda.pl" beforehand !!'),
	 nl,fail),
	gda_IO_version(IO_Ver),
	write('Welcome to GDA-LES System version '),
	write(GDA_Ver),write(-),write(IO_Ver),nl,
	write('Copyright (C) 1999 Tokuyasu KAKUTA'),nl,
	write('HELP command --> help.'),nl,
	(SW==test,test_default(F,DG),!,macro_load(F),set_gui_default(F,DG);
	 true),
	repeat,
	gda_state,
	gda_prompt,
	%get_line(S),
	%parse(S,T,VL),
	get_comm(T),
	comm(T,VL),
	put_comm_history(T),
	T==end,!,abolish(normal_inference),
    (gui_flag(off),!;end_gui).   %%% GUI

get_comm(T):-gui_flag(off),!,read(T).
get_comm(T):-gui_flag(on),!,
             gui_listing_current_state,
             get_gui_command(T).  %%% GUI

macro_load(File):-macro_expander(File,mactmp),load_cl(mactmp),
                  set_current_kb(File).

comm(end,_):-!.
comm(load(F),_):-!,load_cl(F),set_current_kb(F).
comm(mload(F),_):-!,macro_load(F).
comm(convert(F1,F2,G),_):-!,convert(F1,F2,G),!.
comm(log(F,Com),L):-!,tell(F),comm(Com,L),told,!.
comm(log(Com),L):-!,tell(log),comm(Com,L),told,!.
comm(help,_):-!,
	nl,
	write('Command     : Function'),nl,
	write('------------:---------------------------------------------'),nl,
	write('end.        : System End'),nl,
	write('help.       : This help commnad'),nl,
	write('load(File). : Load Knowledge Base (File)'),nl,
	write('gda(GOAL).  : Begining GDA with your original goal as GOAL'),nl,
	write('GOAL.       : Inference of Normal OSL with your GOAL'),nl,
	write('on.         : Analogy mode'),nl,
	write('off.        : Normal mode'),nl,
	write('set(Num).   : Set similarity number'),nl,
	%write('convert(I,O). : Convert I as KB to O as internal file'),nl,
	write('?- GOAL.    : Call your GOAL as prolog system call'),nl,
	write('Number      : Execute the Number-th command again'),nl,
	write('!!          : Execute the previous command again'),nl,
	write('show(Name). : Show states'),nl,
	write('              Name    : State'),nl,
	write('              --------:-----------------'),nl,
	write('              sort    : sort information'),nl,
	write('              clause  : all clauses'),nl,
	write('              role    : all role restrictions'),nl,
	write('              history : command history'),nl,
	write('              sim     : similarites based on last gda'),nl,
	write('              sim(Num): one similarity based on last gda'),nl,
	write('              state   : show states'),nl,
	nl.
comm(on,_):-!, 
	write('*** Analogy Mode ****'),nl,assert(on_gda),
	select_pat(N),
	set_hypothetical_sort(N).
comm(off,_):-!,write('*** Normal  Mode ****'),nl,abolish(on_gda,0),
	remove_hypothetical_sort.
comm(set(N0),_):-!,
	(gui_flag(on),!,(current_sim_num(S,_),!;default_sim_num(S,_)),N is N0+S;
	 N=N0),
	(on_gda,!,(select_pat(N),!;
	           N<1,!,fail;
	           \+ pat_count(N1),!,fail;
	           pat_count(N1),N>N1,!,fail;
	           remove_hypothetical_sort,
	           abolish(select_pat,1),
	           assert(select_pat(N)),
	           set_hypothetical_sort(N));
	 abolish(select_pat,1),
	 assert(select_pat(N))).
comm(gda,_):-!,test_default(_,G),write('default goal --> '),write(G),nl,
	comm(gda(G),_).
comm(gda(G),_):-!,comm(gda(G,main),_).
comm(goal(G),_):-!,comm(gda(G,gda_only),_).
comm(gda(G,Mode),_):-!,
	normal_inference,
	(gui_flag(off),!;clear_mon,clear_sim),
	(abolish(normal_inference,0);
	 write('GDA Failed'),nl,assert(normal_inference),fail),
	time_init,
	gda_start_message,
	(Mode==main,main(G,Pat);
	 Mode==gda_only,gda_only(G,Pat)),
	gda_end_message,
	length(Pat,N),
	count_data(C),
	%similarity_disp(Pat),
	gui_sim_disp(Pat),
	w_mon_nl,
	w_mon_write('all candidates:'),w_mon_write(C),w_mon_nl,
	w_mon_write('appropriate candidates:'),w_mon_write(N),w_mon_nl,
	time_memo('GDA-Execution',T),
	time_disp(T,0,'GDA-Execution'),
	(gui_flag(off),!;
	 w_mon_write('GDA-Execution Time: '),w_mon_write(T),w_mon_write('msec.'),
	 w_mon_nl),	
	abolish(gda_result,1),
	abolish(select_pat,1),
	abolish(pat_count,1),
	assert(pat_count(N)),
	assert(gda_result(Pat)),
	assert(select_pat(1)),
	show_results,
	assert(normal_inference),!.
comm((?- G),_):-!,(call(G);true),!.
comm(show(N),_):-!,
	(N==sort,!,listing_sort;
	 N==clause,!,listing_clause;
	 N==role,!,listing_role;
	 N==history,!,listing_comm_history;
	 N==state,!,listing_current_state;
	 N==sim,!,listing_similarity; %%For CUI
	 N=sim(all),!,abolish(current_sim_num,2),assert(current_sim_num(1,all)),
		gda_result(Pat),gui_sim_disp(Pat),length(Pat,Len),
		disp_gui_sim_range(1,Len);
	 N=sim(Num),!,listing_similarity(Num);  %%For CUI
	 N=sim(N1,N2),!,abolish(current_sim_num,2),assert(current_sim_num(N1,N2)),
		gda_result(Pat),gui_sim_disp(Pat),disp_gui_sim_range(N1,N2);
	 true).
comm(N, _):-number(N),!,
	(comm_history(N,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('Invalid Number !!'),nl).
comm(!!,_):-
	(comm_history_count(N),N1 is N-1,comm_history(N1,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('This is your first command.'),nl),!.
comm(!N,_):-
	(comm_history_count(N0),N1 is N0-N,comm_history(N1,T),!,
	 write('>>'),write(T),nl,put_comm_history(T),comm(T,_);
	 write('Invalid Number !!'),nl),!.
comm($,VL):-!,
	test_default(_,G),write('default goal --> '),write(G),nl,
	comm(G,VL).
comm(cf(L),_):-!,abolish(cf,1),assert(cf(L)).
comm(sic,_):-!,swtype(sic).
comm(sp,_):-!,swtype(sp).
comm(manual,_):-!,sw_selection(on).
comm(auto,_):-!,sw_selection(off).
comm(focus(F),_):-!,(F==sg;F==proof;F==off),!,
	abolish(focusFlag,1),assert(focusFlag(F)).
comm(vrp(X),_):-!,swvrp(X).
comm(G,VL):-
	(gui_flag(off),!;clear_answer),
	(solve(G,[],Hist,_,Tree),
	 inference_result_set(Tree),
	 analyze_result(G,Hist),
	 disp(G,VL),
	 more(Flag),
	 Flag==no,
	 gda_state,w_ans_yes;
	 gda_state,w_ans_no),
	!.

gda_state:-on_gda,!,write('GDA: ').
gda_state:-write('gda: ').
gda_prompt:-write('> ').

more(F):-
	gui_flag(off),!,
	repeat,
	gda_state,write('More (y/n) ? '),
	%read(X),
	get0(C),
	char_code(X,C),
	get0(CR),
	CR==10, %%% SICStus dependent
	(X==y,!,F=yes;X==n,!,F=no),!.
more(F):-
	gui_more(F).  %%% GUI

set_current_kb(F):-abolish(current_kb,1),assert(current_kb(F)).

gda_start_message:-gui_flag(off),!.
gda_start_message:-gui_gda_start. %%%GUI
gda_start_message:-gui_gda_failed,fail. %%%GUI
gda_end_message:-gui_flag(off),!.
gda_end_message:-gui_gda_end.     %%%GUI

show_results:-gui_flag(off),!.
show_results:-
	select_pat(N),
	get_gda_result(N,Pat),
	fail_rule(RL),
	extend_rules(RL,RL1),
	collect_rule_head(RL1,NegHL,[]),
	list_to_goal(NegHL,NegGs),  %%%gda,
	current_ground_goal(Gs),    %%%gda
	%copy_term(Gs,Gs1),
	functor(Gs,Func,Ari),functor(Gs1,Func,Ari),
	functor(NegGs,FuncN,AriN),functor(NegGs1,FuncN,AriN),
	get_tg(TG),   %%%gda
	result_tree(VL1,RTree0),   %%%gda
	conv_result_tree(RTree0,sort,VL1,RTree),
	%%% for proof from case
	abd_solve(Gs1,NegGs1,VL,_,Tree0),  %%%gda
	partial_shared_check(RTree0,Tree0,Pat),
	!,
	conv_result_tree(Tree0,sort,VL,Tree),
	conv_result_tree(RTree0,sort,VL1,RTree),
	make_temp_abs_sort(Pat,AbsHierarchy),
	conv_abs_tree(RTree,AbsHierarchy,ATree),
	send_gui_init,          %%%GUI
	send_gui(goal,Gs),      %%%GUI
	send_gui(proof,Tree),   %%%GUI
	send_gui(rules,RL1),    %%%GUI
	send_gui(ruleId,RL),    %%%GUI
	send_gui(tg,TG),        %%%GUI
	send_gui(rule_proof,RTree),   %%%GUI
	send_gui(abs_proof,ATree),    %%%GUI
	gui_gda_results.              %%%GUI


%partial_shared_check(B,B1,_):-
%	write('call_rule==>'),write(B),nl,
%	write('call_case==>'),write(B1),nl,fail.
partial_shared_check(true,_,_):-!.
partial_shared_check((A,B),(A1,B1),P):-!,
	partial_shared_check(A,A1,P),
	partial_shared_check(B,B1,P).
partial_shared_check(goal(G,rule(Id),B),goal(G1,rule(Id),B1),P):-!,
	is_similar_goal(G,G1,P),
	partial_shared_check(B,B1,P).
partial_shared_check(goal(G,rule(_),true),goal(G1,rule(_),_),P):-
	is_similar_goal(G,G1,P).

is_similar_goal(G,G1,P):-G=..[F|L],G1=..[F|L1],
	is_similar_list(L,L1,P).

is_similar_list([],[],_):-!.
is_similar_list([X|L],[X1|L1],P):-
	is_similar_term(X,X1,P),
	is_similar_list(L,L1,P).

is_similar_term(V:S,V1:S1,P):-var(V),var(V1),!,
	(get_mem(C,P),get_mem(S,C),!,mem(S1,C);S=='*',S1=='*').
is_similar_term(X:S,X1:S1,P):-!,
	(nonver(X),!,in_check(X,S1);nonver(X1),!,in_check(X1,S)).
is_similar_term(C,V:S,P):-!,in_check(C,S).
is_similar_term(V:S,C,P):-!,in_check(C,S).
is_similar_term(C,C,P):-!.

extend_rules([],[]):-!.
extend_rules([R|L],[(R,(H:-B))|L1]):-
	cl(R,_,_,H,B),!,   %%gda
	extend_rules(L,L1).

inference_result_set(Tree):-on_gda,!,
	send_gui(analogy_proof,Tree).         %%%GUI
inference_result_set(Tree):-
	send_gui(normal_proof,Tree).          %%%GUI

%collect_rule_body([],T,T):-!.
%collect_rule_body([(_,(_:-B))|L],H,T):-
%	goal_to_list(B,H,T1),   %%%gda
%	collect_rule_body(L,T1,T).

collect_rule_head([],T,T):-!.
collect_rule_head([(_,(Head:-_))|L],H,T):-
	Head=..[F|As],
	(rev_info(F,F1);rev_info(F1,F)),!,  %%%gda
	Neg=..[F1|As],
	goal_to_list(Neg,H,T1),   %%%gda
	collect_rule_head(L,T1,T).

conv_result_tree(true,_,_,true):-!.
conv_result_tree(goal(G,R,SL),Mode,VL,goal(G1,R,SL1)):-
	new_analyze_result(G,G1,Mode,VL),
	conv_result_subtree(SL,Mode,VL,SL1).

conv_result_subtree(true,Mode,_,true):-!.
conv_result_subtree((GN,Gs),Mode,VL,(GN1,Gs1)):-!,
	conv_result_tree(GN,Mode,VL,GN1),
	conv_result_subtree(Gs,Mode,VL,Gs1).
conv_result_subtree(GN,Mode,VL,GN1):-conv_result_tree(GN,Mode,VL,GN1).

conv_abs_tree(true,_,true):-!.
conv_abs_tree(goal(G,R,SL),P,goal(G1,R,SL1)):-
	abstract_mapping_goal(G,G1,P),
	conv_abs_subtree(SL,P,SL1).

conv_abs_subtree(true,_,true):-!.
conv_abs_subtree((GN,Gs),Pat,(GN1,Gs1)):-!,
	conv_abs_tree(GN,Pat,GN1),
	conv_abs_subtree(Gs,Pat,Gs1).
conv_abs_subtree(GN,Pat,GN1):-conv_abs_tree(GN,Pat,GN1).

abstract_mapping_goal(V,V1,Pat):-var(V),!,V1=V.
abstract_mapping_goal(A,A1,Pat):-atomic(A),!,A1=A.
abstract_mapping_goal(V:S,V1:S1,Pat):-var(V),!,V1=V,
	mapping_abstract_sort(S,S1,Pat).
abstract_mapping_goal(A:_,A1:S1,Pat):-atomic(A),!,A1=A,in_sort(A,S1),
	mapping_abstract_sort(S,S1,Pat).
abstract_mapping_goal([F|L],[F1|L1],Pat):-!,
	abstract_mapping_goal(F,F1,Pat),
	abstract_mapping_goal(L,L1,Pat).
abstract_mapping_goal(T,T1,Pat):-
	T=..[F|L],abstract_mapping_goal(L,L1,Pat),T1=..[F|L1].

mapping_abstract_sort(S,S1,AbsH):-
	(get_mem((S1,Eq),AbsH),  %%% gda
	 get_mem(S,Eq),!;        %%% gda
	 S1=S).

make_temp_abs_sort(Pat,AbsH):-make_temp_abs_sort(Pat,1,AbsH).

make_temp_abs_sort([],_,[]):-!.
make_temp_abs_sort([[_]|Pat],N,L):-!,make_temp_abs_sort(Pat,N,L).
make_temp_abs_sort([EqSet|Pat],N,[(S,EqSet)|L]):-
	make_hypo_sort(N,S),
	N1 is N+1,
	make_temp_abs_sort(Pat,N1,L).

%%%
char_code(y,121):-!.
char_code(y,89):-!.
char_code(n,110):-!.
char_code(n,78):-!.

listing_current_state:-
	write('<System State>'),nl,
	(on_gda,!,M=analogy;M=deduction),
	(goal_selection_sw(on),!,S=manual;S=auto),
	(non_vrp,!,V=off;V=on),
	(select_pat(N),!;N=non),
	(current_kb(FN),!;FN=non),
	write(' Inference Mode : '),             write(M),nl,
	write(' SP / SIC       : '),gda_type(SW),write(SW),nl,
	write(' VRP            : '),             write(V),nl,
	write(' Selection Mode : '),             write(S),nl,
	write(' Focus          : '),focusFlag(F),write(F),nl,
	write(' Current Sim    : '),             write(N),nl,
	write(' Current CF     : '),cf(CF),      write(CF),nl,
	write(' Current KB     : '),             write(KB),nl.

gui_listing_current_state:-
	(on_gda,!,M=analogy;M=deduction),
	(goal_selection_sw(on),!,S=manual;S=auto),
	(non_vrp,!,V=off;V=on),
	gda_type(SW),
	focusFlag(F),
	(select_pat(N),!;N=non),
	(current_kb(FN),!;FN=non),
    clear_state,                          %%% GUI
	disp_state(' Inference Mode : ',M),   %%% GUI
	disp_state(' SP / SIC       : ',SW),  %%% GUI
	disp_state(' VRP            : ',V),   %%% GUI
	disp_state(' Selection Mode : ',S),   %%% GUI
	disp_state(' Focus          : ',F),   %%% GUI
	disp_state(' Current Sim.   : ',N),   %%% GUI
	disp_state(' Current KB     : ',FN).  %%% GUI

listing_sort:-
	w_tab(2),
	w_write('IS-A Subclass of Relations:'),w_nl,
	sort_small(X,Y),w_conv(X,X1),w_conv(Y,Y1),
	w_tab(4),w_write((X1=<Y1)),w_nl,fail.
listing_sort:-
	w_tab(2),
	w_write('IS-An Instance of Relations:'),w_nl,
	in_sort(X,Y),w_conv(X,X1),w_conv(Y,Y1),
	w_tab(4),w_write(X1),w_write('@'),w_write(Y1),w_nl,fail.
listing_sort.

listing_clause:-
	cl(_,Type,_,H,B),
	numbervars((H,B),0,_),
	(Type==rule,w_write('Rule'),w_write(': ');Type\==rule,w_tab(1)),
	w_tab(1),w_write(H),
	(B==true,w_write(('.')),w_nl;B\==true,w_write((' :-')),w_nl,disp_body(B)),
	fail.
listing_clause.

%%
listing_role:-role_fil(R,F,T),tab(7),
	      w_write(R),w_write(': '),w_write(F),w_write(' -> '),
          w_write(T),w_nl,fail.
listing_role.

disp_body((A,B)):-!,w_tab(4),w_write(A),w_write((',')),w_nl,disp_body(B).
disp_body(A):-w_tab(4),w_write(A),w_write(('.')),w_nl.

%% History
listing_comm_history:-write('  NewGDA Command History'),nl,
	comm_history(N,Comm),tab(2),write(N),write(' : '),write(Comm),nl,fail.
listing_comm_history.

put_comm_history(T):-T\==(!!),\+T=(!_),\+number(T), !,
	comm_history_count(N),
	assertz(comm_history(N,T)),
	comm_history_size(Size),
	(N>Size,!,
	 Oldest is N-Size,
	 retract(comm_history(Oldest,_)),!;
	 true),
	up_comm_history_count.
put_comm_history(_).

up_comm_history_count:-retract(comm_history_count(N)),!,
	N1 is N+1,assert(comm_history_count(N1)).

reset_comm_history:-
	(comm_history(_,_),!,abolish(comm_history,2);true),
	(comm_history_count(_),!,abolish(comm_history_count,1);true),
	assert(comm_history_count(1)).

%% TEST Yet
analyze_result(G,VL0):-
	collect_var([G],Vs0,[]),
	compress_vars(Vs0,Vs),
	get_var_hist(Vs,VL0,VL),
	calc_meets(Vs,VL,VsL),
	subst_const(VL),
	%write(VL),nl,
	short_var(VsL).

new_analyze_result(G,G1,Mode,VL0):-
	collect_var([G],Vs0,[]),
	compress_vars(Vs0,Vs),
	get_var_hist(Vs,VL0,VL),
	calc_meets(Vs,VL,VsL),
	subst_const(VL),
	%write(VL),nl,
	(Mode==sort,!;
	 Mode==const,!,
	short_var(VsL),
	true),
	mapping_result_sort(G,G1,VsL).

subst_const([]):-!.
subst_const([(C,C,_)|VL]):-!,subst_const(VL).
subst_const([(C:_,C,_)|VL]):-subst_const(VL).

short_var([]):-!.
short_var([F|L]):-
	short_var1(F),
	short_var(L).

short_var1([]):-!.
short_var1([(_:S,S)|L]):-!,short_var1(L).
short_var1([(C,$(C0,S))|L]):-in_check(C,S),C==C0,!,short_var1(L).
short_var1([_|L]):-short_var1(L).  %%%

mapping_result_sort(V,V1,VsL):-var(V),!,V1=V.
mapping_result_sort(A,A1,VsL):-atomic(A),!,A1=A.
mapping_result_sort(V:S,V1:S1,VsL):-var(V),!,
	get_mem(Vs,VsL),   %%%gda
	get_var_sort(Vs,V,S1),!,V1=V.   %%%% gda
mapping_result_sort(A:_,A1:S1,VsL):-atomic(A),!,A1=A,in_sort(A,S1).
mapping_result_sort([F|L],[F1|L1],VsL):-!,
	mapping_result_sort(F,F1,VsL),
	mapping_result_sort(L,L1,VsL).
mapping_result_sort(T,T1,VsL):-
	T=..[F|L],mapping_result_sort(L,L1,VsL),T1=..[F|L1].

%% TEST Yet
disp(G,VL):-!,
	(gui_flag(off),!,write('Ans.>> ');clear_answer), %%GUI
	%write(G),nl.
	dispG(G),w_ans_nl.

dispG(V):-var(V),!,w_ans_write(V).
dispG(V:S):-!,(var(V),!,w_ans_write(V:S);w_ans_write(V)).
dispG(A):-atomic(A),!,w_ans_write(A).
dispG([F]):-!,dispG(F).
dispG([F|L]):-!,dispG(F),w_ans_write((',')),dispG(L).
dispG(G):-G=..[F|L],w_ans_write(F),w_ans_write('('),dispG(L),w_ans_write(')').
%%%

listing_similarity:-
	gda_result(L),
	listing_similarity_num(L,1).

listing_similarity_num([],_):-!.
listing_similarity_num([F|L],N):-
	write(N),write(:),
	sim_disp1(F),
	N1 is N+1,
	listing_similarity_num(L,N1).

listing_similarity(Num):-
	gda_result(L),!,
	listing_similarity(L,1,Num).
listing_similarity(_):-!,write('Please try GDA at first!'),nl.

listing_similarity([],_,_):-!,write('empty or error'),nl.
listing_similarity([F|_],N,N):-!,sim_disp1(F).
listing_similarity([_|L],C,N):-C1 is C+1,listing_similarity(L,C1,N).

set_hypothetical_sort(N):-
	backuped_rule(RL),  %% call newgda.pl
	retract_cl(RL),     %% call newgda.pl
	get_gda_result(N,Pat),
	assign_hypo_sort(Pat,SL),
	assert_cl(SL),      %% call newgda.pl
	generate_hypo_meet, %% call newgda.pl
	generalization(RL,SL,NewRL),
	abolish(gen_rule,1),
	assert(gen_rule(NewRL)),
	%assert_cl(NewRL).   %% call newgda.pl for CUI-Demo
	asserta_cl(NewRL).   %% call newgda.pl for GUI-Demo

remove_hypothetical_sort:-
	remove_hypo_sort,
	gen_rule(RL),
	retract_cl(RL),
	backuped_rule(OrgRL),
	assert_cl(OrgRL).

get_gda_result(N,Pat):-
	gda_result(L),
	get_at(L,N,Pat).

get_at([X|_],1,X):-!.
get_at([_|L],N,X):-N1 is N-1,get_at(L,N1,X).

assign_hypo_sort(P,SL):-assign_hypo_sort(P,1,SL).

assign_hypo_sort([],Last,[]):-!,
	abolish(last_hypo_sort,1),assert(last_hypo_sort(Last)).
assign_hypo_sort([[_]|Pat],N,SL):-!,
	assign_hypo_sort(Pat,N,SL).
assign_hypo_sort([C|Pat],N,H):-
	make_hypo_sort(N,A),
	N1 is N+1,
	assign_hypo_super(C,A,H,T),
	assign_hypo_sort(Pat,N1,T).

make_hypo_sort(N,S):-name('$abs',[D,A,B,C]),name(N,L),name(S,[D,A,B,C,D|L]).

assign_hypo_super([],_,T,T):-!.
assign_hypo_super([S|L],A,[sort_small(S,A)|H],T):-assign_hypo_super(L,A,H,T).

generalization([],_,[]):-!.
generalization([R|RL],SL,[NewR|NewRL]):-
	generalization1(R,NewR,SL),
	generalization(RL,SL,NewRL).

generalization1(V,V1,_):-var(V),!,V1=V.
generalization1(A,A1,_):-atomic(A),!,A1=A.
generalization1(X:S,X:A,SL):-!,(mem(sort_small(S,A),SL),!;A=S).
generalization1([F|L],[F1|L1],SL):-!,
	generalization1(F,F1,SL),generalization1(L,L1,SL).
generalization1(G,G1,SL):-
	G=..[F|L],generalization1(L,L1,SL),G1=..[F|L1].

remove_hypo_sort:-
	last_hypo_sort(N),
	remove_hypo_sort(N),
	generate_hypo_meet.  %% call newgda.pl

remove_hypo_sort(0):-!.
remove_hypo_sort(N):-make_hypo_sort(N,A),retract(sort_small(_,A)),fail.
remove_hypo_sort(N):-N1 is N-1,remove_hypo_sort(N1).

%%% Called by newgda.pl

tty_read_goals([F|_],F):-
	F=(G,TG,VL,Tree0),
	conv_result_tree(Tree0,sort,VL,Tree),
	show_candidates_proof(G,TG,Tree),!.
tty_read_goals([_|L],H):-
	tty_read_goals(L,H).

show_candidates_proof(G,TG,P):- \+ gui_flag(on),!,
	write('Goal:['),write(G),write(']<==='),nl,
	write(TG),nl,write('y/n :'),read(X),X \== n,!.
show_candidates_proof(G,TG,P):-gui_show_cand_proof(G,P). %%% user.pl

listing_list_elements(_,[]):-!.
listing_list_elements(N,[F|L]):-
	write(N),write(:),write(F),nl,
	N1 is N+1,
	listing_list_elements(N1,L).

read_select_numbers(L):-
	write('which numbers ? (ex. [1,3,...])'),nl,
	read(X),
	(X=[_|_],!,X=L;L=[X]).

get_list_elements([],_,[]):-!.
get_list_elements([F|L],GL,[F1|L1]):-
	get_at(GL,F,F1),
	get_list_elements(L,GL,L1).

%%% OUTPUT with switching GUI/TTY

w_write(X):-gui_flag(off),!,write(X).
w_write(X):-gui_flag(on),disp_window(X).  %%%GUI
w_nl:-gui_flag(off),!,nl.
w_nl:-gui_flag(on),nl_window.  %%%GUI
w_tab(N):-gui_flag(off),!,tab(N).
w_tab(N):-gui_flag(on),(N==0,!;w_write(' '),N1 is N-1,w_tab(N1)).  %%%GUI
w_ans_write(X):-gui_flag(off),!,write(X).
w_ans_write(X):-gui_flag(on),disp_answer(X).  %%%GUI
w_ans_nl:-gui_flag(off),!,nl.
w_ans_nl:-gui_flag(on),nl_ans_window.  %%%GUI
w_ans_yes:-gui_flag(off),!,write('Yes'),nl.
w_ans_yes:-gui_flag(on),!.
w_ans_no:-gui_flag(off),!,write('No'),nl.
w_ans_no:-gui_flag(on),!,clear_answer,disp_answer('No').  %%%GUI
w_mon_write(X):-gui_flag(off),!,write(X).
w_mon_write(X):-gui_flag(on),disp_gda_mon(X).  %%%GUI
w_mon_nl:-gui_flag(off),!,nl.
w_mon_nl:-gui_flag(on),nl_gda_mon.  %%%GUI
w_sim_write(X):-gui_flag(off),!,write(X).
w_sim_write(X):-gui_flag(on),disp_sim(X).  %%%GUI
w_sim_nl:-gui_flag(off),!,nl.
w_sim_nl:-gui_flag(on),nl_sim_window.  %%%GUI

w_conv(X,X1):-name(X,L),w_conv1(L,L1),name(X1,L1).
w_conv1([],[]):-!.
w_conv1([F|L],[C,F|L1]):- "$"=[F],!, "\\"=[C],w_conv1(L,L1).
w_conv1([F|L],[F|L1]):-w_conv1(L,L1).

gui_sim_disp(L):-gui_flag(off),!,listing_similarity_num(L,1).
gui_sim_disp(L):-
    (current_sim_num(Start,End0),!;
     default_sim_num(Start,End0)),
    (End0==all,!,length(L,End);End=End0),
    clear_sim,  %%%GUI
    gui_sim_disp(L,1,Start,End).

gui_sim_disp([],_,_,_):-!.
gui_sim_disp(_,_,N1,N2):-N1>N2,!.
gui_sim_disp([_|L],C,N1,N2):-C<N1,!,
    C1 is C+1,
    gui_sim_disp(L,C1,N1,N2).
gui_sim_disp(_,C,_,N2):-C>N2,!.
gui_sim_disp([F|L],C,N1,N2):-
    gui_sim_form(F,F1),
    disp_sim(C:F1),  %%%GUI
    C1 is C+1,
    gui_sim_disp(L,C1,N1,N2).

gui_sim_form([],[]):-!.
gui_sim_form([[_]|L],R):-!,gui_sim_form(L,R).
gui_sim_form([F|L],[F|R]):-gui_sim_form(L,R).

%% for CUI
sim_disp1([]):-!,nl.
sim_disp1([[_]|L]):-!,sim_disp1(L).
sim_disp1([F|L]):-write(F),sim_disp1(L).

set_gui_default(F,G):-gui_flag(off),!.
set_gui_default(F,G):-gui_flag(on),!,
	set_file_window(F),   %%%GUI
	set_goal_window(G).   %%%GUI

%%============================================================================
%%  Macro Expander for Order-sorted Object-oriented Representation
%%  1997.8.26 (11.19)
%%============================================================================

macro_expander(In,Out):-
   see(In),
   read_all(L),
   seen,
   object_macro_expand(L,L1),
   sort_front_loading(L1,L2),
   tell(Out),
   write_all(L2),
   told.

read_all(L):-
   read(X),
   (X==end_of_file,!,L=[];
    L=[X|T],read_all(T)).

write_all([]):-!.
write_all([F|L]):-
   writeq(F),write('.'),nl,
   write_all(L).

object_macro_expand([],[]):-!.
object_macro_expand([R:X->Y|L],[R:X->Y|L1]):-!,
   object_macro_expand(L,L1).
object_macro_expand([object::X|L],H):-
   object_macro_expand([object(X)|Tail],Tail,H0,T),!,
   H0=[object(Y)|T0],H=[oc(Y)|T0],
   object_macro_expand(L,T).
object_macro_expand([F|L],[F1|L1]):- \+(F=object(_)),
   clause_macro_expand(F,F1),!,
   object_macro_expand(L,L1).
object_macro_expand([F|L],L1):-
   write('Syntax Error detected by macro expander in :'),
   write(F),nl,
   object_macro_expand(L,L1).

clause_macro_expand((rule::R),(rule::R1)):-!,
   clause_macro_expand(R,R1).
clause_macro_expand((H:-B),(H1:-B1)):-!,
   goal_to_d_list(B,BL,T),
   object_macro_expand([H|BL],T,Out,[]),
   list_to_goal(Out,(H1,B1)).
clause_macro_expand(G,G1):-
   goal_to_d_list(G,BL,T),
   object_macro_expand(BL,T,Out,[]),
   (Out=[G1],!;
    list_to_goal(Out,(H1,B1)),G1=(H1:-B1)).

goal_to_d_list((A,B),[A|H],T):-!,goal_to_d_list(B,H,T).
goal_to_d_list(A,[A|T],T).

%list_to_goal([G],G):-!.
%list_to_goal([A|L],(A,B)):-list_to_goal(L,B).

object_macro_expand([],_,OutT,OutT):-!.
object_macro_expand([F|H],T,[F1|L],OutT):-
   attr_macro_expand(F,F1,T,T1),
   object_macro_expand(H,T1,L,OutT).

attr_macro_expand(V,X,L,L):-var(V), !, X=V.
attr_macro_expand([],X,L,L):-!,X=[].
attr_macro_expand(A,X,L,L):-atomic(A), !, X=A.
attr_macro_expand(C:E,X,H,T):-!,
   (var(C),!,X=C:F;X=C),
   functor(E,F,N),
   (N==0,!,H=T;E=..[F|L],to_flat_term(L,C,H,T)).
attr_macro_expand([F|L],[F1|L1],H,T):-!,
   attr_macro_expand(F,F1,H,M),
   attr_macro_expand(L,L1,M,T).
attr_macro_expand(A,X,H,T):-!,
   A=..[F|L],
   attr_macro_expand(L,L1,H,T),
   X=..[F|L1].

to_flat_term([],_,T,T):-!.
to_flat_term([A->B|L],C,[F|H],T):-
   F=..[A,C,B],
   to_flat_term(L,C,H,T).

sort_front_loading([],[]):-!.
sort_front_loading([R:X->Y|L],[R:X->Y|L1]):-!,
   sort_front_loading(L,L1).
sort_front_loading([C|L],[NewC|L1]):-
   rm_sort(C,C0,[],VL),
   add_sort(C0,NewC,VL),
   sort_front_loading(L,L1).

rm_sort(V,X,VL,VL):-var(V),!,X=V.
rm_sort(A,X,VL,VL):-atomic(A),!,X=A.
rm_sort([F|L],[F1|L1],VL,VL2):-!,
   rm_sort(F,F1,VL,VL1),
   rm_sort(L,L1,VL1,VL2).
rm_sort(V:S,X,VL,VL1):-!,
   (search_vl_entry(VL,V),!,VL1=VL;
    VL1=[(V,S,_)|VL]),
   X=V.
rm_sort(T,T1,VL,VL1):-
   T=..[F|L],
   rm_sort(L,L1,VL,VL1),
   T1=..[F|L1].

search_vl_entry([(V0,_,_)|_],V):-V0==V,!.
search_vl_entry([_|VL],V):-search_vl_entry(VL,V).

add_sort(V,X,VL):-var(V),!,
   (get_vl_entry(VL,V,S),!,X=V:S;
    X=V).
add_sort(A,X,VL):-atomic(A),!,X=A.
add_sort([F|L],[F1|L1],VL):-!,
   add_sort(F,F1,VL),
   add_sort(L,L1,VL).
add_sort(T,T1,VL):-
   T=..[F|L],
   add_sort(L,L1,VL),
   T1=..[F|L1].

get_vl_entry([(V0,S,Flag)|_],V,S):-V0==V,!,
   var(Flag),Flag=added.
get_vl_entry([_|VL],V,S):-get_vl_entry(VL,V,S).

