// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.net.*;
import java.io.*;
import java.util.Date;
import java.text.DateFormat;

public class Sleep {
  public static int time = 0;
  public static int thread_num = 0;
  private static Object lock = new Object();

  // do not construct this class
  private Sleep() {
  }

  public static String sleep() {
    int sec = time;
    int th;
    synchronized (lock) {
      th = thread_num++;
    }

    try {
      Thread.sleep(sec * 1000);
    } catch(InterruptedException e) {
    }

    synchronized (lock) {
      thread_num--;
    }

    String ret =  "Thread = "+ th + ", Time = "
                 + DateFormat.getDateTimeInstance().format(new Date());

    return ret;
  }

  public static void main(String args[]) {
    int port = 9007;

    if (args.length == 1) {
      try {
	port = Integer.parseInt(args[0]);
      } catch (java.lang.NumberFormatException nfe) {
	System.err.println("usage : java Sleep [<port>]");
	System.exit(1);
      }
    }

    try {
      ServerSocket servSock = new ServerSocket(port);

      for (;;) {
	// System.out.print("accepting...");
	Socket sock = servSock.accept();
	// System.out.println("connect to " + sock.getInetAddress() + "\n");

	InputStream in = sock.getInputStream();
	OutputStream out = sock.getOutputStream();
	new JK(in, out);
      }
    } catch (Exception e) {
      System.err.println("Exception :" + e);
    }
  }
}
