// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;

public class QueenCanvas extends Canvas {
  private int size;
  private Point pieces[];

  private static final int DefaultWidth = 40;

  QueenCanvas(int size) {
    this.size = size;
    pieces = new Point[0];
  }

  public Dimension getPreferredSize() {
    return new Dimension(DefaultWidth * size + 1, DefaultWidth * size + 1);
  }

  public void setPieces(Point pieces[]) {
    this.pieces = pieces;
    repaint();
  }

  public void paint(Graphics g) {
    setBackground(Color.lightGray);
    g.setColor(getBackground());
    Dimension dim = getSize();
    g.fillRect(0, 0, dim.width, dim.height);

    int min_w = Math.min(dim.width, dim.height);
    int W = (min_w - 1)/ size;
    int xp = (dim.width - W * size - 1)/2;
    int yp = (dim.height - W * size - 1)/2;
    int OD = W / 6;
    int R2 = W - OD*2 + 1;

    g.setColor(Color.black);
    for (int i = 0; i <= size; i ++) {
      g.drawLine(xp + i * W, yp, xp + i * W, yp + W * size);  // vertical
      g.drawLine(xp, yp + i * W, xp + W * size, yp + i * W);  // horizontal
    }

    g.setColor(Color.red.darker());
    for (int i = 0; i < pieces.length; i++) {
      int x = OD + pieces[i].x * W;
      int y = OD + pieces[i].y * W;
      g.fillOval(xp + x, yp + y, R2, R2);
    }
  }
}
