// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.net.*;

public class Queen extends Applet implements AdjustmentListener, ItemListener {
  public static void main(String args[]) {
    int server_port = 9007;
    String server_host = "localhost";

    if (args.length == 2) {
      server_host = args[0];
      try {
        server_port = Integer.parseInt(args[1]);
      } catch (java.lang.NumberFormatException nfe) {
        System.err.println("usage : java Queen [<host> <port>]");
        System.exit(1);
      }
    } else if (args.length != 0 && args.length != 2) {
      System.err.println("usage : java Queen [<host> <port>]");
      System.exit(1);
    }

    Frame frame = new Frame("Queen");
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	System.exit(0);
      }
    } );

    Button exit = new Button("Exit");
    frame.add(exit, "North");
    exit.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	System.exit(0);
      }
    } );

    Queen queen = new Queen(server_host, server_port);
    frame.add(queen, "Center");

    frame.pack();
    frame.show();
  }

  Label l;
  Scrollbar sc;
  int size;
  int[][] ans;
  QueenCanvas qc;
  Choice choice;

  String host_name;
  int port_number;

  Queen(String host_name, int port_number) {
    this.host_name = host_name;
    this.port_number = port_number;

    setBackground(Color.lightGray);
    setLayout(new BorderLayout(3, 3));

    size = 6;
    ans = new int[0][0];

    choice = new Choice();
    for (int i = 4; i <= 9; i++) {
      String str = " " + Integer.toString(i);
      str = str.substring(str.length() - 2);
      choice.addItem(str);
    }
    choice.select(" " + size);

    Panel size_panel = new Panel(new FlowLayout(FlowLayout.CENTER, 0, 0));
    size_panel.add(new Label("Size :", Label.LEFT));
    size_panel.add(choice);

    Panel p = new Panel(new BorderLayout());
    l = new Label("000/000", Label.CENTER);
    p.add(l, "West");
    sc = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, 0);
    p.add(sc, "Center");

    add(size_panel, "North");

    setQueenCanvas();

    add(p, "South");

    sc.addAdjustmentListener(this);
    choice.addItemListener(this);
  }

  // AdjustmentListener
  // Scrollbar
  public void adjustmentValueChanged(AdjustmentEvent e) {
    setAnswer();
  }

  // ItemListener
  // size
  public void itemStateChanged(ItemEvent e) {
    try {
      String str = choice.getSelectedItem();
      while (str.charAt(0) == ' ')
	str = str.substring(1);
      size = Integer.parseInt(str);
      setQueenCanvas();
    } catch (NumberFormatException ne) {
      // nothing to do
    }
  }

  private void setQueenCanvas() {
    if (qc != null)
      remove(qc);
    qc = new QueenCanvas(size);
    add(qc, "Center");
    solve();
    sc.setMaximum(ans.length);
    sc.setValue(0);
    setAnswer();
    validate();
 }

  private void setAnswer() {
    int n = sc.getValue();

    if (ans.length > n) {
      Point p[] = new Point[size];
      for (int i = 0; i < size; i++)
	p[i] = new Point(i, ans[n][i]);

      qc.setPieces(p);
    }

    String str = "  " + String.valueOf(n + 1);
    str = str.substring(str.length() - String.valueOf(ans.length).length());
    l.setText(str + "/" + ans.length);
    l.invalidate();
  }

  void solve() {
    JK jks = makeJK();
    if (jks == null) {
      Toolkit tk = getToolkit();
      if (tk != null)
        tk.beep();

      ans = new int[0][0];
      return;
    }

    Data args[] = new Data[] {Data.Integer(size)};
    Data ret = jks.call("queen", "queen", args);

    jks.close();

    if (ret == null) {
      Toolkit tk = getToolkit();
      if (tk != null)
        tk.beep();

      ans = new int[0][0];
      return;
    }

    Data ans_array[] = Data.ListToArray(ret);
    ans = new int[ans_array.length][];
    for (int i = 0; i < ans_array.length; i++) {
      Data ans_list[] = Data.ListToArray(ans_array[i]);
      ans[i] = new int[size];
      for (int j = 0; j < ans_list.length; j++)
	ans[i][j] = ans_list[j].getInteger() - 1;
    }
  }

  private JK makeJK() {
    InputStream in;
    OutputStream out;

    // System.out.println("Queen : connect " + host_name + ":" + port_number);

    try {
      Socket sock;

      sock = new Socket(host_name, port_number);
      in = sock.getInputStream();
      out = sock.getOutputStream();
    } catch(Exception e) {
      System.err.println("Error in making socket(" + e + ")");
      return null;
    }

    return new JK(in, out);
  }
}
