// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.net.*;
import java.io.*;
import java.util.Date;
import java.text.DateFormat;

public class JKServer {

  // not construct this class
  private JKServer() {
  }

  public static void main(String args[]) {
    int port = 9009;

    if (args.length == 1) {
      try {
	port = Integer.parseInt(args[0]);
      } catch (java.lang.NumberFormatException nfe) {
	System.err.println("usage : java JKServer [<port>]");
	System.exit(1);
      }
    }

    try {
      ServerSocket servSock = new ServerSocket(port);

      for (;;) {
	// System.out.println("JKServer : accepting...");
	Socket sock = servSock.accept();
	// System.out.println("JKServer : connect to "
        //                    + sock.getInetAddress() + "\n");

	InputStream in = sock.getInputStream();
	OutputStream out = sock.getOutputStream();
	new JK(in, out);
      }
    } catch (Exception e) {
      System.err.println("Exception :" + e);
    }
  }
}
