// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;

class HanoiCanvasDisk {
  protected class Disk {
    protected Color color;  // 
    protected int size;  // 
    protected int pole;  // 
    protected int position;  // ΰ
    Rectangle rect;
    Dimension dim;

    protected Disk(int size, int pole, int position) {
      this.size = size;

      int r = 0;
      int g = calcValue(192, 128, size);
      int b = calcValue(128, 255, size);
      color = new Color(r, g, b);

      dim = new Dimension(calcValue(40, 100, size),
			  HanoiCanvasDisk.this.height + 1);
      move(pole, position);
    }

    protected void move(int pole, int position) {
      this.pole = pole;
      this.position = position;

      int m = 30 + 50 + (20 + 100) * pole;  // 濴
      int x = m - dim.width/2;
      int y = 250 - HanoiCanvasDisk.this.height * (position + 1) - 1 - 1;
      int h_width = calcValue(20, 50, size);
      rect = new Rectangle(x, y, dim.width, dim.height);
    }

    protected boolean isTopDisk() {
      return    position == HanoiCanvasDisk.this.number - 1
	     || hd.getPoleData(pole)[position + 1] == 0;
    }

    protected void draw(Graphics g) {
      g.setColor(color);
      g.fillRect(rect.x, rect.y, rect.width, rect.height);
      g.setColor(Color.gray);
      g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
      g.setColor(Color.black);
      g.drawString(String.valueOf(size),
		   rect.x + 10, rect.y + rect.height - 4);
    }
  }

  /**
   * ƱפȤͤ׻.
   * פʤ max ֤,Ǥʤ,
   * size = 1 ʤ min , size = number ʤ max ,
   * ʳϤ֤֤ͤ.
   */
  private int calcValue(int min, int max, int size) {
    if (number <= 0 || number == 1)
      return max;

    double step = (max - min) / (double)(number - 1);
    return (int) (min + (size - 1) * step);
  }

  private HanoiData hd;
  private int height;
  private int number;

  private Disk disk[];

  HanoiCanvasDisk(HanoiData hd) {
    this.hd = hd;
    number = hd.getNumber();

    // פι⤵
    height = (int)Math.floor(150.0 / (double)number);
    if (height > 30)
      height = 30;

    disk = new Disk[number + 1];
    for (int i = 0; i < 3; i++) {
      int pole[] = hd.getPoleData(i);
      for (int l = 0; l < number; l++) {
	int size = pole[l];
	if (size == 0)
	  break;

	disk[size] = new Disk(size, i, l);
      }
    }
  }

  protected boolean canMove(int from, int to) {
    // ºݤưƤߤ롪
    boolean ismoved = hd.move(from, to);

    if (ismoved) {
      hd.move(to, from);  // ᤹
      return true;
    } else {
      return false;
    }
  }

  protected void move(int from, int to) {
    boolean ismoved = hd.move(from, to);
    if (ismoved) {
      int m_position = hd.getPoleHeight(to) - 1;    // ưΰ
      int m_size = hd.getPoleData(to)[m_position];  // ưפ礭
      disk[m_size].move(to, m_position);
    }
  }

  protected Disk getTopDisk(int p) {
    int n = hd.getPoleHeight(p);

    if (n == 0)
      return null;
    else
      return disk[hd.getPoleData(p)[n - 1]];
  }

  protected int getMaxSizeDiskPole() {
    if (hd.getPoleData(0)[0] == number)
      return 0;
    else if (hd.getPoleData(1)[0] == number)
      return 1;
    else
      return 2;
  }

  protected void draw(Graphics g) {
    for (int s = 1; s <= number; s++) {
      disk[s].draw(g);
    }
  }
}

