// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;

abstract class PropertyDialog extends Dialog {
  Button button_ok;
  Button button_cancel;

  private Panel button_panel;
  private Panel property_panel;

  PropertyDialog(Frame parent, String title, boolean modal, boolean editable) {
    super(parent, title, modal);

    // 
    button_panel = new Panel();
    add(button_panel, "South");

    property_panel = new Panel();
    add(property_panel, "Center");

    // ɥĤư
    addWindowListener(new WindowAction());

   // ܥѥͥ
    ButtonAction button_action = new ButtonAction();

    button_ok = new Button(" OK ");
    button_ok.addActionListener(button_action);
    button_panel.add(button_ok);

    if (editable) {
      button_cancel = new Button(" Cancel ");
      button_cancel.addActionListener(button_action);
      button_panel.add(button_cancel);
    }
  }

  class WindowAction extends WindowAdapter {
    public void windowClosing(WindowEvent e) {
      ButtonCancel();
    }
  }

  class ButtonAction implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if (e.getSource() == button_ok)
        ButtonOK();
      else if (e.getSource() == button_cancel)
        ButtonCancel();
    }
  }

  protected void ButtonOK() {
    apply();
    setVisible(false);
  }

  protected void ButtonCancel() {
    setVisible(false);
  }

  protected final void setPropertyComponent(Component comp) {
    property_panel.add(comp);
    pack();
  }

  abstract protected void apply() ;

  /**
   * ꤵ줿֤˥ư
   */
  public void setCenterLocation(int x, int y) {
    Dimension d = getSize();
    setLocation(x - d.width/2, y - d.height/2);
  }
}
