// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;

public class KDPropertyDialog extends PropertyDialog {

  private Data data;
  private boolean editable;

  private Label type_name;
  private Label field_name;
  private Label edit_field_label;
  private TextField edit_text_field;

  /**
   * 󥹥ȥ饯.
   * @param data ɽǡ.
   * @param parent ƥե졼.
   * @param editable ԽǽɤΥե饰.
   * @param listener ѹΤꥹ.
   */
  KDPropertyDialog(Frame parent, boolean editable) {
    super(parent, "Property Dialog", true, editable);

    this.editable = editable;

    setPanel();
  }

  private void setPanel() {
    GridBagLayout gridbag = new GridBagLayout();
    Panel panel = new Panel(gridbag);
    GridBagConstraints c = new GridBagConstraints();

    c.weightx = 1.0;
    c.weighty = 1.0;
    c.insets = new Insets(2, 2, 2, 2);

    c.gridwidth = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.EAST;
    Label type_label = new Label("type :");
    gridbag.setConstraints(type_label, c);
    panel.add(type_label);

    c.gridwidth = GridBagConstraints.REMAINDER;
    c.anchor = GridBagConstraints.WEST;
    type_name = new Label("");
    gridbag.setConstraints(type_name, c);
    panel.add(type_name);

    c.gridwidth = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.EAST;
    field_name = new Label("");
    gridbag.setConstraints(field_name, c);
    panel.add(field_name);

    c.gridwidth = GridBagConstraints.REMAINDER;
    c.anchor = GridBagConstraints.WEST;
    if (editable) {
      edit_text_field = new TextField("", 10);
      edit_text_field.addActionListener(
        new ActionListener() {
	  public void actionPerformed(ActionEvent e) {
	    ButtonOK();
	  }
        } );
      gridbag.setConstraints(edit_text_field, c);
      panel.add(edit_text_field);
    } else {
      edit_field_label = new Label("");
      gridbag.setConstraints(edit_field_label, c);
      panel.add(edit_field_label);
    }

    setPropertyComponent(panel);
  }

  /**
   * ǡμ.
   */
  public Data getData() {
    return data;
  }

  public void setDialog(Data data) {
    this.data = data;

    switch (data.getDataType()) {
    case Data.INTEGER :
      type_name.setText("integer");
      field_name.setText("value :");
      break;
    case Data.STRING :
      type_name.setText("string");
      field_name.setText("value :");
      break;
    case Data.ATOM :
      type_name.setText("atom");
      field_name.setText("name :");
      break;
    case Data.FUNCTOR :
      type_name.setText("functor");
      field_name.setText("name :");
      break;
    }

    type_name.invalidate();
    field_name.invalidate();

    if (editable) {
      edit_text_field.setText(toEditFieldString());
      edit_text_field.selectAll();
      edit_text_field.invalidate();
    } else {
      edit_field_label.setText(toEditFieldString());
      edit_field_label.invalidate();
    }

    pack();
  }

  private String toEditFieldString() {
    switch (data.getDataType()) {
    case Data.INTEGER :
	return String.valueOf(data.getInteger());
    case Data.STRING :
        return new String(data.getString());
    case Data.ATOM :
        return new String(data.getAtomName());
    case Data.FUNCTOR :
        return new String(data.getFunctorName());
    }
    return null;
  }

  protected void apply() {
    if (!editable)
      return;

    String str = edit_text_field.getText();

    // if string is not changed
    if (str.equals(toEditFieldString()))
      return;  // do nothing

    Data new_data = null;

    switch (data.getDataType()) {
    case Data.INTEGER :
      int num;
      try {
	num = Integer.parseInt(str);
      } catch (java.lang.NumberFormatException nfe) {
        new_data = null;
	break;
      }
      new_data = Data.Integer(num);
      break;
    case Data.STRING :
      new_data = Data.String(str);
      break;
    case Data.ATOM :
      new_data = Data.Atom(str);
      break;
    case Data.FUNCTOR :
      new_data = Data.Functor(str, data.getFunctorArguments());
      break;
    }

    if (new_data == null) {
      // not change data
      edit_text_field.setText(toEditFieldString());
      edit_text_field.setCaretPosition(edit_text_field.getText().length());

      Toolkit tk = getToolkit();
      if (tk != null)
        tk.beep();

      return;
    }

    data = new_data;

    edit_text_field.setText(toEditFieldString());
    edit_text_field.setCaretPosition(edit_text_field.getText().length());
  }

}
