// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;

class KDICanvas extends DoubleBufferedCanvas {
  private KDI kdi;

  KDICanvas(KDI kdi) {
    this.kdi = kdi;

    setBackground(Color.lightGray);
    setSize(600, 600);
  }

  protected void redrawNode(Node node) {
    if (node != null)
      redraw(node.rect);
  }

  protected void draw(Graphics g) {
    // طʤɤĤ֤
    g.setColor(getBackground());
    Dimension dim = getSize();
    g.fillRect(0, 0, dim.width, dim.height);

    // ƥΡɤ
    for (int i = 0; i < kdi.root_data.size(); i++) {
      Node node = (Node)(kdi.root_data).elementAt(i);
      draw(g, node);
    }
  }

  protected void directDraw(Graphics g) {
    // ưΥХǥ󥰥ܥå
    if (kdi.mode == KDI.MOVE_NODE) {
      g.setColor(Color.cyan);
      g.drawRect(kdi.move_bound.x, kdi.move_bound.y,
		 kdi.move_bound.width - 1, kdi.move_bound.height - 1);
    }
  }

  private void draw(Graphics g, Node node) {
    if (node.getDataType() == Data.FUNCTOR)
      drawFunctor(g, node);
    else
      drawNode(g, node);
  }

  private void drawNode(Graphics g, Node node) {
    Rectangle rect = node.rect;

    if (!rect.intersects(g.getClipBounds()))
      return;

    switch (node.getDataType()) {
    case Data.INTEGER :
      g.setColor(new Color(223, 255, 223)); break;
    case Data.STRING :
      g.setColor(new Color(255, 223, 223)); break;
    default :
      g.setColor(new Color(223, 223, 255)); break;
    }
    g.fillRect(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);

    g.setColor(Color.gray);
    g.drawRect(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);

    if (node == kdi.select_node) {
      g.setColor(Color.orange);
      g.drawRect(rect.x + 1, rect.y + 1, rect.width - 3, rect.height - 3);
    }

    if (node == kdi.focus_node) {
      g.setColor(Color.red);
      g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
    } else if (   node == kdi.target_node
	       && (   kdi.mode == KDI.MOVE_NODE
                   || kdi.mode == KDI.MOVE_NODE_EXITED) ) {
      g.setColor(Color.green);
      g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
    }

    g.setFont(kdi.font);
    g.setColor(Color.black);
    g.drawString(node.label,
		 rect.x + KDI.PAD, rect.y + KDI.PAD + kdi.fm.getAscent());
  }

  private void drawFunctor(Graphics g, Node node) {
    drawNode(g, node);

    Data args[] = node.getFunctorArguments();

    Rectangle rect = node.rect;
    int y_mid = (rect.y + rect.height + ((Node)args[0]).rect.y)/2;

    g.setColor(Color.black);
    g.drawLine(rect.x + rect.width/2, rect.y + rect.height,
	       rect.x + rect.width/2, y_mid);

    for (int i = 0; i < args.length; i++) {
      Node arg = (Node)args[i];
      draw(g, arg);

      g.setColor(Color.black);
      if (rect.y == arg.rect.y) {
	// cons  cdr ξ
	g.drawLine(rect.x + rect.width, rect.y + rect.height/2 - 2,
		   arg.rect.x,  arg.rect.y + arg.rect.height/2 - 2);
	g.drawLine(rect.x + rect.width, rect.y + rect.height/2 + 2,
		   arg.rect.x,  arg.rect.y + arg.rect.height/2 + 2);
      } else {
	g.drawLine(rect.x + rect.width/2, y_mid,
		   arg.rect.x + arg.rect.width/2, y_mid);
	g.drawLine(arg.rect.x + arg.rect.width/2, y_mid,
		   arg.rect.x + arg.rect.width/2, arg.rect.y);
      }
    }
  }
}
