// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class KDI {
  protected Font font;
  protected FontMetrics fm;

  protected Vector root_data;

  protected Node focus_node;
  protected Node select_node;
  protected Node target_node;

  // MOVE_NODE        Ρɤΰư
  // MOVE_NODE_EXITED Ρɤΰư(ݡͥȤγ)
  // PANE_MOV         ScrollPain ΰư
  protected int mode;
  protected final static int NORMAL = 1;
  protected final static int MOVE_NODE = 2;
  protected final static int MOVE_NODE_EXITED = 3;
  protected final static int PANE_MOVE = 4;

  protected Rectangle move_bound;

  protected static int PAD = 5;

  // --------------
  protected KDICanvas kdic;
  protected ScrollPane pane;
  protected TextField text_field;

  protected Node property_node;
  protected Node new_node;

  protected KDPropertyDialog kdpd;

  protected int pressed_x;
  protected int pressed_y;

  protected int move_bdx;
  protected int move_bdy;

  protected PopupMenu popup_menu;

  protected MenuItem menu_property;
  protected MenuItem menu_delete;
  protected MenuItem menu_remove;

  protected Menu menu_new;

  protected MenuItem menu_new_atom;
  protected MenuItem menu_new_integer;
  protected MenuItem menu_new_string;

  protected boolean editable;

  // ------------------------------------------------------ 

  KDI(Frame parent) {
    this(parent, true);
  }

  KDI(Frame parent, boolean editable) {
    this.editable = editable;

    Panel panel = new Panel(new BorderLayout(5, 0));

    if (editable) {
      text_field = new TextField();
      text_field.setEditable(false);
      panel.add(text_field, "North");
    }

    pane = new ScrollPane();
    pane.setBackground(Color.lightGray);

    kdic = new KDICanvas(this);
    pane.add(kdic);
    panel.add(pane, "Center");

    parent.add(panel);
    parent.pack();
    parent.setSize(300, 300);

    root_data = new Vector();

    focus_node = null;
    select_node = null;
    target_node = null;

    mode = NORMAL;

    font = new Font("SansSerif", Font.PLAIN, 14);
    fm = Toolkit.getDefaultToolkit().getFontMetrics(font);

    MouseEventListener mel = new MouseEventListener();
    kdic.addMouseListener(mel);
    kdic.addMouseMotionListener(mel);

    kdpd = new KDPropertyDialog(parent, editable);
    kdpd.addComponentListener(new PropertyHidden());

    initializePopupMenu();
  }

  private void initializePopupMenu() {
    MenuActionListener listener = new MenuActionListener();

    popup_menu = new PopupMenu("popup menu");
    kdic.add(popup_menu);

    menu_new = new Menu("new");
    popup_menu.add(menu_new);

    menu_new_atom = new MenuItem("atom");
    menu_new_atom.addActionListener(listener);
    menu_new.add(menu_new_atom);

    menu_new_integer = new MenuItem("integer");
    menu_new_integer.addActionListener(listener);
    menu_new.add(menu_new_integer);

    menu_new_string = new MenuItem("string");
    menu_new_string.addActionListener(listener);
    menu_new.add(menu_new_string);

    popup_menu.addSeparator();

    menu_property = new MenuItem("property");
    menu_property.addActionListener(listener);
    popup_menu.add(menu_property);

    menu_delete = new MenuItem("delete");
    menu_delete.addActionListener(listener);
    popup_menu.add(menu_delete);

    menu_remove = new MenuItem("remove");
    menu_remove.addActionListener(listener);
    popup_menu.add(menu_remove);
  }

  // ------------------------------------------------------ 󥿥ե

  public Data getSelectData() {
    return (Data)select_node;
  }

  public void setData(Data d) {
    if (editable)
      return;

    root_data.removeAllElements();

    pane.removeAll();

    if (d == null) {
      kdic.setSize(100, 100);
    } else {
      Node node = addNewData(d);

      int pad = 10;

      Rectangle rect = node.getBounds();
      node.move(node.rect.x - rect.x + pad, node.rect.y - rect.y + pad);
      kdic.setSize(rect.width + pad*2, rect.height + pad*2);
    }

    pane.add(kdic);
    pane.setScrollPosition(0,0);
    kdic.invalidate();
    pane.doLayout();

  }

  // ------------------------------------------------------ 

  private Node addNewData(Data d) {
    Node node = addNewDataRecursive(d);
    root_data.addElement(node);
    return node;
  }

  private Node addNewDataRecursive(Data d) {
    if (d.getDataType() == Data.FUNCTOR) {
      Data atom = Data.Atom(d.getFunctorName());
      Node node = newNode(atom, 0, 0);

      Data args[] = d.getFunctorArguments();
      for (int i = 0; i < args.length; i++)
	node.addArg(addNewDataRecursive(args[i]));

      return node;
    } else {
      return newNode(d, PAD, PAD);
    }
  }

  /**
   * Ρɤκ.
   * Ρɤ, ɬפ˱ƥϤ, ΥΡɤ򤹤.
   * @param d ɲä륢ȥߥåǡ
   * @param x, y Ρɤΰ֤濴
   * @param edit ФɤΥե饰
   */
  private void newNode(Data d, int x, int y, boolean edit) {
    new_node = newNode(d, x, y);

    if (edit) {
      property_node = null;
      kdpd.setDialog((Data)new_node);

      // Ρɤ˥ư
      Point p = kdic.getLocationOnScreen();
      kdpd.setCenterLocation(p.x + x, p.y + y);

      // ɽ
      kdpd.show();
    }

    root_data.addElement(new_node);
    setSelectNode(new_node);
  }

  private Node newNode(Data d, int x, int y) {
    String label = getDataLabel(d);
    Dimension size = calcSize(label);
    Rectangle rect = new Rectangle(x - size.width / 2, y - size.height / 2,
                                   size.width, size.height);
    return new Node(d, rect, label);
  }

  public void changeData(Node node, Data d) {
    String label = getDataLabel(d);
    Dimension size = calcSize(label);
    Rectangle rect = new Rectangle(node.rect.x, node.rect.y,
                                   size.width, size.height);
    node.replaceData(d, rect, label);
    kdic.redraw();

    if (select_node != null)
      setSelectNode(select_node);
  }

  private String getDataLabel(Data d) {
    switch (d.getDataType()) {
    case Data.INTEGER :
      return String.valueOf(d.getInteger());
    case Data.STRING :
      return "\"" + d.getString() + "\"";
    case Data.ATOM :
      return d.getAtomName();
    case Data.FUNCTOR :
      return d.getFunctorName();
    }

    return "";
  }

  private Dimension calcSize(String str) {
    int font_height = fm.getAscent() + fm.getDescent();

    int string_width = Math.max(fm.stringWidth(str), font_height);
    return new Dimension(string_width + PAD * 2, font_height + PAD * 2);
  }

  private void addArgument(Node node) {
    // ե󥯥ɲ
    node.addArg(target_node);

    root_data.removeElement(target_node);
    if (select_node != null)
      setSelectNode(select_node);

    kdic.redraw();
  }

  private void deleteNode(Node node) {
    if (node.isRootNode()) {
      Rectangle rect = node.getBounds();
      checkDelete(node);
      root_data.removeElement(node);
      kdic.redraw(rect);
    }
  }

  // node ʲΥΡɤ select_node ʤСselect_node  null ˤ
  private void checkDelete(Node node) {
    if (select_node == null)
      return;

    if (node == select_node) {
      setSelectNode(null);
      return;
    }

    if (node.getDataType() == Data.FUNCTOR) {
      Data args[] = node.getFunctorArguments();
      for (int i = 0; i < args.length; i++)
	checkDelete((Node)args[i]);
    }
  }

  private void removeArgument(Node node) {
    node.removeArg();
    root_data.addElement(node);
    node.move(node.rect.x + PAD, node.rect.y + PAD);
    setSelectNode(node);
    kdic.redraw();
  }

  private void moveNode(int ex, int ey) {
    // Ρɰư
    int new_x = ex - (pressed_x - target_node.rect.x);
    int new_y = ey - (pressed_y - target_node.rect.y);
    target_node.move(new_x, new_y);

    kdic.redraw();
  }

  private void setSelectNode(Node node) {
    if (!editable)
      return;

    Node previous_select_node = select_node;
    select_node = node;

    if (previous_select_node != null)
      kdic.redrawNode(previous_select_node);

    if (select_node == null) {
      text_field.setText("");
    } else {
      text_field.setText(Data.toStr(select_node));
      kdic.redrawNode(node);
    }
  }

  private void changeFocusNode(Node node) {
    if (node != focus_node) {
      Node previous_focus_node = focus_node;

      // ΤˡԤʤ
      focus_node = node;

      if (previous_focus_node != null)
	kdic.redrawNode(previous_focus_node);

      if (focus_node != null)
	kdic.redrawNode(focus_node);
    }
  }

  private void moveMoveBound(int x, int y) {
    Rectangle old_rect = new Rectangle(move_bound);
    move_bound.setLocation(x, y);

    Rectangle union = old_rect.union(move_bound);
    kdic.repaint(union.x, union.y, union.width, union.height);
  }

  private void showPropertyDialog(Node node) {
    property_node = node;
    kdpd.setDialog((Data)node);

    // Ρɤ˥ư
    Point p = kdic.getLocationOnScreen();
    Rectangle rect = node.rect;
    kdpd.setCenterLocation(p.x + rect.x + rect.width/2,
			   p.y + rect.y + rect.height/2);

    // ɽ
    kdpd.show();
  }

  private Node nodeAt(int x, int y) {
    for (int i = root_data.size() - 1; i >= 0; i--) {
      Node node = nodeAt((Node)root_data.elementAt(i), x, y);
      if (node != null)
	return node;
    }

    return null;
  }

  private Node nodeAt(Node node, int x, int y) {
    if (node.getDataType() == Data.FUNCTOR) {
      Data args[] = node.getFunctorArguments();
      for (int i = 0; i < args.length; i++) {
	Node node_at = nodeAt((Node)args[i], x, y);
	if (node_at != null)
	  return node_at;
      }
    }

    if (node.contains(x, y))
      return node;

    return null;
  }

  // ------------------------------------------------------ ٥Ƚ

  class PropertyHidden extends ComponentAdapter {
    public void componentHidden(ComponentEvent e) {
      if (!KDI.this.editable)
	return;

      KDPropertyDialog pd = (KDPropertyDialog)(e.getComponent());
      if (property_node != null) {
	// ץѥƥѹξ
	changeData(property_node, pd.getData());
      } else {
	// Ρɺξ
	changeData(new_node, pd.getData());
      }
    }
  }

  class MenuActionListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if (e.getSource() == menu_property) {
	showPropertyDialog(target_node);
      } else if (e.getSource() == menu_delete) {
	if (target_node.isRootNode()) {
	  deleteNode(target_node);
	}
      } else if (e.getSource() == menu_remove) {
	removeArgument(target_node);
      } else if (e.getSource() == menu_new_atom) {
	newNode(Data.Atom("atom"), pressed_x, pressed_y, true);
      } else if (e.getSource() == menu_new_integer) {
	newNode(Data.Integer(0), pressed_x, pressed_y, true);
      } else if (e.getSource() == menu_new_string) {
	newNode(Data.String("string"), pressed_x, pressed_y, true);
      }
    }
  }

  class MouseEventListener extends MouseEventWrapper {
    protected boolean isPopupModifier(MouseEvent e) {
      return (e.getModifiers() & InputEvent.BUTTON3_MASK) != 0;
    }

    protected void showPopupMenu(int ex, int ey) {
      pressed_x = ex;
      pressed_y = ey;

      Node node = nodeAt(ex, ey);

      menu_new.setEnabled(editable);

      if (node == null) {
        // Х
        menu_property.setEnabled(false);
        menu_delete.setEnabled(false);
        menu_remove.setEnabled(false);
      } else {
        // Ρɾ
	target_node = node;
        menu_property.setEnabled(true);
	if (node.isRootNode()) {
          // 롼ȥΡ
          menu_delete.setEnabled(editable);
          menu_remove.setEnabled(false);
	} else {
          // 롼ȥΡɰʳ
          menu_delete.setEnabled(false);
          menu_remove.setEnabled(editable);
	}
      }
      popup_menu.show(kdic, ex, ey);
    }

    protected void pressed(MouseEvent e) {
      int ex = e.getX();
      int ey = e.getY();

      pressed_x = ex;
      pressed_y = ey;

      Node node = nodeAt(ex, ey);

      if (   e.getClickCount() == 1 && node != null
	  && node.isRootNode() && editable) {
	// Ρɤΰư
        KDI.this.mode = KDI.MOVE_NODE;
	target_node = node;
	move_bound = new Rectangle(target_node.getBounds());
	move_bdx = ex - move_bound.x;  // Хǥ󥰥ܥå
	move_bdy = ey - move_bound.y;
      } else if (e.getClickCount() == 1 && node == null) {
	KDI.this.mode = KDI.PANE_MOVE;
      }
    }

    protected void clicked(MouseEvent e) {
      int ex = e.getX();
      int ey = e.getY();

      Node node = nodeAt(ex, ey);

      KDI.this.mode = KDI.NORMAL;

      if (node != null)
        setSelectNode(node);

      // ץ쥹(㤨Хɥե)repaint() ƤФ
      // ưΥХǥ󥰥ܥå褵Ƥ礬
      // õ뤿 repaint() Ԥ
      kdic.repaint();
    }

    protected void doubleClicked(MouseEvent e) {
      int ex = e.getX();
      int ey = e.getY();

      Node node = nodeAt(ex, ey);

      if (node != null) {
	if (e.isShiftDown()) {
	  if (node.isRootNode()) {
	    // ֥륯å줿Ρɤκ
	    deleteNode(node);
	  } else {
	    // ֥륯å줿Ρɤ򥢥ƥ
	    removeArgument(node);
	  }
	} else {
	  // ֥륯å줿ΡɤΥץѥƥɽ
	  showPropertyDialog(node);
	}
      } else {
	// ΡɾǤʤä
	if (editable) {
	  if (e.isShiftDown()) {
	    newNode(Data.Atom("."), ex, ey, false);  // ȥ "." 
	  } else if (e.isControlDown()) {
	    newNode(Data.Atom("[]"), ex, ey, false);  // ȥ "[]" 
	  } else if (select_node != null) {
	    // 򤵤줿ΡɤСԡ
	    Node n_node = addNewData(select_node);
	    n_node.move(ex - n_node.rect.width / 2,
			ey - n_node.rect.height / 2);
	    kdic.redraw(n_node.getBounds());
	  } else {
	    // 򤵤줿Ρɤʤ祢ȥ "." 
	    newNode(Data.Atom("."), ex, ey, false);
	  }
	}
      }
    }

    protected void dragReleased(MouseEvent e, boolean on_component) {
      if (KDI.this.mode == KDI.MOVE_NODE) {
	KDI.this.mode = KDI.NORMAL;

	int ex = e.getX();
	int ey = e.getY();

	Node node = nodeAt(ex, ey);

	if (e.isShiftDown()) {
	  // եȤƤХԡ
	  Node n_node = addNewData(target_node);
	  n_node.move(ex - n_node.rect.width / 2,
		      ey - n_node.rect.height / 2);
	  kdic.redraw();
	} else {
	  if (node == null || target_node.isAncestorOf(node)) {
	    // ư褬ʬʬλ¹ξñ˰ư
	    moveNode(ex, ey);
	  } else if (   node != null
		     && (   node.getDataType() == Data.ATOM
			 || node.getDataType() == Data.FUNCTOR)) {
	    // ե󥯥Υƥɲä
	    addArgument(node);
	  } else {
	    kdic.repaint();
	  }
	}
      } else if (KDI.this.mode == KDI.MOVE_NODE_EXITED) {
	KDI.this.mode = KDI.NORMAL;
	kdic.redrawNode(target_node);
      } else if (KDI.this.mode == KDI.PANE_MOVE) {
	KDI.this.mode = KDI.NORMAL;
      }
    }

    protected void moved(MouseEvent e, boolean on_component) {
      int ex = e.getX();
      int ey = e.getY();

      Node node = nodeAt(ex, ey);

      changeFocusNode(node);
    }

    protected void dragged(MouseEvent e, boolean on_component) {
      int ex = e.getX();
      int ey = e.getY();
      switch (KDI.this.mode) {
      case KDI.MOVE_NODE :
      case KDI.MOVE_NODE_EXITED :
	Node node = nodeAt(ex, ey);

	if (KDI.this.mode == KDI.MOVE_NODE && !on_component) {
	  KDI.this.mode = KDI.MOVE_NODE_EXITED;
	  kdic.redrawNode(target_node);
	  kdic.repaint();
	}
	if (KDI.this.mode == KDI.MOVE_NODE_EXITED && on_component) {
	  KDI.this.mode = KDI.MOVE_NODE;
	}

	if (KDI.this.mode == KDI.MOVE_NODE) {
	  moveMoveBound(ex - move_bdx, ey - move_bdy);
	}

	changeFocusNode(node);
	break;

      case KDI.PANE_MOVE :
	// newx = pspx + (- ((nx - nspx) - (px - pspx))) = nspx + px - nx

	Point now_scroll_position = pane.getScrollPosition();
	int new_x =  now_scroll_position.x + pressed_x - ex;
	int new_y =  now_scroll_position.y + pressed_y - ey;
	try {
	  pane.setScrollPosition(new_x, new_y);
	} catch(IllegalArgumentException iae) {
	  // nothing to do
	}
      }  // switch(KDI.this.mode)
    }
  }  // class MouseEventListener

} // class KDI
