// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.awt.*;
import java.awt.event.*;

/**
 * ֥Хåե󥰤ԤХ.
 * ̤ϡpaint() ,
 * draw() ᥽åɤ.
 * ̤κ repaint() ,
 * redraw() ᥽åɤƤӽФȤˤԤ.
 */
class DoubleBufferedCanvas extends Canvas {
  /**
   * ֥ХåեѤΥ᡼.
   */
  protected Image off_image;

  /**
   * ֥ХåեѤΥ᡼Υեå.
   */
  private Graphics off_graphics;

  /**
   * ֥ХåեѤΥ᡼Υ.
   */
  private Dimension off_dimension;

  /**
   * 󥹥ȥ饯.
   */
  public DoubleBufferedCanvas() {
    super();

    off_image = null;

    // ꥵ줿ˡХåե򥯥ꥢ
    addComponentListener(new ComponentAdapter() {
      public void componentResized(ComponentEvent e) {
	off_image = null;
      }
    } );
  }

  /**
   * ̤κ.
   */
  public void update(Graphics g) {
    paint(g);
  }

  /**
   * ̤.
   * Хåե褵줿᡼񤭽Ф.
   */
  public void paint(Graphics g) {
    // ֥Хåե󥰤ν
    Dimension dim = getSize();
    if (off_image == null || !off_dimension.equals(dim)) {
      off_image = createImage(dim.width, dim.height);
      off_graphics = off_image.getGraphics();
      off_dimension = dim;
      off_graphics.setClip(0, 0, off_dimension.width, off_dimension.height);
      draw(off_graphics);
    }

    Rectangle clip = g.getClipBounds();

    // Хåեν񤭽Ф
    g.drawImage(off_image,
		clip.x, clip.y, clip.x + clip.width, clip.y + clip.height,
		clip.x, clip.y, clip.x + clip.width, clip.y + clip.height,
		this);
    directDraw(g);
  }

  /**
   * ̤κ.
   */
  protected void redraw() {
    if (off_image == null || !off_dimension.equals(getSize())) {
      repaint();
      return;
    }

    redraw(0, 0, off_dimension.width, off_dimension.height);
  }

  /**
   * ѹäʬκ.
   */
  protected void redraw(Rectangle rect) {
    redraw(rect.x, rect.y, rect.width, rect.height);
  }

  /**
   * ѹäʬκ.
   */
  protected void redraw(int x, int y, int width, int height) {
    if (off_image == null || !off_dimension.equals(getSize())) {
      repaint();
      return;
    }

    int px = (x < 0) ? 0 : x;
    int py = (y < 0) ? 0 : y;
    int pwidth =  (off_dimension.width < width)
                 ? off_dimension.width : width;
    int pheight = (off_dimension.height < height)
                 ? off_dimension.height : height;

    off_graphics.setClip(px, py, pwidth, pheight);
    draw(off_graphics);
    repaint(px, py, pwidth, pheight);

    Toolkit tk = getToolkit();
    if (tk != null) {
      tk.sync();
    }
  }

  /**
   * ̤.
   * Υ᥽åɤ,֥饹ɬפ.
   */
  protected void draw(Graphics g) {
  }

  /**
   * ̤.
   * եåؤľԤƤ򵭽Ҥ.
   */
  protected void directDraw(Graphics g) {
  }
}
