// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.net.*;
import java.io.*;
import java.lang.reflect.*;
import java.util.Vector;

public class JK {
  private volatile Reader in = null;
  private volatile Writer out = null;
  private ReadThread rt = null;
  private SyncThread st = null;
  private Stream data_stream;
  private ArgsManager args_manager;
  private ObjectTable object_table;
  String errorMessage = null;

  /**
   * String 饹򤢤魯 Class 饹Υ֥.
   */
  private static final Class STRING_TYPE = new String().getClass();

  public JK(InputStream in, OutputStream out) {
    this.in = new BufferedReader(new InputStreamReader(in));
    this.out = new OutputStreamWriter(out);
    data_stream = new Stream();
    args_manager = new ArgsManager();
    object_table = new ObjectTable();
    rt = new ReadThread();
    rt.start();
    st = new SyncThread();
    st.start();
  }


  /**
   * ǡν񤭹.
   */
  public void put(Data d) {
    put(0, d);
  }

  /**
   * ǡν񤭹.
   */
  public void put(int port, Data d) {
    if (out == null) {
      errorOccured("put : socket has already closed");
      return;
    }

    if (port < 0) {
      errorOccured("put : port is negative");
      return;
    }

    String send = new StringBuffer()
      .append("data(")
      .append(Data.getWTString(Data.Integer(port)))
      .append(",")
      .append(Data.getWTString(d))
      .append(")\n")             // \n : ȥåԥ󥰥
      .toString();

    writeMessage(send);
  }

  /**
   * ǡɤ߹.
   */
  public Data get() {
    Object data = null;

    data = data_stream.get();

    return (Data)data;
  }

  /**
   * θƤӽФ.
   * ƤӽФ, Ǹΰ˶β줿֤ͤ.
   */
  public Data call(String module_name, String goal_name, Data args[]) {
    Data args_list = Data.List(args);
    RetObject ret = args_manager.newObject();  // ƽФͤ

    String send = new StringBuffer()
      .append("call(")
      .append(Data.getWTString(Data.Atom(module_name)))
      .append(",")
      .append(Data.getWTString(Data.Atom(goal_name)))
      .append(",")
      .append(Data.getWTString(args_list))
      .append(",")
      .append(Data.getWTString(ret.getTag()))  // Ĥ
      .append(")\n")
      .toString();

    writeMessage(send);

    Data return_value = ret.read();

    return return_value;
  }

  /**
   * ȥ꡼फɤ߹ߤλ,ȥ꡼Ĥ.
   */
  public void close() {
    ReadThread bak_rt = rt;
    if (bak_rt != null) {
      bak_rt.interrupt();
      try {
	bak_rt.join();  // åɤνλԤ
      } catch (InterruptedException e) {
	// nothing to do
      }
      rt = null;
    }

    closeOperation();
  }

  private void closeOperation() {
    data_stream.close();
    args_manager.close();
    object_table.removeAll();

    // SyncThread ߤ롣
    if (st != null) {
      st.interrupt();
      st = null;
    }

    // ϥȥ꡼Ĥ
    try {
      if (out != null) {
	out.close();
	out = null;
      }
    } catch (Exception e) {
      // no error operation
    }
    try {
      if (in != null) {
	in.close();
	in = null;
      }
    } catch (Exception e) {
      // no error operation
    }
  }

  /**
   * ȥ꡼Ū˿.
   */
  private class SyncThread extends Thread {
    int interval;  // ֳִ (ms)

    SyncThread() {
      this(200);
    }

    SyncThread(int interval) {
      this.interval = interval;
    }

    public void run() {
      for (;;) {
	writeMessage("\n");
	try {
	  Thread.sleep(interval);
	} catch(InterruptedException e) {
	  return;
	}
      }
    }
  }

  /**
   * ȥ꡼फΥǡԤʤ.
   */
  private class ReadThread extends Thread {
    public void run() {
      try {
	for (;;) {
	  if (Thread.interrupted()) {
	    closeOperation();
	    rt = null;
	    return;
	  }

	  ParseResult com = parseCommand();
	  if (com.type == ParseResult.EOF) {
	    // System.err.println("==================== EOF");
	    closeOperation();
	    return;
	  } else if (com.type == ParseResult.ERR) {
	    // System.err.println("==================== ERR");
	    continue;
	  }

	  /*
	  System.err.print(com.name + "/" + com.data.length + " : ");
	  for (int i = 0; i < com.data.length; i++) {
	    System.err.print(Data.toStr(com.data[i]));
	    if (i  + 1 < com.data.length)
	      System.err.print(",  ");
	  }
	  System.err.println();
	  */

	  if (com.name.equals("close") && com.data.length == 0) {
	    // close : 󥿥եνλ
	    closeOperation();
	    return;

	  } else if (com.name.equals("data") && com.data.length == 1) {
	    // data(Data) : ȥ꡼񤭹
	    data_stream.put(com.data[0]);

	  } else if (com.name.equals("class_method") && com.data.length == 4) {
	    // class_method(Class, Method, Args, Tag) : 饹᥽åɸƽФ
	    classMethodInvoke(com.data[0], com.data[1],
			      com.data[2], com.data[3]);

	  } else if (com.name.equals("class_fget") && com.data.length == 3) {
	    // class_fget(Class, FieldName, Tag) : 饹եɻ
	    classFieldGet(com.data[0], com.data[1], com.data[2]);

	  } else if (com.name.equals("class_fset") && com.data.length == 4) {
	    // class_fset(Class, FieldName, Data, Tag) : 饹ե
	    classFieldSet(com.data[0], com.data[1], com.data[2], com.data[3]);

	  } else if (com.name.equals("ret") && com.data.length == 2) {
	    // ret(Data, Tag) : ͤꤹ
	    args_manager.setData(com.data[0], com.data[1]);

	  } else if (com.name.equals("instance") && com.data.length == 3) {
	    // instance(Class, Args, tag) : ֥
	    makeInstance(com.data[0], com.data[1], com.data[2]);

	  } else if (com.name.equals("method") && com.data.length == 4) {
	    // method(Number, Method, Args, tag) : ֥ȥ᥽åɸƽФ
	    methodInvoke(com.data[0], com.data[1], com.data[2], com.data[3]);

	  } else if (com.name.equals("fget") && com.data.length == 3) {
	    // fget(Num, FieldName, Tag) : ֥ȥեɻ
	    fieldGet(com.data[0], com.data[1], com.data[2]);

	  } else if (com.name.equals("fset") && com.data.length == 4) {
	    // fset(Num, FieldName, Data, Tag) : ֥ȥե
	    fieldSet(com.data[0], com.data[1], com.data[2], com.data[3]);

	  } else if (com.name.equals("remove") && com.data.length == 1) {
	    // remove(Num) : ֥νλ
	    object_table.remove(com.data[0]);

	  } else {
	    // command not found
	  }
	}
      } catch (IOException e) {
	if (e instanceof InterruptedIOException) {
	  // Java ¦ close() ƤФƤ硢parseCommand() 
	  // interrupt 뤿 InterruptedIOException 
	  closeOperation();  // 
	  rt = null;
	} else {
	  rt = null;
	  // closeOperation(); // errorOccured() ǸƤФ
	  errorOccured("ReadThread : Error at socket(" + e + ")");
	}
	return;
      } catch (ThreadDeath d) {
	closeOperation();
	throw d;
      }
    }
  }

  /**
   * åȤ줿ޥɤɤ߼.
   * command_name(Arg1,....,Argn)\n η.
   */
  private ParseResult parseCommand() throws IOException {
    StringBuffer command = new StringBuffer();
    int ic;

    // ޥ̾ɤ߹
    for (;;) {
      ic = in.read();
      if (ic == -1) {
	return new ParseResult(ParseResult.EOF, null, null);
      } else if (ic == '\n') {
	// ʤΥޥɤξ
	Data args[] = new Data[] {};
	return new ParseResult(ParseResult.OK, command.toString(), args);
      } else if (ic ==  '(') {
	break;
      } else {
	command.append((char)ic);
      }
    }

    Vector args_v = new Vector();  // ¸ Vector

    // ɤ߼
    do {
      Data data = Data.Parse(in);
      if (data == null) {
	return new ParseResult(readRest(in.read()), null, null);
      }

      args_v.addElement(data);
    } while ((ic = in.read()) == ',');

    if (ic == ')') {
      ic = in.read();
      if (ic == '\n') {
	// ɤ߼줿
	Data args[] = new Data[args_v.size()];
	args_v.copyInto(args);	// Vector Ѵ
	return new ParseResult(ParseResult.OK, command.toString(), args);
      }
    }

    // ɤ߼ʤä
    return new ParseResult(readRest(ic), null, null);
  }

  /**
   * ɤ߼ꥨ顼ä,"\n" ޤɤ߼ΤƤ.
   */
  private int readRest(int ic) throws IOException {
    for (;;ic = in.read()) {
      if (ic == -1) {
	return ParseResult.EOF;
      } else if (ic == '\n') {
	return ParseResult.ERR;
      }
    }
    // not reached
  }

  /**
   * ȥ꡼˥å񤭹.
   * 񤭹ߤϤ줹.
   */
  private void writeMessage(String mes) {
    try {
      if (out != null) {
	out.write(mes, 0, mes.length());
	out.flush();
	// System.err.print("mes write:"+mes);
      }
    } catch (IOException e) {
      errorOccured("writeMessage : Error at socket(" + e + ")");
    }
  }

  private void makeInstance(Data cl, Data ar, Data ta) {
    String class_name = cl.getString();
    Data args[] = Data.ListToArray(ar);

    MakeInstanceThread th;
    th = new MakeInstanceThread(class_name, args, ta);
    th.start();
  }

  class MakeInstanceThread extends Thread {
    String class_name;
    Data args[];
    Data tag;

    MakeInstanceThread(String class_name, Data args[], Data tag) {
      this.class_name = class_name;
      this.args = args;
      this.tag = tag;
    }

    public void run() {
      String error_message = null;
      Object obj = null;
      try {
	obj = ObjectElement.makeInstance(class_name, args);
      } catch (ClassNotFoundException e) {
	error_message = e.toString();
      } catch (NoSuchMethodException e) {
	error_message = e.toString();
      } catch (SecurityException e) {
	error_message = e.toString();
      } catch (IllegalAccessException e) {
	error_message = e.toString();
      } catch (IllegalArgumentException e) {
	error_message = e.toString();
      } catch (InstantiationException e) {
	error_message = e.toString();
      } catch (InvocationTargetException e) {
	error_message = e.toString() + " : " + e.getTargetException();
      }

      if (error_message != null) {
	Data err = Data.Functor("abnormal", Data.String(error_message));
	returnValue(err, tag);
	return;
      }

      Data object_tag = object_table.add(obj);
      Data ret = Data.Functor("normal", object_tag);
      returnValue(ret, tag);
    }
  }

  /**
   * 饹᥽åɤ¹Ԥ.
   */
  private void classMethodInvoke(Data cl, Data me, Data ar, Data ta) {
    String class_name = cl.getString();
    String method_name = me.getString();
    Data args[] = Data.ListToArray(ar);

    Class cla;
    try {
      cla = Class.forName(class_name);
    } catch (ClassNotFoundException e) {
      Data err = Data.Functor("abnormal", Data.String(e.toString()));
      returnValue(err, ta);
      return;
    }

    ObjectElement dummy = new ObjectElement(cla, null);

    MethodInvokeThread th;
    th = new MethodInvokeThread(dummy, method_name, args, ta);
    th.start(); // ¾Υ饹᥽åɸƤӽФȤƱʤǼ¹
  }

  /**
   * 饹եɤͤ.
   */
  private void classFieldGet(Data cl, Data fi, Data tag) {
    String class_name = cl.getString();
    String field_name = fi.getString();

    Class cla;
    try {
      cla = Class.forName(class_name);
    } catch (ClassNotFoundException e) {
      Data err = Data.Functor("abnormal", Data.String(e.toString()));
      returnValue(err, tag);
      return;
    }

    ObjectElement dummy = new ObjectElement(cla, null);

    FieldGetThread th = new FieldGetThread(dummy, field_name, tag);
    th.start();
  }

  /**
   * 饹եɤͤꤹ.
   */
  private void classFieldSet(Data cl, Data fi, Data data, Data tag) {
    String class_name = cl.getString();
    String field_name = fi.getString();

    Class cla;
    try {
      cla = Class.forName(class_name);
    } catch (ClassNotFoundException e) {
      Data err = Data.Functor("abnormal", Data.String(e.toString()));
      returnValue(err, tag);
      return;
    }

    ObjectElement dummy = new ObjectElement(cla, null);

    FieldSetThread th = new FieldSetThread(dummy, field_name, data, tag);
    th.start();
  }

  /**
   * ֥ȥ᥽åɤ¹Ԥ.
   */
  private void methodInvoke(Data num, Data me, Data ar, Data ta) {
    String method_name = me.getString();
    Data args[] = Data.ListToArray(ar);

    ObjectElement oe = (ObjectElement)object_table.get(num);
    if (oe == null) {
      Data ret = Data.Functor("abnormal", Data.String("No such object."));
      returnValue(ret, ta);
      return;
    }

    MethodInvokeThread th;
    th = new MethodInvokeThread(oe, method_name, args, ta);
    oe.synchronizedCall(th);
  }

  /**
   * եɤͤ.
   */
  private void fieldGet(Data num, Data fi, Data tag) {
    ObjectElement oe = (ObjectElement)object_table.get(num);
    if (oe == null) {
      Data ret = Data.Functor("abnormal", Data.String("No such object."));
      returnValue(ret, tag);
      return;
    }

    String field_name = fi.getString();

    FieldGetThread th;
    th = new FieldGetThread(oe, field_name, tag);
    oe.synchronizedCall(th);
  }

  /**
   * եɤͤꤹ.
   */
  private void fieldSet(Data num, Data fi, Data data, Data tag) {
    ObjectElement oe = (ObjectElement)object_table.get(num);
    if (oe == null) {
      Data ret = Data.Functor("abnormal", Data.String("No such object."));
      returnValue(ret, tag);
      return;
    }

    String field_name = fi.getString();

    FieldSetThread th;
    th = new FieldSetThread(oe, field_name, data, tag);
    oe.synchronizedCall(th);
  }

  class MethodInvokeThread extends Thread {
    ObjectElement oe;
    String method_name;
    Data args[];
    Data tag;

    MethodInvokeThread(ObjectElement object_element, String method_name,
			    Data args[], Data tag) {
      this.oe = object_element;
      this.method_name = method_name;
      this.args = args;
      this.tag = tag;
    }

    public void run() {
      String error_message = null;
      Data ret = null;
      try {
	ret = oe.methodInvoke(method_name ,args);
      } catch (NoSuchMethodException e) {
	error_message = e.toString();
      } catch (SecurityException e) {
	error_message = e.toString();
      } catch (IllegalAccessException e) {
	error_message = e.toString();
      } catch (IllegalArgumentException e) {
	error_message = e.toString();
      } catch (InstantiationException e) {
	error_message = e.toString();
      } catch (InvocationTargetException e) {
	error_message = e.toString();
      }

      if (error_message != null) {
	Data err = Data.Functor("abnormal", Data.String(error_message));
	returnValue(err, tag);
	return;
      }

      Data ret_data = Data.Functor("normal", ret);
      returnValue(ret_data, tag);
    }
  }

  class FieldGetThread extends Thread {
    ObjectElement oe;
    String field_name;
    Data tag;

    FieldGetThread(ObjectElement object_element, String field_name, Data tag) {
      this.oe = object_element;
      this.field_name = field_name;
      this.tag = tag;
    }

    public void run() {
      String error_message = null;
      Data ret = null;
      try {
	ret = oe.getField(field_name);
      } catch (NoSuchFieldException e) {
	error_message = e.toString();
      } catch (SecurityException e) {
	error_message = e.toString();
      } catch (ClassCastException e) {
	error_message = e.toString();
      } catch (IllegalAccessException e) {
	error_message = e.toString();
      } catch (IllegalArgumentException e) {
	error_message = e.toString();
      }

      if (error_message != null) {
	Data err = Data.Functor("abnormal", Data.String(error_message));
	returnValue(err, tag);
	return;
      }

      Data ret_data = Data.Functor("normal", ret);
      returnValue(ret_data, tag);
    }
  }

  class FieldSetThread extends Thread {
    ObjectElement oe;
    String field_name;
    Data data;
    Data tag;

    FieldSetThread(ObjectElement object_element, String field_name,
		   Data data, Data tag) {
      this.oe = object_element;
      this.field_name = field_name;
      this.data = data;
      this.tag = tag;
    }

    public void run() {
      String error_message = null;
      try {
	oe.setField(field_name, data);
      } catch (NoSuchFieldException e) {
	error_message = e.toString();
      } catch (SecurityException e) {
	error_message = e.toString();
      } catch (ClassCastException e) {
	error_message = e.toString();
      } catch (IllegalAccessException e) {
	error_message = e.toString();
      } catch (IllegalArgumentException e) {
	error_message = e.toString();
      }

      if (error_message != null) {
	Data err = Data.Functor("abnormal", Data.String(error_message));
	returnValue(err, tag);
	return;
      }

      Data ret = Data.Atom("normal");
      returnValue(ret, tag);
    }
  }

  /**
   * Ĥ֤ͤ.
   */
  private void returnValue(Data d, Data tag) {
    String send = new StringBuffer()
      .append("ret(")
      .append(Data.getWTString(d))
      .append(",")
      .append(Data.getWTString(tag))
      .append(")\n")             // \n : ȥåԥ󥰥
      .toString();

    writeMessage(send);
  }

  /**
   * 顼ȯνԤʤ.
   */
  private void errorOccured(String str) {
    // 顼å֤
    errorMessage = str;
    System.err.println(str);

    close();
  }
}


/**
 * åȤ줿ޥɤμ֤Υ饹.
 */
class ParseResult {
  static final int EOF = 1; // end of File
  static final int ERR = 2; // bad command
  static final int OK  = 3; // parse successful

  int type;
  String name;
  Data data[];

  ParseResult(int type, String name, Data data[]) {
    this.type = type;
    this.name = name;
    this.data = data;
  }
}
