// Copyright (C) 1998,1999 Kazuhisa Iizuka

import java.io.*;
import java.util.*;

public class Data {
  /**
   * ǡɽ.
   * ͤФˤ, getInteger() ᥽åɤѤ
   */
  public static final int INTEGER = 0;

  /**
   * ʸǡɽ.
   * ͤФˤ, getString() ᥽åɤѤ
   */
  public static final int STRING  = 1;

  /**
   * ȥǡɽ.
   * ȥ̾Фˤ, getAtomName() ᥽åɤѤ
   */
  public static final int ATOM    = 2;

  /**
   * ե󥯥ǡɽ.
   * ͤФˤ, getFunctorName(), getFunctorArguments()
   * ᥽åɤѤ
   */
  public static final int FUNCTOR = 3;

  /**
   * Data 饹򤢤魯 Class 饹Υ֥.
   */
  public static final Class TYPE = Data.Integer(0).getClass();

  private int type;
  private int num;
  private String str;  // STRING, ATOM, ե󥯥̾
  private Data args[];

  /**
   * Ѥʤ.
   */
  private Data() {
  }

  /**
   * Ѥ륳󥹥ȥ饯.
   * ѤϤʤ
   * 󥹥󥹤, Data.Integer(), Data.String(),
   *  Data.Atom(), Data.Functor() Ѥ롣
   */
  private Data(int type) {
    this.type = type;
  }

  protected Data(Data d) {
    this.type = d.type;

    switch (d.type) {
    case Data.INTEGER :
      this.num = d.num;
      break;
    case Data.STRING :
      this.str = d.str;
      break;
    case Data.ATOM :
      this.str = d.str;
      break;
    case Data.FUNCTOR :
      this.str = d.str;
      this.args = d.args;
      break;
    }
  }

  /**
   * Ϳ줿ǡʣ.
   */
  public static Data clone(Data d) {
    switch (d.type) {
    case Data.INTEGER :
      return Data.Integer(d.num);
    case Data.STRING :
      return Data.String(d.str);
    case Data.ATOM :
      return Data.Atom(d.str);
    case Data.FUNCTOR :
      Data args[] = new Data[d.args.length];
      for (int i = 0; i < d.args.length; i++) {
	args[i] = Data.clone(d.args[i]);
      }
      return Data.Functor(d.str, args);
    }

    return null;  // not reached
  }

  /**
   * ֥ȤΥϥå女ɤ֤.
   */
  public int hashCode() {
    // ξ, ͼ
    // ʸξ, ʸ hashCode()
    // ȥȥե󥯥ξ, ȥ̾ʸ hashCode()
    switch (type) {
    case Data.INTEGER :
      return num;
    case Data.STRING :
    case Data.ATOM :
    case Data.FUNCTOR :
      return str.hashCode();
    }

    return 0;  // not reached
  }

  /**
   * Ϳ줿ǡƱƤǤ뤫Ĵ٤.
   */
  public boolean equals(Object obj) {
    if (obj == null || !(obj instanceof Data))
      return false;

    Data d = (Data)obj;
    if (type != d.type)
      return false;

    switch (type) {
    case Data.INTEGER :
      return num == d.num;
    case Data.STRING :
      return str.equals(d.str);
    case Data.ATOM :
      return str.equals(d.str);
    case Data.FUNCTOR :
      if (!str.equals(d.str))
	return false;

      for (int i = 0; i < args.length; i++) {
	if (!args[i].equals(d.args[i]))
	  return false;
      }
      return true;
    }

    return false;  // not reached
  }

  protected void replace(Data d) {
    this.type = d.type;
    this.num = d.num;
    this.str = d.str;
    this.args = d.args;
  }

  /**
   * Υǡμ֤.
   */
  public int getDataType() {
    return type;
  }

  /**
   * ǡ.
   */
  public static Data Integer(int num) {
    Data d = new Data(INTEGER);
    d.num = num;
    return d;
  }

  /**
   * ǡͤФ.
   */
  int getInteger() {
    return num;
  }

  /**
   * ʸǡ.
   */
  public static Data String(String str) {
    Data d = new Data(STRING);
    d.str = str;
    return d;
  }

  /**
   * ʸǡͤФ.
   */
  public String getString() {
    return str;
  }

  /**
   * ȥǡ.
   */
  public static Data Atom(String atom) {
    Data d = new Data(ATOM);
    d.str = atom;
    return d;
  }

  /**
   * ȥ̾Ф.
   */
  public String getAtomName() {
    return str;
  }

  /**
   * 1Υե󥯥ǡ.
   */
  public static Data Functor(String atom, Data arg) {
    return Functor(atom, new Data[] {arg});
  }

  /**
   * ե󥯥ǡ.
   */
  public static Data Functor(String atom, Data args[]) {
    // ĹΥå
    if (args.length == 0) {
      return Atom(atom);
    }

    // Ȥ̥ݥ󥿤Ǥʤå
    for (int i = 0; i < args.length; i++) {
      if (args[i] == null)
	return Atom(atom);
    }

    Data d = new Data(FUNCTOR);
    d.str = atom;

    // 򿷤Ȥ򥳥ԡ
    d.args = new Data[args.length];
    System.arraycopy(args, 0, d.args, 0, args.length);

    return d;
  }

  /**
   * ե󥯥̾Ф.
   */
  public String getFunctorName() {
    return str;
  }

  /**
   * ե󥯥ΰФ.
   */
  public Data[] getFunctorArguments() {
    Data ret[] = new Data[args.length];
    System.arraycopy(args, 0, ret, 0, args.length);
    return ret;
  }

  /**
   * Nil([])ǡ.
   */
  static Data Nil() {
    return Data.Atom("[]");
  }

  /**
   * 󥹥.
   */
  public static Data Cons(Data car, Data cdr) {
    Data[] cons = new Data[] {car, cdr};
    return Data.Functor(".", cons);
  }

  /**
   * ꥹȤˤʤäƤǡ, Ǥ.
   */
  public static Data[] ListToArray(Data list) {
    // ⤷[] ʤĹ֤
    if (Data.isNil(list))
      return new Data[0];

    if (Data.isCons(list)) {      // ꥹȤʤ ...
      Vector v = new Vector();
      Data d;

      // ꥹȤγǤ٥¸
      for(d = list; Data.isCons(d); d = d.args[1]) {
	v.addElement(d.args[0]);
      }

      // Ǹ夬 [] ǤʤСΥǡɲä
      if (!isNil(d))
	v.addElement(d);

      // ٥Ѵ
      Data ret[] = new Data[v.size()];
      v.copyInto(ret);

      return ret;
    }

    // ⤷ꥹȤǤʤСΥǡͣǤȤꥹȤ֤
    return new Data[] { Data.Cons(list, Nil()) };
  }

  /**
   * Ϳ줿󤫤ꥹȤ.
   */
  public static Data List(Data list[]) {
    return makeList(list, 0);
  }

  private static Data makeList(Data list[], int p) {
    if (p == list.length)
      return Nil();
    else
      return Cons(list[p], makeList(list, p+1));
  }

  /**
   * ǡ󥹥뤫ɤĴ٤.
   */
  public static boolean isCons(Data d) {
    return    d.type == FUNCTOR
           && d.str.equals(".")
           && d.args.length == 2;
  }

  /**
   * ǡ Nil([]) ɤĴ٤.
   */
  public static boolean isNil(Data d) {
    return d.type == ATOM && d.str.equals("[]");
  }


  /**
   * ʸ󤫤ǡ.
   */
  public static Data Parse(Reader in) throws IOException {
    return Data.ParseMain(in);
  }

  private static Data ParseMain(Reader in) throws IOException {
    int ic = in.read();
    if (ic == -1) {
      return null;
    }
    char c = (char)ic;

    switch (c) {
    case 'a' :
      for (int i = 1; i < "atom(".length(); i++)
	in.read();
      return parseAtom(in);
    case 'i' :
      for (int i = 1; i < "integer(".length(); i++)
	in.read();
      return parseInteger(in);
    case 'l' :
      for (int i = 1; i < "list(".length(); i++)
	in.read();
      return parseList(in);
    case 'f' :
      for (int i = 1; i < "functor(".length(); i++)
	in.read();
      return parseFunctor(in);
    case 's' :
      for (int i = 1; i < "string(".length(); i++)
	in.read();
      return parseString(in);
    }

    return null;
  }

  /**
   * ȥåԥʸ stop Ȥơʸǧʤɤ߹.
   */
  private static String readToken(Reader in, char stop) throws IOException {
    StringBuffer str = new StringBuffer();

    int ic;
    char c;

    for (;;) {
      if ((ic = in.read()) < 0) {
	return null;
      }
      c = (char)ic;

      if (c == '\\') {  // meta character
	int nic = in.read();
	if (ic < 0){
	  return null;
	} else if ((char)nic == 'n') {
	  str.append('\n');
	} else if ((char)nic == 't') {
	  str.append('\t');
	} else {
	  str.append((char)nic);
	}
      } else if (c == stop) {
	return str.toString();
      } else {
	str.append(c);
      }
    }
  }

  private static Data parseAtom(Reader in) throws IOException {
    // atom(...) | ex. atom([])
    String str = readToken(in, ')');
    if (str == null)
      return null;
    else
      return Data.Atom(str);
  }

  private static Data parseInteger(Reader in) throws IOException {
    // integer(...) | ex. integer(-1)
    String str = readToken(in, ')');
    if (str == null) {
      return null;
    } else {
      return Data.Integer(Integer.valueOf(str).intValue());
    }
  }

  private static Data parseString(Reader in) throws IOException {
    // string("...") | ex. string("abc")
    in.read();  // read '"'
    String str = readToken(in, '\"');  // " Java Hilit ...
    if (str == null) {
      return null;
    } else {
      in.read();  // read ')'
      return Data.String(str);
    }
  }

  private static Data parseList(Reader in) throws IOException {
    // list([..|..]) | ex. list([atom(a)|atom([])])

    in.read();  // read '['

    Data car, cdr;

    car = Data.ParseMain(in);
    if (car == null)
      return null;

    in.read();  // read '|'

    cdr = Data.ParseMain(in);
    if (cdr == null)
      return null;

    in.read();  // read ']'
    in.read();  // read ')'

    return Data.Cons(car, cdr);
  }

  private static Data parseFunctor(Reader in) throws IOException {
    // functor(func(..)) | ex. functor(.(atom(one), atom([])))

    String str = readToken(in, '(');  // '(' ޤǤե󥯥̾
    if (str == null)
      return null;

    Vector args = new Vector();

    do {
      Data arg = Data.ParseMain(in);
      if (arg == null)
	return null;
      args.addElement(arg);
    } while (in.read() != ')');  // read separator (',' or ')')

    in.read();  // read ')'

    Data[] args_array = new Data[args.size()];
    args.copyInto((Object[])args_array);

    return Data.Functor(str, args_array);
  }



  /**
   * ǡ뤿,åפ줿ʸѴ.
   */
  public static String getWTString(Data d) {
    return wrapStr(d);
  }

  /**
   * ǡåפ줿ʸѴ.
   */
  private static String wrapStr(Data d) {
     switch (d.type) {
     case Data.INTEGER :
       return convertInt(d);
     case Data.STRING :
       return convertStr(d);
     case Data.ATOM :
       return convertAtom(d);
     case Data.FUNCTOR :
       if (Data.isCons(d))
	 return convertList(d);
       else
	 return convertFunctor(d);
     }

     return "";
  }

  private static String convertInt(Data d) {
    // integer(...) | ex. integer(-1)
    return "integer(" + Data.toStringInt(d) + ")";
  }

  private static String convertStr(Data d) {
    // string("...") | ex. string("abc")
    return "string(" + Data.toStringStr(d) + ")";
  }

  private static String convertAtom(Data d) {
    // atom(...) | ex. atom([])
    return "atom(" + Data.toStringAtom(d) + ")";
  }

  private static String convertList(Data d) {
    // list([..|..]) | ex. list([atom(a)|atom([])])
    return "list([" + Data.wrapStr(d.args[0]) + "|"
                    + wrapStr(d.args[1]) + "])";
  }

  private static String convertFunctor(Data d) {
    // functor(func(..)) | ex. functor(.(atom(one)))
    StringBuffer str = new StringBuffer();

    str.append("functor(");

    str.append(Data.toStringAtom(d)).append("(");
    str.append(wrapStr(d.args[0]));
    for (int i = 1; i < d.args.length; i++) {
      str.append(",");
      str.append(wrapStr(d.args[i]));
    }
    str.append(")");

    str.append(")");

    return str.toString();
  }

  /**
   * ǡʸѴ.
   */
  public static String toStr(Data d) {
    if (d == null)
      return null;

    switch (d.type) {
    case Data.INTEGER :
      return toStringInt(d);
    case Data.STRING :
      return toStringStr(d);
    case Data.ATOM :
      return toStringAtom(d);
    case Data.FUNCTOR :
      if (Data.isCons(d))
	return toStringList(d);
      else
	return toStringFunctor(d);
    }

    return "";
  }

  /**
   * '\n', '\t', '(', ')', '\", '\'', '\\' ,
   * "\" ǥפʸ֤.
   * // " Java Hilit ...
   */
  private static String getEscapedString(String str) {
    char[] chars = str.toCharArray();
    StringBuffer buf = new StringBuffer();

    for(int i = 0; i < chars.length; i++) {
      switch(chars[i]) {
      case '\n' : buf.append("\\n");  break;
      case '\t' : buf.append("\\t");  break;
      case '('  : buf.append("\\(");  break;
      case ')'  : buf.append("\\)");  break;
      case '\"' : buf.append("\\\""); break;
      case '\'' : buf.append("\\\'"); break;
      case '\\' : buf.append("\\\\"); break;
      default : buf.append(chars[i]); break;
      }
    }

    return buf.toString();
  }

  private static String toStringInt(Data d) {
    return String.valueOf(d.num);
  }

  private static String toStringStr(Data d) {
    return "\"" + getEscapedString(d.str) + "\"";
  }

  // atom ¾ functor μե󥯥ȤƤƤФ
  private static String toStringAtom(Data d) {
    return getEscapedString(d.str);
  }

  private static String toStringList(Data d) {
    StringBuffer str = new StringBuffer();

    str.append("[");

    for (;;) {
      str.append(Data.toStr(d.args[0]));

      if (!isCons(d.args[1]))
	break;

      str.append(",");
      d = d.args[1];
    }

    if (!isNil(d.args[1]))
      str.append("|").append(Data.toStr(d.args[1]));

    str.append("]");

    return str.toString();
  }

  private static String toStringFunctor(Data d) {
    StringBuffer str = new StringBuffer();

    str.append(Data.toStringAtom(d)).append("(");
    str.append(Data.toStr(d.args[0]));
    for (int i = 1; i < d.args.length; i++) {
      str.append(",");
      str.append(Data.toStr(d.args[i]));
    }
    str.append(")");

    return str.toString();
  }
}
