/*--------------------------------------------------------*/
/*   Copyright (C) 1997/98 E.Pontelli, G.Gupta, K.Deopura*/
/*--------------------------------------------------------*/

/*--------------------------------------------------*/
/*                 Headers Inclusion                */
/*--------------------------------------------------*/

/*----------------------------------------*/
/*   CCI: Copyright by NCSA               */
/****     Modified by E. Pontelli (1998)  */
/*----------------------------------------*/


#include <string.h>
#include <sys/utsname.h>
#include "memStuffForPipSqueeks.h"
#include "cci.h"
#include "connect.h"
#include "list.h"


/*--------------------------------------------------*/
/*               Global Variables                   */
/*--------------------------------------------------*/

static int initialized = 0;
static List anchorCBList = 0;
static List outputCBList = 0;
static List browserViewCBList = 0;

extern char *GetLine();

/*--------------------------------------------------*/
/*               Prototypes                         */
/*--------------------------------------------------*/

int MosaicInitialize();
int MosaicIsConnected(MCCIPort);
MCCIPort MosaicConnect(char *,int);
int MosaicDisconnect(MCCIPort);
int MosaicIsThereInput(MCCIPort);
char *MosaicGetResponse(MCCIPort);
int MosaicActivateAnchorTransmission(MCCIPort,int);
int MosaicDeactivateAnchorTransmission(MCCIPort);
int MosaicGet(MCCIPort,char *,int,int,char *);
int MosaicActivateFilter(MCCIPort,char *);
int MosaicDeactivateFilter(MCCIPort,char *);

static char *MosaicHandleAddOutput(MCCIPort,char *);
char *MosaicReadBrowserViewOutput(MCCIPort,char *);
static char *MosaicReadSendDataOutput(MCCIPort);
static int MosaicWrite(MCCIPort,char *,int);

/*--------------------------------------------------*/
/*      Initialization of Interface to Mosaic       */
/*--------------------------------------------------*/

int MosaicInitialize()
{
  initialized = 1;
  return (0);
}


/*----------------------------------------------------*/
/*    Verify connection with Mosaic: 1 connected      */
/*----------------------------------------------------*/

int MosaicIsConnected(Port)
MCCIPort Port;
{
	return(NetIsConnected(Port));
}



/*------------------------------------------------------*/
/*   Connect to a running session of Mosaic             */
/*------------------------------------------------------*/

MCCIPort MosaicConnect(Address,port)
     char *Address;
     int port;
{
  MCCIPort serverPort;
  char *line;

	if (!initialized) {
		MosaicInitialize();
		}

	if (!(serverPort = NetClientConnect(Address,port))) {
		return((MCCIPort) 0);
		}

	line = MosaicGetResponse(serverPort);

	printf("MosaicConnect(): received from server:\n%s",line);

	return(serverPort);
}	


/*------------------------------------------------------*/
/*   Disconnect a running session of Mosaic             */
/*------------------------------------------------------*/

int MosaicDisconnect(Port)
     MCCIPort Port;
{
  char buff[80];
  int length,lengthToSend;
  char *line;

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }
  
  NetCloseConnection(Port);

  return(MCCI_OK);
}



/*------------------------------------------------------*/
/*   Check if there is any input on the Mosaic Port     */
/*------------------------------------------------------*/

int MosaicIsThereInput(Port)
     MCCIPort Port;
{
  int temp;

  if (!Port)
    return(0);
  if (!MosaicIsConnected(Port)) {
    return(0);
  }
  temp  = NetIsThereInput(Port);
  return (temp);
}


/*------------------------------------------------------*/
/*   Obtain a response from a running Mosaic            */
/*------------------------------------------------------*/

char *MosaicGetResponse(Port)
     MCCIPort Port;
{
  char *response;

  if (!MosaicIsConnected(Port)) 
    {
      return("Missing Connection");
    }
  
  response = GetLine(Port);
  if (response) 
    {
/*       while (response[0] == '3')  */
/* 	{ */
	  MosaicHandleAddOutput(Port,response);
/* 	  response = GetLine(Port); */
/* 	} */
    }
  else 
    {
      MosaicDisconnect(Port);
      return("900 Error No response");
    }
  
  return(response);
}



char *MosaicGetInput(Port)
     MCCIPort Port;
{
  char *response;

  if (!MosaicIsConnected(Port)) 
    {
      return("Missing Connection");
    }
  
  response = GetLine(Port);
  if (response) 
    {
      return MosaicHandleAddOutput(Port,response);
    }
  else 
    {
      MosaicDisconnect(Port);
	printf("GetINput FAILED\n");
      return("900 Error No response");
    }
}

/*------------------------------------------------------*/
/*   Handling of Anchors Communication                  */
/*------------------------------------------------------*/

int MosaicActivateAnchorTransmission(Port,Flag)
     MCCIPort Port;
     int Flag;
{
  char buff[80];
  int len1,len2;
  char *line;
  

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }

  if (Flag ==1)
    sprintf(buff,"%s %s %s\r\n",MCCI_S_SEND,MCCI_S_ANCHOR,MCCI_S_BEFORE);
  else if (Flag == 2)
    sprintf(buff,"%s %s %s\r\n",MCCI_S_SEND,MCCI_S_ANCHOR,MCCI_S_AFTER);
  else {
    return (MCCI_FAIL);
  }

  len1 = strlen((char *)buff);
  len2 = MosaicWrite(Port,buff,len1);
  if (len1 != len2)
    return (MCCI_FAIL);

  line = MosaicGetResponse(Port);
  
  printf("SEND ANCHOR Reply: %s\n",line);
  if (!line)
    return (MCCI_NETWORK_ERROR);
  if (line[0] == '2')
    return (MCCI_OK);
  else
    return (MCCI_REQUEST_FAIL);
}


int MosaicDeactivateAnchorTransmission(Port)
     MCCIPort Port;
{
  char buf[80];
  int len1,len2;
  char *line;

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }

  sprintf(buf,"%s %s %s\r\n",MCCI_S_SEND,MCCI_S_ANCHOR,MCCI_S_STOP);
  len1 = strlen(buf);
  len2 = MosaicWrite(Port,buf,len1);
  if (len1 != len2)
    return (MCCI_FAIL);
  
  line = MosaicGetResponse(Port);
  
  /*printf("Anchor Reply %s\n",line);*/

  if (!line) 
    return (MCCI_NETWORK_ERROR);
  if (line[0] == '2')
    return (MCCI_OK);
  else
    return (MCCI_REQUEST_FAIL);
}


/*------------------------------------------------------*/
/*    Force Mosaic to Load a given document             */
/*------------------------------------------------------*/


int MosaicGet(Port,url,output,absRelative,additionalHeader)
     MCCIPort Port;
     char *url; 
     int output;
     int absRelative;
     char *additionalHeader;
{
  char *buff;
  char buff2[80];
  int length,lengthToSend;
  char *line;
  int approxSize;
  
  if (!Port) {
    return(MCCI_FAIL);
  }

  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }

  approxSize = 256;
  if (!url) {
    return(MCCI_FAIL);
  }
  else {
    approxSize += strlen(url);
  }

  if (additionalHeader) {
    approxSize += strlen(additionalHeader);
  }

  if (!(buff = (char *)malloc(approxSize))) {
    return(MCCI_OUTOFMEMORY);
  }

  sprintf(buff,"GET URL <%s>",url);
  
  switch (output) {
  case MCCI_OUTPUT_NONE:	/* do not display */
    strcat(buff," OUTPUT NONE");
    break;
  case MCCI_OUTPUT_NEW:	        /* display in new window */
    strcat(buff," OUTPUT NEW");
    break;
  case MCCI_OUTPUT_CURRENT:	/* display in current window */
  default: 
    strcat(buff," OUTPUT CURRENT");
    break;
  }

  if (additionalHeader) {
    strcat(buff," HEADER\r\n");
    sprintf(buff2,"Content-Length: %d\r\n",
	    strlen(additionalHeader));
    strcat(buff,buff2);
    strcat(buff,additionalHeader);
  }
  else {
    strcat(buff,"\r\n");
  }
  
  lengthToSend = strlen(buff);
  length = MosaicWrite(Port, buff, lengthToSend);
  free(buff);

  if (length != lengthToSend) {
    return(MCCI_FAIL);
  }

  line = MosaicGetResponse(Port);

  /*printf("GET reply: %s\n",line);*/


  if (!line) {
    return(MCCI_NETWORK_ERROR);
  }
  if (line[0]=='2') {
    return(MCCI_OK);
  }
  else {
    return(MCCI_REQUEST_FAIL);
  }
}


/*-------------------------------------------------------*/
/*     Activate A filter for a given MIME Type           */
/*-------------------------------------------------------*/


int MosaicActivateFilter(Port,mimeType)
     MCCIPort Port;
     char *mimeType;
{
  char buff[128];
  int length,lengthToSend;
  char *line;

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }
  sprintf(buff,"%s %s %s TO %s\r\n",
			MCCI_S_SEND,MCCI_S_OUTPUT,
			mimeType, NetReturnAddress(Port));
  
  lengthToSend = strlen(buff);
  length = MosaicWrite(Port,buff,lengthToSend);

  if (length != lengthToSend) {
    return(MCCI_FAIL);
  }
  
  line = MosaicGetResponse(Port);

  /*printf("SEND OUTPUT reply: %s\n",line);*/

  if (!line) {
    return(MCCI_NETWORK_ERROR);
  }
  if (line[0]=='2') {
    return(MCCI_OK);
  }
  else {
    return(MCCI_REQUEST_FAIL);
  }
}


int MosaicDeactivateFilter(Port,mimeType)
     MCCIPort Port;
     char *mimeType;
{
  char buff[128];
  int length,lengthToSend;
  char *line;

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }

  sprintf(buff,"%s %s %s %s %s\r\n",
	  MCCI_S_SEND, MCCI_S_OUTPUT, MCCI_S_STOP,
	  mimeType,NetReturnAddress(Port));

  lengthToSend = strlen(buff);
  length = MosaicWrite(Port, buff, lengthToSend);

  if (length != lengthToSend) {
    return(MCCI_FAIL);
  }
  
  line = MosaicGetResponse(Port);

  /*printf("SEND OUTPUT STOP reply: %s\n",line);*/

  if (!line) {
    return(MCCI_NETWORK_ERROR);
  }
  if (line[0]=='2') {
    return(MCCI_OK);
  }
  else {
    return(MCCI_REQUEST_FAIL);
  }
}


/*-------------------------------------------------------*/
/*     Copy of browser content to routine                */
/*-------------------------------------------------------*/


int MosaicSendBrowserView(Port,mode)
     MCCIPort Port;
     int mode;
{
  char *line;
  char buff[80];
  int lengthToSend;
  int length;

  if (!Port) {
    return(MCCI_FAIL);
  }
  if (!MosaicIsConnected(Port)) {
    return(MCCI_NETWORK_ERROR);
  }


  if (mode) {
    sprintf(buff,"%s %s\r\n",MCCI_S_SEND, MCCI_S_BROWSERVIEW);
  }
  else {
    sprintf(buff,"%s %s %s\r\n",MCCI_S_SEND, MCCI_S_BROWSERVIEW, 
	    MCCI_S_STOP);
  }

  lengthToSend = strlen(buff);
  length = MosaicWrite(Port, buff, lengthToSend);
  if (length != lengthToSend) {
    return(MCCI_FAIL);
  }

  /* get response from browser */
  line = MosaicGetResponse(Port);

  /*printf("SEND BROWSERVIEW reply: %s\n",line);*/
  
  if (!line) {
    return(MCCI_NETWORK_ERROR);
  }
  if (line[0]=='2') {
    return(MCCI_OK);
  }
  else {
    return(MCCI_REQUEST_FAIL);
  }
}




/*----------------------------------------------------------------------*/
/*------------           Lower Level CCI Access           --------------*/
/*----------------------------------------------------------------------*/


/*------------------------------------------------------*/
/*    Handling the Output line received from Mosaic     */
/*------------------------------------------------------*/

static char *MosaicHandleAddOutput(Port,response)
     MCCIPort Port;
     char *response;
{
  char respCode[10];
  char *start,*end;
  static char url[1024];

  if (! response)
	{
		printf("Disconnecting in handle output\n");	
    		MosaicDisconnect(Port);
	}

  if ((!response) || (!MosaicIsConnected(Port))) {
    return;
  }

  /*printf("Entering the Handle with %s\n",response);*/
  
  sprintf(respCode,"%d",MCCIR_ANCHOR_INFO);
  if (!strncmp(respCode,response,3)) 
    {
      /* It's an ANCHOR INFO */
      start = strchr(response,'<');
      end = strchr(response,'>');
      
      start++;
      *end='\0';
      strcpy(url,start);

      /*printf("Received %s\n",url);*/
      return (url);
    }
  
  sprintf(respCode,"%d",MCCIR_SEND_DATA_OUTPUT);
  if (!strncmp(respCode,response,3)) 
    {
      /* It's send output data */
      return MosaicReadSendDataOutput(Port);
    }

  sprintf(respCode,"%d",MCCIR_SEND_BROWSERVIEW);
  if (!strncmp(respCode,response,3)) 
    {
      /* It's send output data */
      return MosaicReadBrowserViewOutput(Port,response);
    }

  sprintf(respCode, "%d", MCCIR_GET_OK);
  if (!strncmp(respCode,response,3)) 
    {
      /* It's a GET OK */
      /*printf("GET reply: %s\n",response);*/
    }

  sprintf(respCode, "%d", MCCIR_GET_FAILED);
  if (!strncmp(respCode,response,3)) 
    {
      /* It's a GET FAILED */
      /*printf("GET reply: %s\n",response);*/
    }
	        
  /* I don't know what this is Additional Output is... */
  return;
}


/*--------------------------------------------------------*/
/*    Handling on/off and filtering all pages from Mosaic */
/*--------------------------------------------------------*/

char *MosaicReadBrowserViewOutput(serverPort,response)
     MCCIPort serverPort;
     char *response;
{
  char *line;
  char *url = (char *) 0;
  char *start,*end,*s,*contentType;
  int contentLength;
  char *data = (char *) 0;
  int numRead;

  s = response;
  s+=4; /* skip over repsonse code */
  GetWordFromString(s,&url,&end);
  if (url && (url != end)) 
    {
      url = strdup(url);
    }
  else 
    {
      url = (char *) 0;
    }
  

  /*printf("MosaicReadBrowserViewOutput(): I've been called\n");*/
  /*printf("MosaicReadBrowserViewOutput(): url = \"%s\"\n",url);*/

  line = GetLine(serverPort);
  if (!line) {
    return NULL;
  }

  /*printf("MosaicReadBrowserViewOutput(): got line:%s\n",line);*/

 contentType = (char *) 0;
 if (!strncasecmp("Content-Type:",line,13)) {
   start = line;
   start += 13;
   GetWordFromString(start,&s,&end);
   *end = '\0';
   contentType = strdup(s);
   
   line = GetLine(serverPort);

   /*printf("MosaicReadBrowserViewOutput(): 2 got line:%s\n",line);*/

   if (!line) {
     return NULL;
   }
 }

 /*printf("MosaicReadBrowserViewOutput(): contentType:%s\n",contentType);*/

 if (!strncasecmp("Content-Length:",line,15)) {
   start = line;
   start += 15;
   GetWordFromString(start,&s,&end);
   contentLength = atoi(s);
   if (contentLength < 1){
     return NULL; /* error */
   }
   if (!(data = (char *) malloc(contentLength))) {
     return NULL; /* error */
   }

   /*printf("MosaicReadBrowserViewOutput(): type=%s,length=%d\n",
			contentType,contentLength);*/

   
   numRead = ReadBuffer(serverPort,data,contentLength);

   /*printf("MosaicReadBrowserViewOutput(): number of bytes read = %d\n",numRead);*/
   return data;
 }
 return NULL;
}





/*------------------------------------------------------*/
/*        Handling the Output sent by Mosaic            */
/*------------------------------------------------------*/

static char *MosaicReadSendDataOutput(serverPort)
     MCCIPort serverPort;
{
  char *line;
  char *start,*end,*s,*contentType;
  int contentLength;
  int numRead;
  char *data = (char *) 0;


  line = GetLine(serverPort);
  if (!line) {
    return;
  }

  /*printf("MosaicReadSendDataOutput(): got line:%s\n",line);*/

  contentType = (char *) 0;
  if (!strncasecmp("Content-Type:",line,13)) 
    {
      start = line;
      start += 13;
      GetWordFromString(start,&s,&end);
      *end = '\0';
      contentType = strdup(s);
      
      line = GetLine(serverPort);
      
      /*printf("MosaicReadSendDataOutput(): 2 got line:%s\n",line);*/
      
      if (!line) {
	return;
      }
    }

  /*printf("MosaicReadSendDataOutput(): contentType:%s\n",contentType);*/

  if (!strncasecmp("Content-Length:",line,15)) 
    {
      start = line;
      start += 15;
      GetWordFromString(start,&s,&end);
      contentLength = atoi(s);
      if (contentLength < 1){
	return; /* error */
      }
      if (!(data = (char *) MALLOC(contentLength))) {
	return; /* error */
      }

      /*printf("MosaicReadSendDataOutput(): type=%s,length=%d\n",
			contentType,contentLength);*/
      
      numRead = ReadBuffer(serverPort,data,contentLength);

      /*printf("MosaicReadSendDataOutput(): number of bytes read = %d\n",numRead);
      printf("MosaicReadSendDataOutput(): returning\n");*/

      return (data);
    }
}



/*------------------------------------------------------*/
/*        Send CCI Request to Mosaic                    */
/*------------------------------------------------------*/

static int MosaicWrite(Port,message,length)
     MCCIPort Port;
     char *message;
     int length;
{
  int writeLength;

  if (!MosaicIsConnected(Port)) {
    return(0);
  }
  
  while(NetIsThereInput(Port)) {
    MosaicGetResponse(Port);
    if (!MosaicIsConnected(Port)) {
      return(0);
    }
  }
  writeLength = NetWrite(Port,message,length);
  
  return(writeLength);
}


/*---------------------------------------------------------------*/
/*                     Auxiliary                                 */
/*---------------------------------------------------------------*/

char *get_machine_name()
{
	struct utsname name;
	char *tmp;

	uname(&name);
	tmp = (char *)malloc(strlen(name.nodename)*sizeof(char));
	strcpy(tmp,name.nodename);
	return tmp;
}

