/************************************************************************
 *									*
 * FILE		:	connect.h					*
 *									*
 * FUNCTION	: 	gethtml(char *netlocation, char *netfile)	*
 *			char *netlocation :- Location of the webpage    *
 *			uses internet addressing scheme			*
 *									*
 *			char *netfile :- Relative path on the remote	*
 *									*
 * PURPOSE	:	This function returns the pointer to the        *
 *			buffer containing the html page specified by    *
 *			netlocation and netfile				*
 *									*
 * AUTHOR	:	Koustubh Deopura				*
 *									*
 * DATE LAST MODIFIED	:	10/12/97				*
 *									*
 * MODIFICATION SUMMARY	:						*
 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/uio.h>
#include <unistd.h>

#define HTTP_PORT	80	/* Default port to connect */

char html[129];		/* Temporary buffer to store contents of page
			   on each read operation */

char *gethtml(char *location, char *netfile){
	
	int sd;		/* sd is a socket */
	int htmlsize, totalsize;
	char *string; 
	char *newlocation; 
	char *protocol, *netlocation;
	char *htmlfile, *htmlptr, *htmlptr1=NULL;
	char *http_message = "GET %s HTTP/1.0\r\n\r\n";
	char *http_new_msg;
	struct sockaddr_in serv_addr;
	struct hostent *hostptr;
	struct in_addr *ptr;

	/* Parse the location: Following strings are accepted

		a.b.c.d
		a.b.c.d/
		a.b.c.d/path/filename
		protocol:a.b.c.d
		protocol:a.b.c.d/
		protocol:a.b.c.d/path/filename
		parse_location(location, protocol, netlocation, netfile);
	*/


	/* Currently, assuming that protocol is only http, later
	   on this variable could be used to decide the kind of 
	   connection desired
	*/

	/* get the IP address in correct form */
	hostptr = gethostbyname(location);
	ptr = (struct in_addr *)*(hostptr->h_addr_list);
	
	/* initialize the data structure */
	bzero((char *)&serv_addr, sizeof(struct sockaddr_in));

	serv_addr.sin_family = PF_INET;
	serv_addr.sin_addr.s_addr = inet_addr(inet_ntoa(*ptr));
	serv_addr.sin_port = htons(HTTP_PORT);

#ifdef _DEBUG
	printf("%s \n", inet_ntoa(*ptr));
#endif

	if((sd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		perror("Failed to open stream socket");

	/* form the get message */
	http_new_msg = (char *)malloc(sizeof(char)*(strlen(http_message) +
                                                    strlen(netfile)+1));
	sprintf(http_new_msg, http_message, netfile);

#ifdef _DEBUG
	printf("%s", http_new_msg);
#endif

	if(connect(sd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
		perror("Unable to connect");

	if(write(sd, http_new_msg, (strlen(http_new_msg)+1)) < 0)
		perror("Write failed");

	free(http_new_msg);

	if((htmlsize=read(sd, html, 128))!=0){
		totalsize = htmlsize;
		htmlptr = (char *)malloc(totalsize*sizeof(char)+1);
		memcpy(htmlptr, html, htmlsize);
		htmlptr[totalsize]='\0';
		while((htmlsize=read(sd, html, 128))!=0){
			totalsize += htmlsize;
			if(htmlptr1 != NULL){
				free(htmlptr);
				htmlptr = htmlptr1;
			}
			htmlptr1 = (char *)malloc(totalsize*sizeof(char)+1);
			strcpy(htmlptr1, htmlptr);
			html[htmlsize]='\0';
			strcat(htmlptr1, (const char *)html);
		}
		if(htmlptr1 == NULL)
			htmlptr1 = htmlptr;
		else
			free(htmlptr);
	}
	else{
		html[htmlsize]='\0';
		htmlptr1=html;
		close(sd);
		return htmlptr1;
	}
	close(sd);
	return htmlptr1;
}
