#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main()
{
  WaitReply(5000);
}


int WaitReply(int iport)
{
  int desc;
  struct sockaddr_in server;

  desc = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
  if (desc < 0)
	printf("ERROR socket creation\n");
  
  memset((void *)&server,sizeof(struct sockaddr_in));
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = iport;
  if (bind(desc,(struct sockaddr *)(&server),sizeof(struct sockaddr_in)) < 0)
	printf("ERROR bind\n");
  
  if (listen(desc, 1024) < 0)
	printf("ERROR listen\n");
  

  while (1)
	{
	  int new_sd;
	  struct sockaddr *sock;
	  char buffer[256];
	  int len,cnt;
	  int bts;
	  char locb[1024];

	  new_sd = accept(desc,(struct sockaddr *)(&sock),&len);
	  if (new_sd < 0)
		printf("ERROR accept\n");
	  
	  bzero(buffer,255);
	  if ( (cnt = read(new_sd,buffer,sizeof(buffer))) < 0)
	    printf("ERROR read\n");

	  printf("Message Received : %s\n", buffer);
	  printf("Ready to answer...\n");

	  if (write(new_sd,"jingle bells",12) < 0)
	    {
	      perror("Write Error: ");
	    }
	  
	  close(new_sd);
	  break;
	}
	  

}


