#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <errno.h>


int main()
{
  WaitReply(5000);
}

char *generate_long_msg()
{
  char *tmp;
  int i;
  char a = '0';

  tmp = (char *)malloc(1025);
  for (i=0; i < 1023; i++)
    {
      tmp[i] = a;
      a = (a == '9')? '0':a+1;
    }

  tmp[1024]='\0';
  
  return tmp;
}

int WaitReply(int iport)
{
  int desc=-1;
  struct sockaddr_in server;
  struct hostent *hp;
  char buffer[256];
  int con=0;
  int bts;
  char *msg;

  memset((void *)&server,sizeof server);
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = iport;
  hp = gethostbyname("pippo");
  if (hp == NULL)
    printf("ERROR gethostbyname\n");
  
  bcopy(hp->h_addr_list[0],&server.sin_addr.s_addr,hp->h_length);
  
      desc = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
      if (desc < 0)
	printf("ERROR socket creation\n");
  do
    {
      con = connect(desc,(struct sockaddr *)(&server),sizeof(server));
    }
  while ((con < 0) && ((errno == ECONNREFUSED) || (con == ETIMEDOUT) || (errno == 22)));

  if (con < 0)
    {
      printf("RETURNED CODE: %d - %d\n",con,errno);
      printf("ERROR connect\n");
      perror("Error Message: ");
      exit(0);
    }

  msg = generate_long_msg();


  printf("Generated Msg of len %d with first char %c and last %c\n",
	 strlen(msg),msg[0],msg[strlen(msg)-1]);
  transmit_msg(desc,msg);

  bts = read(desc,buffer,sizeof(buffer));
  buffer[bts]='\0';
  printf("Got reply %s\n",buffer);

  close(desc);
}


int transmit_msg(int sock, char *msg)
{
  int len;
  int res = strlen(msg) % 256;
  int i;
  int ptr =0;
  char buflen[4];

  len = (res == 0) ? strlen(msg)/256 : strlen(msg)/256 + 1;

	printf("Size of messages %d\n",len);

  sprintf(buflen,"%d",len);
  zerofill(buflen,4);
  printf("Sending the len %d\n",buflen);

  write(sock,buflen,4);
  for (i = 0; i < len ; i++)
    {
      char buffi[257];
      
      strncpy(buffi,&(msg[ptr]),256);
      buffi[256]='\0';
      printf("About to send fragment %s\n",buffi);

      write(sock,&(msg[ptr]),256);
      ptr += 256;
    }
}

int zerofill(char *buf,int len)
{
  int i;
  
  for (i = 0 ; (i < len) && (buf[i] == ' '); i++)
    buf[i]=0;
}
  
