#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <errno.h>


int main()
{
  WaitReply(5000);
}


int WaitReply(int iport)
{
  int desc=-1;
  struct sockaddr_in server;
  struct hostent *hp;
  char buffer[256];
  int con=0;
  int bts;

  memset((void *)&server,sizeof server);
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = iport;
  hp = gethostbyname("ep-lap");
  if (hp == NULL)
    printf("ERROR gethostbyname\n");
  
  bcopy(hp->h_addr_list[0],&server.sin_addr.s_addr,hp->h_length);
  
  do
    {
      if (desc != -1)
	close(desc);

      desc = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
      if (desc < 0)
	printf("ERROR socket creation\n");
      


      con = connect(desc,(struct sockaddr *)(&server),sizeof(server));
    }
  while ((con < 0) && ((errno == ECONNREFUSED) || (con == ETIMEDOUT) || (errno == 22)));

  if (con < 0)
    {
      printf("RETURNED CODE: %d - %d\n",con,errno);
      printf("ERROR connect\n");
      perror("Error Message: ");
      exit(0);
    }

  bzero(buffer,sizeof(buffer));
  
  strcpy(buffer,"Message from client to server");
  
  write(desc,buffer,sizeof(buffer));
	  
  bts = read(desc,buffer,sizeof(buffer));
  buffer[bts]='\0';
  printf("Got reply %s\n",buffer);

  close(desc);
}


