/*****************************************************************************
 * Copyright (c) 1998/99 Enrico Pontelli - Lab. for Logic and Databases
 *                       New Mexico State University
 *
/******************************************************************************
 * Copyright (c) 1996 Netscape Communications. All rights reserved.
 ******************************************************************************/
/*
 * Netscape Client Plugin API
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>
#include <signal.h>

#include "npapi.h"

/*--------------------------------------------------
  State:
  --------------------*/

#define INITIATE       0
#define LISTEN         1
#define COMPILE        2
#define GETURL         3
#define NEWSTREAM      4
#define WRITESTREAM    5
#define READPAGE       6
#define POSTURL        7
#define CLOSESTREAM     8
#define RESET          9 



typedef struct _PluginInstance
{
  int nothing;
  int input_port;
  int output_port;  
  char host[128];
  char url[128];
  char myurl[128];
  char filename[512];
  FILE *dump;
  FILE *temp;
  int State;
  NPStream *stream;
  int target;
  int desc;
  int new_sd;
  int process;
} PluginInstance;

/*----------------------------------------------------*/

char *WaitClient(PluginInstance *,int,char *);

char*
NPP_GetMIMEDescription(void)
{
	return("application/x-webklic:kl1:WEB-KLIC Plug-In");
}

NPError
NPP_GetValue(void *future, NPPVariable variable, void *value)
{
	NPError err = NPERR_NO_ERROR;

	switch (variable) {
		case NPPVpluginNameString:
			*((char **)value) = "WEB-KLIC Plug-In";
			break;
		case NPPVpluginDescriptionString:
			*((char **)value) =
				"This PlugIn is used to handle WEB-KLIC"
				" procedures.";
			break;
		default:
			err = NPERR_GENERIC_ERROR;
	}
	return err;
}

NPError
NPP_Initialize(void)
{
    return NPERR_NO_ERROR;
}

void
NPP_Shutdown(void)
{
}

void *sighand(int c)
{
  fprintf(stderr,"CAPTURED THE SIGNAL\n");
  return;
}


NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
        PluginInstance* This;
		int i;
		char buf[2];

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
		
	signal(SIGUSR1,(void *)sighand);
	signal(SIGUSR2,(void *)sighand);

	instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
	
	This = (PluginInstance*) instance->pdata;

	This->State = INITIATE;

	if (This != NULL)
	  {

		This->dump = fopen("/tmp/dump","w");
		fprintf(This->dump,"%s\n",pluginType);
		fflush(This->dump);

		for (i=0; i < argc; i++)
		  {
			if (!strcmp(argn[i],"SRC"))
			  {
				strcpy(This->url,argv[i]);
				fprintf(This->dump,"URL = %s\n",This->url);
			  }
			if (!strcmp(argn[i],"INPUTPORT"))
			  {
				This->input_port = atoi(argv[i]);
				fprintf(This->dump,"INPUTPORT = %d\n",This->input_port);
			  }
			if (!strcmp(argn[i],"OUTPUTPORT"))
			  This->output_port = atoi(argv[i]);
			if (!strcmp(argn[i],"MYURL"))
			  {
				strcpy(This->myurl,argv[i]);
				fprintf(This->dump,"MYURL=%s\n",argv[i]);
			  }
		  }

		fflush(This->dump);

 		if (NPN_GetURL(instance,This->myurl,NULL)== NPERR_NO_ERROR) 
		  return NPERR_NO_ERROR;
		else 
		  return NPERR_OUT_OF_MEMORY_ERROR;
	  }
	else
		return NPERR_OUT_OF_MEMORY_ERROR;
}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
	PluginInstance* This;

	
	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;
	fprintf(This->dump,"BYYE\n");
	fclose(This->dump);


	kill(This->process,9);

	if (This != NULL) {
		NPN_MemFree(instance->pdata);
		instance->pdata = NULL;
	}

	return NPERR_NO_ERROR;
}





NPError 
NPP_NewStream(NPP instance,
			  NPMIMEType type,
			  NPStream *stream, 
			  NPBool seekable,
			  uint16 *stype)
{
	NPByteRange range;
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	This = (PluginInstance*) instance->pdata;


	fprintf(This->dump,"Attempting the read of a file\n");
	fprintf(This->dump,"TYPE: %s\n",type);
	fprintf(This->dump,"Current value of stype is %d\n",*stype);

	fflush(This->dump);
	(*stype) = NP_ASFILE;

	makefilename(This);
	This->temp = fopen(This->filename,"w");
	fprintf(This->dump,"Writing to file %s\n",This->filename);


	if (This->State == INITIATE)
	  This->State = COMPILE;
	if (This->State == GETURL || This->State == POSTURL)
	  This->State = READPAGE;

	return NPERR_NO_ERROR;
}




int32 STREAMBUFSIZE = 0X0FFFFFFF; 

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
	PluginInstance* This;
	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	
	return STREAMBUFSIZE;
}


int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
  PluginInstance* This;
  char localbuf[4096];
  int i;

  if (instance != NULL)
	{
		  This = (PluginInstance*) instance->pdata;

		  if (This->State == RESET)
			return len;

		  for (i=0; i<len; i++)
			{
			  fprintf(This->dump,"%c",((char*)buffer)[i]);
			  fprintf(This->temp,"%c",((char*)buffer)[i]);
			}
		  fflush(This->temp);
		  fflush(This->dump);
	}
	return len;		/* The number of bytes accepted */
}


NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	PluginInstance* This;
	char command[512];
	int reply;
	int stalecommand;
	char *reccmd;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;
	This = (PluginInstance*) instance->pdata;
	fprintf(This->dump,"Received an end of stream\n");
	fflush(This->dump);

	if (This->State == CLOSESTREAM)
	  {
		This->State = RESET;
		NPN_GetURL(instance,"~/.netscape/cache/local.html",NULL);
	  }

	return NPERR_NO_ERROR;
}


void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
	PluginInstance* This;
	FILE *re;
	char b[256];
	int stalecommand = 1;
	char *reccmd;

	if (instance != NULL)
		This = (PluginInstance*) instance->pdata;

	fflush(This->temp);
	fclose(This->temp);

	fprintf(This->dump,"received the file name %s\n",This->filename);


	if (This->State == RESET)
	  {
		char command[256];
		char *reccmd;
		int cnt,reply;
		char finalcommand[512];

		This->State = LISTEN;
		stalecommand = 1;
		while (stalecommand)
		  {
			reccmd = WaitClient(This,This->input_port,This->host);
			reply = DispatchCommand(instance,reccmd,&stalecommand);
			if (reply == -1)
			  return;

			SendError(This,reply);
		  }
		fprintf(This->dump,"Abandon top loop\n");
		fflush(This->dump);
		sprintf(finalcommand,"/bin/rm %s",This->filename);
		system(finalcommand);
	  }

	else

	if (This->State == READPAGE)
	  {
		int len;
		FILE *f;
		char outbuf[256];
		char command[512];
		int frag,i;
		int reply;

		fprintf(This->dump,"Proceeding in read page mode\n");
		fflush(This->dump);

		if (This->target == 0)
		  {
			f = fopen(This->filename,"r");
			for (len=0; (!feof(f)); len++)
			  fgetc(f);
			fclose(f);
			
			if ((len % 256)==0)
			  frag = len / 256;
			else
			  frag = (len / 256) + 1;
			
			fprintf(This->dump,"Size message is %d\n",frag);
			fprintf(This->dump,"Original total size %d\n",len);
			
			sprintf(outbuf,"%d",frag);
			zerofill(outbuf,4);
			outbuf[4]='\0';
			
			GetAccept(This);
			WriteFragment(This,outbuf,4);
			
			fprintf(This->dump,"Sending message len\n");
			fflush(This->dump);
			
			f = fopen(This->filename,"r");
			i = 0;
			for (len = 0; (!feof(f)); len++)
			  {
				outbuf[i++] = fgetc(f);
				if (i == 256)
				  {
					WriteFragment(This,outbuf,256);
					fprintf(This->dump,"sending fragment \n");
					fflush(This->dump);
					i = 0;
				  }
			  }
			if (i != 0)
			  {
				outbuf[i]='\0';
				WriteFragment(This,outbuf,i-1);
			  }
			
			CloseCommunication(This);

		  }
		else if (This->target == 2)
		  {		
			fprintf(This->dump,"Original total size %d\n",strlen(This->filename));
			fflush(This->dump);
			
			sprintf(outbuf,"%d",1);
			zerofill(outbuf,4);
			outbuf[4]='\0';
			
			GetAccept(This);
			WriteFragment(This,outbuf,4);
			
			fprintf(This->dump,"Sending message len\n");
			fflush(This->dump);
			
			WriteFragment(This,This->filename,256);
			fprintf(This->dump,"sending file path \n");
			fflush(This->dump);
			CloseCommunication(This);

		  }

		This->State = LISTEN;

		stalecommand = 1;


		while (stalecommand)
		  {
			reccmd = WaitClient(This,This->input_port,This->host);
			reply = DispatchCommand(instance,reccmd,&stalecommand);
			if (reply == -1)
			  return;
			SendError(This,reply);
		  }
		fprintf(This->dump,"Abandon the top loop \n");
		fflush(This->dump);
		sprintf(command,"/bin/rm %s",This->filename);
		system(command);
	  }
	else
	if (This->State == COMPILE)
	  {
		char command[256];
		char buffer[256];
		char hst[128];
		FILE *ptr;
		char *reccmd;
		int cnt,reply;
		char stradr[16];
		char finalcommand[512];

		gethostname(This->host,127);
		 
		sprintf(command,
			"cp %s/navigator.kl1 ~/.netscape/cache; \
                         cd ~/.netscape/cache; \
                         %s -g -o ~/.netscape/cache/a.out navigator.kl1 %s; \
                         /bin/rm atom.* funct.* predicates.* klic.db ; \
                         ~/.netscape/cache/a.out %s %d %d &",\
                                NAV,
				KLIC_PATH,
				This->filename,
				This->host,This->input_port,This->output_port);

		/*		sprintf(command,
 				"/home/pippo2/Klic/bin/klic -g -o ~/.netscape/cache/a.out %s; \
				/bin/rm atom.* funct.* predicates.* klic.db",This->filename,This->host,This->input_port,This->output_port);*/

		fprintf(This->dump,"~/.netscape/cache/a.out %s %d %d&",This->host,This->input_port,This->output_port);
		fflush(This->dump);

		fprintf(This->dump,"%s\n",command);
		fflush(This->dump);

		if((ptr = popen(command, "r")) != NULL)
		  {
			/*	while (fgets(buffer,200,ptr) != NULL)
			  fprintf(This->dump,"%s\n",buffer);
			  pclose(ptr);*/
		  }

		/*		re = fopen(This->filename,"r");
				while (!feof(re))
				{
				char c = fgetc(re);
				
				if (!feof(re))
				fprintf(This->dump,"%c",c);
				} */

		fflush(This->dump);

		fprintf(This->dump,"Creating point of contact\n");
		fflush(This->dump);

		CreatePointofContact(This,This->input_port,This->host);

		fprintf(This->dump,"Get accept wait\n");
		fflush(This->dump);

		{
		  int len;
		  struct sockaddr_in sock;
		  
		  This->new_sd = accept(This->desc,(struct sockaddr *)(&sock),&len);
		  if (This->new_sd < 0)
			{
			  fprintf(This->dump,"ERROR accept %d errno = %d\n",This->desc,errno);
			  fprintf(This->dump,"Error: %s\n",sys_errlist[errno]);
			  perror("ACCEPT:");
			  GetAccept(This);
			}
		  else
			fprintf(This->dump,"accept went ok\n");
		  fflush(This->dump);
		}

		if ((cnt=read(This->new_sd,stradr,10)) < 0)
		  {
			fprintf(This->dump,"ERROR DURING READ PID\n");
			fflush(This->dump);
			perror("Error while reading pid: ");
		  }
		stradr[10]='\0';
		This->process = atoi(stradr);
		CloseCommunication(This);
		fprintf(This->dump,"Proc Ide: %d\n",This->process);
		fflush(This->dump);



		This->State = LISTEN;

		while (stalecommand)
		  {
			reccmd = WaitClient(This,This->input_port,This->host);
			reply = DispatchCommand(instance,reccmd,&stalecommand);
			if (reply == -1)
			  return;

			SendError(This,reply);
		  }
		fprintf(This->dump,"Abandon top loop\n");
		fflush(This->dump);
		sprintf(finalcommand,"/bin/rm %s",This->filename);
		system(finalcommand);
	  }

}

int WriteFragment(PluginInstance *This,char *buf, int len)
{
  if (write(This->new_sd,buf,len) < 0)
	{
	  perror("Write Error: ");
	}
}

int zerofill(char *buf,int len)
{
  int i;
  
  for (i = 0 ; (i < len) && (buf[i] == ' '); i++)
    buf[i]=0;
}
  
int GetAccept(PluginInstance *This)
{
  int len;
  struct sockaddr sock;


  This->new_sd = accept(This->desc,(struct sockaddr *)(&sock),&len);
  if (This->new_sd < 0)
	{
	  fprintf(This->dump,"ERROR accept %d errno = %d\n",This->desc,errno);
	  fprintf(This->dump,"Error: %s\n",sys_errlist[errno]);
	  perror("ACCEPT:");
	}
  else
	fprintf(This->dump,"accept went ok\n");
  fflush(This->dump);

}

int CloseCommunication(PluginInstance *This)
{
  close(This->new_sd);
}

int SendError (PluginInstance *This,int error)
{
  char buffer[16];

  bzero(buffer,16);
  sprintf(buffer,"%d",error);
  write(This->new_sd,buffer,strlen(buffer));
  close(This->new_sd);
/*   close(desc); */
}
  

int DispatchCommand(NPP instance, char *command,int *stalecommand)
{
  char *str;
  int status;
  PluginInstance* This;

  if (instance != NULL)
	This = (PluginInstance*) instance->pdata;

  str = index(command,' ');
  str[0] = '\0';
  str = &(str[1]);
  
  fprintf(This->dump,"COmmand: %s\n",command);
  fflush(This->dump);

  if (!strcmp(command,"end_plugin"))
	{
	  fprintf(This->dump,"prepare to kill proc %d\n",This->process);
	  fflush(This->dump);
	  kill(This->process,9);
	  close(This->desc);
	  fclose(This->dump);
	  return -1;
	}
  else
  if (!strcmp(command,"new_stream"))
	{
	  int st;

	  status = NPN_NewStream(instance,"text/html","_blank",&(This->stream));
   	  This->State = LISTEN;
	  fprintf(This->dump,"New stream gives %d\n",status);
	  fflush(This->dump);
	  
	  (*stalecommand)=1;
	}
  else if (!strcmp(command,"write_stream"))
	{
	  status = NPN_Write(instance,This->stream,
					  strlen(str)+2,
					  str);
	  This->State = LISTEN;
	  fprintf(This->dump,"Write Stream gives %d\n",status);
	  fprintf(This->dump,"Attempting to send string %s\n",str);
	  fflush(This->dump);
	  (*stalecommand)=1;
	}
  else if (!strcmp(command,"destroy_stream"))
	{
	  status = NPN_DestroyStream(instance,This->stream,NPRES_DONE);
	  This->State = CLOSESTREAM;
	  fprintf(This->dump,"Destroy stream gives %d\n",status);
	  fflush(This->dump);
	  (*stalecommand) = 0;
	}
  else if (!strcmp(command,"post_url"))
	{
	  char *target;
	  char *url;
	  char cmpstr[5];

	  sprintf(cmpstr," %c ",27);
	  target = index(str,' ');
	  target[0] = '\0';
	  target = &(target[1]);
	  url = strstr(target,cmpstr);
	  url[0] = '\0';
	  url = &(url[3]);

	  fprintf(This->dump,"Post Url with parameter %s\n",str);
	  fflush(This->dump);

	  if (atoi(str) == 0)
		{
		  This->State = POSTURL;
		  This->target = 0;
		  status = NPN_PostURL(instance,target,NULL,strlen(url),url,TRUE);
		  fprintf(This->dump,"Outcome of post is %d\n",status);
		  fflush(This->dump);
		  (*stalecommand) = 0;
		}
	  else
		{
		  fprintf(This->dump,"target = %s\n",target);
		  fprintf(This->dump,"url = %s\n",url);
		  fflush(This->dump);
		  This->State = POSTURL;
		  This->target = 1;
		  status = NPN_PostURL(instance,target,"_blank",strlen(url),url,TRUE);
		  fprintf(This->dump,"Outcome of post is %d\n",status);
		  fflush(This->dump);
		  (*stalecommand) = 1;
		}
	}
  else if (!strcmp(command,"get_url"))
	{
	  char *target;

	  target = index(str,' ');
	  target[0] = '\0';
	  target = &(target[1]);
	  fprintf(This->dump,"GETURL with paramter %s\n",str);
	  fflush(This->dump);

	  if (atoi(str)== 0 || atoi(str) == 2)
		{
		  This->State = GETURL;
		  This->target = atoi(str);
		  status = NPN_GetURL(instance,target,NULL);
		  (*stalecommand) = 0;
		}
	  else
		{
		  This->State = GETURL;
		  This->target = 1;
		  status = NPN_GetURL(instance,target,"_blank");
		  (*stalecommand) = 1;
		}
	}
  return status;
}


int CreatePointofContact(PluginInstance *This,int iport,char *host)
{
  int len,cnt;
  struct sockaddr_in server;
  struct sockaddr *sock;
  char *buffer;
  struct hostent *hp;

  This->desc = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
  if (This->desc < 0)
	{
        printf("ERROR socket creation\n");
		fprintf(This->dump,"Error during socket: %s\n",sys_errlist[errno]);
	}

  memset((void *)&server,0,sizeof(struct sockaddr_in));
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = iport;

  if (bind(This->desc,(struct sockaddr *)(&server),sizeof(struct sockaddr_in)) < 0)
	{
	  fprintf(This->dump,"ERROR bindi: %s\n",sys_errlist[errno]);
	  perror("Error: ");
	  fflush(This->dump);
	  exit(0);
	}

  if (listen(This->desc, 1024) < 0)
	{
	  fprintf(This->dump,"ERROR listen: %s\n",sys_errlist[errno]);
	  perror("Error: ");
	  fflush(This->dump);
	  exit(0);
	}
  fprintf(This->dump,"Successful creation of socket %d\n",This->desc);
  fflush(This->dump);
}

char *WaitClient(PluginInstance *This,int iport,char *host)
{
  int len,cnt;
  struct sockaddr_in server;
  struct sockaddr sock;
  char *buffer;
  char *outmsg;
  struct hostent *hp;
  int i,siz,ptr;

  This->new_sd = accept(This->desc,(struct sockaddr *)(&sock),&len);
  if (This->new_sd < 0)
	printf("ERROR accept\n");
  
  buffer = (char *)malloc(257);
  bzero(buffer,257);

  if ( (cnt = read(This->new_sd,buffer,4)) < 0)
	printf("ERROR read size\n");
  
  buffer[5]='\0';
  
  siz = atoi(buffer);
  fprintf(This->dump,"SIZE of message: %d\n",siz);
  fflush(This->dump);

  ptr = 0;
  outmsg = (char *)malloc(256*siz);

  if (outmsg == NULL)
	{
	  fprintf(This->dump,"malloc failed: %s\n",sys_errlist[errno]);
	  fflush(This->dump);
	}

  for (i=0; i<siz; i++)
	{
	  fprintf(This->dump,"waiting to read\n");
	  fflush(This->dump);
	  if ((cnt = read(This->new_sd,buffer,256)) < 0)
		{
		  fprintf(This->dump,"ERROR read fragment %d\n",i);
		  fflush(This->dump);
		}
	  buffer[cnt]='\0';
	  strncpy(&(outmsg[ptr]),buffer,256);
	  ptr=ptr+256;
	  fprintf(This->dump,"Message Received : %s\n", buffer);
	  fflush(This->dump);
	}
  return outmsg;
}


void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
	if(printInfo == NULL)
		return;

	if (instance != NULL) {
		PluginInstance* This = (PluginInstance*) instance->pdata;
	
		if (printInfo->mode == NP_FULL) {
			void* platformPrint =
				printInfo->print.fullPrint.platformPrint;
			NPBool printOne =
				printInfo->print.fullPrint.printOne;
			
			/* Do the default*/
			printInfo->print.fullPrint.pluginPrinted = FALSE;
		}
		else {	/* If not fullscreen, we must be embedded */

			NPWindow* printWindow =
				&(printInfo->print.embedPrint.window);
			void* platformPrint =
				printInfo->print.embedPrint.platformPrint;
		}
	}
}


/*------------------------------------------------------------*/


jref
NPP_GetJavaClass()
{
    return NULL;
}



NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
	PluginInstance* This;

	if (instance == NULL)
		return NPERR_INVALID_INSTANCE_ERROR;

	if (window == NULL)
		return NPERR_NO_ERROR;

	This = (PluginInstance*) instance->pdata;

	return NPERR_NO_ERROR;
}


/*----------------------------------------------------------------*/

int makefilename(PluginInstance *This)
{
  char prefix[256];
  char *fln;

  sprintf(prefix,"%s/.netscape/cache/",getenv("HOME"));
  fln = tempnam(prefix,"file");
  sprintf(This->filename,"%s.kl1",fln);
  free(fln);
}

