(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Variables`",{"Types`"}];

Off[General::"spell"];



Var::usage="Var[expr] picks out the free variables of expr." ;

IsVar::usage=
  "IsVar[expr] yields True is expr is a CFLP variable, and yields False \
otherwise.";

IsHiVar::usage=
  "IsHiVar[term] yields True is a higher order variable, and yields False \
otherwise.";

SetHiVar::usage=
  "SetHiVar[symb] declares the symbol `symb` as higher order variable.";

SetVariables::usage=
  "SetVariables[list] sets the list of attributes of the symbols of list to \
{Temporary}." ;

ClearVariables::usage=
  "ClearVariables[list] sets the list of attributes of the symbols of list to \
{}." ;

NewX::usage="NewX[ ] returns a new Temporary symbol of the form x$nnn" ;

NewY::usage="NewY[ ] returns a new Temporary symbol of the form y$nnn" ;

NewC::usage="NewC[ ] returns a new Temporary symbol of the form c$nnn" ;

KeepVarTypes::usage=
  "KeepVarTypes is a valid option for the function ClearVariables that \
specifies whether the types associated to variables should be removed or \
not.";









NewX:=Function[Module[{x},x]];
NewY:=Function[Module[{y},y]];
NewC:=Function[Module[{z},z]];



Begin["`Private`"];

PrependTo[$ContextPath,"TypeSyntax`"];







IsHiVar[_]:=False;







SetHiVar[x_]:=(IsHiVar[x]=True;x);







IsVar[x_] :=
	If[Head[x] === Symbol,
		Attributes[x] === {Temporary}, 
		False];







Clear[Var];
Var[term_Function]:=
  Complement[Var[term\[LeftDoubleBracket]2\[RightDoubleBracket]],
    term\[LeftDoubleBracket]1\[RightDoubleBracket]];
Var[x_?IsVar]:={x};
Var[x_?AtomQ]:={};
Var[f_[args___]]:=Apply[Union,Append[Var /@ {args},Var[f]]];









Clear[SetVariables];
SetVariables[l_List]:=Join@@ SetVariables /@ l;
SetVariables[v_Symbol]:=
	Block[{},
		Attributes[v]={Temporary};
		{v}];
SetVariables[f_[v_,\[Tau]_]]/;(f===Pattern):=
	Block[{},
		Attributes[v]={Temporary};
		If[!IsTyped[v],
			Type[v]=FormTypeExpr[{},\[Tau]//.{ShortRightArrow\[Rule]FuncType}]];
		{v}];











Clear[ClearVariables];
Options[ClearVariables]:={KeepVarTypes\[Rule]False};
ClearVariables[v_Symbol,b_Symbol]:=
	If[IsVar[v],
		If[!b,EraseType[v]];
		Attributes[v]={};{v},
		{}];
ClearVariables[e_Pattern,b_Symbol]:=
	Block[{v=Head[e]},
		If[IsVar[v],
			If[!b,EraseType[v]];
			Attributes[v]={};{v},
			{}]
	];
ClearVariables[v_List,opts___Rule]:=
  Join @@ Map[
      ClearVariables[#,KeepVarTypes/.{opts}/.Options[ClearVariables]]&,v];
ClearVariables[v_,opts___Rule]:=
	ClearVariables[v,KeepVarTypes/.{opts}/.Options[ClearVariables]];



End[];

On[General::"spell"];

EndPackage[];











































