(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Types`",{"TypeSyntax`"}];



Arity::usage="";

NewTyVar::usage="NewTyVar[] creates a fresh type variable.";

TypeConstructor::usage=
  "TypeConstructor[constr1, constr2, \[Ellipsis] ] declares the symbols \
constr1, constr2, \[Ellipsis] as type constructors.";

\!\(\(FormTypeExpr::usage = 
    \*"\"\<FormTypeExpr[type-vars, type] yields the encoding of the \
polymorphic type \!\(\[ForAll] \_\(type - vars\)\) type.\>\""; \)\)

DeclareType::usage=
  "DeclareType[symb,type] assigns the encoding of the polymorphic type \
specified by type to the value of Type[symb], and yields the list {symb}." ;

EraseType::usage=
  "EraseType[symbol1, symbol2, \[Ellipsis] ] clears types for the symboli.";

TyVars::usage=
  "TyVars[type] picks out all type variables of type, i.e. all symbols which \
are not type constructors" ;

DefaultExternal::usage
    "DefaultExternal[] sets the default signatures of external symbols.";

IsTyped::usage=
  "IsTyped[symb] yields True if symb is a typed operator or a typed variable, \
and yields False otherwise." ;

IsFunType::usage=
  "IsFunType[type] yields True if type is a function type, and yields False \
otherwise." ;

IsFunOnCPType::usage=
  "IsFunOnCPType[type] yields True if type is a function type defined on a \
Cartesian product, and yields False otherwise." ;

Bool::usage=
  "Bool denotes the type of booleans with the constants True and False.";

Int::usage="Int denotes the type of integers.";

Rat::usage="Rat denotes the type of rational numbers.";

Float::usage="Float denotes the type of real numbers.";

Compl::usage="Compl denotes the Complex type.";

Symb::usage="Symb is the CFLP type of an undeclared symbol.";

Strings::usage="Strings is the CFLP type of a Mathematica string.";

\[EmptySquare]::usage="\[EmptySquare] denotes the void type." ;

\[WatchIcon]::usage=
  "\[WatchIcon] forces the scheduler to start processing the constraints \
collected so far." ;

TYPE::usage="TYPE is the type of type constructors." ;

RULE::usage="RULE is the type of CFLP rewrite rules." ;

GetType::usage=
  "GetType[s] returns the type of `s`. `s` is defined for Mathematica atoms." \
;

DefaultTypes::usage=
  "DefaultTypes[] sets the default types for the CFLP literals.";

ShortRightArrow::usage;

Type::usage=
  "Type[symb][ ] yields a valid type instance of the type of symbol symb." ;

TypeCheck::usage=
  "TypeCheck is an option to TSolve. With TypeCheck->True, type checking is \
imposed on the specified CRRs of a Def or TSolve call, and on the goal of a \
TSolve call. With TypeCheck->False, the decision to perform type checking is \
determined by the default option of TSolve.";





Begin["`Private`"];





















Clear[External];

External[p_[f_,\[Tau]_]]/;(p===Pattern):=
	Block[{\[Tau]1},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		IsExternal[f]=True;
		DeclareType[{f,\[Tau]//.{ShortRightArrow\[Rule]FuncType}}/.{
          List\[Rule]Pattern}];
		If[IsFunType[\[Tau]],
			\[Tau]1=\[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket];
			If[\[Tau]1===\[EmptySquare],
				Arity[f]=0,
				Arity[f]=If[Head[\[Tau]1]===Cross,Length[\[Tau]1],1]
			],
			Arity[f]=0
		];{f}
	];

External[\[Tau]1_\[ShortRightArrow]\[Tau]2_]:=
	Block[{f=Head[\[Tau]1]},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		Arity[f]=Length[\[Tau]1/.{f[\[EmptySquare]]:>f[]}];
		IsExternal[f]=True;
		If[Arity[f]\[LessEqual]1,
				DeclareType[ {f,
              FuncType[(\[Tau]1/.{f[]:>f[\[EmptySquare]]})
                    \[LeftDoubleBracket]1\[RightDoubleBracket],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List\[Rule]Pattern}],
				DeclareType[ {f,FuncType[Apply[Cross ,\[Tau]1],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List\[Rule]Pattern}]
		];
		{f}
	];

External[e_]/;Head[e]=!=Pattern:={};
External[es___]:=Join @@ External /@ {es};







DefaultExternal[]:=
	External[
		\[WatchIcon]:Bool,
		Plus:Compl\[Cross]Compl\[ShortRightArrow]Compl,
		Times:Compl\[Cross]Compl\[ShortRightArrow]Compl,
		Power:Compl\[Cross]Compl\[ShortRightArrow]Compl,
		Sin:Compl\[ShortRightArrow]Compl,
		Cos:Compl\[ShortRightArrow]Compl,
		 Tan:Compl\[ShortRightArrow]Compl,
		And:Bool\[Cross]Bool\[ShortRightArrow]Bool,
		Or:Bool\[Cross]Bool\[ShortRightArrow]Bool,
		Greater:Float\[Cross]Float\[ShortRightArrow]Bool,
		GreaterEqual:Float\[Cross]Float\[ShortRightArrow]Bool,
		Less:Float\[Cross]Float\[ShortRightArrow]Bool,
		LessEqual:Float\[Cross]Float\[ShortRightArrow]Bool,
		Pi:Float,
		Not:Bool\[ShortRightArrow]Bool];









NewTyVar := Function[Module[{Global`\[Alpha]},Global`\[Alpha]]];







Clear[DefaultTypes];
DefaultTypes[]:=(
		Type[_Symbol][]={{},Symb};
		Type[_Integer][]={{},Int};
		Type[_Complex][]={{},Compl};
		Type[_Rational][]={{},Rat};
		Type[_Real][]={{},Float};
		Type[_String][]={{},Strings}
	);







Clear[GetType];
GetType[s_]:=Last[Type[s][]];







Clear[TypeConstructor];
TypeConstructor[c_Symbol]:=
	Block[{},
		IsTypeConstructor[c]=True;
		IsConstructor[c]=True;{c}
	];
TypeConstructor[_]:={};
TypeConstructor[cs__Symbol]:=Join @@ TypeConstructor /@ {cs};







Clear[IsTyped];
IsTyped[x_] := Type[x]\[LeftDoubleBracket]0\[RightDoubleBracket]=!=Type;







TyVars[\[Tau]_]:=
  Union [Cases[{\[Tau]},_Symbol?(Not[IsTypeConstructor[#]]&),-1]];









FormTypeExpr[type\[Dash]vars_List,\[Tau]_]:=
	Function[{},
		Module[type\[Dash]vars,{type\[Dash]vars,\[Tau]}]
	];







Clear[DeclareType];
DeclareType[e_Pattern]:=
	Block[{f=e\[LeftDoubleBracket]1\[RightDoubleBracket],
      \[Tau]=e\[LeftDoubleBracket]2\[RightDoubleBracket]},
		If[IsTyped[f],Print["Type of ", f, " already defined"],
			Type[f]=FormTypeExpr[TyVars[\[Tau]],\[Tau]]];{f}
	];
DeclareType[fs___Pattern]:=Join @@ DeclareType /@ {fs};
DeclareType[fs___]:=(Print["Warning: DeclareType: wrong syntax call"];{});







EraseType[x_Symbol]:=If[IsTyped[x],Type[x]=.];
EraseType[e_Pattern] :=
	Block[{x=e\[LeftDoubleBracket]1\[RightDoubleBracket]},
		If[(Head[x]===Symbol)\[And]IsTyped[x],
		Type[x]=.]
	];
EraseType[xs___] :=Scan[EraseType,{xs}];







IsTypeConstructor[
    Bool|Int|Rat|Float|Compl|Symb|Strings|\[EmptySquare]|TyList|FuncType|
      Cross|TYPE|RULE]:=True;
IsTypeConstructor[_]:=False;







IsFunType[\[Tau]_FuncType|\[Tau]_ShortRightArrow]:=True;
IsFunType[_]:=False;







IsFunOnCPType[\[Tau]_]:= 
  And[IsFunType[\[Tau]],
    \[Tau]\[LeftDoubleBracket]1,0\[RightDoubleBracket]===Cross];



End[];

EndPackage[];

















