(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Terms`",
	{"TermSyntax`","Variables`","Types`","RewriteRules`"}];



$FunctionSymbol::usage=
  "$FunctionSymbol gives the current list of declared function symbols.";

Constructor::usage=
  "Constructor[type\[Dash]expression \[Ellipsis] ] declares as constructors \
the type\[Dash]annotated symbols given as arguments, which were not declared \
before. Also, the specified type is associated with them.";

DefaultConstructor::usage
    "DefaultConstructor[] sets the default constructor type signatures.";

DefinedSymbol::usage= 
  "DefinedSymbol[type\[Dash]expression \[Ellipsis] ] declares as defined \
symbols the type\[Dash]annotated symbols given as arguments, which were not \
declared before. Also, the specified type is associated to them.";

ClearSignature::usage=
  "ClearSignature[ symb\[Dash]1, symb\[Dash]2, \[Ellipsis] ] undoes all the \
operations performed for symb\[Dash]i by a previous Constructor, External, or \
DefinedSymbol command.";

ResetSignature::usage=
  "ResetSignature[ ] resets the values of Type, Arity, IsDefinedSymbol, \
IsExternal, IsConstructor and $FunctionSymbol to the defaults.";

DefineSignature::usage=
  "DefineSignature[ ] sets the values of Type, Arity, IsDefinedSymbol, \
IsExternal, IsConstructor and $FunctionSymbol to the defaults.";

IsConstructorTerm::usage=
  "IsConstructorTerm[term] yields True if term is a term of the form c or \
c[term1, term2, \[Ellipsis]] where c is a constructor, and False otherwise.";

IsNotFlex::usage=
  "IsNotFlex[term] yields False if term is a variable or a term of the form \
X[term1, term2, \[Ellipsis]] where X is a variable, and True otherwise.";

IsFunctionTerm::usage=
  "IsFunctionTerm[term] yields True if term is a defined function symbol or a \
term
		of the form f[ term1, term2, \[Ellipsis] ] where f is a defined function \
symbol, and False otherwise .";

TypedVars::usage="";





Begin["`Private`"];

PrependTo[$ContextPath,"TypeSyntax`"];





















Clear[Constructor];

Constructor[p_[f_,\[Tau]_]]/;(p===Pattern):=
	Block[{\[Tau]1},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		IsConstructor[f]=True;
		DeclareType[{f,\[Tau]//.{ShortRightArrow\[Rule]FuncType}}/.{
          List\[Rule]Pattern}];
		If[IsFunType[\[Tau]],
			\[Tau]1=\[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket];
			If[\[Tau]1===\[EmptySquare],
				Arity[f]=0,
				Arity[f]=If[Head[\[Tau]1]===Cross,Length[\[Tau]1],1]
			],
			Arity[f]=0
		];{f}
	];

Constructor[\[Tau]1_\[ShortRightArrow]\[Tau]2_]:=
	Block[{f=Head[\[Tau]1]},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		Arity[f]=Length[\[Tau]1/.{f[\[EmptySquare]]:>f[]}];
		IsConstructor[f]=True;
		If[Arity[f]\[LessEqual]1,
				DeclareType[ {f,
              FuncType[(\[Tau]1/.{f[]:>f[\[EmptySquare]]})
                    \[LeftDoubleBracket]1\[RightDoubleBracket],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List->Pattern}],
				DeclareType[ {f,FuncType[Apply[Cross ,\[Tau]1],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List->Pattern}]
		];
		{f}
	];

Constructor[f_]:=
	If[Head[f]=!=Symbol\[Or]IsDeclared[f],
		{},
		IsConstructor[f]=True;
		Type[f]=FormTypeExpr[{},NewTyVar[]];{f}
	];
Constructor[es___]:=Join @@ Constructor /@ {es};







Clear[DefaultConstructor];
DefaultConstructor[]:=
	Block[{},
		IsConstructor[c_?AtomQ]/;(
          c\[LeftDoubleBracket]0\[RightDoubleBracket]=!=Symbol)=True;
		Constructor[
			TYPE,
			Function,
			Bool:TYPE,
		  String:TYPE,
		  Int:TYPE,
		  Float:TYPE,
		  Rat:TYPE,
		  Compl:TYPE,
		  Symb:TYPE,
		  \[EmptySquare]:TYPE,
		  TyList:TYPE,
		  FuncType:TYPE,
			Cross:TYPE,
			False:Bool,
			True:Bool,
		  \[Bullet]:TyList[Global`\[Alpha]],
			Cons:FuncType[Global`\[Alpha]\[Cross]TyList[Global`\[Alpha]],
          TyList[Global`\[Alpha]]],
			RewriteRule:
        FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha]\[Cross]Bool,RULE],
			eq:FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha],Bool]]
	];















Clear[DefinedSymbol];

DefinedSymbol[p_[f_,\[Tau]_]]/;(p===Pattern):=
	Block[{\[Tau]1},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		IsDefinedSymbol[f]=True;
		DeclareType[{f,\[Tau]//.{ShortRightArrow\[Rule]FuncType}}/.{
          List\[Rule]Pattern}];
		If[IsFunType[\[Tau]],
			\[Tau]1=\[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket];
			If[\[Tau]1===\[EmptySquare],
				Arity[f]=0,
				Arity[f]=If[Head[\[Tau]1]===Cross,Length[\[Tau]1],1]
			],
			Arity[f]=0
		];{f}
	];

DefinedSymbol[\[Tau]1_\[ShortRightArrow]\[Tau]2_]:=
	Block[{f=Head[\[Tau]1]},
		If[Head[f]=!=Symbol\[Or]IsDeclared[f],Return[{}]];
		Arity[f]=Length[\[Tau]1/.{f[\[EmptySquare]]:>f[]}];
		IsDefinedSymbol[f]=True;
		If[Arity[f]\[LessEqual]1,
				DeclareType[ {f,
              FuncType[(\[Tau]1/.{f[]:>f[\[EmptySquare]]})
                    \[LeftDoubleBracket]1\[RightDoubleBracket],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List\[Rule]Pattern}],
				DeclareType[ {f,FuncType[Apply[Cross ,\[Tau]1],\[Tau]2]}//.{
              ShortRightArrow\[Rule]FuncType}/.{List->Pattern}]
		];{f}
	];

DefinedSymbol[f_]:=
	If[Head[f]=!=Symbol\[Or]IsDeclared[f],
		{},
		IsDefinedSymbol[f]=True;
		Type[f]=FormTypeExpr[{},NewTyVar[]];{f}
	];

DefinedSymbol[es___]:=Join @@ DefinedSymbol /@ {es};







DefineSignature[]:=
	($FunctionSymbol={};
		DefaultTypes[];
		DefaultExternal[];
		DefaultConstructor[];
		Arity[_Integer|_Real|_Complex|_Rational|_String]:=0
	);







ResetSignature[]:=
	(Clear[IsDefinedSymbol,IsConstructor,IsExternal,Type,Arity];
		DefineSignature[]);







Clear[ClearSignature];
ClearSignature[f_Symbol]:=
	If[IsExternal[f],
		DPrint[1,"Unable to clear signature of external symbol"],
		IsDefinedSymbol[f]=False;
		IsConstructor[f]=False;
		If[Head[Type[f]]=!=Type,Type[f]=.;Arity[f]=.];
		RewriteRuleList[f]={};
		$FunctionSymbol=$FunctionSymbol/.f->Sequence[];
		{f}
	];
ClearSignature[fs___Symbol]:=Join @@ ClearSignature /@ {fs} ;









Clear[NotFlex];
IsNotFlex[x_?IsVar]:=False;
IsNotFlex[x_?IsVar[___]]:=False;
IsNotFlex[_]:=True;







IsConstructorTerm[(_?IsConstructor)[___]|_?IsConstructor]:=True;
IsConstructorTerm[_]:=False;







IsFunctionTerm[(_?IsDefinedSymbol)[___]
|_?IsDefinedSymbol]:=True;
IsFunctionTerm[_]:=False;



End[];

DefineSignature[];

EndPackage[];

