(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["StartSolvers`"];



Link5000::usage="Link5000 yields an opened link to local port 5000.";

Start::usage="Start[] initializes the constraint solvers for CFLP.";

$NumberOfSchedulers::usage=
  "$NumberOfSchedulers yields the current numer of running constraint \
schedulers. It has the initial value 0 and is incremented each time when the \
function Config`MakeLinks[] is (successfully) invoked.";





Off[LinkOpen::"linkf",LinkConnect::"linkc"];

Begin["`Private`"];









$NumberOfSchedulers:=0;







NumberOfInstances["Linear"]:=1;
NumberOfInstances["Polynomial"]:=2;
NumberOfInstances["Derivative"]:=2;
NumberOfInstances["PartialDerivative"]:=0;









ProcessQueries[]:=
	Block[{res,newLinks,tmpLnks,crtLnk,crtMeth,crtLnks},
		While[True,
			If[LinkReadyQ[Link5000],
				res=LinkRead[Link5000];
				Print[res];
				If[res===$Failed,
					tmpLnks=LinkCreate[];
					Link5000=LinkCreate["5000",LinkProtocol->"TCP"];
					LinkClose[tmpLnks];
					Continue[]
				];
				If[res==="exit",Break[]];
				If[res==="ignore",
					$NumberOfSchedulers--;
					res="close"
				];
				If[res==="ask",
					{crtMeth,crtLnks}=First[LocalSolvers];
					tmpLnks=Rest[LocalSolvers];
					LinkWrite[Link5000,++$NumberOfSchedulers];
					Continue[]
				];
				If[res==="askmore",
					While[True,
						If[crtLnks==={},
							If[tmpLnks==={},
								LinkWrite[Link5000,"stop"];
								Break[],
								{crtMeth,crtLnks}=First[tmpLnks];
								tmpLnks=Rest[tmpLnks]
							],
							crtLnk=First[crtLnks];
							crtLnks=Rest[crtLnks];
							LinkWrite[crtLnk,Unevaluated[LinkCreate[]]];
							While[Not[LinkReadyQ[crtLnk]],Continue[]];
							res=LinkRead[crtLnk];
							LinkWrite[Link5000,{crtMeth,res}];
							Break[]
						]
					];
					Continue[]
				];
				If[res==="close",
					LinkClose[Link5000];
					Link5000=LinkCreate["5000",LinkProtocol->"TCP"]
				]
			]
		];
		Map[LinkWrite[#,Unevaluated[Exit[]]]&,
			Complement[Links[],{$ParentLink,Link5000}]];
		Exit[]
	];









Start[]:=
	If[(Link5000=LinkCreate["5000",LinkProtocol->"TCP"])===$Failed,
		Print["Solvers were already started."];
		Exit[],
		LocalSolvers=
			Block[{i},
				Print["Starting solvers ..."];
				Map[{#,Table[
							LinkLaunch[StringJoin[
									"math -mathlink -initfile ",
									#<>".m",
									" -run Loop[] -batchoutput"]],{i,NumberOfInstances[#]}]}&,
					SolveMethods]
			];
		ProcessQueries[]
	];





SolveMethods={"Linear","Polynomial","Derivative","PartialDerivative"};



End[];

EndPackage[];

