(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["SchedulerInterface`",{"Debug`"}];



Stop::usage="";

StartCFLP::usage=
  "StartCFLP[ ] creates the Mathlink connections needed for a CFLP session.";

CSEnd::usage="CSEnd[ ] closes the Mathlink connections of the CFLP session.";

SetCSType::usage=
  "SetCSType[tyVals] defines the `Type` function to the constraint scheduler \
such that it coincides with the `Type` function of the constraint \
interpreter.";

GetCSConnections::usage=
  "GetCSConnections[] prints the connections established between constraint \
scheduler and constraint solvers.";

SendCSQuery::usage=
  "SendCSQuery[ msg ] sends the message msg to the constraint scheduler";

CSSchedule::usage=
  "CSSchedule[] is the actual call to the constraint scheduler.";

QueryForResources::usage;
ResetLocalResources::usage;
ResetRemoteResources::usage;

Query::usage="Query[id] ";



Begin["`Private`"];





CSEnd[ ]:=
	(NotebookClose[$CFLPsyntax];
		CloseCFLPTraceWindow[];
		CloseCSTraceWindow[];
		If[MemberQ[Links[],CSlink],
			SendCSQuery[{"End"}];
			Print["done."],
			Print["link already disabled."]]); 





GetCSConnections[]:=
	If[CSlink==={},
			Print["Warning: connection to scheduler is dead."],
		Scan[GetMethConnections,
			{"Linear","Polynomial","Derivative","PartialDerivative"}]];





GetMethConnections[meth_]:=
	Print[meth," connections:",SendCSQuery[{"GetLinks",meth}]];



Query[_]:={};













SendCSQuery[{"End"}]:=
	Block[{},
		LinkWrite[CSlink,{"End"}];
		LinkClose[CSlink];
		CSlink={}
	];







SendCSQuery[{"GetResults",id_Integer}]:=
	Block[{resultCS="",returnedResult},
		If[CSlink==={},
			Print["Warning: connection to scheduler is dead."];Return[{}]];
		LinkWrite[CSlink,{"GetResults",id}];
		While[True,
			If[Not[LinkReadyQ[CSlink]],Continue[]];
			resultCS=LinkRead[CSlink];
			Switch[Head[resultCS],
				String,Break[],
				List,CSPrint[1,Sequence @@ resultCS],
				_,(* process the computed answer returned by the scheduler *)
				returnedResult=ProcessResults[Rest[List @@ resultCS]];
				(* Print["returnedResult=",returnedResult]; *)
				AppendTo[Query[First[resultCS]],returnedResult]
			]
		];
		(* Print["GetResults got:",resultCS]; *)
		resultCS
	];







SendCSQuery[{"Confirm"}]:=
	Block[{res},
		If[CSlink==={},
			Print["Warning: connection to scheduler is dead."];Return["."]];
		LinkWrite[CSlink,{"Confirm"}];
		While[True,
			If[Not[LinkReadyQ[CSlink]],Continue[]];
			If[LinkRead[CSlink]==="Confirmed",
				Print["done."];
				Break[]
			]
		]
	];







SendCSQuery[{"GetLinks",meth_}]:=
	Block[{res},
		If[CSlink==={},
			Print["Warning: connection to scheduler is dead."];Return["."]];
		LinkWrite[CSlink,{"GetLinks",meth}];
		While[True,
			If[Not[LinkReadyQ[CSlink]],Continue[]];
			res=LinkRead[CSlink];
			Break[]
		];
		res
	];



SendCSQuery[msg_]:=
	Block[{resultCS,processedResults},
		If[CSlink==={},
			Print["connection to scheduler is dead."];
			Return["dead."],
			LinkWrite[CSlink,msg];
			LinkFlush[CSlink];
			While[True,
				If[LinkReadyQ[CSlink],
					resultCS=LinkRead[CSlink];
					Switch[Head[resultCS],
						String,Break[],
						List,CSPrint[1,Sequence @@ resultCS],
						_,
						processedResults=ProcessResults[Rest[List @@ resultCS]];
						AppendTo[Query[First[resultCS]],processedResults]
					]
				]
			]
		];
		resultCS
	];







StartCFLP[ ]:=
	If[MemberQ[Links[],CSlink],
		Print["connection to scheduler is already available."],
		Print["connecting\[Ellipsis]"];
		OpenCSTraceWindow[WindowTitle\[Rule]"Scheduler Trace"];
		OpenCFLPTraceWindow[WindowTitle\[Rule]"CFLP Trace"];
		SetPanel[];
		If[Head[$CFLPsyntax]=!=NotebookObject\[Or]
				NotebookInformation[$CFLPsyntax]===$Failed,
			$CFLPsyntax=NotebookOpen[Global`$cflpSrcDirectory<>"CFLPsyntax.nb"]
		]; 
		CSlink=LinkLaunch[
        "math -mathlink -initfile Scheduler.m -run Schedule[] -batchoutput"];
		SendCSQuery[{"Confirm"}]
	];











ProcessResults[{v_,\[Sigma]_,eqs_List}]:=
	Prepend[
		ReplaceAll[
		{Inner[Rule,v,v//.\[Sigma],List],eqs},
		{DelayMark[x_]:>x,(Rule|RuleDelayed)[x_,x_]:>Sequence[]}],v];







QueryForResources[]:=
	Block[{resourceCell},
		CSLaunchNotebookCFLP=
      NotebookOpen[Global`$cflpSrcDirectory<>"CSLaunch.nb",Visible->False];
	NotebookLocate[{Global`$cflpSrcDirectory<>"CSLaunch.nb","resources"}];
		resourceCell=NotebookRead[CSLaunchNotebookCFLP]/.
				{Rule[InitializationCell,True]->Rule[InitializationCell,False],
					"Input"->"Text"};
		UserNotebookCFLP=NotebookOpen[Global`$cflpSrcDirectory<>"UserPanel1.nb"];
		NotebookLocate[{Global`$cflpSrcDirectory<>"UserPanel1.nb","resources"}];
		numberOfResources=Length[ListOfValues=Cases[resourceCell,"=",\[Infinity]]];
		NotebookWrite[UserNotebookCFLP,resourceCell]
	];







ResetLocalResources[]:=
	Block[{w,ListOfValues},
		NotebookLocate[{Global`$cflpSrcDirectory<>"UserPanel1.nb","resources"}];
		resourceCell=NotebookRead[UserNotebookCFLP]/.
				{Rule[InitializationCell,False]->Rule[InitializationCell,True],
				"Text"->"Input"};
		(* perform a superficial correctness check *)
		ListOfValues=Cases[resourceCell,List[_,"=",w_]:>w,\[Infinity]];
		If[And[
				Length[ListOfValues]==numberOfResources,
				Complement[ListOfValues,
					{"0","1","2","3","4","5","6","7","8","9","10","11","12"}]==={}],
			NotebookWrite[CSLaunchNotebookCFLP,resourceCell];
			NotebookSave[CSLaunchNotebookCFLP];
			RenameFile[$cflpSrcDirectory<>"CSLaunch.m",$cflpPkgDirectory<>
          "CSLaunch.m"]
		];
		NotebookLocate[{Global`$cflpSrcDirectory<>"CSLaunch.nb","remote"}];
		NotebookClose[UserNotebookCFLP];
		resourceCell=NotebookRead[CSLaunchNotebookCFLP]/.
				{Rule[InitializationCell,True]->Rule[InitializationCell,False],
					"Input"->"Text"};
		UserNotebookCFLP=NotebookOpen[Global`$cflpSrcDirectory<>"UserPanel2.nb"];
		SetSelectedNotebook[UserNotebookCFLP];
		NotebookLocate[{Global`$cflpSrcDirectory<>"UserPanel2.nb","remote"}];
		NotebookWrite[UserNotebookCFLP,resourceCell] 
	];







ResetRemoteResources[]:=
	Block[{},
		SetSelectedNotebook[UserNotebookCFLP];
		NotebookLocate["remote"];
		resourceCell=NotebookRead[UserNotebookCFLP]/.
				{Rule[InitializationCell,False]->Rule[InitializationCell,True],
				"Text"->"Input"};
		SetSelectedNotebook[CSLaunchNotebookCFLP];
		NotebookLocate["remote"];
		NotebookWrite[CSLaunchNotebookCFLP,resourceCell];
		NotebookSave[CSLaunchNotebookCFLP];
		RenameFile[$cflpSrcDirectory<>"CSLaunch.m",$cflpPkgDirectory<>
        "CSLaunch.m"];
		NotebookClose[UserNotebookCFLP];
		NotebookClose[CSLaunchNotebookCFLP]
	];







Stop[ ]:=
	(NotebookClose[$CFLPsyntax];
		CloseCFLPTraceWindow[];
		CloseCSTraceWindow[];
		NotebookClose[Debug`Private`\[Bullet]ctrlPanel];
		If[MemberQ[Links[],CSlink],
			SendCSQuery[{"End"}];
			Print["done."],
			Print["link already disabled."]];
		Exit[]
	); 



End[];

EndPackage[];

