(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Debug`",{"TermSyntax`"}];



ClearCFLPTraceWindow::usage=
  "ClearCFLPTraceWindow[] clears the current trace window of the \
interpreter.";

IsClosedPanel::usage=
  "IsClosedPanel[] returns True if the CFLP control panel is closed and False \
otherwise.";

ClearCSTraceWindow::usage=
  "ClearCSTraceWindow[] clears the current trace window of the constraint \
solving component.";

CloseCFLPTraceWindow::usage=
  "CloseCFLPTraceWindow[] closes the current trace window of the \
interpreter.";

CloseCSTraceWindow::usage=
  "CloseCSTraceWindow[] closes the current trace window of the constraint \
solving component.";

OpenCFLPTraceWindow::usage=
  "OpenCFLPTraceWindow[options] opens a trace window for the CFLP interpreter \
using the specified options.";

OpenCSTraceWindow::usage=
  "OpenCSTraceWindow[options] opens a trace window for the constraint solving \
component using the specified options.";

DPrint::usage=
  "DPrint[level,expr] prints `expr` into the trace window of the interpreter \
if `level` is less than or equal to $CFLPTraceLevel.";

CSPrint::usage=
  "CSPrint[level,expr] prints `expr` into the trace window of the constraint \
scheduler if `level` is less than or equal to $CFLPTraceLevel.";

$CFLPTraceLevel::usage=
  "$CFLPTraceLevel controls the granularity of trace output.";

$CSWindow::usage="";$TraceWindow::usage="";

MessageOff::usage="";MessageOn::usage="";

SetPanel::usage="";MessageOn::usage="";ResetPanel::usage="";





Begin["`Private`"];







Clear[\[Bullet]ctrlPanel];
\[Bullet]ctrlPanel:=Null;



$TraceWindow:=Null;
$CSWindow:=Null;



$CFLPTraceLevel:=2;



Clear[CSPrint];
CSPrint[level_,expr___]/;
    And[Head[$CSWindow]===NotebookObject,level\[LessEqual]$CFLPTraceLevel]:=
	NotebookWrite[$CSWindow,
		Cell[BoxData[RowBox[Function[StyleBox[ToBoxes[#,StandardForm]]]/@ {expr}]],
      "Message",
			GeneratedCell\[Rule]True]];







Clear[ClearCFLPTraceWindow];
ClearCFLPTraceWindow[]:=
	If[$TraceWindow=!=Null,
		SelectionMove[$TraceWindow,All,Notebook];
		NotebookDelete[$TraceWindow]
	];





Clear[ClearCSTraceWindow];
ClearCSTraceWindow[]:=
	If[$CSWindow=!=Null,
		SelectionMove[$CSWindow,All,Notebook];
		NotebookDelete[$CSWindow]];





Clear[CloseCFLPTraceWindow];
CloseCFLPTraceWindow[]:=
	If[$TraceWindow=!=Null,
		NotebookClose[$TraceWindow];$TraceWindow=Null];







Clear[CloseCSTraceWindow];
CloseCSTraceWindow[]:=
	If[$CSWindow=!=Null,
		NotebookClose[$CSWindow];$CSWindow=Null];





\!\(Clear[DPrint]; \n
  DPrint[level_, \*"\"\<\!\(\( \[Implies] \^cs\)\)\>\"", expr__] /; 
      And[Head[$TraceWindow] === NotebookObject, 
        level \[LessEqual] $CFLPTraceLevel] := \n\t
    NotebookWrite[$TraceWindow, \n\t\t
      Cell[BoxData[
          RowBox[Function[StyleBox[ToBoxes[#, StandardForm]]]/@
              \ {\*"\"\<\!\(\[Implies]\^cs\)\>\"", expr}]], "\<Message\>", \n
        \t\t\tCellFrame -> True, \n\t\t\tGeneratedCell \[Rule] True]]; \)

DPrint[level_,expr___]/;
    And[Head[$TraceWindow]===NotebookObject,
      level\[LessEqual]$CFLPTraceLevel]:=
		NotebookWrite[$TraceWindow,
		Cell[BoxData[RowBox[Function[StyleBox[ToBoxes[#,StandardForm]]]/@ {expr}]],
      "Message",
			GeneratedCell\[Rule]True]];







IsClosedPanel[]:=
  Or[\[Bullet]ctrlPanel===Null,
    NotebookInformation[\[Bullet]ctrlPanel]===$Failed];



MessageOff[]:=($CFLPTraceLevel=0);



MessageOn[]:=($CFLPTraceLevel=2);





OpenCFLPTraceWindow[opts___Rule]:=
	Block[{curr=SelectedNotebook[]},
		If[$TraceWindow=!=Null,CloseCFLPTraceWindow[]];
		$TraceWindow=
			If[ValueQ[$FrontEnd],
					NotebookCreate[opts,
					WindowSize->{400,120},
					WindowTitle->"CFLP Trace",
					WindowElements->{"VerticalScrollBar","HorizontalScrollBar"},
					Magnification->1]];
		SetSelectedNotebook[curr]
	];





Clear[OpenCSTraceWindow];
OpenCSTraceWindow[opts___Rule]:=
	Block[{curr=SelectedNotebook[]},
		If[$CSWindow=!=Null,CloseCSTraceWindow[]];
		$CSWindow=
			If[ValueQ[$FrontEnd],
					NotebookCreate[opts,
					WindowSize->{400,120},
					WindowTitle->"Scheduler Trace",
					WindowElements->{"VerticalScrollBar","HorizontalScrollBar"},
					Magnification->1]];
		SetSelectedNotebook[curr]
	];





ResetPanel[]:=
	Block[{},
		NotebookClose[\[Bullet]ctrlPanel];
		\[Bullet]ctrlPanel=
      NotebookOpen[Global`$cflpSrcDirectory<>"ControlPanel1.nb"]
	];





Clear[SetPanel];
SetPanel[]:=
	If[
			\[Bullet]ctrlPanel===Null\[Or]
				NotebookInformation[\[Bullet]ctrlPanel]=!=$Failed,
		\[Bullet]ctrlPanel=
      NotebookOpen[Global`$cflpSrcDirectory<>"ControlPanel1.nb"]
		];



End[];

EndPackage[];











