(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Calculus`",
	{"Terms`","RewriteRules`","Debug`","Substitutions`","SchedulerInterface`"}];



TcCall::usage ;

cflpInterrupt::usage=
  "cflpInterrupt is a global variable for the internal use of CallTSolve. It \
is used for signaling the occurrence of a user interrupt event.";

CallTSolve::usage=
  "CallTSolve[{form1,\[Ellipsis]}, vars] attempts to solve the set of \
equational formulas {form1,\[Ellipsis]} for the variables `vars`.
		It is the designed to be called by the term algebra solver `TSolve` and by \
the type checker `Tc`." ;

TSolveRules::usage;

CFLP::usage=
  "CFLP[eqns,cnstrs] attempts to solve the system of equations `eqns` and \
constraints `cnstrs` for the set of Temporary symbols of `eqns` and `cnstrs`. \
\n
		It is designed to be called by CallTSolve." ;

IsConstrV::usage=
  "IsConstrV[expr] yields True if `expr` is a CFLP constructor term and \
yields False otherwise. A CFLP constructor term is a term consisting only of \
bound variables, constructors and external operators. A weak version of the \
variable occur check test is imposed.";

IsValue::usage=
  "IsValue[expr] yields True if `expr` is a CFLP value and yields False \
otherwise. A CFLP value is a term consisting only of bound variables, \
constructors and external operators.";

CFLPRules::usage=
  "CFLPRules gives the list of inference rules of the CFLP calculus. The \
inference rules are tried from left to right.";

CFLPANDRules::usage=
  "CFLPANDRules gives the list of inference rules of the CFLP calculus for \
AND contexts. The inference rules are tried from left to right.";





Begin["`Private`"];

$ContextPath=
  Join[{"Variables`","TermSyntax`","TypeSyntax`","Types`"},$ContextPath];

Off[RuleDelayed::"argr"];







Clear[IsConstrV,IsConstrVAux];
IsConstrV[term_Function]:=True;
IsConstrV[t_]:=IsConstrVAux[t];
IsConstrVAux[_?IsConstructor|_?IsVar]:=True;
IsConstrVAux[_?IsConstrVAux[___?IsConstrVAux]]:=True;
IsConstrVAux[_]:=False;







Clear[IsVarValue];
IsVarValue[_?IsConstructor|_?IsExternal|_?IsVar]:=True;
IsVarValue[_?IsExternal[___]]:=True;
IsVarValue[_?IsVarValue[___?IsVarValue]]:=True;
IsVarValue[_]:=False;

Clear[IsValue];
IsValue[term_]:=And[IsVarValue[term],Var[term]==={}];





ComputedAnswer[gV_,\[Sigma]_]:=
		FixedPoint[ApplySubst[#,\[Sigma]]&,
    Select[\[Sigma],
      MemberQ[gV,#\[LeftDoubleBracket]1\[RightDoubleBracket]]&]];





NewCFLP[EqType_,RewritesTo[t_,cs1_List,cs2_List],rhs_,forms___]:=
	(If[addType,
			TypeChecker`Tc[{Sequence @@ cs1,EqType[t,rhs],Sequence @@ cs2},
				TypeChecker`KeepTypes->True]];
		{Sequence @@ cs1,EqType[t,rhs],Sequence @@ cs2,forms});





NewCFLPImitation[EqType_,f_,X_,params_List,t_,{forms___},Cs_]:=
	Block[
		{mapsTo,newVars=Table[Module[{x},x],{Length[params]}],\[Lambda]term,
			Global`Substitution=Global`Substitution},
		\[Lambda]term = \[Lambda][#1, #2]&
				[newVars,f @@ Table[Module[{H}, H @@ #]& [newVars],{Arity[f]}]];
		mapsTo=X->\[Lambda]term;
		Global`Substitution=Append[Global`Substitution /. mapsTo,mapsTo]
	];



Clear[NewCFLPProjection];
NewCFLPProjection[EqType_,X_,params_List,t_,{forms___},Cs_]:=
	Block[{mapsTo,\[Lambda]dummy,\[Lambda]vars=NewX /@ params,
			\[Lambda]term,Global`Substitution=Global`Substitution},
		\[Lambda]term=Function[{x,vars},
				x @@ Table[Module[{H},H @@ vars],{i,Arity[x]}]];	
		Scan[
				(CFLP @@({{
                    EqType[t,
                      \[Lambda]term[#\[LeftDoubleBracket]2
                          \[RightDoubleBracket],params]],forms},Cs}/.X->
                  Function @@ {\[Lambda]vars,
                      \[Lambda]term[#\[LeftDoubleBracket]1
                          \[RightDoubleBracket],\[Lambda]vars]}))&,
		Transpose[{\[Lambda]vars,params}]
		]
	];



EmptySequence:=Sequence[];









NewEqns[h_,s_,t_]:=
  Sequence @@ 
    Table[h[s\[LeftDoubleBracket]i\[RightDoubleBracket],
        t\[LeftDoubleBracket]i\[RightDoubleBracket]],{i,Length[s]}];











VariantsRule[f_Symbol,nr_]:=
  RewriteRuleList[f]\[LeftDoubleBracket]nr\[RightDoubleBracket][];
VariantsRule[f_[args___],nr_]:=
  RewriteRuleList[f]\[LeftDoubleBracket]nr\[RightDoubleBracket][args];





\[Sigma]Vars:={};\[Bullet]ANDContext:=False;

















Clear[\[Bullet]sys,\[Bullet]Nsys,\[Bullet]ORsys,\[Bullet]ANDsys,
  \[Bullet]ORbranches,\[Bullet]waitsys];



















Clear[cflp];





\!\(\(\[Bullet]sys[\[Sigma]_, gv_, {}, {}] := \n\t
    Block[{\[Theta], \[Tau]}, \n\t\t
      \[Theta] = 
        Inner[\n\t\t\t\tRule, \n\t\t\t\tinitialVars, \n\t\t\t\t
          FixedPoint[ApplySubst[#, \[Sigma]]&, initialVars], \n\t\t\t\tList]; 
      \n\t\t\(nSols--\); \n\t\t
      DPrint[1, \*"\"\<\!\(\( \[Implies] \^b\)\)\>\"", \[Theta]]; \n\t\t
      AppendTo[result, \[Theta]]; \n\t\t{}\n\t]; \)\)

\[Bullet]sys[\[Sigma]_,gv_,{}]:=
	Block[{\[Tau]},
		AppendTo[result,\[Sigma]/.{_?IsVar[\[Tau]_]:>\[Tau]}];
		{}
	];







\!\(\*
  RowBox[{
    RowBox[{\(\[Bullet]sys[\[Sigma]_, gv_, {}, cs_]\), ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({sentOK}\), ",", "\n", "\t\t", 
          RowBox[{
          \(DPrint[1, \*"\"\<\!\(\[Implies]\^cs\)\>\"", cs, gv, 
              Join[Complement[Var[{cs, \[Sigma]}], gv], pV], \[Sigma]]\), 
            ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"!", 
                  StyleBox["callCS",
                    FontColor->RGBColor[1, 0, 0]]}], ",", "\n", "\t\t\t\t", 
                RowBox[{
                  RowBox[{
                    StyleBox["callCS",
                      FontColor->RGBColor[1, 0, 0]], "=", "True"}], ";", 
                  "\n", "\t\t\t\t", 
                  RowBox[{"SendCSQuery", "[", 
                    RowBox[{"{", 
                      RowBox[{
                        StyleBox["\"\<SetConstructors\>\"",
                          FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                        "\t\t\t\t\t\t", 
                        \(Complement[
                          Cases[Cases[DownValues[IsConstructor], 
                              RuleDelayed[x__] :> {x}\[LeftDoubleBracket]1, 
                                  1, 1\[RightDoubleBracket]], \n
                            \t\t\t\t\t\t\t_Symbol], pV]\)}], "}"}], 
                    "]"}]}]}], "]"}], ";", "\n", "\t\t", 
            RowBox[{
              StyleBox["queryIndex",
                FontColor->RGBColor[1, 0, 0]], "++"}], ";", "\n", "\t\t", 
            RowBox[{"sentOK", "=", 
              RowBox[{"SendCSQuery", "[", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["\"\<CSolve\>\"",
                      FontColor->RGBColor[0, 0, 1]], ",", "\n", "\t\t\t\t\t", 
                    \(Union[cs]\), ",", "\[Sigma]", ",", "gv", ",", 
                    \(Join[Complement[Var[{cs, \[Sigma]}], gv], pV]\)}], 
                  "}"}], "]"}]}], ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{\(sentOK === "\<dead.\>"\), ",", "\n", "\t\t\t", 
                RowBox[{
                  StyleBox[\(queryIndex--\),
                    FontColor->RGBColor[1, 0, 0]], ";", \({}\)}], ",", "\n", 
                "\t\t\t", 
                RowBox[{"\[Bullet]waitsys", "[", 
                  RowBox[{
                    StyleBox["queryIndex",
                      FontColor->RGBColor[1, 0, 0]], ",", "gv", ",", 
                    \(Length[\[Sigma]]\), ",", \({}\)}], "]"}]}], "\n", 
              "\t\t", "]"}]}]}], "\n", "\t", "]"}]}], ";"}]\)







\!\(\*
  RowBox[{
    RowBox[{
    \(\[Bullet]sys[\[Sigma]_, gv_, {\[WatchIcon], forms___}, cs_]\), ":=", 
      "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({}\), ",", "\n", "\t\t", 
          RowBox[{
          \(DPrint[1, \*"\"\<\!\(\( \[Implies] \^cs\)\)\>\"", cs, gv, 
              Join[Complement[Var[{cs, \[Sigma]}], gv], pV], \[Sigma]]\), 
            ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"!", 
                  StyleBox["callCS",
                    FontColor->RGBColor[1, 0, 0]]}], ",", "\n", "\t\t\t\t", 
                RowBox[{
                  RowBox[{
                    StyleBox["callCS",
                      FontColor->RGBColor[1, 0, 0]], "=", "True"}], ";", 
                  "\n", "\t\t\t\t", 
                  RowBox[{"SendCSQuery", "[", 
                    RowBox[{"{", 
                      RowBox[{
                        StyleBox["\"\<SetConstructors\>\"",
                          FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                        "\t\t\t\t\t\t", 
                        \(Complement[
                          Cases[Cases[DownValues[IsConstructor], 
                              RuleDelayed[x__] :> {x}\[LeftDoubleBracket]1, 
                                  1, 1\[RightDoubleBracket]], \n
                            \t\t\t\t\t\t\t_Symbol], pV]\)}], "}"}], 
                    "]"}]}]}], "]"}], ";", "\n", "\t\t", 
            RowBox[{
              StyleBox["queryIndex",
                FontColor->RGBColor[1, 0, 0]], "++"}], ";", "\n", "\t\t", 
            \( (*\ Print["\<constraints:\>", Union[cs]]; \n\t\t
              Print["\<variables:\>", {gv, 
                  Join[Complement[Var[{cs, \[Sigma]}], gv], pV]}]; \ *) \), 
            "\n", "\t\t", 
            RowBox[{"SendCSQuery", "[", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["\"\<CSolve\>\"",
                    FontColor->RGBColor[0, 0, 1]], ",", "\n", "\t\t\t\t\t", 
                  \(Union[cs]\), ",", "\[Sigma]", ",", "gv", ",", 
                  \(Join[Complement[Var[{cs, \[Sigma]}], gv], pV]\)}], "}"}], 
              "]"}], ";", "\n", "\t\t", 
            RowBox[{"\[Bullet]waitsys", "[", 
              RowBox[{
                StyleBox["queryIndex",
                  FontColor->RGBColor[1, 0, 0]], ",", "gv", ",", 
                \(Length[\[Sigma]]\), ",", \({forms}\)}], "]"}]}]}], "\n", 
        "\t", "]"}]}], ";"}]\)







\[Bullet]ORbranches[x__,{}]:=\[Bullet]ORbranches[x];
\[Bullet]ORbranches[x_]:=x;
\[Bullet]ORbranches[]:={};

Clear[NewSys];
NewSys[gv_,{},l\[Sigma]_,{v_,\[Sigma]_,eqs_}]:=
	Block[{},
		SetVariables[v];
		AppendTo[result,\[Sigma]];{}
	];
NewSys[gv_,forms_,l\[Sigma]_,{v_,\[Sigma]_,eqs_}]:=
	Block[{},
		SetVariables[v];
		\[Bullet]sys[\[Sigma],Union[gv,Var[\[Sigma]]],
      Join[forms,Map[CSMark,eqs]]/.\[Sigma],{}]
	];
NewSys[x_]:=Block[{},Print["NewSys:",x];{}];

cflp["wait"]:=\[Bullet]waitsys[id_,gv_,l\[Sigma]_,forms_]:>
		Block[{tmp,answer,res,\[Bullet]ORbranches},
			answer=SendCSQuery[{"GetResults",id}];
			tmp=Query[id];
			Query[id]={};
			res=Apply[\[Bullet]ORbranches,Map[NewSys[gv,forms,l\[Sigma],#]&,tmp]];
			AppendTo[res,If[answer==="y",{},\[Bullet]waitsys[id,gv,l\[Sigma],forms]]]
		];







cflp["B"]:=x_/;nSols\[LessEqual]0:>{};







cflp["||\[Dash]OR"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{or\[Dash]eq_DoubleVerticalBar,forms___},cs_]:>
		Block[{OR\[Dash]systems=
          Apply[\[Bullet]ORbranches,
            Map[\[Bullet]sys[\[Sigma],gv,{#,forms},cs]&,or\[Dash]eq]]},
			DPrint[1,Superscript["\[Implies]","OR"],OR\[Dash]systems];
			OR\[Dash]systems
		];







\[Bullet]sys[{},\[Bullet]ORsys[x__]]:=\[Bullet]sys[x];

cflp["seq\[Dash]OR"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{or\[Dash]eq_Or,forms___},cs_]:>
		Block[{},
			DPrint[1,Superscript["\[Implies]","OR"],{First[or\[Dash]eq],forms}];
			\[Bullet]sys[
				\[Bullet]sys[\[Sigma],gv,{First[or\[Dash]eq],forms},cs],
				\[Bullet]ORsys[\[Sigma],gv,{Rest[or\[Dash]eq],forms},cs]
			]
		];







cflp["seq\[Dash]AND"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{and\[Dash]eq_List,forms___},cs_]:>
	\[Bullet]sys[\[Sigma],gv,{Sequence @@ and\[Dash]eq,forms},cs];







Clear[ANDSelectionCriterium];
ANDSelectionCriterium[e_]:=MemberQ[e,_?(MemberQ[tmpvars,#]&),\[Infinity]];

Clear[\[Bullet]ANDPartition];
\[Bullet]ANDPartition[eqs_List]:=\[Bullet]ANDPartitionAux[eqs,{}];

Clear[\[Bullet]ANDPartitionAux];
\[Bullet]ANDPartitionAux[{},ps_List]:=ps;
\[Bullet]ANDPartitionAux[{form_, forms___}, ps_List] := 
  Block[{tmpvars = Var[form], newp = {form}, newforms, oldforms = {forms}}, 
    While[True, newforms = Select[oldforms, ANDSelectionCriterium]; 
			If[newforms === {}, 
				Break[], 
				tmpvars = Var[newforms]; 
				newp = Join[newp, newforms]; 
				oldforms = Complement[oldforms, newforms]]]; 
		\[Bullet]ANDPartitionAux[oldforms, Append[ps, newp]]];

cflp["||\[Dash]AND"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{and\[Dash]eqs_And,forms___},cs_]:>
		Block[{neweqs=Flatten[List @@ and\[Dash]eqs,1],eqPartition},
			eqPartition=\[Bullet]ANDPartition[neweqs];
			If[Length[eqPartition]>1,
				\[Bullet]sys[\[Sigma],gv,{Wedge @@ eqPartition,forms},cs],
				\[Bullet]sys[\[Sigma],gv,{First[eqPartition],forms},cs]
			]
		];





\!\(\(cflp["\<AND\[Dash]1\>"] := 
    \[Bullet]sys[\[Sigma]_, gv_, {form : Wedge[{} ... ], forms___}, cs_] :> \n
      \t\t\((DPrint[1, \*"\"\<\!\(\[Implies]\^AND\)\>\"", {forms}]; 
        \[Bullet]sys[\[Sigma], gv, {forms}, cs])\); \)\)





cflp["AND\[Dash]2"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{andform_Wedge,forms___},cs_]:>
	Block[
			{cflpFailed=False,
				newSystems,tmp,
				\[Sigma]New,csNew,gvNew=gv,
				andformNew,current\[Dash]sys},
			(* generate the states of the interpreter which are processed 
          simultaneously *)
			newSystems=
        Map[\[Bullet]sys[{},gv\[Intersection]Var[#],Append[#,True],{}]&,
          andform];
			newSystems=newSystems/.CFLPRules;
			(* d\etect inconsistencies *);
			If[cflpFailed,Return[{}]];
			(* generate the new AND\[Dash]goal *);
			\[Sigma]New={};csNew=cs;
			andformNew=Wedge[];
			While[newSystems=!=Wedge[],
				current\[Dash]sys=First[newSystems];
				\[Sigma]New=
          Join[\[Sigma]New,
            current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]];
				gvNew=
          Union[gvNew,
            current\[Dash]sys\[LeftDoubleBracket]2\[RightDoubleBracket]];
				csNew=
          ApplySubst[csNew,
            current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]];
				csNew=
          Join[csNew,
            current\[Dash]sys\[LeftDoubleBracket]4\[RightDoubleBracket]];
				AppendTo[
					andformNew,
					ApplySubst[
						Drop[
              current\[Dash]sys\[LeftDoubleBracket]3\[RightDoubleBracket],{
                Length[current\[Dash]sys\[LeftDoubleBracket]3
                    \[RightDoubleBracket]]}],
						current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]
					]
				];
				newSystems=Rest[newSystems]
			];
			DPrint[1,
        Subsuperscript["\[Implies]",\[Sigma]New,"AND"],{
          Join[\[Sigma],\[Sigma]New],{andformNew,forms},gvNew,csNew}];
			\[Bullet]sys[Join[\[Sigma],\[Sigma]New],gvNew,{andformNew,forms},csNew]
		];







\!\(\(cflp["\<t\>"] := 
    \[Bullet]sys[\[Sigma]_, gv_, {\((eq | ppeq)\)[x_, x_], forms___}, cs_] :> 
      \n\t\tBlock[{}, \n\t\t\t
        DPrint[1, \*"\"\<\!\(\[Implies]\^t\)\>\"", {forms}]; \n\t\t\t
        \[Bullet]sys[\[Sigma], gv, {forms}, cs]]; \)\)

cflp["v1"]:=\[Bullet]sys[\[Sigma]_,gv_,{_[x_?IsVar,y_?IsVar],forms___},cs_]:>
		Block[{\[Sigma]new=If[MemberQ[gv,x],y->x,x->y],newforms},
			newforms=ApplySubst[{forms},\[Sigma]new];
			DPrint[1,Subsuperscript["\[Implies]",\[Sigma]new,"v"],newforms];
			\[Bullet]sys[
					Append[\[Sigma],\[Sigma]new],
					If[MemberQ[gv,x],Append[gv,y],gv],
					newforms,
					ApplySubst[cs,\[Sigma]new]
				]
		];

cflp["v2"]:=
  \[Bullet]sys[\[Sigma]_,
        gv_,{_[x_?IsVar,t_Function]|_[t_Function,x_?IsVar],forms___},cs_]/;
      Or[IsConstrV[t],IsValue[t]]:>
		Block[{\[Sigma]new,newforms},
			If[MemberQ[t,x,-1],
				cflpFailed=True;{},
				\[Sigma]new=x\[Rule]t;
				newforms=ApplySubst[{forms},\[Sigma]new];
				DPrint[1,Subsuperscript["\[Implies]",\[Sigma]new,"v"],newforms];
				If[IsHiVar[x],Map[SetHiVar,Cases[t,f_?IsVar[__]:>f,\[Infinity]]]];
				\[Bullet]sys[
					Append[\[Sigma],\[Sigma]new],
					If[MemberQ[gv,x],Join[gv,Var[t]],gv],
					newforms,
					ApplySubst[cs,\[Sigma]new]
				]
			]
		];

cflp["v3"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{_[x_?IsVar,t_]|_[t_,x_?IsVar],forms___},cs_]/;
      Or[IsConstrV[t],IsValue[t]]:>
		Block[{\[Sigma]new},
			If[MemberQ[t,x,-1],
				cflpFailed=True;{},
				\[Sigma]new=x\[Rule]t;
				DPrint[1,Subsuperscript["\[Implies]",\[Sigma]new,"v"],
          ApplySubst[{forms},\[Sigma]new]];
				\[Bullet]sys[
					Append[\[Sigma],\[Sigma]new],
					If[MemberQ[gv,x],Join[gv,Var[t]],gv],
					ApplySubst[{forms},\[Sigma]new],
					ApplySubst[cs,\[Sigma]new]
				]
			]
		];







cflp["xdel"]:=\[Bullet]sys[\[Sigma]_,gv_,{CSMark[eq[u_,u_]],forms___},cs_]:>
	Block[{},
		DPrint[1,Superscript["\[Implies]","xdel"],{forms}];
		\[Bullet]sys[\[Sigma],gv,{forms},cs]
	];

cflp["xfer"]:=\[Bullet]sys[\[Sigma]_,gv_,{CSMark[e_],forms___},cs_]:>
	Block[{},
		DPrint[1,Superscript["\[Implies]","xfer"],{forms}];
		\[Bullet]sys[\[Sigma],gv,{forms},Append[cs,e]]
	];

cflp["D"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{(eq|ppeq)[s_,t_],forms___},cs_]/;
      Not[FreeQ[eq[s,t],_?IsHiVar]]:>
    \[Bullet]sys[\[Sigma],gv,{forms},Append[cs,eq[s,t]]];







\!\(\[Bullet]sys[{}, \[Bullet]Nsys[_, _, _, _, {}, _, _]] := {}; \n
  \[Bullet]sys[{}, 
      \[Bullet]Nsys[\[Sigma]_, gv_, t_, e_, {s_, nr_, l_}, {forms___}, 
        cs_]] := \n\t
    Block[{neweqns = NewCFLP[e, VariantsRule[s, nr], t, forms]}, \n\t\t
      DPrint[1, \*"\"\<\!\(\( \[Implies] \^on\)\)\>\"", neweqns]; \n\t\t
      If[l == nr, \n\t\t\t\[Bullet]sys[\[Sigma], gv, neweqns, cs], \n\t\t\t
        \[Bullet]sys[\n\t\t\t\t\[Bullet]sys[\[Sigma], gv, neweqns, cs], \n
          \t\t\t\t\[Bullet]Nsys[\[Sigma], gv, t, e, {s, nr + 1, l}, {forms}, 
            cs]\n\t\t\t]\n\t\t]\n\t]; \)

cflp["on"]:=\[Bullet]sys[\[Sigma]_,gv_,
		{eq[s:(f_?IsDefinedSymbol)
							|(f_?IsDefinedSymbol[___]),t_]
					|eq[t_,s:(f_?IsDefinedSymbol)
								|(f_?IsDefinedSymbol[___])],forms___},cs_]:>
		If[RewriteRuleList[f]==={},
			{},
			\[Bullet]sys[{},
				\[Bullet]Nsys[\[Sigma],gv,t,eq,{s,1,Length[RewriteRuleList[f]]},{forms},
          cs]
			]
		];







cflp["simplif1"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{(eq|ppeq)[(\[CurlyPhi]_)[args__],t_],forms___},
        cs_]/;And[IsExternal[\[CurlyPhi]],Not[IsValue[\[CurlyPhi][args]]]]:>
		\[Bullet]sys[\[Sigma],gv,
      \[Bullet]spl[Simplify[eq[\[CurlyPhi][args],t]],forms],cs];

cflp["simplif2"]:=
  \[Bullet]sys[\[Sigma]_,gv_,{(eq|ppeq)[s_,(\[Psi]_)[args__]],forms___},cs_]/;
      And[IsExternal[\[Psi]],Not[IsValue[\[Psi][args]]]]:>
	\[Bullet]sys[\[Sigma],gv,\[Bullet]spl[Simplify[eq[s,\[Psi][args]]],forms],
      cs];







cflp["xi1"]:=
  \[Bullet]sys[\[Sigma]_,gv_,\[Bullet]spl[_[t_,t_],forms___],cs_]:>
	\[Bullet]sys[\[Sigma],gv,{forms},cs];

cflp["xi2"]:=
  \[Bullet]sys[\[Sigma]_,gv_,
        \[Bullet]spl[eq[\[CurlyPhi]_[args__],t_],forms___],cs_]/;
      IsExternal[\[CurlyPhi]]:>
		Block[{newV=NewX/@{args},neweqs,eqMarked},
			neweqs={NewEqns[eq,{args},newV]};
			Function[eqMarked=CSMark[eq[\[CurlyPhi] @@ newV,#]];AppendTo[newV,#]][
        NewX[]];
			neweqs=Join[neweqs,{eqMarked,eq[Last[newV],t],forms}];
			DPrint[1,Superscript["\[Implies]","i"],neweqs];
			\[Bullet]sys[\[Sigma],Join[gv,newV],neweqs,cs]
		];

cflp["xi3"]:=
  \[Bullet]sys[\[Sigma]_,gv_,\[Bullet]spl[eq[s_,\[Psi]_[args__]],forms___],
        cs_]/;IsExternal[\[Psi]]:>
		Block[{newV=NewX/@{args},neweqs,eqMarked},
			neweqs={NewEqns[eq,{args},newV]};
			Function[eqMarked=CSMark[eq[#,\[Psi] @@ newV]];AppendTo[newV,#]][NewX[]];
			neweqs=Join[neweqs,{eqMarked,eq[s,Last[newV]],forms}];
			DPrint[1,Superscript["\[Implies]","i"],neweqs];
			\[Bullet]sys[\[Sigma],Join[gv,newV],neweqs,cs]
		];



cflp["xi4"]:=\[Bullet]sys[\[Sigma]_,gv_,\[Bullet]spl[e_,forms___],cs_]:>
	\[Bullet]sys[\[Sigma],gv,{e,forms},cs];

















Clear[CFLPImitation];





cflp["ovi1"]:=\[Bullet]sys[\[Sigma]_,gv_,
		{(eq|ppeq)[x_?IsVar[params__?IsVar],t_?IsVarValue],forms___},cs_]/;(
        Length[Union[{params}]]==Length[{params}]):>
		Block[{\[Sigma]new=x\[Rule]Function[#1,#2]&[{params},t],newforms},
			newforms=ApplySubst[{forms},\[Sigma]new];
			DPrint[1,Subsuperscript["\[Implies]",\[Sigma]new,"ovi"],{forms}];
			\[Bullet]sys[
					Append[\[Sigma],\[Sigma]new],
					If[MemberQ[gv,x],
          Join[gv,Var[\[Sigma]new\[LeftDoubleBracket]2\[RightDoubleBracket]]],
          gv],
					newforms,
					ApplySubst[cs,\[Sigma]new]
				]
		];

cflp["ovi2"]:=\[Bullet]sys[\[Sigma]_,gv_,
		{(eq|ppeq)[t_?IsVarValue,x_?IsVar[params__?IsVar]],forms___},cs_]/;(
        Length[Union[{params}]]==Length[{params}]):>
		Block[{\[Sigma]new=x\[Rule]Function[#1,#2]&[{params},t],newforms},
			newforms=ApplySubst[{forms},\[Sigma]new];
			DPrint[1,Subsuperscript["\[Implies]",\[Sigma]new,"ovi"],{forms}];
			\[Bullet]sys[
					Append[\[Sigma],\[Sigma]new],
					If[MemberQ[gv,x],
          Join[gv,Var[\[Sigma]new\[LeftDoubleBracket]2\[RightDoubleBracket]]],
          gv],
					newforms,
					ApplySubst[cs,\[Sigma]new]
				]
		];

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[X_?IsVar[params__],f_?IsVarValue],forms___},
      cs_]]=
	CFLPImitation[f,\[Bullet]sys[\[Sigma],gv,cv,{EqType[X[params],f],forms},cs]];

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[X_?IsVar[params__],f_?IsConstructor],forms___},
      cs_]]=
	CFLPImitation[f,\[Bullet]sys[\[Sigma],gv,cv,{EqType[X[params],f],forms},cs]];

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[f_?IsConstructor,X_?IsVar[params__]],forms___},
      cs_]]:=
	CFLPImitation[f,\[Bullet]sys[\[Sigma],gv,cv,{EqType[X[params],f],forms},cs]];

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[X_?IsVar[params__],f_?IsConstructor[args___]],
        forms___},cs_]]=
	CFLPImitation[f,
    \[Bullet]sys[\[Sigma],gv,cv,{EqType[X[params],f[args]],forms},cs]];

CFLPImitation[\[Bullet]sys[\[Sigma]_,gv_,cv_,
		{(EqType:eq|ppeq)[f_?IsConstructor[args___],X_?IsVar[params__]],forms___},
      cs_]]=
	CFLPImitation[f,
    \[Bullet]sys[\[Sigma],gv,cv,{EqType[f[args],X[params]],forms},cs]];

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[t_?IsNotFlex,X_?IsVar[params__]],forms___},
      cs_]]:=
	{};

CFLPImitation[
    \[Bullet]sys[\[Sigma]_,gv_,
      cv_,{(EqType:eq|ppeq)[X_?IsVar[params__],t_?IsNotFlex],forms___},
      cs_]]:=
	{};





Clear[CFLPProjection];

CFLPProjection[
    \[Bullet]sys[\[Sigma]_,
      gv_,{(EqType:eq|ppeq)[X_?IsVar[params__],t_?IsNotFlex],forms___},
      cs_]]:=
	(DPrint[1,"projection rule:",EqType[X[params],t]];
		Join @@ 
      Map[CFLPImitation[#,
            \[Bullet]sys[\[Sigma],gv,{EqType[X[params],t],forms},cs]]&,
				Select[{params},(Head[Arity[#]]=!=Arity)&]]);

CFLPProjection[
    \[Bullet]sys[\[Sigma]_,
      gv_,{(EqType:eq|ppeq)[t_?IsNotFlex,X_?IsVar[params__]],forms___},
      cs_]]:=
	(DPrint[1,"projection rule:",EqType[X[params],t]];
		Join @@ 
      Map[CFLPImitation[#,
            \[Bullet]sys[\[Sigma],gv,{EqType[t,X[params]],forms},cs]]&,
				Select[{params},(Head[Arity[#]]=!=Arity)&]]);













cflp["vp"]:=
  \[Bullet]sys[\[Sigma]_,
      gv_,{form:ppeq[s_,x_?IsVar]|ppeq[x_?IsVar,s_],forms___},cs_]:>
		If[MemberQ[s,x,-1],
			cflpFailed=True;
			{},
			Function[
				DPrint[1,Subsuperscript["\[Implies]",#1,"v"],ApplySubst[{forms},#1]];
				\[Bullet]sys[
					Append[\[Sigma],#1],
					#2,
					ApplySubst[{forms},#1],
					cs]][x\[Rule]s,If[MemberQ[gv,x],Join[gv,Var[s]],gv]]
		];







cflp["onpp"]:=\[Bullet]sys[\[Sigma]_,gv_,
		{ppeq[s:(f_?IsDefinedSymbol)
							|(f_?IsDefinedSymbol[___]),t_]
					|ppeq[t_,s:(f_?IsDefinedSymbol)
							|(f_?IsDefinedSymbol[___])],forms___},cs_]:>
		If[RewriteRuleList[f]==={},
			{},
			\[Bullet]sys[{},
				\[Bullet]Nsys[\[Sigma],gv,t,ppeq,{s,1,Length[RewriteRuleList[f]]},{forms},
          cs]
			]
		];







cflp["i"]:=
	\[Bullet]sys[\[Sigma]_,gv_,
		{eq[s_,x_?IsVar]|eq[x_?IsVar,s_],forms___},
		cs_]:>
		Block[{},
			Apply[Function[
					If[addType,TypeChecker`Tc[#1,TypeChecker`KeepTypes->True]];
						DPrint[1,
							Subsuperscript["\[Implies]",x\[Rule]#1,"i"],
            ApplySubst[{NewEqns[eq,s,#1],forms},x\[Rule]#1]];
					\[Bullet]sys[
						Append[\[Sigma],x\[Rule]#1],
						#2,
						ApplySubst[{NewEqns[eq,s,#1],forms},x\[Rule]#1],
						cs]],{#,If[MemberQ[gv,x],Join[gv,List @@ #],gv]}&[NewC/@ s]
			]
		];







\!\(\*
  RowBox[{
    RowBox[{\(cflp["\<d\[Lambda]\>"]\), ":=", 
      RowBox[{
      \(\[Bullet]sys[\[Sigma]_, gv_, \n
          \t\t{e_[s_Function, t_Function], forms___}, cs_]\), ":>", "\n", 
        "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"Function", "[", "\n", "\t\t\t", 
                RowBox[{
                \(DPrint[1, 
                    \*"\"\<\!\(\( \[Implies] \^d\[Lambda]\)\)\>\"", {
                      e[s\ @@#, t\ @@#], forms}]\), ";", "\n", "\t\t  ", 
                  RowBox[{"If", "[", 
                    RowBox[{
                      StyleBox["addType",
                        FontColor->RGBColor[1, 0, 0]], ",", 
                      \(TypeChecker`Tc[#, TypeChecker`KeepTypes -> True]\)}], 
                    "]"}], ";", "\n", "\t\t\t", 
                  \(\[Bullet]sys[\[Sigma], gv, {e[s\ @@#, t\ @@#], forms}, cs]
                    \)}], "]"}], "[", 
              \(NewX\ /@\ s\[LeftDoubleBracket]1\[RightDoubleBracket]\), 
              "]"}]}], "\n", "\t", "]"}]}]}], ";"}]\)







\!\(\(cflp["\<d1\>"] := \n\t
    \[Bullet]sys[\[Sigma]_, gv_, \n
        \t\t{_[s_?AtomQ, t_?IsConstructorTerm] | _[t_?IsConstructorTerm, 
              s_?AtomQ], forms___}, cs_] :> \n\t\t
      If[t === s \[Or] t === s[], \n\t\t\t
        DPrint[1, \*"\"\<\!\(\( \[Implies] \^d\)\)\>\"", {forms}]; 
        \[Bullet]sys[\[Sigma], gv, {forms}, cs], \n\t\t\t
        cflpFailed = True; {}\n\t\t]; \)\)

\!\(\(cflp["\<d2\>"] := 
    \[Bullet]sys[\[Sigma]_, 
        gv_, {e_[\((f_?IsConstructor)\)[fargs___], 
            \((g_?IsConstructor)\)[gargs___]], forms___}, cs_] :> \n\t\t
      If[f === g \[And] Length[{fargs}] == Length[{gargs}], \n\t\t\t
        DPrint[1, 
          \*"\"\<\!\(\( \[Implies] \^d\)\)\>\"", {
            NewEqns[e, {fargs}, {gargs}], forms}]; \n\t\t\t
        \[Bullet]sys[\[Sigma], gv, {NewEqns[e, {fargs}, {gargs}], forms}, 
          cs], \n\t\t\tcflpFailed = True; \n\t\t\t{}]; \)\)





cflp["oth"]:=\[Bullet]sys[_,_,{e:_[f_[___],g_[___]],___},_]:>
		Block[{},
			DPrint[1,Superscript["\[Implies]","oth"],{}];
			{}];





CFLPRules:=Map[cflp,
		{
				"AND\[Dash]1",
				"AND\[Dash]2",
				"B","wait",
				"seq\[Dash]OR",
				"||\[Dash]OR",				
				"seq\[Dash]AND",
				"||\[Dash]AND",
				"t",
				"v1",
			  "v2",
				"v3",
				"xdel",
				"xfer",
				"D",
				"on",
				"ovi1",
				"ovi2",
				"simplif1",
				"simplif2",
				"xi1",
				"xi2",
				"xi3",
				"xi4",
				"vp",
				"onpp",
				"i",
				"d\[Lambda]",
				"d1",
				"d2",
				"oth"}]; 















CallTSolve[eqs_,vars_List,elims_List,ns_,typeInfo_:False]:=
	Block[
		{addType=typeInfo,
			callCS=False,
			gV,hV,
			queryIndex=0,
			result={},
			pV=Constructor @@ elims,
			nSols=ns,initialVars,
			sysCrt,
			oldV=Select[
          Join[vars,elims]/.{
              e_Pattern:>e\[LeftDoubleBracket]1\[RightDoubleBracket]},IsVar]
		},
		initialVars=(gV=SetVariables[vars]);
		sysCrt=\[Bullet]sys[{},gV,eqs];
		If[TcCall,
			FixedPoint[ReplaceAll[#,TSolveRules]&,sysCrt],
			AppendTo[sysCrt,{}];
			hV=Union @@ 
          Map[Cases[#,Derivative[__][f_?IsVar][__]:>f,\[Infinity]]&,eqs];
			Map[SetHiVar,hV];
			While[sysCrt=!={},
				If[NotebookFind[Debug`Private`\[Bullet]ctrlPanel,"Interrupting",
              Next]=!=$Failed,
					cflpInterrupt=True;
					Print["Interrupted"];
					result={};
					Break[],
					sysCrt=sysCrt/.TSolveRules
				]
			]
		];
		result=Function[
          Select[#,
            Head[#]=!=Rule\[Or]MemberQ[
                  gV,#\[LeftDoubleBracket]1\[RightDoubleBracket]]&]] /@ 
        result;
		(* result=
        Function[
            Select[#,
              Head[#]===Rule\[And]MemberQ[
                    gV,#\[LeftDoubleBracket]1\[RightDoubleBracket]]&]] /@ 
          result; *)
		ClearVariables[gV];
		SetVariables[oldV];
		Map[(IsHiVar[#]=.)&,hV];
		(* reset the scheduler *)
		If[callCS,SendCSQuery[{"Reset"}]]; 
		Simplify[result]
	];



End[];

EndPackage[];

