(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["CSLaunch`"];



WorkStations::usage=
  "WorkStations gives the list of assigned names of the computers on which \
the CFLP constraint solvers are being run. An empty string represents the \
name of the local machine.";

SolverList::usage=
  "SolverList[meth] gives the list of MathLink connections to the solvers \
implementing the method `meth`";

CSStart::usage="CSStart[] creates links to constraint solvers.";

CSEnd::usage="CSEnd[] closes the links to the constraint solvers.";

MethodList::usage=
  "MethodList gives the list of assigned names of the constraint solving \
methods. Currently, there are available four constraint solving method names: \
\"Linear\", \"Polynomial\", \"Derivative\" and \"PartialDerivative\".";



Off[LinkConnect::"linkc",LinkOpen::"linkf",LinkObject::"linkn",
  LinkObject::"linkd"];

Begin["`Private`"]; 



CSEnd[]:=Scan[ResetSolvers,MethodList];









CSStart[]:=Scan[SetSolverConnections,WorkStations];









SetSolverConnections[""]:=
	Map[(Do[
				SolverList[#]=Append[SolverList[#],{CreateMethLink[#],"idle"}],
				{Instances[#]}];#)&,MethodList];



SetSolverConnections[name_String]:=
	Block[{Link5000,nrC,info},
		Link5000=LinkConnect["5000@"<>name,LinkProtocol->"TCP"];
		info=LinkWrite[Link5000,"ask"];
		If[info===$Failed,
			Pause[1];
			Link5000=LinkConnect["5000@"<>name,LinkProtocol->"TCP"];
			info=LinkWrite[Link5000,"ask"]
		];
		If[info=!=$Failed,
			nrC=LinkRead[Link5000];
			If[nrC>15,
				LinkWrite[Link5000,"ignore"],
				While[True,
					LinkWrite[Link5000,"askmore"];
					While[Not[LinkReadyQ[Link5000]],Continue[]];
					While[LinkReadyQ[Link5000],info=LinkRead[Link5000];Print[info]];
					If[info==="stop",
						LinkWrite[Link5000,"close"];
						Break[],
						SolverList[info\[LeftDoubleBracket]1\[RightDoubleBracket]]=
              Join[SolverList[info\[LeftDoubleBracket]1\[RightDoubleBracket]],
                WaitAndConnect[
                  info\[LeftDoubleBracket]2\[RightDoubleBracket]]]
					]
				]
			];
			LinkClose[Link5000]
			(* ,LinkWrite[$ParentLink,{"FFF"}] *)
		]
	];







CreateMethLink[meth_String]:=
	Block[{l},
		l=LinkLaunch[StringJoin[
				"math -mathlink -initfile ",
				meth,".m -batchoutput"]];
		While[Not[LinkReadyQ[l]],Continue[]];
		LinkWrite[l,"OK"];
		While[Not[LinkReadyQ[l]],Continue[]];
		LinkRead[l];l];



CloseLink[lnk_LinkObject]:=
	If[IsLocalLink[lnk],
		LinkWrite[lnk,Unevaluated[Exit[]]],
		LinkWrite[lnk,"close"]
	];







Instances["Linear"]=2;
Instances["Polynomial"]=2;
Instances["Derivative"]=1;
Instances["PartialDerivative"]=1;





IsLocalLink[lnk_LinkObject]:=StringMatchQ[First[lnk],"math*"];	





MethodList:={"Linear","Polynomial","Derivative","PartialDerivative"};





WaitAndConnect[name_String]:=
	Block[{lnk},
		lnk=LinkConnect[name];
		If[lnk===$Failed,
			{},
			While[Not[LinkReadyQ[lnk],Continue[]]];
			If[LinkWrite[lnk,"OK"]=!=$Failed,
				LinkRead[lnk];
				{{lnk,"idle"}},
				{}]
		]
	];



ResetSolvers[name_String]:=
	Block[{lnks=Map[First,SolverList[name]]},
		Scan[(LinkWrite[#,"close"];While[Not[LinkReadyQ[#]],Continue[]])&,
			lnks];
		Scan[LinkClose,lnks];
		SolverList[name]={}
	];





SolverList[_]={};





WorkStations={""};



End[];

EndPackage[];



