(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21246,        820]*)
(*NotebookOutlinePosition[     22082,        849]*)
(*  CellTagsIndexPosition[     22038,        845]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Variables", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[{
  "This package contains commands for handling object variables. In our \
setting, an object variable is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol with the list of attributes {",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "}."
}], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Variables`\>", {"\<Types`\>"}]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Var::usage = "\<Var[expr] picks out the free variables of expr.\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsVar::usage = 
      "\<IsVar[expr] yields True is expr is a CFLP variable, and yields False \
otherwise.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsHiVar::usage = 
      "\<IsHiVar[term] yields True is a higher order variable, and yields \
False otherwise.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetHiVar::usage = 
      "\<SetHiVar[symb] declares the symbol `symb` as higher order \
variable.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetVariables::usage = 
      "\<SetVariables[list] sets the list of attributes of the symbols of \
list to {Temporary}.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(ClearVariables::usage = 
      "\<ClearVariables[list] sets the list of attributes of the symbols of \
list to {}.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewX::usage = 
      "\<NewX[ ] returns a new Temporary symbol of the form x$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewY::usage = 
      "\<NewY[ ] returns a new Temporary symbol of the form y$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewC::usage = 
      "\<NewC[ ] returns a new Temporary symbol of the form c$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(KeepVarTypes::usage = 
      "\<KeepVarTypes is a valid option for the function ClearVariables that \
specifies whether the types associated to variables should be removed or not.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["NewX, NewY, NewC", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax calls\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["NewX[ ];\n\tNewY[ ];\n\tNewC[ ];",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "NewX[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol x\n\tNewY[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol y\n\tNewC[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol c"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(NewX := Function[Module[{x}, x]]; \nNewY := Function[Module[{y}, y]]; \n
    NewC := Function[Module[{z}, z]]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(PrependTo[$ContextPath, "\<TypeSyntax`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["IsHiVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsHiVar[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " denotes a constraint variable, and False otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(IsHiVar[_] := False; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetHiVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["SetHiVar[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " denotes a constraint variable, and False otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(SetHiVar[x_] := \((IsHiVar[x] = True; x)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsVar[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta term ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a symbol with attribute ",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(IsVar[x_]\  := \n\t
      If[Head[x]\  === \ Symbol, \n\t\tAttributes[x]\  === \ {Temporary}, \ \n
        \t\tFalse]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Var", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tVar[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a CFLP expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tthe set of free variables of ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (i.e. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols with attribute ",
  StyleBox["Temporary)",
    FontFamily->"Courier"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[Var]; \n
    Var[term_Function] := 
      Complement[Var[term\[LeftDoubleBracket]2\[RightDoubleBracket]], 
        term\[LeftDoubleBracket]1\[RightDoubleBracket]]; \n
    Var[x_?IsVar] := {x}; \nVar[x_?AtomQ] := {}; \n
    Var[f_[args___]] := Apply[Union, Append[Var\ /@\ {args}, Var[f]]]; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Var[x_] := Union\ [Cases[{x}, _Symbol?IsVar, \(-1\)]]; \)\)], "Input",\

  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetVariables", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tSetVariables[{ ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  symbols or type annotated symbols\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tfor each list element ",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_i\),
          FontSlant->"Italic"], TraditionalForm]]],
  " do:\n\t(a) if ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol then make it a CFLP variable (by setting its attributes to {",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "})\n\t(b) if ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is a type annotated ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  Cell[BoxData[
      \(TraditionalForm\`v\_i\)]],
  "\[Proportion]",
  Cell[BoxData[
      \(TraditionalForm\`\[Tau]\_i\)]],
  " then \n\t\t(b1) make ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " a CFLP variable \n\t\t(b2) declare ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " of type ",
  Cell[BoxData[
      \(TraditionalForm\`\[Tau]\_i\)]],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[SetVariables]; \n
    SetVariables[l_List] := Join@@\ \(SetVariables\ /@\ l\); \n
    SetVariables[v_Symbol] := \n\t
      Block[{}, \n\t\tAttributes[v] = {Temporary}; \n\t\t{v}]; \n
    SetVariables[f_[v_, \[Tau]_]] /; \((f === Pattern)\) := \n\t
      Block[{}, \n\t\tAttributes[v] = {Temporary}; \n\t\t
        If[\(! IsTyped[v]\), \n\t\t\t
          Type[v] = 
            FormTypeExpr[{}, \[Tau] //. {ShortRightArrow \[Rule] FuncType}]]; 
        \n\t\t{v}]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearVariables", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tClearVariables[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta list of CFLP variables, possibly type annotated\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "undeclare the variables ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x\_n\),
            FontSlant->"Italic"], "."}], TraditionalForm]]],
  " If option ",
  StyleBox["KeepVarTypes\[Rule]True",
    FontWeight->"Bold"],
  " is specified then the type associated to the variable is not removed."
}], "Text",
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[ClearVariables]; \n
    Options[ClearVariables] := {KeepVarTypes \[Rule] False}; \n
    ClearVariables[v_Symbol, b_Symbol] := \n\t
      If[IsVar[v], \n\t\tIf[\(! b\), EraseType[v]]; \n\t\t
        Attributes[v] = {}; {v}, \n\t\t{}]; \n
    ClearVariables[e_Pattern, b_Symbol] := \n\t
      Block[{v = Head[e]}, \n\t\t
        If[IsVar[v], \n\t\t\tIf[\(! b\), EraseType[v]]; \n\t\t\t
          Attributes[v] = {}; {v}, \n\t\t\t{}]\n\t]; \n
    ClearVariables[v_List, opts___Rule] := 
      Join\ @@\ Map[
          ClearVariables[#, 
              \(KeepVarTypes /. {opts}\) /. Options[ClearVariables]]&, v]; \n
    ClearVariables[v_, opts___Rule] := \n\t
      ClearVariables[v, 
        \(KeepVarTypes /. {opts}\) /. Options[ClearVariables]]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell["<<Variables.m", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetVariables[{x : Bool, y : Int}]\)], "Input"],

Cell[BoxData[
    \({x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetType[x]\)], "Input"],

Cell[BoxData[
    \(Bool\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsVar[x]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearVariables[x, KeepVarTypes -> False]\)], "Input"],

Cell[BoxData[
    \({x}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsVar[x]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetType[x]\)], "Input"],

Cell[BoxData[
    \(Symb\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearVariables[y, KeepVarTypes -> True]\)], "Input"],

Cell[BoxData[
    \({y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetType[y]\)], "Input"],

Cell[BoxData[
    \(Int\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IsVar[y]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetVariables[{y : Float}]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{727, 513},
WindowMargins->{{Automatic, -20}, {-60, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 65, 1, 102, "Title"],
Cell[1799, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2021, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2088, 66, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4451, 111, 39, 0, 53, "Subtitle"],
Cell[4493, 113, 291, 9, 50, "Text"],
Cell[4787, 124, 207, 5, 27, "Input",
  InitializationCell->True],
Cell[4997, 131, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5153, 138, 27, 0, 45, "Subsection"],
Cell[5183, 140, 179, 4, 27, "Input",
  InitializationCell->True],
Cell[5365, 146, 215, 5, 43, "Input",
  InitializationCell->True],
Cell[5583, 153, 219, 5, 43, "Input",
  InitializationCell->True],
Cell[5805, 160, 206, 5, 27, "Input",
  InitializationCell->True],
Cell[6014, 167, 230, 5, 43, "Input",
  InitializationCell->True],
Cell[6247, 174, 225, 5, 43, "Input",
  InitializationCell->True],
Cell[6475, 181, 196, 5, 27, "Input",
  InitializationCell->True],
Cell[6674, 188, 196, 5, 27, "Input",
  InitializationCell->True],
Cell[6873, 195, 196, 5, 27, "Input",
  InitializationCell->True],
Cell[7072, 202, 290, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7411, 214, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7470, 218, 38, 0, 45, "Subsection"],
Cell[7511, 220, 622, 23, 158, "Text"],

Cell[CellGroupData[{
Cell[8158, 247, 125, 3, 42, "Subsubsection"],
Cell[8286, 252, 211, 4, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8546, 262, 24, 0, 54, "Section"],
Cell[8573, 264, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[8759, 271, 148, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8932, 278, 29, 0, 45, "Subsection"],
Cell[8964, 280, 498, 20, 86, "Text"],

Cell[CellGroupData[{
Cell[9487, 304, 125, 3, 42, "Subsubsection"],
Cell[9615, 309, 125, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9789, 318, 30, 0, 45, "Subsection"],
Cell[9822, 320, 499, 20, 86, "Text"],

Cell[CellGroupData[{
Cell[10346, 344, 125, 3, 42, "Subsubsection"],
Cell[10474, 349, 148, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10671, 358, 27, 0, 45, "Subsection"],
Cell[10701, 360, 790, 37, 140, "Text"],

Cell[CellGroupData[{
Cell[11516, 401, 125, 3, 42, "Subsubsection"],
Cell[11644, 406, 223, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11916, 417, 25, 0, 45, "Subsection"],
Cell[11944, 419, 775, 33, 122, "Text"],

Cell[CellGroupData[{
Cell[12744, 456, 125, 3, 42, "Subsubsection"],
Cell[12872, 461, 399, 9, 91, "Input",
  InitializationCell->True],
Cell[13274, 472, 133, 3, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13456, 481, 34, 0, 45, "Subsection"],
Cell[13493, 483, 2167, 85, 230, "Text"],

Cell[CellGroupData[{
Cell[15685, 572, 125, 3, 42, "Subsubsection"],
Cell[15813, 577, 570, 12, 203, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16432, 595, 36, 0, 45, "Subsection"],
Cell[16471, 597, 690, 26, 104, "Text"],
Cell[17164, 625, 608, 19, 50, "Text"],
Cell[17775, 646, 465, 19, 50, "Text"],

Cell[CellGroupData[{
Cell[18265, 669, 125, 3, 42, "Subsubsection"],
Cell[18393, 674, 851, 18, 299, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19305, 699, 22, 0, 54, "Section"],
Cell[19330, 701, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[19499, 708, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[19632, 713, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19842, 723, 31, 0, 54, "Section"],
Cell[19876, 725, 30, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[19931, 729, 66, 1, 27, "Input"],
Cell[20000, 732, 40, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20077, 738, 43, 1, 27, "Input"],
Cell[20123, 741, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20198, 747, 41, 1, 27, "Input"],
Cell[20242, 750, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20317, 756, 73, 1, 27, "Input"],
Cell[20393, 759, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20467, 765, 41, 1, 27, "Input"],
Cell[20511, 768, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20587, 774, 43, 1, 27, "Input"],
Cell[20633, 777, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20708, 783, 72, 1, 27, "Input"],
Cell[20783, 786, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20857, 792, 43, 1, 27, "Input"],
Cell[20903, 795, 37, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20977, 801, 41, 1, 27, "Input"],
Cell[21021, 804, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21097, 810, 58, 1, 27, "Input"],
Cell[21158, 813, 36, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

