(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43794,       1627]*)
(*NotebookOutlinePosition[     44628,       1656]*)
(*  CellTagsIndexPosition[     44584,       1652]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Types", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains commands for handling types. ", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Types`\>", {"\<TypeSyntax`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Arity::usage = "\<\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewTyVar::usage = "\<NewTyVar[] creates a fresh type variable.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TypeConstructor::usage = 
      "\<TypeConstructor[constr1, constr2, \[Ellipsis] ] declares the symbols \
constr1, constr2, \[Ellipsis] as type constructors.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(FormTypeExpr::usage = 
      \*"\"\<FormTypeExpr[type-vars, type] yields the encoding of the \
polymorphic type \!\(\[ForAll] \_\(type - vars\)\) type.\>\""; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DeclareType::usage = 
      "\<DeclareType[symb,type] assigns the encoding of the polymorphic type \
specified by type to the value of Type[symb], and yields the list {symb}.\>"\ \
; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EraseType::usage = 
      "\<EraseType[symbol1, symbol2, \[Ellipsis] ] clears types for the \
symboli.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TyVars::usage = 
      "\<TyVars[type] picks out all type variables of type, i.e. all symbols \
which are not type constructors\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefaultExternal::usage 
      "\<DefaultExternal[] sets the default signatures of external \
symbols.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsTyped::usage = 
      "\<IsTyped[symb] yields True if symb is a typed operator or a typed \
variable, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunType::usage = 
      "\<IsFunType[type] yields True if type is a function type, and yields \
False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunOnCPType::usage = 
      "\<IsFunOnCPType[type] yields True if type is a function type defined \
on a Cartesian product, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Bool::usage = 
      "\<Bool denotes the type of booleans with the constants True and False.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Int::usage = "\<Int denotes the type of integers.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Rat::usage = "\<Rat denotes the type of rational numbers.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Float::usage = "\<Float denotes the type of real numbers.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Compl::usage = "\<Compl denotes the Complex type.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Symb::usage = "\<Symb is the CFLP type of an undeclared symbol.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Strings::usage = 
      "\<Strings is the CFLP type of a Mathematica string.\>"; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\[EmptySquare]::usage = 
      "\<\[EmptySquare] denotes the void type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\[WatchIcon]::usage = 
      "\<\[WatchIcon] forces the scheduler to start processing the \
constraints collected so far.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TYPE::usage = "\<TYPE is the type of type constructors.\>"\ ; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(RULE::usage = "\<RULE is the type of CFLP rewrite rules.\>"\ ; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(GetType::usage = 
      "\<GetType[s] returns the type of `s`. `s` is defined for Mathematica \
atoms.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefaultTypes::usage = 
      "\<DefaultTypes[] sets the default types for the CFLP literals.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(ShortRightArrow::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Type::usage = 
      "\<Type[symb][ ] yields a valid type instance of the type of symbol \
symb.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TypeCheck::usage = 
      "\<TypeCheck is an option to TSolve. With TypeCheck->True, type \
checking is imposed on the specified CRRs of a Def or TSolve call, and on the \
goal of a TSolve call. With TypeCheck->False, the decision to perform type \
checking is determined by the default option of TSolve.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions for handling external operators", "Section"],

Cell[CellGroupData[{

Cell["External", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tExternal[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox["typed\[Dash]symbol",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "a sequence of type-annotated symbols. A type annotated symbol is an \
expression of one of the forms:\n",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau] \n",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau] \n\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau] \n",
    FontWeight->"Bold"],
  "where ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "symbol and ",
  StyleBox["\[Tau],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  " are type expressions. The last two forms denote the same thing."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list of ",
  StyleBox["newly",
    FontSlant->"Italic"],
  " ",
  StyleBox["typed",
    FontSlant->"Italic"],
  " symbols. A  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " will be ",
  StyleBox["newly typed",
    FontSlant->"Italic"],
  " if:\n\t(a) a type-annotated expression for ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " appears in the ",
  StyleBox["External",
    FontWeight->"Bold"],
  " call. \n\t(b) ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " was not subject to a previous ",
  StyleBox["TypeConstructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Constructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DefinedSymbol",
    FontWeight->"Bold"],
  " or ",
  StyleBox["External",
    FontWeight->"Bold"],
  " declaration."
}], "Text"],

Cell[TextData[StyleBox["Effect",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  "For every argument of the form ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". For every argument ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " or ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" \[Cross] \[CenterEllipsis] \[Cross] \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Also, define ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " as external operator by defining ",
  StyleBox["IsExternal[ ",
    FontWeight->"Bold"],
  StyleBox["op ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]:=True",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[StyleBox["Note",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  StyleBox["External",
    FontWeight->"Bold"],
  " is not intended for the user but for the system developer. Therefore it \
is not visible outside the package. "
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[External]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(External[p_[f_, \[Tau]_]] /; \((p === Pattern)\) := \n\t
      Block[{\[Tau]1}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        IsExternal[f] = True; \n\t\t
        DeclareType[{f, \[Tau] //. {ShortRightArrow \[Rule] FuncType}} /. {
              List \[Rule] Pattern}]; \n\t\t
        If[IsFunType[\[Tau]], \n\t\t\t
          \[Tau]1 = \[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket]; \n\t\t\t
          If[\[Tau]1 === \[EmptySquare], \n\t\t\t\tArity[f] = 0, \n\t\t\t\t
            Arity[f] = If[Head[\[Tau]1] === Cross, Length[\[Tau]1], 1]\n
            \t\t\t], \n\t\t\tArity[f] = 0\n\t\t]; {f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(External[\[Tau]1_ \[ShortRightArrow] \[Tau]2_] := \n\t
      Block[{f = Head[\[Tau]1]}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        Arity[f] = Length[\[Tau]1 /. {f[\[EmptySquare]] :> f[]}]; \n\t\t
        IsExternal[f] = True; \n\t\t
        If[Arity[f] \[LessEqual] 1, \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[
                    \((\[Tau]1 /. {f[] :> f[\[EmptySquare]]})
                        \)\[LeftDoubleBracket]1\[RightDoubleBracket], 
                    \[Tau]2]} //. {ShortRightArrow \[Rule] FuncType}\) /. {
                List \[Rule] Pattern}], \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[Apply[Cross\ , \[Tau]1], \[Tau]2]} //. {
                  ShortRightArrow \[Rule] FuncType}\) /. {
                List \[Rule] Pattern}]\n\t\t]; \n\t\t{f}\n\t]; \)\)], "Input",\

  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(External[e_] /; Head[e] =!= Pattern := {}; \n
    External[es___] := Join\ @@\ \(External\ /@\ {es}\); \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefaultExternal", "Subsection"],

Cell["\<\
This call initializes the CFLP recognizer for external operators.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(DefaultExternal[] := \n\t
      External[\n\t\t\[WatchIcon] : Bool, \n\t\t
        Plus : Compl\[Cross]Compl \[ShortRightArrow] Compl, \n\t\t
        Times : Compl\[Cross]Compl \[ShortRightArrow] Compl, \n\t\t
        Power : Compl\[Cross]Compl \[ShortRightArrow] Compl, \n\t\t
        Sin : Compl \[ShortRightArrow] Compl, \n\t\t
        Cos : Compl \[ShortRightArrow] Compl, \n\t\t\ 
        Tan : Compl \[ShortRightArrow] Compl, \n\t\t
        And : Bool\[Cross]Bool \[ShortRightArrow] Bool, \n\t\t
        Or : Bool\[Cross]Bool \[ShortRightArrow] Bool, \n\t\t
        Greater : Float\[Cross]Float \[ShortRightArrow] Bool, \n\t\t
        GreaterEqual : Float\[Cross]Float \[ShortRightArrow] Bool, \n\t\t
        Less : Float\[Cross]Float \[ShortRightArrow] Bool, \n\t\t
        LessEqual : Float\[Cross]Float \[ShortRightArrow] Bool, \n\t\t
        Pi : Float, \n\t\tNot : Bool \[ShortRightArrow] Bool]; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions for handling type expressions", "Section"],

Cell[CellGroupData[{

Cell["NewTyVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNewTyVar",
    FontWeight->"Bold"],
  "[ ",
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a fresh type variable"
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(NewTyVar\  := \ Function[Module[{Global`\[Alpha]}, Global`\[Alpha]]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["DefaultTypes", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefaultTypes[ ",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]\n",
    FontWeight->"Bold"],
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "Define the default types of ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " literals"
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(Clear[DefaultTypes]; \n
    DefaultTypes[] := 
      \((\n\t\t\(Type[_Symbol]\)[] = {{}, Symb}; \n\t\t
        \(Type[_Integer]\)[] = {{}, Int}; \n\t\t
        \(Type[_Complex]\)[] = {{}, Compl}; \n\t\t
        \(Type[_Rational]\)[] = {{}, Rat}; \n\t\t
        \(Type[_Real]\)[] = {{}, Float}; \n\t\t
        \(Type[_String]\)[] = {{}, Strings}\n\t)\); \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tGetType[ op ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol or literal.\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "The CFLP type that is currently attached to ",
  StyleBox["op",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(Clear[GetType]; \nGetType[s_] := Last[\(Type[s]\)[]]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["TypeConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTypeConstructor",
    FontWeight->"Bold"],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "]\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a sequence  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the list {  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "}\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " as type constructors by extending the initial definition of ",
  StyleBox["IsTypeConstructor",
    FontWeight->"Bold"],
  ".",
  StyleBox["\n\t",
    FontWeight->"Bold"],
  "declare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " as constructors by extending the default definition of ",
  StyleBox["IsConstructor",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[TypeConstructor]; \n
    TypeConstructor[c_Symbol] := \n\t
      Block[{}, \n\t\tIsTypeConstructor[c] = True; \n\t\t
        IsConstructor[c] = True; {c}\n\t]; \nTypeConstructor[_] := {}; \n
    TypeConstructor[cs__Symbol] := Join\ @@\ \(TypeConstructor\ /@\ {cs}\); 
    \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["IsTyped", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsTyped[ ",
    FontWeight->"Bold"],
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a typed symbol, i.e. a typed variable or a typed operator\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[IsTyped]; \n
    IsTyped[x_]\  := \ 
      \(Type[x]\)\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Type; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["TyVars",
  FontWeight->"Bold"]], "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTyVars[\[Tau]]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a type expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the set ",
  Cell[BoxData[
      \({\[Alpha]\_1,  ... , \[Alpha]\_n}\)]],
  "of type variables appearing in ",
  StyleBox["\[Tau];\n\t",
    FontWeight->"Bold"],
  "type variable is any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol which is not a declared type constructor"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(TyVars[\[Tau]_] := 
      Union\ [Cases[{\[Tau]}, _Symbol?\((Not[IsTypeConstructor[#]]&)\), 
          \(-1\)]]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormTypeExpr", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["FormTypeExpr[ type\[Dash]vars, \[Tau] ] ",
    FontWeight->"Bold"],
  StyleBox["\t\nInput\n\ttype\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a list ",
  Cell[BoxData[
      \({\[Alpha]\_1,  ... , \[Alpha]\_n}\)]],
  " of type variables\n\t",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : a type expression",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "the CFLP encoding ",
  StyleBox["F",
    FontWeight->"Bold"],
  " of the polymorphic type",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \_type\[Dash]vars\)],
    FontWeight->"Bold"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  ".\nThe characteristic property of ",
  StyleBox["F",
    FontWeight->"Bold"],
  " is: every call F[ ] returns a pair {",
  StyleBox["type\[Dash]vars', \[Tau]'}",
    FontWeight->"Bold"],
  ", where:\n",
  StyleBox["type\[Dash]vars'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  Cell[BoxData[
      \(set\ {\[Alpha]\_1',  ... , \[Alpha]\_n'}\ \ of\ \ fresh\ type\ 
        variables\)]],
  "\n",
  StyleBox["\[Tau]'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " = ",
  StyleBox["\[Tau] \[Sigma],",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " where ",
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  "=",
  Cell[BoxData[
      \({\[Alpha]\_1 \[RightTeeArrow] \[Alpha]\_1',  ... , 
        \[Alpha]\_n \[RightTeeArrow] \[Alpha]\_n'}\)]]
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(FormTypeExpr[type\[Dash]vars_List, \[Tau]_] := \n\t
      Function[{}, \n\t\tModule[type\[Dash]vars, {type\[Dash]vars, \[Tau]}]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["DeclareType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDeclareType[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[", ... ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tA sequence of type signatures  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ",
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["\[Tau]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["i",
              FontWeight->"Bold"]]}], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "The list {",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ",. .. ,",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "} of declared function symbols\n",
  StyleBox["Side Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "assign the (polymorphic) type ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \)]],
  Cell[BoxData[
      \(TraditionalForm\`\[Tau]\_i\)]],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[DeclareType]; \n
    DeclareType[e_Pattern] := \n\t
      Block[{f = e\[LeftDoubleBracket]1\[RightDoubleBracket], 
          \[Tau] = e\[LeftDoubleBracket]2\[RightDoubleBracket]}, \n\t\t
        If[IsTyped[f], Print["\<Type of \>", \ f, \ "\< already defined\>"], 
          \n\t\t\tType[f] = FormTypeExpr[TyVars[\[Tau]], \[Tau]]]; {f}\n\t]; 
    \nDeclareType[fs___Pattern] := Join\ @@\ \(DeclareType\ /@\ {fs}\); \n
    DeclareType[fs___] := 
      \((Print["\<Warning: DeclareType: wrong syntax call\>"]; {})\); \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["EraseType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tEraseType[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  StyleBox[", ... ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tA sequence of symbols  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "  ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "remove the  type information  attached to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(EraseType[x_Symbol] := If[IsTyped[x], Type[x] =. ]; \n
    EraseType[e_Pattern]\  := \n\t
      Block[{x = e\[LeftDoubleBracket]1\[RightDoubleBracket]}, \n\t\t
        If[\((Head[x] === Symbol)\) \[And] IsTyped[x], \n\t\tType[x] =. ]\n
        \t]; \nEraseType[xs___]\  := Scan[EraseType, {xs}]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["IsTypeConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsTypeConstructor[ ",
    FontWeight->"Bold"],
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a declared type constructor\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsTypeConstructor[
        Bool | Int | Rat | Float | Compl | Symb | Strings | \[EmptySquare] | 
          TyList | FuncType | Cross | TYPE | RULE] := True; \n
    IsTypeConstructor[_] := False; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsFunType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunType[ \[Tau]",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : a type expression",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  "  is of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["\[RightArrow]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold"], 
          StyleBox["2",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "(i.e. a function type)\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsFunType[\[Tau]_FuncType | \[Tau]_ShortRightArrow] := True; \n
    IsFunType[_] := False; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["IsFunOnCPType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunOnCPType[ \[Tau] ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : a type expression",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  "  is of the form  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  " \[Cross] \[CenterEllipsis] \[Cross] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "n"], TraditionalForm]]],
  "\[ShortRightArrow] ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Tau]'\),
          FontWeight->"Bold"], TraditionalForm]]],
  " ( i.e. a Cartesian product)\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(IsFunOnCPType[\[Tau]_] := \ 
      And[IsFunType[\[Tau]], 
        \[Tau]\[LeftDoubleBracket]1, 0\[RightDoubleBracket] === Cross]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Example", "Section"],

Cell["<<Types.m", "Input"],

Cell["DefaultExternal[]", "Input"],

Cell[CellGroupData[{

Cell[TextData["IsFunType[a\[Cross]b\[ShortRightArrow]Int]"], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arity[e]", "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetType[d]\)], "Input"],

Cell[BoxData[
    \(Int \[ShortRightArrow] Int\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{727, 509},
WindowMargins->{{18, Automatic}, {-3, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 61, 1, 102, "Title"],
Cell[1795, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2017, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2084, 66, 2324, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4445, 111, 39, 0, 53, "Subtitle"],
Cell[4487, 113, 67, 0, 32, "Text"],
Cell[4557, 115, 153, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4735, 122, 27, 0, 45, "Subsection"],
Cell[4765, 124, 127, 3, 27, "Input",
  InitializationCell->True],
Cell[4895, 129, 176, 4, 27, "Input",
  InitializationCell->True],
Cell[5074, 135, 266, 5, 43, "Input",
  InitializationCell->True],
Cell[5343, 142, 264, 6, 44, "Input",
  InitializationCell->True],
Cell[5610, 150, 287, 6, 43, "Input",
  InitializationCell->True],
Cell[5900, 158, 211, 5, 27, "Input",
  InitializationCell->True],
Cell[6114, 165, 238, 5, 43, "Input",
  InitializationCell->True],
Cell[6355, 172, 210, 5, 43, "Input",
  InitializationCell->True],
Cell[6568, 179, 242, 5, 43, "Input",
  InitializationCell->True],
Cell[6813, 186, 225, 5, 43, "Input",
  InitializationCell->True],
Cell[7041, 193, 264, 5, 43, "Input",
  InitializationCell->True],
Cell[7308, 200, 203, 5, 27, "Input",
  InitializationCell->True],
Cell[7514, 207, 158, 3, 27, "Input",
  InitializationCell->True],
Cell[7675, 212, 169, 4, 27, "Input",
  InitializationCell->True],
Cell[7847, 218, 169, 4, 27, "Input",
  InitializationCell->True],
Cell[8019, 224, 158, 3, 27, "Input",
  InitializationCell->True],
Cell[8180, 229, 177, 4, 27, "Input",
  InitializationCell->True],
Cell[8360, 235, 187, 5, 27, "Input",
  InitializationCell->True],
Cell[8550, 242, 182, 4, 27, "Input",
  InitializationCell->True],
Cell[8735, 248, 232, 5, 27, "Input",
  InitializationCell->True],
Cell[8970, 255, 169, 4, 27, "Input",
  InitializationCell->True],
Cell[9142, 261, 170, 4, 27, "Input",
  InitializationCell->True],
Cell[9315, 267, 213, 5, 43, "Input",
  InitializationCell->True],
Cell[9531, 274, 206, 5, 27, "Input",
  InitializationCell->True],
Cell[9740, 281, 128, 3, 27, "Input",
  InitializationCell->True],
Cell[9871, 286, 207, 5, 27, "Input",
  InitializationCell->True],
Cell[10081, 293, 413, 7, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10543, 306, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[10602, 310, 24, 0, 54, "Section"],
Cell[10629, 312, 128, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10794, 320, 60, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[10879, 324, 162, 5, 45, "Subsection",
  Evaluatable->False],
Cell[11044, 331, 440, 17, 68, "Text"],
Cell[11487, 350, 1650, 61, 104, "Text"],
Cell[13140, 413, 1065, 47, 86, "Text"],
Cell[14208, 462, 87, 2, 32, "Text"],
Cell[14298, 466, 2020, 81, 50, "Text"],
Cell[16321, 549, 85, 2, 32, "Text"],
Cell[16409, 553, 283, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[16717, 564, 125, 3, 42, "Subsubsection"],
Cell[16845, 569, 200, 6, 27, "Input",
  InitializationCell->True],
Cell[17048, 577, 826, 16, 235, "Input",
  InitializationCell->True],
Cell[17877, 595, 1036, 22, 219, "Input",
  InitializationCell->True],
Cell[18916, 619, 282, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19247, 632, 37, 0, 45, "Subsection"],
Cell[19287, 634, 91, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[19403, 641, 125, 3, 42, "Subsubsection"],
Cell[19531, 646, 1013, 18, 283, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20605, 671, 58, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[20688, 675, 30, 0, 45, "Subsection"],
Cell[20721, 677, 314, 14, 86, "Text"],

Cell[CellGroupData[{
Cell[21060, 695, 83, 2, 42, "Subsubsection"],
Cell[21146, 699, 179, 4, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21374, 709, 34, 0, 29, "Subsection"],
Cell[21411, 711, 469, 19, 86, "Text"],

Cell[CellGroupData[{
Cell[21905, 734, 83, 2, 42, "Subsubsection"],
Cell[21991, 738, 532, 13, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22572, 757, 29, 0, 45, "Subsection"],
Cell[22604, 759, 566, 24, 122, "Text"],

Cell[CellGroupData[{
Cell[23195, 787, 83, 2, 42, "Subsubsection"],
Cell[23281, 791, 233, 6, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23563, 803, 37, 0, 29, "Subsection"],
Cell[23603, 805, 2603, 101, 176, "Text"],

Cell[CellGroupData[{
Cell[26231, 910, 125, 3, 42, "Subsubsection"],
Cell[26359, 915, 457, 11, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[26865, 932, 29, 0, 29, "Subsection"],
Cell[26897, 934, 846, 36, 140, "Text"],

Cell[CellGroupData[{
Cell[27768, 974, 125, 3, 42, "Subsubsection"],
Cell[27896, 979, 295, 9, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28240, 994, 70, 1, 29, "Subsection"],
Cell[28313, 997, 754, 29, 140, "Text"],

Cell[CellGroupData[{
Cell[29092, 1030, 125, 3, 42, "Subsubsection"],
Cell[29220, 1035, 296, 8, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29565, 1049, 34, 0, 29, "Subsection"],
Cell[29602, 1051, 571, 21, 122, "Text"],
Cell[30176, 1074, 1177, 43, 86, "Text"],

Cell[CellGroupData[{
Cell[31378, 1121, 125, 3, 42, "Subsubsection"],
Cell[31506, 1126, 247, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[31802, 1137, 33, 0, 29, "Subsection"],
Cell[31838, 1139, 3011, 113, 160, "Text"],

Cell[CellGroupData[{
Cell[34874, 1256, 125, 3, 42, "Subsubsection"],
Cell[35002, 1261, 703, 15, 139, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35754, 1282, 31, 0, 29, "Subsection"],
Cell[35788, 1284, 1552, 59, 122, "Text"],

Cell[CellGroupData[{
Cell[37365, 1347, 125, 3, 42, "Subsubsection"],
Cell[37493, 1352, 475, 10, 123, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[38017, 1368, 39, 0, 29, "Subsection"],
Cell[38059, 1370, 826, 36, 140, "Text"],

Cell[CellGroupData[{
Cell[38910, 1410, 125, 3, 42, "Subsubsection"],
Cell[39038, 1415, 374, 9, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39461, 1430, 31, 0, 45, "Subsection"],
Cell[39495, 1432, 1240, 51, 140, "Text"],

Cell[CellGroupData[{
Cell[40760, 1487, 125, 3, 42, "Subsubsection"],
Cell[40888, 1492, 270, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[41207, 1505, 35, 0, 29, "Subsection"],
Cell[41245, 1507, 1192, 46, 140, "Text"],

Cell[CellGroupData[{
Cell[42462, 1557, 125, 3, 42, "Subsubsection"],
Cell[42590, 1562, 319, 9, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42970, 1578, 22, 0, 34, "Section"],
Cell[42995, 1580, 111, 3, 27, "Input",
  InitializationCell->True],
Cell[43109, 1585, 118, 3, 27, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[43264, 1593, 34, 0, 34, "Section"],
Cell[43301, 1595, 26, 0, 27, "Input"],
Cell[43330, 1597, 34, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[43389, 1601, 69, 0, 27, "Input"],
Cell[43461, 1603, 38, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43536, 1609, 25, 0, 27, "Input"],
Cell[43564, 1611, 35, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43636, 1617, 43, 1, 27, "Input"],
Cell[43682, 1620, 60, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

