(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10789,        334]*)
(*NotebookOutlinePosition[     11596,        362]*)
(*  CellTagsIndexPosition[     11552,        358]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Type Syntax", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NO WARRANTY"]], "Subsubsection",
  InitializationCell->True],

Cell[TextData[StyleBox[
"The program was produced on an experimental basis in the\ncourse of the \
research and development conducted during the project\nand is provided to \
users as so produced on an experimental basis.\nAccordingly, the program is \
provided without any warranty whatsoever,\nwhether express, implied, \
statutory or otherwise. The term \"warranty\"\nused herein includes, but is \
not limited to, any warranty of the\nquality, performance, merchantability \
and fitness for a particular\npurpose of the program and the nonexistence of \
any infringement or\nviolation of any right of any third party.\n\nEach user \
of the program will agree and understand, and be\ndeemed to have agreed and \
understood, that there is no warranty\nwhatsoever for the program and, \
accordingly, the entire risk arising\nfrom or otherwise connected with the \
program is assumed by the user.\n\nTherefore, neither ICOT, the copyright \
holder, or any other\norganization that participated in or was otherwise \
related to the\ndevelopment of the program and their respective officials, \
directors,\nofficers and other employees shall be held liable for any and all\
\ndamages, including, without limitation, general, special, incidental\nand \
consequential damages, arising out of or otherwise in connection\nwith the \
use or inability to use the program or any product, material\nor result \
produced or otherwise obtained by using the program,\nregardless of whether \
they have been advised of, or otherwise had\nknowledge of, the possibility of \
such damages at any time during the\nproject or thereafter. Each user will be \
deemed to have agreed to the\nforegoing by his or her commencement of use of \
the program. The term\n\"use\" as used herein includes, but is not limited \
to, the use,\nmodification, copying and distribution of the program and the\n\
production of secondary products from the program.\n\nIn the case where the \
program, whether in its original form or\nmodified, was distributed or \
delivered to or received by a user from\nany person, organization or entity \
other than ICOT, unless it makes or\ngrants independently of ICOT any \
specific warranty to the user in\nwriting, such person, organization or \
entity, will also be exempted\nfrom and not be held liable to the user for \
any such damages as noted\nabove as far as the program is concerned."]], 
  "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains syntax definitions for type expressions and \
type signatures.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TypeSyntax`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Arity::usage = 
      "\<Arity[symb] yields the arity of the typed symbol symb.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(FuncType::usage = 
      "\<FuncType[type1,type2] is the full form representation of the type \
expression type1 \[ShortRightArrow] type2\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TyList::usage = 
      "\<TyList[type] is the type of CFLP lists with elements of type \
type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsTypeConstructor::usage = 
      "\<IsTypeConstructor[term] yields True if term is a type constructor, \
and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsConstructor::usage = 
      "\<IsConstructor[term] yields True if term is a constructor, and yields \
False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsDefinedSymbol::usage = 
      "\<IsDefinedSymbol[symb] yields True if symb is a defined symbol, and \
yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsExternal::usage = 
      "\<IsExternal[symb] yields True if symb is declared as external symbol, \
and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunctionSymbol::usage = 
      "\<IsFunctionSymbol[symb] yields True if symb is a
		declared constructor/defined symbol/external operator, and yields False \
otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsDeclared::usage = "\<IsDeclared[symb] yields True if symb is a
		declared constructor/defined symbol/external operator, and yields False \
otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TyList::usage = 
      "\<TyList[type] is the type of CFLP lists with elements of type \
type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPCopyright::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["CFLPCopyright", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[PrintCopyrightMessage]; \n
    PrintCopyrightMessage[] := \n\t
      Print["\<Copyright 1998-1999 Institute RISC-Linz and Institute of \
Information Sciences and Electronics, Tsukuba.\>"]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(If[CFLPCopyright =!= True, \n\tAttributes[CFLPCopyright] = {}; \n\t
      CFLPCopyright = True; \n\tAttributes[CFLPCopyright] = {Protected}; \n\t
      PrintCopyrightMessage[]\n]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
IsTypeConstructor, 
IsConstructor,
IsDefinedSymbol,
IsFunctionSymbol, 
IsExternal, 
IsDeclared\
\>", "Subsection"],

Cell[TextData[{
  "These are the definitions of the initial recognizer for type constructors, \
constructors, defined symbols and external operators over the signature ",
  StyleBox["F=F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]],
  StyleBox["\[Union] F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_d\)]],
  StyleBox["\[Union] F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_e\)]],
  " of CFLP."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsTypeConstructor[_] := False; \nIsConstructor[_] := False; \n
    IsDefinedSymbol[_] := False; \nIsExternal[_] := False; \n
    IsFunctionSymbol[f_] := 
      Or[IsConstructor[f], IsDefinedSymbol[f], IsExternal[f]]; \n
    IsDeclared = IsFunctionSymbol; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FuncType", "Subsection"],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(FuncType\  /: \ 
      MakeBoxes[FuncType[\[Tau]1_, \ \[Tau]2_], \ StandardForm]\  := \n
      RowBox[\ {MakeBoxes[\[Tau]1, \ StandardForm], \n\ 
          "\<\[ShortRightArrow]\>", \ MakeBoxes[\[Tau]2, \ StandardForm]}\ ]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{716, 408},
WindowMargins->{{Automatic, -28}, {Automatic, 37}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 67, 1, 102, "Title"],
Cell[1801, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2023, 63, 84, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2110, 66, 2437, 33, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4584, 104, 39, 0, 53, "Subtitle"],
Cell[4626, 106, 108, 3, 32, "Text"],
Cell[4737, 111, 192, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4954, 120, 27, 0, 45, "Subsection"],
Cell[4984, 122, 191, 5, 27, "Input",
  InitializationCell->True],
Cell[5178, 129, 248, 5, 43, "Input",
  InitializationCell->True],
Cell[5429, 136, 205, 5, 27, "Input",
  InitializationCell->True],
Cell[5637, 143, 244, 5, 43, "Input",
  InitializationCell->True],
Cell[5884, 150, 231, 5, 43, "Input",
  InitializationCell->True],
Cell[6118, 157, 238, 5, 43, "Input",
  InitializationCell->True],
Cell[6359, 164, 239, 5, 43, "Input",
  InitializationCell->True],
Cell[6601, 171, 281, 6, 43, "Input",
  InitializationCell->True],
Cell[6885, 179, 262, 5, 43, "Input",
  InitializationCell->True],
Cell[7150, 186, 205, 5, 27, "Input",
  InitializationCell->True],
Cell[7358, 193, 126, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7533, 202, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7592, 206, 24, 0, 54, "Section"],
Cell[7619, 208, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7772, 215, 35, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[7832, 219, 125, 3, 42, "Subsubsection"],
Cell[7960, 224, 295, 6, 75, "Input",
  InitializationCell->True],
Cell[8258, 232, 284, 5, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8591, 243, 124, 7, 130, "Subsection"],
Cell[8718, 252, 564, 19, 50, "Text"],

Cell[CellGroupData[{
Cell[9307, 275, 125, 3, 42, "Subsubsection"],
Cell[9435, 280, 355, 7, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9839, 293, 30, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[9894, 297, 43, 0, 42, "Subsubsection"],
Cell[9940, 299, 333, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10334, 313, 22, 0, 54, "Section"],
Cell[10359, 315, 190, 6, 27, "Input",
  InitializationCell->True],
Cell[10552, 323, 197, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

