(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28366,        913]*)
(*NotebookOutlinePosition[     29060,        938]*)
(*  CellTagsIndexPosition[     29016,        934]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Type Checker", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell[TextData[StyleBox[
"The program was produced on an experimental basis in the\ncourse of the \
research and development conducted during the project\nand is provided to \
users as so produced on an experimental basis.\nAccordingly, the program is \
provided without any warranty whatsoever,\nwhether express, implied, \
statutory or otherwise. The term \"warranty\"\nused herein includes, but is \
not limited to, any warranty of the\nquality, performance, merchantability \
and fitness for a particular\npurpose of the program and the nonexistence of \
any infringement or\nviolation of any right of any third party.\n\nEach user \
of the program will agree and understand, and be\ndeemed to have agreed and \
understood, that there is no warranty\nwhatsoever for the program and, \
accordingly, the entire risk arising\nfrom or otherwise connected with the \
program is assumed by the user.\n\nTherefore, neither ICOT, the copyright \
holder, or any other\norganization that participated in or was otherwise \
related to the\ndevelopment of the program and their respective officials, \
directors,\nofficers and other employees shall be held liable for any and all\
\ndamages, including, without limitation, general, special, incidental\nand \
consequential damages, arising out of or otherwise in connection\nwith the \
use or inability to use the program or any product, material\nor result \
produced or otherwise obtained by using the program,\nregardless of whether \
they have been advised of, or otherwise had\nknowledge of, the possibility of \
such damages at any time during the\nproject or thereafter. Each user will be \
deemed to have agreed to the\nforegoing by his or her commencement of use of \
the program. The term\n\"use\" as used herein includes, but is not limited \
to, the use,\nmodification, copying and distribution of the program and the\n\
production of secondary products from the program.\n\nIn the case where the \
program, whether in its original form or\nmodified, was distributed or \
delivered to or received by a user from\nany person, organization or entity \
other than ICOT, unless it makes or\ngrants independently of ICOT any \
specific warranty to the user in\nwriting, such person, organization or \
entity, will also be exempted\nfrom and not be held liable to the user for \
any such damages as noted\nabove as far as the program is concerned."]], 
  "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[
"This package contains the implementation of the type checker used by the \
CFLP calculus. The type checker is based on the Hindley\[Dash]Milner type \
system."], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TypeChecker`\>", \n
      \t{"\<Calculus`\>", "\<TypeRules`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Tc::usage = 
      "\<Tc[term] yields the type of term if term is well typed, and yields \
\[UpTee] otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TcX::usage = 
      "\<TcX[term,type,type\[Dash]eqs,type\[Dash]vars] yields a pair {new\
\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term has type type and the type sharing equations type\[Dash]eqs in \
variables type\[Dash]vars hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TcXList::usage = 
      "\<TcXList[{term1,term2,\[Ellipsis]},{type1,type2,\[Ellipsis]},type\
\[Dash]eqs,type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term1 has type type1, term2 has type type2, \[Ellipsis], 
		and the type sharing equations type\[Dash]eqs in variables type\[Dash]vars \
hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(ListToCons::usage = 
      "\<ListToCons[term] substitutes in term all lists that are not formal \
arguments to \[Lambda]-terms with their corresponding CFLP encodings. The \
CFLP encoding of a list {a,b,\[Ellipsis],z} is \
Cons[a,Cons[\[Ellipsis],Cons[z,\[Bullet]]\[Ellipsis]]] with the wisual \
representation \[LeftAngleBracket]a,b,\[Ellipsis],z,\[Bullet]\
\[RightAngleBracket]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(WeakListToCons::usage = "\<\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(ToFormula::usage = 
      "\<ToFormula[goal] generates the CFLP formula which is represented by \
`goal`.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(KeepTypes::usage = 
      "\<KeepTypes is a valid option for Tc that specifies whether the types \
associated to variables should be removed or not.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = \n\t
      Join[\n\t\t{"\<Variables`\>", "\<TermSyntax`\>", "\<TypeSyntax`\>", \n
          \t\t\t"\<Types`\>", "\<RewriteRules`\>", "\<Terms`\>", 
          "\<Debug`\>"}, \n\t\t$ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Tc", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTc",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" , ",
    FontWeight->"Bold"],
  StyleBox["opts ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Input\n\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the type of  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  " if ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is well typed\n\t\"\[UpTee]\" otherwise\n",
  StyleBox["Side effect\n \tTc",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  recognizes the options ",
  StyleBox["KeepTypes \[Rule] True | False",
    FontWeight->"Bold"],
  " and ",
  StyleBox["TypedVars \[Rule] {\[Ellipsis]}",
    FontWeight->"Bold"],
  "\n \tDefault options are",
  StyleBox[" KeepTypes \[Rule] False",
    FontWeight->"Bold"],
  " and ",
  StyleBox["TypedVars \[Rule] {}\n \t",
    FontWeight->"Bold"],
  "If ",
  StyleBox["KeepTypes \[Rule] True ",
    FontWeight->"Bold"],
  " is specified and ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is well typed, then the types of variables and \n \toperators appearing \
in ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are instantiated accordingly; otherwise the types attached to \n \t\
operators and variables remain unchanged. "
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(Options[Tc] := {KeepTypes -> False, TypedVars \[Rule] {}}; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Tc[t_, opts___Rule]\  := \ \n\t
      Module[\n\t\t{sol, teqn, tV, oldV, \n\t\t\t$RecursionLimit = 8000, \n
          \t\t\tsaveType = DownValues[Type], \n\t\t\t
          oldLevel = Debug`$CFLPTraceLevel, \n\t\t\t\[Beta] = NewTyVar[], 
          keepType}, \n\t\toldV = Var[t]; \n
        \t\t{tV, keepType} = 
          \({TypedVars, KeepTypes} /. {opts}\) /. Options[Tc]; \n\t\t
        SetVariables[tV]; \n
        \t\t{teqn, tV} = TcX\ [t, \[Beta], {}, {\[Beta]}]; \n\t\t
        TSolveRules = cflpTypeRules; \n\t\tTcCall = True; \n\t\t
        sol = CallTSolve[teqn, tV, {}, 2]; \n\t\t
        If[sol =!= {}, \n\t\t\t
          If[keepType, \n\t\t\t\t
            DownValues[Type] = 
              DownValues[Type] /. 
                sol\[LeftDoubleBracket]1\[RightDoubleBracket], \n\t\t\t\t
            ClearVariables[tV, KeepVarTypes -> False]; \n\t\t\t\t
            SetVariables[oldV]; \n\t\t\t\tDownValues[Type] = saveType; \n
            \t\t\t]; \n\t\t\t
          \[Beta] /. sol\[LeftDoubleBracket]1\[RightDoubleBracket], \n\t\t\t
          ClearVariables[tV]; \n\t\t\tSetVariables[oldV]; \n\t\t\t
          "\<\[UpTee]\>"\n\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TcX", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTcX",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  \[Tau] ",
    FontWeight->"Bold"],
  ",  ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[":",
    FontWeight->"Bold"],
  " a CFLP term\n",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : the expected type of ",
  StyleBox["term\ntype\[Dash]expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a list of equalities representing the type sharing constraints \
collected so far\n",
  StyleBox["type",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\[Dash]",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of type variables appearing in ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[StyleBox["Output",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  "a pair  ",
  StyleBox["{",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["', ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["'}",
    FontWeight->"Bold"],
  "  such that:\n",
  StyleBox["type-eqs'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "=",
  StyleBox["type\[Dash]eqs\[Union]type\[Dash]eqs''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["type\[Dash]eqs''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are the type\[Dash]sharing constraints that were generated by imposing \
type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ",\n",
  StyleBox["type\[Dash]vars'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "=",
  StyleBox["type\[Dash]vars\[Union]type\[Dash]vars''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["type\[Dash]vars''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are the type\[Dash]variables produced by imposing type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Side effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tintroduce new variables for type-checking \[Lambda]-terms\n\tassign \
type information to variables "
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\( (*\ variables\ *) \n
    \(TcX[x_?IsVar, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      If[IsTyped[x], \n\t\t
        \(Type[x]\)[] /. {\[Alpha]v_, \[Tau]1_} :> {\n\t\t\t\t\t
              Append[\[Tau]eqn, eq[\[Tau]1, \[Tau]]], 
              \[Alpha]v \[Union] \[Alpha]var}, \n\t\t
        Block[{xNew = NewTyVar[]}, \n\t\t\tType[x] = FormTypeExpr[{}, xNew]; 
          \n\t\t\t{Append[\[Tau]eqn, eq[\[Tau], xNew]], 
            Append[\[Alpha]var, xNew]}]\n\t]; \)\t\t\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ function\ symbol\ or\ symbol\ literal\ *) \n
    \(TcX[x : _Symbol | _Complex | _Real | _Integer | _Rational, \[Tau]_, 
        \[Tau]eqn_, \[Alpha]var_]\  := \n\t
      Block[{\[Tau]expr, \[Alpha]v}, \n
        \t\t{\[Alpha]v, \[Tau]expr} = \(Type[x]\)[]; \n\t\t
        If[Complement[{\[Tau], \[Tau]expr}, {Int, Rat, Float, Compl}] === {}, 
          \n\t\t\t{\[Tau]eqn, \[Alpha]var}, \n
          \t\t\t{Append[\[Tau]eqn, eq[\[Tau]expr, \[Tau]]], 
            \[Alpha]var \[Union] \[Alpha]v}\n\t\t]\n\t]; \)\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ \[Lambda] - terms\ *) \n
    TcX[f_[{___, x_, ___, x_, ___}, _], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] /; 
        \((f === \[Lambda])\) := \n\t{{eq[Int, Bool]}, {}}; \n
    TcX[f_[x_Symbol, t_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] /; 
        \((f === \[Lambda])\) := \n\t
      \(TcX[\[Lambda][{#1}, #2], \[Tau], \[Tau]eqn, \[Alpha]var]&\)[x, t]; \n
    TcX[f_[xs_List, \ t_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] /; 
        \((f === \[Lambda])\) := \n\t
      Block[{xsNew, tNew, \[Beta], newTyVars}, \ \n
        \t\t{xsNew, tNew}\  = \ \((Module[#1, \ {#1, \ #2}]\ &\ )\)[xs, t]; \n
        \t\tnewTyVars = 
          Map[\((Last[\((Type[#]\  = \ FormTypeExpr[{}, NewTyVar[]])\)[]])
                \)\ &\ , xsNew]; \n\t\t
        \[Beta]\  = 
          If[Length[newTyVars] > 1, \n\t\t\t\t
            FuncType[Cross\ @@\ newTyVars, NewTyVar[]], \n\t\t\t\t
            FuncType[First[\ newTyVars], NewTyVar[]]\n\t\t\t]; \n\t\t
        TcX[tNew, Last[\[Beta]], \ \n\t\t\t
          Append[\[Tau]eqn, \ eq[\[Beta], \[Tau]]], \n\t\t\t
          Append[Union[\[Alpha]var, \ newTyVars], \ Last[\[Beta]]]]\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ lists\ *) \n
    \(TcX[l_List, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      \(Function[
          TcXList[l, Table[#, {Length[l]}], \n\t\t
            Append[\[Tau]eqn, eq[\[Tau], TyList[#]]], Append[\[Alpha]var, #]]]
          \)[NewTyVar[]]; \)\ \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ application\ for\ flattened\ functions\ *) \n
    TcX[Plus[x_, y_] | Times[x_, y_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n
      \t\tTcXList[{x, y}, {Compl, Compl}, 
        Append[\[Tau]eqn, eq[\[Tau], Compl]], \[Alpha]var]; \n
    TcX[And[x_, y_] | Or[x_, y_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t\t
      TcXList[{x, y}, {Bool, Bool}, Append[\[Tau]eqn, eq[\[Tau], Bool]], 
        \[Alpha]var]; \)\)], "Input",
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ \((partial)\)\ derivatives\ *) \n
    \(TcX[\(\(Derivative[slots__]\)[f_]\)[args__], \[Tau]_, \[Tau]eqn_, 
        \[Alpha]var_] := \n\t
      If[Length[{slots}] != Length[{args}], \n\t\t{{eq[Int, Bool]}, {}}, \n
        \t\tTcXList[{args, f[args]}, Append[Map[Compl&, {args}], \[Tau]], 
          \[Tau]eqn, \[Alpha]var]\n\t]; \)\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ marked\ term\ *) \n
    \(TcX[\((CSMark | DelayMark)\)[t_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := 
      TcX[t, \[Tau], \[Tau]eqn, \[Alpha]var]; \)\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\( (*\ application\ *) \n
    \(TcX[f_[], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      TcX[f, FuncType[\[Placeholder], \[Tau]], \[Tau]eqn, \[Alpha]var]; 
    \)\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(TcX[f_[arg_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      \(Function[
          TcXList[{f, arg}, {FuncType[#1, \[Tau]], #1}, \[Tau]eqn, 
            Append[\[Alpha]var, #1]]]\)[NewTyVar[]]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(TcX[f_[arg_, args__], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      If[MemberQ[Attributes[f], Flat], \n\t\t\t
        \(Function[\n\t\t\t\t
            TcXList[\n\t\t\t\t\t{f, arg, f[args]}, \n
              \t\t\t\t\t{FuncType[Cross[#1, #2], \[Tau]], #1, #2}, \[Tau]eqn, 
              Join[\[Alpha]var, {#1, #2}]]]\)[NewTyVar[], NewTyVar[]], \n
        \t\t\t\(Function[\n\t\t\t\t
            TcXList[{f, arg, args}, \n
              \t\t\t\t\t{FuncType[Apply[Cross\ , #1], \[Tau]], \n\t\t\t\t\t\t
                Apply[Sequence, #1]}, \[Tau]eqn, Join[\[Alpha]var, #1]]]\)[
          NewTyVar/@{arg, args}]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(TcX[_, _, _, _] := {{eq[Int, Bool]}, {}}; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TcXList", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTcXList",
    FontWeight->"Bold"],
  "[{ ",
  StyleBox["term1, term2, \[Ellipsis] ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "}",
  StyleBox[",  ",
    FontWeight->"Bold"],
  "{ ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox["1, ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox["2, \[Ellipsis]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "},  ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["\tterm1, term2, \[Ellipsis]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : CFLP terms\n\t",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox["1, ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox["2, \[Ellipsis]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  ": the expected types of ",
  StyleBox["term1, term2, \[Ellipsis]\n\ttype\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a list of equalities representing the type sharing constraints \
collected so far\n\t",
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of type variables appearing in ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[StyleBox["Output",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  "a pair  ",
  StyleBox["{",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["', ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["'}",
    FontWeight->"Bold"],
  "  such that:\n",
  StyleBox["type-eqs'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "=",
  StyleBox["type\[Dash]eqs\[Union]type\[Dash]eqs''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["type\[Dash]eqs''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are the type\[Dash]sharing constraints that were generated by imposing \
type ",
  StyleBox["\[Tau]1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ",
  StyleBox["\[Tau]2",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term2",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Ellipsis]",
    FontSlant->"Italic"],
  "\n",
  StyleBox["type\[Dash]vars'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "=",
  StyleBox["type\[Dash]vars\[Union]type\[Dash]vars''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["type\[Dash]vars''",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are the new type\[Dash]variables produced by imposing type ",
  StyleBox["\[Tau]1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ",
  StyleBox["\[Tau]2",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to ",
  StyleBox["term2",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Ellipsis]",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(TcXList[{}, {}, \[Tau]eqn_, \[Alpha]var_]\  := {\[Tau]eqn, 
        \[Alpha]var}; \n
    TcXList[{t_, ts___}, {\[Alpha]_, \[Alpha]v___}, \[Tau]eqn_, 
        \[Alpha]var_] := \n\t
      Block[{tmp = TcX[t, \[Alpha], \[Tau]eqn, \[Alpha]var]}, \n\t\t
        TcXList[{ts}, {\[Alpha]v}, First[tmp], Last[tmp]]\n\t]; \t\t\n
    TcXList[_, _, _, _] := {{eq[Int, Bool]}, {}}; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.700008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ListToCons", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tListToCons",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the expression obtained from ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " by replacing all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists that are not lambda arguments \n\twith the corresponding CFLP \
lists."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[WeakListToCons, ListToCons]; \n
    WeakListToCons[l_List] := Map[WeakListToCons, Flatten[l]]; \n
    WeakListToCons[l_And | l_Or] := WeakListToCons\ /@\ l; \n
    WeakListToCons[l_] := ListToCons[l]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.700008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(ListToCons[{}] := \[Bullet]; \n
    ListToCons[{h_, t___}] := Cons[ListToCons[h], ListToCons[{t}]]; \n
    ListToCons[f_[l_, t_]] /; \((f === \[Lambda])\) := 
      \(\[Lambda][#1, #2]&\)[l, ListToCons[t]]; \nListToCons[t_?AtomQ] := t; 
    \nListToCons[t_] := Map[ListToCons, t]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.700008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToFormula", "Subsection"],

Cell[BoxData[
    \(Clear[ToFormula]; \nToFormula[l_List] := Apply[And, ToFormula\ /@\ l]; 
    \nToFormula[l_And | l_Or] := ToFormula\ /@\ l; \nToFormula[l_] := l; \)], 
  "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell["Package Demo", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{727, 482},
WindowMargins->{{22, Automatic}, {Automatic, 8}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 68, 1, 102, "Title"],
Cell[1802, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2024, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2091, 66, 2437, 33, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4565, 104, 39, 0, 53, "Subtitle"],
Cell[4607, 106, 185, 3, 50, "Text"],
Cell[4795, 111, 186, 4, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5006, 119, 27, 0, 45, "Subsection"],
Cell[5036, 121, 221, 5, 43, "Input",
  InitializationCell->True],
Cell[5260, 128, 521, 10, 91, "Input",
  InitializationCell->True],
Cell[5784, 140, 614, 12, 91, "Input",
  InitializationCell->True],
Cell[6401, 154, 489, 9, 75, "Input",
  InitializationCell->True],
Cell[6893, 165, 136, 3, 27, "Input",
  InitializationCell->True],
Cell[7032, 170, 214, 5, 43, "Input",
  InitializationCell->True],
Cell[7249, 177, 257, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7555, 188, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7614, 192, 24, 0, 54, "Section"],
Cell[7641, 194, 128, 3, 27, "Input",
  InitializationCell->True],
Cell[7772, 199, 313, 6, 91, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8110, 209, 24, 0, 45, "Subsection"],
Cell[8137, 211, 1645, 63, 248, "Text"],

Cell[CellGroupData[{
Cell[9807, 278, 83, 2, 42, "Subsubsection"],
Cell[9893, 282, 166, 4, 27, "Input",
  InitializationCell->True],
Cell[10062, 288, 1255, 24, 443, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11366, 318, 25, 0, 45, "Subsection"],
Cell[11394, 320, 607, 27, 68, "Text"],
Cell[12004, 349, 782, 28, 86, "Text"],
Cell[12789, 379, 87, 2, 32, "Text"],
Cell[12879, 383, 1461, 57, 86, "Text"],
Cell[14343, 442, 212, 6, 68, "Text"],

Cell[CellGroupData[{
Cell[14580, 452, 125, 3, 42, "Subsubsection"],
Cell[14708, 457, 657, 14, 155, "Input",
  InitializationCell->True],
Cell[15368, 473, 698, 14, 155, "Input",
  InitializationCell->True],
Cell[16069, 489, 1300, 26, 283, "Input",
  InitializationCell->True],
Cell[17372, 517, 440, 11, 75, "Input",
  InitializationCell->True],
Cell[17815, 530, 566, 11, 91, "Input"],
Cell[18384, 543, 518, 11, 107, "Input",
  InitializationCell->True],
Cell[18905, 556, 335, 8, 43, "Input",
  InitializationCell->True],
Cell[19243, 566, 345, 9, 59, "Input",
  InitializationCell->True],
Cell[19591, 577, 379, 9, 43, "Input",
  InitializationCell->True],
Cell[19973, 588, 803, 16, 203, "Input",
  InitializationCell->True],
Cell[20779, 606, 225, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21053, 618, 29, 0, 45, "Subsection"],
Cell[21085, 620, 923, 41, 68, "Text"],
Cell[22011, 663, 861, 30, 86, "Text"],
Cell[22875, 695, 87, 2, 32, "Text"],
Cell[22965, 699, 1894, 77, 104, "Text"],

Cell[CellGroupData[{
Cell[24884, 780, 125, 3, 42, "Subsubsection"],
Cell[25012, 785, 549, 12, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25610, 803, 32, 0, 45, "Subsection"],
Cell[25645, 805, 850, 36, 140, "Text"],

Cell[CellGroupData[{
Cell[26520, 845, 125, 3, 42, "Subsubsection"],
Cell[26648, 850, 386, 9, 75, "Input",
  InitializationCell->True],
Cell[27037, 861, 460, 10, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27546, 877, 31, 0, 45, "Subsection"],
Cell[27580, 879, 296, 7, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27925, 892, 22, 0, 54, "Section"],
Cell[27950, 894, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[28119, 901, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[28307, 909, 31, 0, 54, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

