(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["TypeChecker`",
	{"Calculus`","TypeRules`"}];



Tc::usage=
  "Tc[term] yields the type of term if term is well typed, and yields \
\[UpTee] otherwise." ;

TcX::usage=
  "TcX[term,type,type\[Dash]eqs,type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term has type type and the type sharing equations type\[Dash]eqs in \
variables type\[Dash]vars hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold." ;

TcXList::usage=
  "TcXList[{term1,term2,\[Ellipsis]},{type1,type2,\[Ellipsis]},type\[Dash]eqs,\
type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term1 has type type1, term2 has type type2, \[Ellipsis], 
		and the type sharing equations type\[Dash]eqs in variables type\[Dash]vars \
hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold." ;

ListToCons::usage=
  "ListToCons[term] substitutes in term all lists that are not formal \
arguments to \[Lambda]-terms with their corresponding CFLP encodings. The \
CFLP encoding of a list {a,b,\[Ellipsis],z} is \
Cons[a,Cons[\[Ellipsis],Cons[z,\[Bullet]]\[Ellipsis]]] with the wisual \
representation \[LeftAngleBracket]a,b,\[Ellipsis],z,\[Bullet]\
\[RightAngleBracket]";

WeakListToCons::usage="";

ToFormula::usage=
  "ToFormula[goal] generates the CFLP formula which is represented by \
`goal`.";

KeepTypes::usage=
  "KeepTypes is a valid option for Tc that specifies whether the types \
associated to variables should be removed or not.";





Begin["`Private`"];

$ContextPath=
	Join[
		{"Variables`","TermSyntax`","TypeSyntax`",
			"Types`","RewriteRules`","Terms`","Debug`"},
		$ContextPath];







Options[Tc]:={KeepTypes->False,TypedVars\[Rule]{}};

Tc[t_,opts___Rule] := 
	Module[
		{sol,teqn,tV,oldV,
			$RecursionLimit=8000,
			saveType=DownValues[Type],
			oldLevel=Debug`$CFLPTraceLevel,
			\[Beta]=NewTyVar[],keepType},
		oldV=Var[t];
		{tV,keepType}={TypedVars,KeepTypes}/.{opts}/.Options[Tc];
		SetVariables[tV];
		{teqn,tV}=TcX [t,\[Beta],{},{\[Beta]}];
		TSolveRules=cflpTypeRules;
		TcCall=True;
		sol=CallTSolve[teqn,tV,{},2];
		If[sol=!={},
			If[keepType,
				DownValues[Type]=
          DownValues[Type]/.sol\[LeftDoubleBracket]1\[RightDoubleBracket],
				ClearVariables[tV,KeepVarTypes->False];
				SetVariables[oldV];
				DownValues[Type]=saveType;
			];
			\[Beta]/.sol\[LeftDoubleBracket]1\[RightDoubleBracket],
			ClearVariables[tV];
			SetVariables[oldV];
			"\[UpTee]"
		]
	];















(* variables *)
TcX[x_?IsVar,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	If[IsTyped[x],
		Type[x][]/.{\[Alpha]v_,\[Tau]1_}:>{
					Append[\[Tau]eqn,eq[\[Tau]1,\[Tau]]],\[Alpha]v\[Union]\[Alpha]var},
		Block[{xNew=NewTyVar[]},
			Type[x]=FormTypeExpr[{},xNew];
			{Append[\[Tau]eqn,eq[\[Tau],xNew]],Append[\[Alpha]var,xNew]}]
	];		

(* function symbol or symbol literal *)
TcX[x:_Symbol|_Complex|_Real|_Integer|_Rational,\[Tau]_,\[Tau]eqn_,
    \[Alpha]var_] :=
	Block[{\[Tau]expr,\[Alpha]v},
		{\[Alpha]v,\[Tau]expr}=Type[x][];
		If[Complement[{\[Tau],\[Tau]expr},{Int,Rat,Float,Compl}]==={},
			{\[Tau]eqn,\[Alpha]var},
			{Append[\[Tau]eqn,eq[\[Tau]expr,\[Tau]]],\[Alpha]var\[Union]\[Alpha]v}
		]
	];

(* \[Lambda]-terms *)
TcX[f_[{___,x_,___,x_,___},_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]/;(
      f===\[Lambda]):=
	{{eq[Int,Bool]},{}};
TcX[f_[x_Symbol,t_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]/;(f===\[Lambda]):=
	TcX[\[Lambda][{#1},#2],\[Tau],\[Tau]eqn,\[Alpha]var]&[x,t];
TcX[f_[xs_List, t_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]/;(f===\[Lambda]):=
	Block[{xsNew,tNew,\[Beta],newTyVars}, 
		{xsNew,tNew} = (Module[#1, {#1, #2}] & )[xs,t];
		newTyVars=Map[(Last[(Type[#] = FormTypeExpr[{},NewTyVar[]])[]]) & ,xsNew];
		\[Beta] =If[Length[newTyVars]>1,
				FuncType[Cross @@ newTyVars,NewTyVar[]],
				FuncType[First[ newTyVars],NewTyVar[]]
			];
		TcX[tNew,Last[\[Beta]], 
			Append[\[Tau]eqn, eq[\[Beta],\[Tau]]],
			Append[Union[\[Alpha]var, newTyVars], Last[\[Beta]]]]
	];

(* lists *)
TcX[l_List,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	Function[TcXList[l,Table[#,{Length[l]}],
		Append[\[Tau]eqn,eq[\[Tau],TyList[#]]],Append[\[Alpha]var,#]]][NewTyVar[]]; 



(* (partial) derivatives *)
TcX[Derivative[slots__][f_][args__],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	If[Length[{slots}]!=Length[{args}],
		{{eq[Int,Bool]},{}},
		TcXList[{args,f[args]},Append[Map[Compl&,{args}],\[Tau]],\[Tau]eqn,
      \[Alpha]var]
	];

(* marked term *)
TcX[(CSMark|DelayMark)[t_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
  TcX[t,\[Tau],\[Tau]eqn,\[Alpha]var];

(* application *)
TcX[f_[],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	TcX[f,FuncType[\[Placeholder],\[Tau]],\[Tau]eqn,\[Alpha]var];

TcX[f_[arg_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	Function[
      TcXList[{f,arg},{FuncType[#1,\[Tau]],#1},\[Tau]eqn,
        Append[\[Alpha]var,#1]]][NewTyVar[]];

TcX[f_[arg_,args__],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	If[MemberQ[Attributes[f],Flat],
			Function[
				TcXList[
					{f,arg,f[args]},
					{FuncType[Cross[#1,#2],\[Tau]],#1,#2},\[Tau]eqn,
          Join[\[Alpha]var,{#1,#2}]]][NewTyVar[],NewTyVar[]],
			Function[
				TcXList[{f,arg,args},
					{FuncType[Apply[Cross ,#1],\[Tau]],
						Apply[Sequence,#1]},\[Tau]eqn,Join[\[Alpha]var,#1]]][
      NewTyVar/@{arg,args}]
		];

TcX[_,_,_,_]:={{eq[Int,Bool]},{}};













TcXList[{},{},\[Tau]eqn_,\[Alpha]var_] :={\[Tau]eqn,\[Alpha]var};
TcXList[{t_,ts___},{\[Alpha]_,\[Alpha]v___},\[Tau]eqn_,\[Alpha]var_]:=
	Block[{tmp=TcX[t,\[Alpha],\[Tau]eqn,\[Alpha]var]},
		TcXList[{ts},{\[Alpha]v},First[tmp],Last[tmp]]
	];		
TcXList[_,_,_,_]:={{eq[Int,Bool]},{}};







Clear[WeakListToCons,ListToCons];
WeakListToCons[l_List]:=Map[WeakListToCons,Flatten[l]];
WeakListToCons[l_And|l_Or]:=WeakListToCons /@ l;
WeakListToCons[l_]:=ListToCons[l];

ListToCons[{}]:=\[Bullet];
ListToCons[{h_,t___}]:=Cons[ListToCons[h],ListToCons[{t}]];
ListToCons[f_[l_,t_]]/;(f===\[Lambda]):=\[Lambda][#1,#2]&[l,ListToCons[t]];
ListToCons[t_?AtomQ]:=t;
ListToCons[t_]:=Map[ListToCons,t];



Clear[ToFormula];
ToFormula[l_List]:=Apply[And,ToFormula /@ l];
ToFormula[l_And|l_Or]:=ToFormula /@ l;
ToFormula[l_]:=l;



End[];

EndPackage[];

