(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40766,       1429]*)
(*NotebookOutlinePosition[     41461,       1454]*)
(*  CellTagsIndexPosition[     41417,       1450]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Terms", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NO WARRANTY"]], "Subsubsection",
  InitializationCell->True],

Cell[TextData[StyleBox[
"The program was produced on an experimental basis in the\ncourse of the \
research and development conducted during the project\nand is provided to \
users as so produced on an experimental basis.\nAccordingly, the program is \
provided without any warranty whatsoever,\nwhether express, implied, \
statutory or otherwise. The term \"warranty\"\nused herein includes, but is \
not limited to, any warranty of the\nquality, performance, merchantability \
and fitness for a particular\npurpose of the program and the nonexistence of \
any infringement or\nviolation of any right of any third party.\n\nEach user \
of the program will agree and understand, and be\ndeemed to have agreed and \
understood, that there is no warranty\nwhatsoever for the program and, \
accordingly, the entire risk arising\nfrom or otherwise connected with the \
program is assumed by the user.\n\nTherefore, neither ICOT, the copyright \
holder, or any other\norganization that participated in or was otherwise \
related to the\ndevelopment of the program and their respective officials, \
directors,\nofficers and other employees shall be held liable for any and all\
\ndamages, including, without limitation, general, special, incidental\nand \
consequential damages, arising out of or otherwise in connection\nwith the \
use or inability to use the program or any product, material\nor result \
produced or otherwise obtained by using the program,\nregardless of whether \
they have been advised of, or otherwise had\nknowledge of, the possibility of \
such damages at any time during the\nproject or thereafter. Each user will be \
deemed to have agreed to the\nforegoing by his or her commencement of use of \
the program. The term\n\"use\" as used herein includes, but is not limited \
to, the use,\nmodification, copying and distribution of the program and the\n\
production of secondary products from the program.\n\nIn the case where the \
program, whether in its original form or\nmodified, was distributed or \
delivered to or received by a user from\nany person, organization or entity \
other than ICOT, unless it makes or\ngrants independently of ICOT any \
specific warranty to the user in\nwriting, such person, organization or \
entity, will also be exempted\nfrom and not be held liable to the user for \
any such damages as noted\nabove as far as the program is concerned."]], 
  "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains commands for handling terms. ", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Terms`\>", \n
      \t{"\<TermSyntax`\>", "\<Variables`\>", "\<Types`\>", 
        "\<RewriteRules`\>"}]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\($FunctionSymbol::usage = 
      "\<$FunctionSymbol gives the current list of declared function symbols.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Constructor::usage = 
      "\<Constructor[type\[Dash]expression \[Ellipsis] ] declares as \
constructors the type\[Dash]annotated symbols given as arguments, which were \
not declared before. Also, the specified type is associated with them.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefaultConstructor::usage 
      "\<DefaultConstructor[] sets the default constructor type \
signatures.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefinedSymbol::usage = \ 
      "\<DefinedSymbol[type\[Dash]expression \[Ellipsis] ] declares as \
defined symbols the type\[Dash]annotated symbols given as arguments, which \
were not declared before. Also, the specified type is associated to them.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["ClearSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<ClearSignature[ symb\[Dash]1, symb\[Dash]2, \[Ellipsis] ] undoes \
all the operations performed for symb\[Dash]i by a previous Constructor, \
External, or DefinedSymbol command.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["ResetSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<ResetSignature[ ] resets the values of Type, Arity, \
IsDefinedSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["DefineSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<DefineSignature[ ] sets the values of Type, Arity, \
IsDefinedSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsConstructorTerm::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsConstructorTerm[term] yields True if term is a term of the \
form c or c[term1, term2, \[Ellipsis]] where c is a constructor, and False \
otherwise.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsNotFlex::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsNotFlex[term] yields False if term is a variable or a term of \
the form X[term1, term2, \[Ellipsis]] where X is a variable, and True \
otherwise.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsFunctionTerm::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsFunctionTerm[term] yields True if term is a defined function \
symbol or a term\n\t\tof the form f[ term1, term2, \[Ellipsis] ] where f is a \
defined function symbol, and False otherwise .\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      StyleBox[\(TypedVars::usage = "\<\>"\),
        FontWeight->"Bold"], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(PrependTo[$ContextPath, "\<TypeSyntax`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["Function Symbol Declarations", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["$FunctionSymbol",
  FontWeight->"Bold"]], "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  "The global variable ",
  StyleBox["$FunctionSymbol",
    FontWeight->"Bold"],
  " is the list of declared function symbols. "
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Constructor", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tConstructor[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox["typed\[Dash]symbol",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  "| ",
  StyleBox["symbol",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" , \[Ellipsis] ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "a sequence of symbols or type-annotated symbols. A type\[Dash]annotated \
symbol is an expression of one of the forms:\n",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau] \n",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau] \n\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau] \n",
    FontWeight->"Bold"],
  "where ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "symbol and ",
  StyleBox["\[Tau],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  " are type expressions. The last two forms denote the same thing. \nIf a \
single symbol ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is passed to a ",
  StyleBox["Constructor",
    FontWeight->"Bold"],
  " call, it will be typed with a fresh type variable ",
  StyleBox["\[Alpha]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list of ",
  StyleBox["newly",
    FontSlant->"Italic"],
  " ",
  StyleBox["typed",
    FontSlant->"Italic"],
  " symbols. A  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " will be ",
  StyleBox["newly typed",
    FontSlant->"Italic"],
  " if:\n\t(a) a type-annotated expression for ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " appears in the ",
  StyleBox["Constructor",
    FontWeight->"Bold"],
  " call. \n\t(b) ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " was not subject to a previous ",
  StyleBox["TypeConstructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Constructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DefinedSymbol",
    FontWeight->"Bold"],
  " or ",
  StyleBox["External",
    FontWeight->"Bold"],
  " declaration."
}], "Text"],

Cell[TextData[StyleBox["Effect",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  " For every argument of the form ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". For every argument ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " or ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" \[Cross] \[CenterEllipsis] \[Cross] \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Also, define ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " as external operator by defining ",
  StyleBox["IsConstructor[ ",
    FontWeight->"Bold"],
  StyleBox["op ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]:=True",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[Constructor]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(Constructor[p_[f_, \[Tau]_]] /; \((p === Pattern)\) := \n\t
      Block[{\[Tau]1}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        IsConstructor[f] = True; \n\t\t
        DeclareType[{f, \[Tau] //. {ShortRightArrow \[Rule] FuncType}} /. {
              List \[Rule] Pattern}]; \n\t\t
        If[IsFunType[\[Tau]], \n\t\t\t
          \[Tau]1 = \[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket]; \n\t\t\t
          If[\[Tau]1 === \[EmptySquare], \n\t\t\t\tArity[f] = 0, \n\t\t\t\t
            Arity[f] = If[Head[\[Tau]1] === Cross, Length[\[Tau]1], 1]\n
            \t\t\t], \n\t\t\tArity[f] = 0\n\t\t]; {f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(Constructor[\[Tau]1_ \[ShortRightArrow] \[Tau]2_] := \n\t
      Block[{f = Head[\[Tau]1]}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        Arity[f] = Length[\[Tau]1 /. {f[\[EmptySquare]] :> f[]}]; \n\t\t
        IsConstructor[f] = True; \n\t\t
        If[Arity[f] \[LessEqual] 1, \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[
                    \((\[Tau]1 /. {f[] :> f[\[EmptySquare]]})
                        \)\[LeftDoubleBracket]1\[RightDoubleBracket], 
                    \[Tau]2]} //. {ShortRightArrow \[Rule] FuncType}\) /. {
                List -> Pattern}], \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[Apply[Cross\ , \[Tau]1], \[Tau]2]} //. {
                  ShortRightArrow \[Rule] FuncType}\) /. {List -> Pattern}]\n
          \t\t]; \n\t\t{f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(Constructor[f_] := \n\t
      If[Head[f] =!= Symbol \[Or] IsDeclared[f], \n\t\t{}, \n\t\t
        IsConstructor[f] = True; \n\t\t
        Type[f] = FormTypeExpr[{}, NewTyVar[]]; {f}\n\t]; \n
    Constructor[es___] := Join\ @@\ \(Constructor\ /@\ {es}\); \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefaultConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefaultConstructor[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  StyleBox["Define the default CFLP constructors",
    FontSlant->"Plain"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[DefaultConstructor]\), ";", "\n", 
      RowBox[{\(DefaultConstructor[]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
            \(IsConstructor[c_?AtomQ] /; 
                  \((c\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Symbol)
                    \) = True\), ";", "\n", "\t\t", 
              RowBox[{"Constructor", "[", "\n", "\t\t\t", 
                RowBox[{
                "TYPE", ",", "\n", "\t\t\t", "Function", ",", "\n", "\t\t\t", 
                  \(Bool : TYPE\), ",", "\n", "\t\t  ", \(String : TYPE\), 
                  ",", "\n", "\t\t  ", \(Int : TYPE\), ",", "\n", "\t\t  ", 
                  \(Float : TYPE\), ",", "\n", "\t\t  ", \(Rat : TYPE\), ",", 
                  "\n", "\t\t  ", \(Compl : TYPE\), ",", "\n", "\t\t  ", 
                  \(Symb : TYPE\), ",", "\n", "\t\t  ", 
                  \(\[EmptySquare] : TYPE\), ",", "\n", "\t\t  ", 
                  \(TyList : TYPE\), ",", "\n", "\t\t  ", 
                  \(FuncType : TYPE\), ",", "\n", "\t\t\t", \(Cross : TYPE\), 
                  ",", "\n", "\t\t\t", \(False : Bool\), ",", "\n", "\t\t\t", 
                  \(True : Bool\), ",", "\n", "\t\t  ", 
                  \(\[Bullet] : TyList[Global`\[Alpha]]\), ",", "\n", 
                  "\t\t\t", 
                  \(Cons : 
                    FuncType[Global`\[Alpha]\[Cross]TyList[Global`\[Alpha]], 
                      TyList[Global`\[Alpha]]]\), ",", "\n", "\t\t\t", 
                  RowBox[{
                    StyleBox["RewriteRule",
                      FontWeight->"Bold"], 
                    StyleBox[":",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["FuncType",
                        FontWeight->"Bold"], 
                      StyleBox["[",
                        FontWeight->"Bold"], 
                      \(Global`\[Alpha]\[Cross]Global`\[Alpha]\[Cross]Bool, 
                      RULE\), "]"}]}], ",", "\n", "\t\t\t", 
                  \(eq : FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha], 
                      Bool]\)}], "]"}]}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefinedSymbol", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefinedSymbol[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(typed\[Dash]symbol | \ symbol\),
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "a sequence of symbols or type-annotated symbols. A type\[Dash]annotated \
symbol is an expression of one of the forms:",
  StyleBox["\nop",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau] \n",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau] \n\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau] \n",
    FontWeight->"Bold"],
  "where ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "symbol and ",
  StyleBox["\[Tau],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  " are type expressions. The last two forms denote the same thing.\nIf a \
single symbol ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is passed to a ",
  StyleBox["DefinedSymbol",
    FontWeight->"Bold"],
  " call, it will be typed with a fresh type variable ",
  StyleBox["\[Alpha]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list of ",
  StyleBox["newly",
    FontSlant->"Italic"],
  " ",
  StyleBox["typed",
    FontSlant->"Italic"],
  " symbols. A  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " will be ",
  StyleBox["newly typed",
    FontSlant->"Italic"],
  " if:\n\t(a) a type-annotated expression for ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " appears in the ",
  StyleBox["DefinedSymbol",
    FontWeight->"Bold"],
  " call. \n\t(b) ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " was not subject to a previous ",
  StyleBox["TypeConstructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Constructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DefinedSymbol",
    FontWeight->"Bold"],
  " or ",
  StyleBox["External",
    FontWeight->"Bold"],
  " declaration."
}], "Text"],

Cell[TextData[StyleBox["Effect",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  " For every argument of the form ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : \[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". For every argument ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[",\[Ellipsis],\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" ]\[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " or ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[CenterEllipsis] ",
    FontWeight->"Bold"],
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " do attach type ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[" \[Cross] \[CenterEllipsis] \[Cross] \[Tau]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  StyleBox[" \[ShortRightArrow]\[Tau]",
    FontWeight->"Bold"],
  " to ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Also, define ",
  StyleBox["op",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " as external operator by defining ",
  StyleBox["IsDefinedSymbol[ ",
    FontWeight->"Bold"],
  StyleBox["op ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]:=True",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[DefinedSymbol]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DefinedSymbol[p_[f_, \[Tau]_]] /; \((p === Pattern)\) := \n\t
      Block[{\[Tau]1}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        IsDefinedSymbol[f] = True; \n\t\t
        DeclareType[{f, \[Tau] //. {ShortRightArrow \[Rule] FuncType}} /. {
              List \[Rule] Pattern}]; \n\t\t
        If[IsFunType[\[Tau]], \n\t\t\t
          \[Tau]1 = \[Tau]\[LeftDoubleBracket]1\[RightDoubleBracket]; \n\t\t\t
          If[\[Tau]1 === \[EmptySquare], \n\t\t\t\tArity[f] = 0, \n\t\t\t\t
            Arity[f] = If[Head[\[Tau]1] === Cross, Length[\[Tau]1], 1]\n
            \t\t\t], \n\t\t\tArity[f] = 0\n\t\t]; {f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DefinedSymbol[\[Tau]1_ \[ShortRightArrow] \[Tau]2_] := \n\t
      Block[{f = Head[\[Tau]1]}, \n\t\t
        If[Head[f] =!= Symbol \[Or] IsDeclared[f], Return[{}]]; \n\t\t
        Arity[f] = Length[\[Tau]1 /. {f[\[EmptySquare]] :> f[]}]; \n\t\t
        IsDefinedSymbol[f] = True; \n\t\t
        If[Arity[f] \[LessEqual] 1, \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[
                    \((\[Tau]1 /. {f[] :> f[\[EmptySquare]]})
                        \)\[LeftDoubleBracket]1\[RightDoubleBracket], 
                    \[Tau]2]} //. {ShortRightArrow \[Rule] FuncType}\) /. {
                List \[Rule] Pattern}], \n\t\t\t\t
          DeclareType[\ 
            \({f, FuncType[Apply[Cross\ , \[Tau]1], \[Tau]2]} //. {
                  ShortRightArrow \[Rule] FuncType}\) /. {List -> Pattern}]\n
          \t\t]; {f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DefinedSymbol[f_] := \n\t
      If[Head[f] =!= Symbol \[Or] IsDeclared[f], \n\t\t{}, \n\t\t
        IsDefinedSymbol[f] = True; \n\t\t
        Type[f] = FormTypeExpr[{}, NewTyVar[]]; {f}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DefinedSymbol[es___] := Join\ @@\ \(DefinedSymbol\ /@\ {es}\); \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefineSignature", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefineSignature[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tset the default  signature of the CFLP interpreter."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(DefineSignature[] := \n\t
      \(($FunctionSymbol = {}; \n\t\tDefaultTypes[]; \n\t\tDefaultExternal[]; 
        \n\t\tDefaultConstructor[]; \n\t\t
        Arity[_Integer | _Real | _Complex | _Rational | _String] := 0\n\t)\); 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetSignature", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tResetSignature[",
    FontWeight->"Bold"],
  " ",
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["reset the type signature context to default.",
    FontWeight->"Plain"]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(ResetSignature[] := \n\t
      \((Clear[IsDefinedSymbol, IsConstructor, IsExternal, Type, Arity]; \n
        \t\tDefineSignature[])\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearSignature", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tClearSignature[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta sequence of constructor-, external-,  or defined function symbols\n",
  
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tundeclare ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold"]], TraditionalForm]]],
  " (",
  StyleBox["1 \[LessEqual] i \[LessEqual] n",
    FontWeight->"Bold"],
  ")"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        StyleBox["ClearSignature",
          FontWeight->"Bold"], "]"}], ";", "\n", 
      \(ClearSignature[f_Symbol] := \n\t
        If[IsExternal[f], \n\t\t
          DPrint[1, "\<Unable to clear signature of external symbol\>"], \n
          \t\tIsDefinedSymbol[f] = False; \n\t\tIsConstructor[f] = False; \n
          \t\tIf[Head[Type[f]] =!= Type, Type[f] =. ; Arity[f] =. ]; \n\t\t
          RewriteRuleList[f] = {}; \n
          \t\t$FunctionSymbol = $FunctionSymbol /. f -> Sequence[]; \n
          \t\t{f}\n\t]\), ";", "\n", 
      \(ClearSignature[fs___Symbol] := 
        Join\ @@\ \(ClearSignature\ /@\ {fs}\)\), " ", ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Term Recognizers", "Section"],

Cell[CellGroupData[{

Cell["NotFlex", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNotFlex[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["False",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a is a variable or a term with  variable head.\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[NotFlex]; \nIsNotFlex[x_?IsVar] := False; \n
    IsNotFlex[x_?IsVar[___]] := False; \nIsNotFlex[_] := True; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["IsConstructorTerm", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsConstructorTerm[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]\n",
    FontWeight->"Bold"],
  StyleBox["Input\n\tt",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  or  ",
  StyleBox["c ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], "1"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis], ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  ", where  ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a constructor,\n\t",
  StyleBox["Fals",
    FontWeight->"Bold"],
  "e  otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsConstructorTerm[\((_?IsConstructor)\)[___] | _?IsConstructor] := 
      True; \nIsConstructorTerm[_] := False; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["IsFunctionTerm", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunctionTerm[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]\n",
    FontWeight->"Bold"],
  StyleBox["Input\n\tt",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  or  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], "1"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis], ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  ", where  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a defined function symbol,\n\t",
  StyleBox["Fals",
    FontWeight->"Bold"],
  "e  otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsFunctionTerm[\((_?IsDefinedSymbol)\)[___]\n | _?IsDefinedSymbol] := 
      True; \nIsFunctionTerm[_] := False; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefineSignature[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell["Package Demo", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{727, 509},
WindowMargins->{{Automatic, 20}, {-3, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 61, 1, 102, "Title"],
Cell[1795, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2017, 63, 84, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2104, 66, 2437, 33, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4578, 104, 39, 0, 53, "Subtitle"],
Cell[4620, 106, 67, 0, 32, "Text"],
Cell[4690, 108, 281, 7, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4996, 119, 27, 0, 45, "Subsection"],
Cell[5026, 121, 214, 5, 43, "Input",
  InitializationCell->True],
Cell[5243, 128, 356, 7, 59, "Input",
  InitializationCell->True],
Cell[5602, 137, 213, 5, 43, "Input",
  InitializationCell->True],
Cell[5818, 144, 363, 7, 59, "Input",
  InitializationCell->True],
Cell[6184, 153, 434, 10, 43, "Input",
  InitializationCell->True],
Cell[6621, 165, 392, 10, 43, "Input",
  InitializationCell->True],
Cell[7016, 177, 392, 10, 43, "Input",
  InitializationCell->True],
Cell[7411, 189, 430, 11, 43, "Input",
  InitializationCell->True],
Cell[7844, 202, 420, 11, 43, "Input",
  InitializationCell->True],
Cell[8267, 215, 468, 11, 75, "Input",
  InitializationCell->True],
Cell[8738, 228, 185, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8972, 239, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[9031, 243, 24, 0, 54, "Section"],
Cell[9058, 245, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[9244, 252, 203, 5, 27, "Input",
  InitializationCell->True],
Cell[9450, 259, 182, 5, 45, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9657, 268, 211, 6, 45, "Subsection",
  Evaluatable->False],
Cell[9871, 276, 156, 5, 32, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[10064, 286, 165, 5, 29, "Subsection",
  Evaluatable->False],
Cell[10232, 293, 523, 21, 68, "Text"],
Cell[10758, 316, 1968, 73, 122, "Text"],
Cell[12729, 391, 1068, 47, 86, "Text"],
Cell[13800, 440, 87, 2, 32, "Text"],
Cell[13890, 444, 2024, 81, 50, "Text"],

Cell[CellGroupData[{
Cell[15939, 529, 125, 3, 42, "Subsubsection"],
Cell[16067, 534, 203, 6, 27, "Input",
  InitializationCell->True],
Cell[16273, 542, 832, 16, 235, "Input",
  InitializationCell->True],
Cell[17108, 560, 1024, 21, 219, "Input",
  InitializationCell->True],
Cell[18135, 583, 433, 10, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18617, 599, 40, 0, 45, "Subsection"],
Cell[18660, 601, 390, 15, 86, "Text"],

Cell[CellGroupData[{
Cell[19075, 620, 125, 3, 42, "Subsubsection"],
Cell[19203, 625, 2300, 43, 411, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21552, 674, 167, 5, 45, "Subsection",
  Evaluatable->False],
Cell[21722, 681, 459, 17, 68, "Text"],
Cell[22184, 700, 1969, 73, 122, "Text"],
Cell[24156, 775, 1070, 47, 86, "Text"],
Cell[25229, 824, 87, 2, 32, "Text"],
Cell[25319, 828, 2026, 81, 50, "Text"],

Cell[CellGroupData[{
Cell[27370, 913, 125, 3, 42, "Subsubsection"],
Cell[27498, 918, 205, 6, 27, "Input",
  InitializationCell->True],
Cell[27706, 926, 836, 16, 235, "Input",
  InitializationCell->True],
Cell[28545, 944, 1027, 21, 203, "Input",
  InitializationCell->True],
Cell[29575, 967, 375, 9, 107, "Input",
  InitializationCell->True],
Cell[29953, 978, 249, 7, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30251, 991, 169, 5, 45, "Subsection",
  Evaluatable->False],
Cell[30423, 998, 304, 11, 86, "Text"],

Cell[CellGroupData[{
Cell[30752, 1013, 125, 3, 42, "Subsubsection"],
Cell[30880, 1018, 335, 7, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31264, 1031, 168, 5, 45, "Subsection",
  Evaluatable->False],
Cell[31435, 1038, 515, 21, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31975, 1063, 125, 3, 42, "Subsubsection"],
Cell[32103, 1068, 239, 5, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32391, 1079, 168, 5, 45, "Subsection",
  Evaluatable->False],
Cell[32562, 1086, 1291, 49, 122, "Text"],

Cell[CellGroupData[{
Cell[33878, 1139, 125, 3, 42, "Subsubsection"],
Cell[34006, 1144, 769, 16, 203, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34836, 1167, 35, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[34896, 1171, 29, 0, 45, "Subsection"],
Cell[34928, 1173, 826, 36, 2300, "Text"],

Cell[CellGroupData[{
Cell[35779, 1213, 125, 3, 42, "Subsubsection"],
Cell[35907, 1218, 214, 4, 75, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[36170, 1228, 61, 1, 29, "Subsection",
  Evaluatable->False],
Cell[36234, 1231, 1420, 61, 140, "Text"],

Cell[CellGroupData[{
Cell[37679, 1296, 125, 3, 42, "Subsubsection"],
Cell[37807, 1301, 292, 7, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[38148, 1314, 58, 1, 29, "Subsection",
  Evaluatable->False],
Cell[38209, 1317, 1429, 61, 140, "Text"],

Cell[CellGroupData[{
Cell[39663, 1382, 125, 3, 42, "Subsubsection"],
Cell[39791, 1387, 292, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40144, 1401, 22, 0, 54, "Section"],
Cell[40169, 1403, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[40338, 1410, 178, 5, 27, "Input",
  InitializationCell->True],
Cell[40519, 1417, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[40707, 1425, 31, 0, 54, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

