(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20914,        675]*)
(*NotebookOutlinePosition[     21740,        704]*)
(*  CellTagsIndexPosition[     21696,        700]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Term Syntax", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NO WARRANTY"]], "Subsubsection",
  InitializationCell->True],

Cell[TextData[StyleBox[
"The program was produced on an experimental basis in the\ncourse of the \
research and development conducted during the project\nand is provided to \
users as so produced on an experimental basis.\nAccordingly, the program is \
provided without any warranty whatsoever,\nwhether express, implied, \
statutory or otherwise. The term \"warranty\"\nused herein includes, but is \
not limited to, any warranty of the\nquality, performance, merchantability \
and fitness for a particular\npurpose of the program and the nonexistence of \
any infringement or\nviolation of any right of any third party.\n\nEach user \
of the program will agree and understand, and be\ndeemed to have agreed and \
understood, that there is no warranty\nwhatsoever for the program and, \
accordingly, the entire risk arising\nfrom or otherwise connected with the \
program is assumed by the user.\n\nTherefore, neither ICOT, the copyright \
holder, or any other\norganization that participated in or was otherwise \
related to the\ndevelopment of the program and their respective officials, \
directors,\nofficers and other employees shall be held liable for any and all\
\ndamages, including, without limitation, general, special, incidental\nand \
consequential damages, arising out of or otherwise in connection\nwith the \
use or inability to use the program or any product, material\nor result \
produced or otherwise obtained by using the program,\nregardless of whether \
they have been advised of, or otherwise had\nknowledge of, the possibility of \
such damages at any time during the\nproject or thereafter. Each user will be \
deemed to have agreed to the\nforegoing by his or her commencement of use of \
the program. The term\n\"use\" as used herein includes, but is not limited \
to, the use,\nmodification, copying and distribution of the program and the\n\
production of secondary products from the program.\n\nIn the case where the \
program, whether in its original form or\nmodified, was distributed or \
delivered to or received by a user from\nany person, organization or entity \
other than ICOT, unless it makes or\ngrants independently of ICOT any \
specific warranty to the user in\nwriting, such person, organization or \
entity, will also be exempted\nfrom and not be held liable to the user for \
any such damages as noted\nabove as far as the program is concerned."]], 
  "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains syntax definitions for terms.", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TermSyntax`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\[Bullet]sys::usage; DoubleVerticalBar::usage; Wedge::usage; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(\[Bullet]ORbranches::usage = 
      "\<\[Bullet]ORbranches is a data constructor used for handling the \
alternative search branches of the solution tree generated by the \
[||\[Dash]OR] inference rule of CFLP.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(eq::usage = 
      "\<eq[ term1, term2 ] is the full form representation of the initial \
equation term1 \[TildeTilde] term2.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(ppeq::usage = 
      "\<ppeq[ term1, term2 ] is the full form representation of the \
parameter passing equation term1 \[CupCap] term2.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(CSMark::usage = 
      "\<CSMark[equation] is the full form representation of the marked \
equation \[LeftCeiling]equation\[RightCeiling]\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(DelayMark::usage = 
      "\<DelayMark[equation] is the full form representation of the marked \
equation \[LeftFloor]equation\[RightFloor]\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(RewriteRule::usage = 
      "\<RewriteRule[lhs, rhs, condition ] is the full form representation of \
the conditional rewrite rule `lhs \[RightArrow] rhs \[DoubleLeftArrow] \
condition`.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(Cons::usage = 
      "\<Cons[elem,list\[Dash]term] gives list\[Dash]term with elem \
prepended. It is the full form representation of \[LeftAngleBracket] elem, \
elem\[Dash]list \[RightAngleBracket].\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(\[Bullet]::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<\[Bullet] denotes the empty CFLP list.\>\""}], ";", 
      \(ToCons::usage\), ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    RowBox[{
      RowBox[{"DoubleLeftArrow", 
        StyleBox["::",
          FontWeight->"Bold"], 
        StyleBox["usage",
          FontWeight->"Bold"]}], 
      StyleBox[";",
        FontWeight->"Bold"], 
      StyleBox[\(RightArrow::usage\),
        FontWeight->"Bold"], 
      StyleBox[";",
        FontWeight->"Bold"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    StyleBox[
      \(TildeTilde::usage = 
        "\<an infix operator, x\[TildeTilde]y is by default interpreted as \
TildeTilde[x,y].\>"; \),
      FontWeight->"Bold"]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(\[Lambda]::usage = 
      "\<\[Lambda] is the lambda term constructor. \[Lambda][x, body] is a \
lambda abstraction with a single formal argument x. \[Lambda][{x1, x2, \
\[Ellipsis] }, body ] is a lambda term with list {x1, x2, \[Ellipsis] } of \
formal arguments.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(\[Bullet]cnstr::usage = 
      "\<\[Bullet]cnstr is reserved to the use of Calculus` and \
Scheduler`\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["eq", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{x_, "\<\[TildeTilde]\>", y_}], 
        StandardForm] := \n\t
      MakeExpression[RowBox[{"\<eq\>", "\<[\>", x, "\<,\>", y, "\<]\>"}], \n
        \t\tStandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(eq /: \ MakeBoxes[eq[x_, \ y_], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[TildeTilde]\>", 
          \ MakeBoxes[y, \ StandardForm]}\ \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ppeq", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{x_, "\<\[CupCap]\>", y_}], StandardForm] := \n
      \tMakeExpression[RowBox[{"\<ppeq\>", "\<[\>", x, "\<,\>", y, "\<]\>"}], 
        \n\t\tStandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(ppeq /: \ MakeBoxes[ppeq[x_, \ y_], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[CupCap]\>", \ 
          MakeBoxes[y, \ StandardForm]}\ \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["CSMark", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{"\<\[LeftCeiling]\>", x_, "\<\[RightCeiling]\>"}], 
        StandardForm] := \n\t
      MakeExpression[RowBox[{"\<CSMark\>", "\<[\>", x, "\<]\>"}], 
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(CSMark /: MakeBoxes[CSMark[x_], \ StandardForm] := \n\t\t
      RowBox[{"\<\[LeftCeiling]\>", MakeBoxes[x, \ StandardForm], \ 
          "\<\[RightCeiling]\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["DelayMark", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{"\<\[LeftFloor]\>", x_, "\<\[RightFloor]\>"}], 
        StandardForm] := \n\t
      MakeExpression[RowBox[{"\<DelayMark\>", "\<[\>", x, "\<]\>"}], 
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(DelayMark /: MakeBoxes[DelayMark[x_], \ StandardForm] := \n\t\t
      RowBox[{"\<\[LeftFloor]\>", MakeBoxes[x, \ StandardForm], \ 
          "\<\[RightFloor]\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["\[Bullet]ORbranches"], "Subsection"],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(\[Bullet]ORbranches\  /: \ 
      MakeBoxes[\[Bullet]ORbranches[x__], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[DoubleVerticalBar[x], \ StandardForm]}]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RewriteRule", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{x_, "\<\[RightArrow]\>", y_, "\<\[DoubleLeftArrow]\>", 
              "\<\[Placeholder]\>"}] | RowBox[{x_, "\<\[RightArrow]\>", y_}], 
        StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<RewriteRule\>", "\<[\>", x, "\<,\>", y, "\<,\>", 
            RowBox[{"\<{\>", \ "\<}\>"}], "\<]\>"}], \n\t\tStandardForm]; 
    \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{x_, "\<\[RightArrow]\>", y_, "\<\[DoubleLeftArrow]\>", z_}], 
        StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<RewriteRule\>", "\<[\>", x, "\<,\>", y, "\<,\>", z, 
            "\<]\>"}], \n\t\tStandardForm]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(RewriteRule\  /: \ 
      MakeBoxes[RewriteRule[x_, \ y_, {}], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[RightArrow]\>", 
          \ MakeBoxes[y, \ StandardForm]}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(RewriteRule\  /: \ 
      MakeBoxes[RewriteRule[x_, \ y_, {z_}], \ StandardForm]\  := \n\t\ 
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[RightArrow]\>", 
          \ MakeBoxes[y, \ StandardForm], "\<\[DoubleLeftArrow]\>", \n\t\t\t
          MakeBoxes[z, \ StandardForm]}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(RewriteRule\  /: \ 
      MakeBoxes[RewriteRule[x_, \ y_, z_], \ StandardForm]\  := \n\t\ 
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[RightArrow]\>", 
          \ MakeBoxes[y, \ StandardForm], "\<\[DoubleLeftArrow]\>", \n\t\t\t
          MakeBoxes[z, \ StandardForm]}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToCons", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tToCons",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["seq, l ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Input\n\tseq",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a sequence of CFLP terms\n\t",
  StyleBox["l",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a CFLP list\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "the CFLP list corresponding to the notation ",
  StyleBox["[ ",
    FontWeight->"Bold"],
  StyleBox["seq | l",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[ToCons]; \nToCons[hd_, tl_] := Cons[hd, tl]; \n
    ToCons[hds__, hd_, tl_] := ToCons[hds, Cons[hd, tl]]; \n
    ToCons[hd_] := hd; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cons", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{"\<[\>", \ \n\ \ \ \ \ \ RowBox[{hd_, \ "\<|\>", \ tl_}], \ 
            "\<]\>"}], StandardForm] := \n\t
      MakeExpression[RowBox[{"\<Cons\>", "\<[\>", hd, "\<,\>", tl, "\<]\>"}], 
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{"\<[\>", \ \n\ \ \ \ \ \ 
            RowBox[{hds__, \ \n\ \ \ \ \ \ \ \ 
                RowBox[{hd_, \ "\<|\>", \ tl_}]}], \ "\<]\>"}], 
        StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<ToCons\>", "\<[\>", \ \n\ \ \ \ \ \ 
            RowBox[{hds, \ \n\ \ \ \ \ \ \ \ 
                RowBox[{"\<Cons\>", "\<[\>", hd, "\<,\>", tl, "\<]\>"}]}], \ 
            "\<]\>"}], StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[TextData[
"MB\[Bullet]\[Bullet] is an auxiliary function used in generating the \
desirable displayed form of a CFLP list."], "Text"],

Cell[BoxData[
    \(Clear[\[Bullet]\[Bullet]MB]; \n
    MB\[Bullet]\[Bullet][Cons[x_, y_Cons], \ StandardForm] := 
      RowBox[{MakeBoxes[x, \ StandardForm], "\<,\>", 
          MB\[Bullet]\[Bullet][y, \ StandardForm]}]; \n
    MB\[Bullet]\[Bullet][Cons[x_, y_], \ StandardForm] := 
      RowBox[{RowBox[{MakeBoxes[x, \ StandardForm], "\<|\>", 
              MakeBoxes[y, \ StandardForm]}]}]; \)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Cons /: MakeBoxes[Cons[x_, y_Cons], \ StandardForm] := \n\t
      RowBox[{"\<[\>", 
          RowBox[{MakeBoxes[x, \ StandardForm], "\<,\>", 
              MB\[Bullet]\[Bullet][y, \ StandardForm]}], "\<]\>"}]; \)\)], 
  "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Cons /: MakeBoxes[Cons[x_, y_], \ StandardForm] := \n\t\t
      RowBox[{"\<[\>", 
          RowBox[{MakeBoxes[x, \ StandardForm], "\<|\>", 
              MakeBoxes[y, \ StandardForm]}], "\<]\>"}]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["\[Lambda]"], "Subsection"],

Cell[BoxData[
    \(Clear[\[Lambda]]; \n\[Lambda] := Function; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{"\<\[Lambda]\>", \ "\<[\>", \ \n\ \ \ \ \ \ 
            RowBox[{x_, \ "\<,\>", \ y_}], \ "\<]\>"}], StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<Function\>", \ "\<[\>", \ \n\ \ \ \ \ \ 
            RowBox[{x, \ "\<,\>", \ y}], \ "\<]\>"}], \n\t\tStandardForm]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(Attributes[Function] = {HoldAll}; \n
    Function /: MakeBoxes[Function[x_, y_], \ StandardForm] := \n\t\t
      RowBox[{"\<\[Lambda]\>", "\<[\>", 
          RowBox[{MakeBoxes[x, \ StandardForm], "\<,\>", 
              MakeBoxes[y, \ StandardForm]}], "\<]\>"}]; \n
    Attributes[Function] = {HoldAll, Protected}; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[TextData["\[Bullet]cnstr"], "Subsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell[BoxData[
    \(<< TermSyntax`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \(CSEnd[]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\([a, z, \([u, c | ev]\) | f[\([d | y]\)]]\) // FullForm\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        \(Cons[a, Cons[z, Cons[Cons[u, Cons[c, ev]], f[Cons[d, y]]]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
WindowSize->{727, 509},
WindowMargins->{{Automatic, 12}, {-8, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 67, 1, 102, "Title"],
Cell[1801, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2023, 63, 84, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2110, 66, 2437, 33, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4584, 104, 39, 0, 53, "Subtitle"],
Cell[4626, 106, 67, 0, 32, "Text"],
Cell[4696, 108, 192, 5, 27, "Input",
  InitializationCell->True],
Cell[4891, 115, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5047, 122, 27, 0, 45, "Subsection"],
Cell[5077, 124, 157, 4, 27, "Input",
  InitializationCell->True],
Cell[5237, 130, 312, 6, 59, "Input",
  InitializationCell->True],
Cell[5552, 138, 236, 5, 43, "Input",
  InitializationCell->True],
Cell[5791, 145, 246, 5, 43, "Input",
  InitializationCell->True],
Cell[6040, 152, 248, 5, 43, "Input",
  InitializationCell->True],
Cell[6291, 159, 250, 5, 43, "Input",
  InitializationCell->True],
Cell[6544, 166, 297, 6, 43, "Input",
  InitializationCell->True],
Cell[6844, 174, 310, 6, 43, "Input",
  InitializationCell->True],
Cell[7157, 182, 341, 10, 27, "Input",
  InitializationCell->True],
Cell[7501, 194, 421, 14, 27, "Input",
  InitializationCell->True],
Cell[7925, 210, 262, 7, 43, "Input",
  InitializationCell->True],
Cell[8190, 219, 373, 7, 59, "Input",
  InitializationCell->True],
Cell[8566, 228, 210, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8825, 239, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[8884, 243, 24, 0, 54, "Section"],
Cell[8911, 245, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[9064, 252, 24, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[9113, 256, 47, 0, 42, "Subsubsection"],
Cell[9163, 258, 293, 6, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9493, 269, 43, 0, 42, "Subsubsection"],
Cell[9539, 271, 290, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9878, 282, 26, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[9929, 286, 47, 0, 42, "Subsubsection"],
Cell[9979, 288, 282, 5, 59, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[10298, 298, 43, 0, 42, "Subsubsection"],
Cell[10344, 300, 290, 5, 75, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10683, 311, 28, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[10736, 315, 47, 0, 42, "Subsubsection"],
Cell[10786, 317, 308, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11131, 329, 43, 0, 42, "Subsubsection"],
Cell[11177, 331, 266, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[11492, 342, 31, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[11548, 346, 47, 0, 42, "Subsubsection"],
Cell[11598, 348, 298, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11933, 359, 43, 0, 42, "Subsubsection"],
Cell[11979, 361, 268, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12296, 372, 51, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[12372, 376, 43, 0, 42, "Subsubsection"],
Cell[12418, 378, 270, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12737, 390, 33, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[12795, 394, 47, 0, 42, "Subsubsection"],
Cell[12845, 396, 443, 9, 59, "Input"],
Cell[13291, 407, 338, 7, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13666, 419, 43, 0, 42, "Subsubsection"],
Cell[13712, 421, 319, 6, 75, "Input",
  InitializationCell->True],
Cell[14034, 429, 398, 7, 91, "Input",
  InitializationCell->True],
Cell[14435, 438, 396, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14880, 451, 28, 0, 45, "Subsection"],
Cell[14911, 453, 514, 22, 122, "Text"],
Cell[15428, 477, 324, 11, 32, "Text"],

Cell[CellGroupData[{
Cell[15777, 492, 103, 2, 42, "Subsubsection"],
Cell[15883, 496, 238, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16170, 507, 26, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[16221, 511, 47, 0, 42, "Subsubsection"],
Cell[16271, 513, 344, 7, 59, "Input",
  InitializationCell->True],
Cell[16618, 522, 545, 12, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17200, 539, 43, 0, 42, "Subsubsection"],
Cell[17246, 541, 138, 2, 32, "Text"],
Cell[17387, 545, 446, 8, 91, "Input"],
Cell[17836, 555, 289, 6, 43, "Input"],
Cell[18128, 563, 273, 5, 59, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18450, 574, 41, 0, 45, "Subsection"],
Cell[18494, 576, 143, 3, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[18662, 583, 47, 0, 42, "Subsubsection"],
Cell[18712, 585, 421, 9, 91, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19170, 599, 43, 0, 42, "Subsubsection"],
Cell[19216, 601, 415, 8, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[19658, 613, 46, 0, 45, "Subsection"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19741, 618, 22, 0, 54, "Section"],
Cell[19766, 620, 190, 6, 27, "Input",
  InitializationCell->True],
Cell[19959, 628, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[20092, 633, 197, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20326, 644, 31, 0, 54, "Section"],
Cell[20360, 646, 47, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[20432, 651, 40, 1, 27, "Input"],
Cell[20475, 654, 41, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20553, 660, 89, 1, 27, "Input"],
Cell[20645, 663, 217, 6, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

