(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17566,        470]*)
(*NotebookOutlinePosition[     18565,        506]*)
(*  CellTagsIndexPosition[     18459,        499]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TSolve", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell[TextData[StyleBox[
"The program was produced on an experimental basis in the\ncourse of the \
research and development conducted during the project\nand is provided to \
users as so produced on an experimental basis.\nAccordingly, the program is \
provided without any warranty whatsoever,\nwhether express, implied, \
statutory or otherwise. The term \"warranty\"\nused herein includes, but is \
not limited to, any warranty of the\nquality, performance, merchantability \
and fitness for a particular\npurpose of the program and the nonexistence of \
any infringement or\nviolation of any right of any third party.\n\nEach user \
of the program will agree and understand, and be\ndeemed to have agreed and \
understood, that there is no warranty\nwhatsoever for the program and, \
accordingly, the entire risk arising\nfrom or otherwise connected with the \
program is assumed by the user.\n\nTherefore, neither ICOT, the copyright \
holder, or any other\norganization that participated in or was otherwise \
related to the\ndevelopment of the program and their respective officials, \
directors,\nofficers and other employees shall be held liable for any and all\
\ndamages, including, without limitation, general, special, incidental\nand \
consequential damages, arising out of or otherwise in connection\nwith the \
use or inability to use the program or any product, material\nor result \
produced or otherwise obtained by using the program,\nregardless of whether \
they have been advised of, or otherwise had\nknowledge of, the possibility of \
such damages at any time during the\nproject or thereafter. Each user will be \
deemed to have agreed to the\nforegoing by his or her commencement of use of \
the program. The term\n\"use\" as used herein includes, but is not limited \
to, the use,\nmodification, copying and distribution of the program and the\n\
production of secondary products from the program.\n\nIn the case where the \
program, whether in its original form or\nmodified, was distributed or \
delivered to or received by a user from\nany person, organization or entity \
other than ICOT, unless it makes or\ngrants independently of ICOT any \
specific warranty to the user in\nwriting, such person, organization or \
entity, will also be exempted\nfrom and not be held liable to the user for \
any such damages as noted\nabove as far as the program is concerned."]], 
  "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of the term solver based \
on the CFLP\.03\.03\.03\.03 calculus. \
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TSolve`\>", \n
      \t{"\<TypeChecker`\>", "\<RewriteRuleDefs`\>"}\n]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($IterationLimit = 10000; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>", General::"\<spell1\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(TSolve::usage = 
      "\<TSolve[eqns,vars] attempts to solve an equation or a set of \
equations for the variables vars.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetTypeCheck::usage = 
      "\<SetTypeCheck[True|False] sets the default type checking option of \
TSolve calls.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Initialize::usage = 
      "\<Initialize is an option to the function TSolve. With \
TypeCheck->True, all previously defined conditional rewrite rules are \
removed. By default, TypeCheck->False.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NSolution::usage = 
      "\<NSolution is an option to TSolve which specifies the maximum number \
of solutions to be found.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(RuleVars::usage = 
      "\<RuleVars is an option to TSolve which specifies the rewrite rule \
variables given by the 'Rule' option.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Rule::usage = 
      "\<Rule is an option to TSolve which specifies the set of CRRs w.r.t. \
which the system of equations is tried to be solved. During the solving \
process also the globally declared CRRs are used.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($CFLPpackages::usage = 
      "\<$CFLPpackages gives the list of CFLP packages on top of which the \
TSolve package is written.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[Remove::"\<rmnsm\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = 
      Join[\n\t\t{\n\t\t\t"\<TypeSyntax`\>", \n\t\t\t\t"\<Types`\>", \n
          \t\t\t\t"\<Variables`\>", \n\t\t\t\t"\<TermSyntax`\>", \n\t\t\t\t
          "\<Terms`\>", \n\t\t\t\t"\<RewriteRules`\>", \n\t\t\t\t
          "\<RewriteRuleDefs`\>", \n\t\t\t\t"\<Calculus`\>", \n\t\t\t\t
          "\<Debug`\>"\n\t\t}, $ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["$CFLPpackages", "Subsection",
  CellTags->"TSolveOptions"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\($CFLPpackages = {"\<TypeSyntax`\>", "\<Types`\>", "\<Variables`\>", 
        "\<TermSyntax`\>", "\<Terms`\>", "\<RewriteRules`\>", 
        "\<RewriteRuleDefs`\>", \n\t\t\t\t"\<Calculus`\>", "\<Debug`\>"}; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options[TSolve]", "Subsection",
  CellTags->"TSolveOptions"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Options[TSolve] = {\n\t\tNSolution -> 256, \n\t\tRule -> {}, \n\t\t
        Initialize -> False, \n\t\tConstructor -> {}, \n\t\t
        DefinedSymbol -> {}, \n\t\tRuleVars -> {}, \n\t\tTypeCheck -> True\n
        \t}; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(SetTypeCheck[tyChkVal : \((True | False)\)] := \n\t
      \((Options[TSolve] = 
          Options[TSolve] /. 
            \((\((TypeCheck -> _)\) -> \((TypeCheck -> tyChkVal)\))\))\); 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TSolve", "Subsection",
  CellTags->"TSolver"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTSolve",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["eqns, vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input\n\teqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the equation(s) to be solved\n\t",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the variables of ",
  StyleBox["eqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the set of solutions of ",
  StyleBox["eqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(BeginRule[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.501961]],

Cell[BoxData[
    RowBox[{
    \(TSolve[goal_List, vars_List, opts___Rule] := 
        TSolve[goal, vars, {}, opts]\), ";", "\n", 
      RowBox[{
      \(TSolve[goal_List, vars_List, elims_List, opts___Rule]\), ":=", "\n", 
        "\t", 
        RowBox[{"Block", "[", 
          RowBox[{
          \({\n\t\t\tnewGoal = WeakListToCons\ [goal], \n\t\t\t
              saveRewriteRuleList = DownValues[RewriteRuleList], \n\t\t\t
              saveIsDefinedSymbol = DownValues[IsDefinedSymbol], \n\t\t\t
              saveIsConstructor = DownValues[IsConstructor], \n\t\t\t
              saveType = DownValues[Type], \n\t\t\t$RecursionLimit = 8000, \n
              \t\t\tsol = "\<\[UpTee]\>", oldV = Var[goal]\n\t\t\t}\), ",", 
            "\n", "\t\t", 
            \( (*Remove["\<\[Alpha]$@\>", "\<x$@\>", "\<y$@\>", "\<z$@\>", 
                "\<w$@\>"]; *) \), "\n", "\t\t", 
            RowBox[{
            \(cflpInterrupt = False\), ";", "\n", "\t\t", 
              \(If[IsClosedPanel[], \n\t\t\tSetTypeCheck[True]; \n\t\t\t
                MessageOn[]; \n\t\t\tResetPanel[]\n\t\t]\), ";", "\n", 
              "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\($CFLPTraceLevel == 2\), ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"If", "[", 
                      RowBox[{
                      \($TraceWindow === Null \[Or] \n\t\t\t\t\t
                          NotebookInformation[$TraceWindow] === $Failed\), 
                        ",", "\n", "\t\t\t\t", 
                        RowBox[{"OpenC", 
                          StyleBox[\(FLPTraceWindow[]\),
                            FontWeight->"Bold"]}], ",", "\n", "\t\t\t\t", 
                        \(ClearCFLPTraceWindow[]\)}], "\n", "\t\t\t", "]"}], 
                    ";", "\n", "\t\t\t", 
                    RowBox[{"If", "[", 
                      RowBox[{
                      \($CSWindow === Null \[Or] \n\t\t\t\t\t
                          NotebookInformation[$CSWindow] === $Failed\), ",", 
                        "\n", "\t\t\t\t", 
                        RowBox[{"OpenCS", 
                          StyleBox[\(TraceWindow[]\),
                            FontWeight->"Bold"]}], 
                        StyleBox[",",
                          FontWeight->"Bold"], "\n", "\t\t\t\t", 
                        \(ClearCSTraceWindow[]\)}], "\n", "\t\t\t", 
                      "]"}]}]}], "\n", "\t\t", 
                StyleBox["]",
                  FontWeight->"Bold"]}], ";", "\n", "\t\t", 
              \(NotebookClose[Debug`Private`\[Bullet]ctrlPanel]\), ";", "\n", 
              "\t\t", \(Debug`Private`\[Bullet]ctrlPanel = 
                NotebookOpen[Global`$cflpSrcDirectory<>"\<ControlPanel2.nb\>"]
                  \), ";", "\n", "\t\t", 
              \(If[\((\(NSolution /. {opts}\) /. Options[TSolve])\) 
                  \[LessEqual] 0, \n\t\t\t{}, \n\t\t\t
                If[\(Initialize /. {opts}\) /. Options[TSolve], BeginRule[]]; 
                \n\t\t\tConstructor\ @@\ 
                  \((\(Constructor /. {opts}\) /. Options[TSolve])\); \n\t\t\t
                DefinedSymbol\ @@\ 
                  \((\(DefinedSymbol /. {opts}\) /. Options[TSolve])\); \n
                \t\t\tIf[\(TypeCheck /. {opts}\) /. Options[TSolve], \n
                  \t\t\t\tIf[
                    Def[\n\t\t\t\t\t\t
                        \(RuleVars /. {opts}\) /. Options[TSolve], \n
                        \t\t\t\t\t\t\(Rule /. {opts}\) /. Options[TSolve], \n
                        \t\t\t\t\t\tTypeCheck -> True] === "\<\[DownTee]\>", 
                    \n\t\t\t\t\t
                    sol = Tc[\n\t\t\t\t\t\t\t
                        ToFormula[
                          newGoal //. {TermSyntax`DoubleVerticalBar -> Or, 
                              TermSyntax`Wedge -> And}], \n\t\t\t\t\t\t\t
                        KeepTypes -> True, \n\t\t\t\t\t\t\t
                        TypedVars \[Rule] vars \[Union] elims]; \n
                    \t\t\t\t\t (*Print["\<sol=\>", sol]; *) \n\t\t\t\t\t
                    If[sol =!= Bool, \n\t\t\t\t\t\t
                      If[sol === "\<\[UpTee]\>", \n\t\t\t\t\t\t\t
                        Print["\<Type check error : can not type the \
goal.\>"], \n\t\t\t\t\t\t\tPrint["\<Type check : wrong goal type.\>"]; \n
                        \t\t\t\t\t\t\tClearVariables[vars \[Union] elims]; \n
                        \t\t\t\t\t\t\tSetVariables[oldV]\n\t\t\t\t\t\t], \n
                      \t\t\t\t\t\t
                      ClearVariables[vars \[Union] elims, 
                        KeepVarTypes -> True]; \n\t\t\t\t\t\t
                      SetVariables[oldV]; \n\t\t\t\t\t\t
                      TSolveRules = CFLPRules; \n\t\t\t\t\t\tTcCall = False; 
                      \n\t\t\t\t\t\t
                      sol = CallTSolve[newGoal, vars, elims, 
                          \(NSolution /. {opts}\) /. Options[TSolve], False]\n
                      \t\t\t\t\t]; \n\t\t\t\t], \n\t\t\t\t
                  Def[\n\t\t\t\t\t\(RuleVars /. {opts}\) /. Options[TSolve], 
                    \n\t\t\t\t\t\(Rule /. {opts}\) /. Options[TSolve], \n
                    \t\t\t\t\tTypeCheck -> False]; \n\t\t\t\t
                  TSolveRules = CFLPRules; \n\t\t\t\tTcCall = False; \n
                  \t\t\t\tsol = 
                    CallTSolve[newGoal, vars, elims, 
                      \(NSolution /. {opts}\) /. Options[TSolve]]\n\t\t\t]; \n
                \t\t\tDownValues[RewriteRuleList] = saveRewriteRuleList; \n
                \t\t\tDownValues[IsDefinedSymbol] = saveIsDefinedSymbol; \n
                \t\t\tDownValues[IsConstructor] = saveIsConstructor; \n\t\t\t
                DownValues[Type] = saveType; \n\t\t\tSetTypeCheck[True]; \n
                \t\t\tMessageOn[]; \n\t\t\tResetPanel[]; \n\t\t\tsol\n\t\t]
                \)}]}], "\n", "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TSolve[goal_, vars_List, opts___] := TSolve[{goal}, vars, opts]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TSolve[___] := Print["\<Error: invalid syntax call.\>"]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{727, 482},
WindowMargins->{{Automatic, 5}, {-7, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "TSolveOptions"->{
    Cell[8003, 216, 64, 1, 45, "Subsection",
      CellTags->"TSolveOptions"],
    Cell[8663, 241, 66, 1, 45, "Subsection",
      CellTags->"TSolveOptions"]},
  "TSolver"->{
    Cell[9708, 278, 51, 1, 45, "Subsection",
      CellTags->"TSolver"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"TSolveOptions", 18186, 487},
  {"TSolver", 18360, 492}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 62, 1, 102, "Title"],
Cell[1796, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2018, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2085, 66, 2437, 33, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4559, 104, 39, 0, 53, "Subtitle"],
Cell[4601, 106, 130, 3, 32, "Text"],
Cell[4734, 111, 192, 4, 59, "Input",
  InitializationCell->True],
Cell[4929, 117, 122, 3, 27, "Input",
  InitializationCell->True],
Cell[5054, 122, 154, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5233, 129, 27, 0, 45, "Subsection"],
Cell[5263, 131, 230, 5, 43, "Input",
  InitializationCell->True],
Cell[5496, 138, 222, 5, 43, "Input",
  InitializationCell->True],
Cell[5721, 145, 304, 6, 59, "Input",
  InitializationCell->True],
Cell[6028, 153, 233, 5, 43, "Input",
  InitializationCell->True],
Cell[6264, 160, 241, 5, 43, "Input",
  InitializationCell->True],
Cell[6508, 167, 325, 6, 59, "Input",
  InitializationCell->True],
Cell[6836, 175, 236, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7121, 186, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7180, 190, 24, 0, 54, "Section"],
Cell[7207, 192, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[7393, 199, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[7526, 204, 452, 8, 203, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8003, 216, 64, 1, 45, "Subsection",
  CellTags->"TSolveOptions"],

Cell[CellGroupData[{
Cell[8092, 221, 125, 3, 42, "Subsubsection"],
Cell[8220, 226, 394, 9, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8663, 241, 66, 1, 45, "Subsection",
  CellTags->"TSolveOptions"],

Cell[CellGroupData[{
Cell[8754, 246, 125, 3, 42, "Subsubsection"],
Cell[8882, 251, 402, 9, 155, "Input",
  InitializationCell->True],
Cell[9287, 262, 372, 10, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9708, 278, 51, 1, 45, "Subsection",
  CellTags->"TSolver"],
Cell[9762, 281, 757, 33, 140, "Text"],

Cell[CellGroupData[{
Cell[10544, 318, 125, 3, 42, "Subsubsection"],
Cell[10672, 323, 117, 3, 27, "Input",
  InitializationCell->True],
Cell[10792, 328, 5962, 104, 1275, "Input",
  InitializationCell->True],
Cell[16757, 434, 174, 4, 27, "Input",
  InitializationCell->True],
Cell[16934, 440, 164, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17159, 451, 22, 0, 54, "Section"],
Cell[17184, 453, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[17353, 460, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

