(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8538,        282]*)
(*NotebookOutlinePosition[      9352,        310]*)
(*  CellTagsIndexPosition[      9308,        306]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Operations with Substitutions", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains basic operations for handling \
substitutions.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Substitutions`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(ApplySubst::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsSubst::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["ApplySubst", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tApplySubst[ ",
    FontWeight->"Bold"],
  StyleBox["expr, \[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a CFLP expression\n\t",
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  " : a CFLP substitution\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tthe CFLP expression ",
  StyleBox["expr'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  obtained by applying ",
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to the free variables of ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[ApplySubst]; \n
    ApplySubst[t_, \[Sigma]_Rule] := ApplySubst[t, {\[Sigma]}]; \n
    ApplySubst[f_[v_, body_], \[Sigma]_] /; \((f === Function)\) := \n\t
      \(\((Function[#1, #2])\)&\)[v, 
        ApplySubst[body, Select[\[Sigma], Not[MemberQ[v, First[#]]]&]]]; \n
    ApplySubst[f_[u_, v_], \[Sigma]_] /; 
        \((f === Rule \[Or] f === RuleDelayed)\) := 
      \(Rule[#1, #2]&\)[u, ApplySubst[v, \[Sigma]]]; \n
    ApplySubst[s_?AtomQ, \[Sigma]_] := s /. \[Sigma]; \n
    ApplySubst[f_[args___], \[Sigma]_] := 
      \((ApplySubst[f, \[Sigma]]\ @@\ 
          \((\(ApplySubst[#, \[Sigma]]&\)\ /@\ \ {args})\))\); \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[BoxData[
    \(<< Substitutions`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sigma] = {f -> Function[{x}, x*Sin[x]], 
        g -> Function[{x, y}, x^2*Sin[y]], x -> maz, z -> may}\)], "Input"],

Cell[BoxData[
    \({f \[Rule] \[Lambda][{x}, x\ Sin[x]], 
      g \[Rule] \[Lambda][{x, y}, x\^2\ Sin[y]], x \[Rule] maz, z \[Rule] may}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ApplySubst[\(f'\)[x] + f + \(\(Derivative[1, 1]\)[g]\)[y, m], \[Sigma]]
      \)], "Input"],

Cell[BoxData[
    \(2\ y\ Cos[m] + maz\ Cos[maz] + \[Lambda][{x}, x\ Sin[x]] + Sin[maz]\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ApplySubst[\(\(Derivative[1, 1]\)[g]\)[y, m], \[Sigma]]\)], "Input"],

Cell[BoxData[
    \(2\ y\ Cos[m]\)], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{732, 600},
WindowMargins->{{21, Automatic}, {Automatic, 29}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{597.562, 842.375},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 85, 1, 102, "Title"],
Cell[1819, 54, 197, 5, 35, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2041, 63, 64, 1, 33, "Subsubsection",
  InitializationCell->True],
Cell[2108, 66, 2326, 40, 34214, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4471, 111, 39, 0, 33, "Subtitle"],
Cell[4513, 113, 92, 3, 24, "Text"],
Cell[4608, 118, 195, 5, 22, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4828, 127, 27, 0, 45, "Subsection"],
Cell[4858, 129, 123, 3, 27, "Input",
  InitializationCell->True],
Cell[4984, 134, 120, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5153, 143, 34, 0, 64, "Subtitle"],
Cell[5190, 145, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5338, 152, 32, 0, 45, "Subsection"],
Cell[5373, 154, 961, 40, 140, "Text"],

Cell[CellGroupData[{
Cell[6359, 198, 125, 3, 42, "Subsubsection"],
Cell[6487, 203, 724, 14, 139, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7260, 223, 22, 0, 54, "Section"],
Cell[7285, 225, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[7449, 232, 168, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7654, 242, 26, 0, 54, "Section"],
Cell[7683, 244, 50, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[7758, 249, 138, 2, 27, "Input"],
Cell[7899, 253, 158, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8094, 261, 111, 2, 27, "Input"],
Cell[8208, 265, 104, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8349, 272, 88, 1, 27, "Input"],
Cell[8440, 275, 46, 1, 27, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

